/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.CostAccount;
import kd.fi.calx.algox.CostPriceResultInfo;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.ParamCache;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.accounttype.CostAdjustInfo;
import kd.fi.calx.algox.accounttype.LocalRow;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.constant.CostPriceSourceTypeEnum;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.function.AbstractAccountTypeFunction;
import kd.fi.calx.algox.function.AccountTypeContext;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.function.CostDomainDataInfo;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CalServiceHelper;
import kd.fi.calx.algox.report.CalOutRptHolder;
import kd.fi.calx.algox.report.RptStatus;

public class MoveAddAccountTypeFunction
extends AbstractAccountTypeFunction {
    private static final long serialVersionUID = -4302725707069780021L;
    private static Log logger = LogFactory.getLog(MoveAddAccountTypeFunction.class);
    public static final long DEFAULT_MATERIAL_SUBCOSTELEMENT = 773175233367685120L;
    private Map<String, CostDomainDataInfo> domainMap = new HashMap<String, CostDomainDataInfo>(128);
    private Map<Long, CostSubElement> elementMap;
    private boolean calbycostelement = false;
    AccountTypeContext ctx;
    private int runningMode;
    private boolean isPriced = false;
    private long calOrgId;
    private long costAccountId;
    private CommonInfo commonInfo;

    public MoveAddAccountTypeFunction(RowMeta rowMeta, CommonInfo commonInfo, Map<Long, CostAccount> costAccountMap) {
        super(rowMeta, commonInfo, costAccountMap);
        this.commonInfo = commonInfo;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        try (DataSet dataSet = this.createDataSet(iterable);){
            this.domainMap.clear();
            this.ctx = this.createContext(collector);
            this.doCalculate(dataSet);
        }
    }

    private void loadParameters() {
        ParamCache param = this.ctx.getParamCache();
        Object iscyclebillcal = param.getParamValue(this.calOrgId, "iscyclebillcal");
        this.isPriced = iscyclebillcal == null ? false : (Boolean)iscyclebillcal;
        this.calbycostelement = param.isCalByElement(this.costAccountId);
        Map<String, Integer> runningModeMap = this.commonInfo.getRunningModeMap();
        this.runningMode = runningModeMap.get(AccountTypeEnum.MOVEDAVG_INTIME.getValue());
    }

    private void initCalRangeInfo(Row row) {
        this.calOrgId = row.getLong("calorg");
        this.costAccountId = row.getLong("costaccount");
        this.loadParameters();
        this.initElementMap();
    }

    private void doCalculate(DataSet dataSet) {
        for (Row row : dataSet.copy()) {
            this.ctx.getGroupBillHolder().addGroupRecord(row);
        }
        String balanceType = this.getBalanceRowType();
        DataSet balanceData = dataSet.copy().filter("rowtype = '" + balanceType + "'");
        DataSet data = dataSet.copy().filter("rowtype in ('1','2')");
        boolean firstRow = true;
        for (Row row : dataSet) {
            if (firstRow) {
                this.initCalRangeInfo(row);
            }
            firstRow = false;
            String costDomainId = row.getString("costdomainid");
            if (this.domainMap.containsKey(costDomainId)) continue;
            CostDomainDataInfo domainInfo = new CostDomainDataInfo(this.elementMap, row);
            this.domainMap.put(costDomainId, domainInfo);
        }
        this.dealBalanceData(balanceData);
        this.addRptBeginData();
        data = data.orderBy(this.buildOrderByField());
        this.beforeCalculated();
        Long beforeRowId = null;
        LocalRow beforeRow = null;
        while (data.hasNext()) {
            Row row = data.next();
            String domainId = row.getString("costdomainid");
            CostDomainDataInfo domainInfo = this.domainMap.get(domainId);
            if (domainInfo.isEmptyRange()) {
                domainInfo.getHolder().addDivideBasisValue(row.getString("divideBasisValue"));
            }
            Long currentId = row.getLong("entryid");
            LocalRow currentRow = this.createCurrentRow(row);
            if (!currentId.equals(beforeRowId)) {
                this.doCalculate(this.ctx, beforeRowId, beforeRow);
            }
            beforeRowId = currentId;
            beforeRow = currentRow;
        }
        this.doCalculate(this.ctx, beforeRowId, beforeRow);
        this.afterCalculated();
    }

    private void beforeEndCalculated() {
        for (Map.Entry<String, CostDomainDataInfo> e : this.domainMap.entrySet()) {
            CostDomainDataInfo domainInfo = e.getValue();
            if (!domainInfo.getTempInGroupRow().isEmpty()) {
                domainInfo.getHolder().setCalStatus(RptStatus.WARNING);
            }
            for (LocalRow costNotDeterminedRow : domainInfo.getTempInGroupRow()) {
                this.joinCalculate(costNotDeterminedRow, ResManager.loadKDString((String)"(\u6210\u672c\u672a\u786e\u5b9a)", (String)"WeightedAvgAT_13", (String)"fi-calx-algox", (Object[])new Object[0]), null);
            }
        }
    }

    private String getEndErrorMsg(CostDomainDataInfo domainInfo) {
        if (domainInfo.isHasPriceFailed()) {
            return ResManager.loadKDString((String)"\u5b58\u5728\u53d6\u4ef7\u5931\u8d25\u7684\u573a\u666f\uff0c\u7ed3\u8f6c\u5931\u8d25\u3002", (String)"MovedAvgIntimeAT_2", (String)"fi-calx-algox", (Object[])new Object[0]);
        }
        StringBuilder endFormula = new StringBuilder();
        if (domainInfo.isHasPriceFailedBill()) {
            endFormula.append("\r\n");
            endFormula.append(ResManager.loadKDString((String)"\u6210\u672c\u57df\u5185\u5b58\u5728\u53d6\u4ef7\u5931\u8d25\u7684\u5355\u636e\uff0c\u7ed3\u8f6c\u5931\u8d25\u3002", (String)"AbstractAccountType_12", (String)"fi-calx-algox", (Object[])new Object[0]));
        } else if (domainInfo.getExceptionRow().size() > 0) {
            endFormula.append("\r\n");
            StringBuilder newendFormula = new StringBuilder();
            if (domainInfo.getExceptionRow().size() > 3) {
                for (int i = 0; i <= 3; ++i) {
                    LocalRow row = domainInfo.getExceptionRow().get(i);
                    newendFormula.append(row.getBillnumber());
                    newendFormula.append(',');
                }
                newendFormula.deleteCharAt(newendFormula.length() - 1);
                newendFormula.append("...");
            } else {
                for (LocalRow row : domainInfo.getExceptionRow()) {
                    newendFormula.append(row.getBillnumber());
                    newendFormula.append(',');
                }
                newendFormula.deleteCharAt(newendFormula.length() - 1);
            }
            String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u6210\u7ec4\u5165\u5e93\u6216\u51fa\u5e93\u5355\u4f4d\u6750\u6599\u6210\u672c\u5c0f\u4e8e0\u7684\u5355\u636e\u201c%1$s\u201d\uff0c\u7ed3\u8f6c\u5931\u8d25\u3002", (String)"AbstractAccountType_6", (String)"fi-calx-algox", (Object[])new Object[0]), newendFormula.toString());
            endFormula.append(msg);
        } else {
            return null;
        }
        return endFormula.toString();
    }

    protected String getEndWarnMsg(CostDomainDataInfo domainInfo) {
        BigDecimal unitActualCost;
        StringBuilder endFormula = new StringBuilder();
        BigDecimal bigDecimal = unitActualCost = domainInfo.getCurrentTotalQty().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : domainInfo.getCurrentTotalCost().divide(domainInfo.getCurrentTotalQty(), 10, RoundingMode.HALF_UP);
        if (domainInfo.getCurrentTotalQty().compareTo(BigDecimal.ZERO) != 0 && unitActualCost.compareTo(BigDecimal.ZERO) == 0) {
            endFormula.append("\r\n");
            endFormula.append(ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u671f\u672b\u6570\u91cf\u4e0d\u4e3a0\uff0c\u4f46\u671f\u672b\u5355\u4ef7=0\u3002", (String)"AbstractAccountType_13", (String)"fi-calx-algox", (Object[])new Object[0]));
        } else if (domainInfo.getCurrentTotalQty().compareTo(BigDecimal.ZERO) != 0 && unitActualCost.compareTo(BigDecimal.ZERO) < 0) {
            endFormula.append("\r\n");
            endFormula.append(ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u671f\u672b\u6570\u91cf\u4e0d\u4e3a0\uff0c\u4f46\u671f\u672b\u5355\u4ef7<0\u3002", (String)"AbstractAccountType_2", (String)"fi-calx-algox", (Object[])new Object[0]));
        } else if (domainInfo.getCurrentTotalQty().compareTo(BigDecimal.ZERO) < 0) {
            endFormula.append("\r\n");
            endFormula.append(ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u671f\u672b\u6570\u91cf<0\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AbstractAccountType_3", (String)"fi-calx-algox", (Object[])new Object[0]));
        } else if (domainInfo.getCurrentTotalQty().compareTo(BigDecimal.ZERO) == 0 && domainInfo.getCurrentTotalCost().compareTo(BigDecimal.ZERO) != 0) {
            endFormula.append("\r\n");
            endFormula.append(ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u671f\u672b\u6570\u91cf\u4e3a0\u4f46\u671f\u672b\u6210\u672c\u4e0d\u4e3a0\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AbstractAccountType_5", (String)"fi-calx-algox", (Object[])new Object[0]));
        } else {
            return null;
        }
        return endFormula.toString();
    }

    private void writeEndRpt() {
        for (Map.Entry<String, CostDomainDataInfo> e : this.domainMap.entrySet()) {
            CostDomainDataInfo domainInfo = e.getValue();
            CalOutRptHolder holder = domainInfo.getHolder();
            StringBuilder endFormula = new StringBuilder();
            int endindex = holder.createNewEntry();
            holder.setBillType(endindex, ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d", (String)"AbstractAccountType_1", (String)"fi-calx-algox", (Object[])new Object[0]));
            endFormula.append(this.toBigDecimalString(domainInfo.getCurrentTotalQty().setScale(domainInfo.getQtyPrecision(), RoundingMode.HALF_UP)));
            endFormula.append('*');
            BigDecimal unitActualCost = domainInfo.getCurrentTotalQty().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(domainInfo.getPricePrecision()) : domainInfo.getCurrentTotalCost().divide(domainInfo.getCurrentTotalQty(), domainInfo.getPricePrecision(), RoundingMode.HALF_UP);
            endFormula.append(this.toBigDecimalString(unitActualCost));
            endFormula.append('=');
            endFormula.append(this.toBigDecimalString(domainInfo.getCurrentTotalCost().setScale(domainInfo.getAmtPrecision(), RoundingMode.HALF_UP)));
            holder.setBalanceFormula(endindex, endFormula.toString());
            String errorInfo = this.getEndErrorMsg(domainInfo);
            if (StringUtils.isEmpty((String)errorInfo)) {
                String warnInfo = this.getEndWarnMsg(domainInfo);
                if (StringUtils.isNotEmpty((String)warnInfo)) {
                    holder.appendBalanceFormula(endindex, warnInfo);
                    holder.setCalStatus(RptStatus.WARNING);
                }
            } else {
                holder.setCalStatus(RptStatus.ERROR);
                holder.appendBalanceFormula(endindex, errorInfo);
            }
            for (Map.Entry<Long, BigDecimal> entry : domainInfo.getCurrentTotalElementCostMap().entrySet()) {
                endFormula.setLength(0);
                Long elementId = entry.getKey();
                BigDecimal elementTotalCost = entry.getValue();
                if (elementTotalCost.compareTo(BigDecimal.ZERO) == 0) continue;
                int subIndex = holder.createNewSubEntry(endindex, this.elementMap.get(elementId).getName());
                endFormula.append(this.toBigDecimalString(domainInfo.getCurrentTotalQty().setScale(domainInfo.getQtyPrecision(), RoundingMode.HALF_UP)));
                endFormula.append('*');
                BigDecimal elementUnitActualCost = domainInfo.getCurrentTotalQty().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(domainInfo.getPricePrecision()) : elementTotalCost.divide(domainInfo.getCurrentTotalQty(), domainInfo.getPricePrecision(), RoundingMode.HALF_UP);
                endFormula.append(this.toBigDecimalString(elementUnitActualCost));
                endFormula.append('=');
                endFormula.append(this.toBigDecimalString(elementTotalCost.setScale(domainInfo.getAmtPrecision(), RoundingMode.HALF_UP)));
                holder.setBalanceFormula(subIndex, endFormula.toString());
            }
        }
    }

    protected void afterCalculated() {
        if (this.runningMode == 0) {
            return;
        }
        this.beforeEndCalculated();
        this.writeEndRpt();
        this.afterEndCalculated();
        this.flushUpdateRow();
        this.flushCostAdjust();
        this.insertCalRpt();
    }

    private void flushUpdateRow() {
        for (Map.Entry<String, CostDomainDataInfo> e : this.domainMap.entrySet()) {
            CostDomainDataInfo domainInfo = e.getValue();
            if (RptStatus.ERROR.getValue().equals(domainInfo.getHolder().getCalStatusValue())) continue;
            for (Object[] updateRowInfo : domainInfo.getToUpdatedRowMap().values()) {
                updateRowInfo[20] = domainInfo.getRecentCostId();
                updateRowInfo[21] = domainInfo.getCurrentTotalQty();
                updateRowInfo[22] = domainInfo.getCurrentTotalCost();
                updateRowInfo[23] = domainInfo.getHolder().getCalRptID();
                updateRowInfo[24] = domainInfo.getRecentCostId().hashCode() % 8;
                this.ctx.collectCostUpdateInfo(updateRowInfo);
            }
        }
    }

    private void insertCalRpt() {
        for (Map.Entry<String, CostDomainDataInfo> e : this.domainMap.entrySet()) {
            CostDomainDataInfo domainInfo = e.getValue();
            CalOutRptHolder holder = domainInfo.getHolder();
            boolean matrix = this.ctx.enableMatrix();
            holder.setMatrix(matrix);
            boolean costatenddateenable = this.ctx.enableCostatenddateenable();
            holder.setCostatenddateenable(costatenddateenable);
            if (costatenddateenable) {
                Date costatenddate = this.ctx.getCostatenddate();
                holder.setCostatenddate(costatenddate);
            }
            TXHandle h = TX.requiresNew();
            Throwable throwable = null;
            try {
                if (!this.ctx.isWriteRpt() || this.ctx.isOnlyWriteErrRpt() && holder.getCalStatusValue().equals(RptStatus.SUCESS.getValue())) continue;
                try {
                    holder.flushRptInfo(new DBRoute("cal"));
                }
                catch (Exception e1) {
                    h.markRollback();
                    throw e1;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
    }

    private void flushCostAdjust() {
        for (Map.Entry<String, CostDomainDataInfo> e : this.domainMap.entrySet()) {
            CostDomainDataInfo domainInfo = e.getValue();
            if (RptStatus.ERROR.getValue().equals(domainInfo.getHolder().getCalStatusValue()) || domainInfo.getAdjustInfoMap().isEmpty()) continue;
            DynamicObject[] adjustDyInfos = new DynamicObject[domainInfo.getAdjustInfoMap().size()];
            int i = 0;
            HashMap periodAdjustInfoMap = new HashMap(16);
            for (CostAdjustInfo costAdjustInfo : domainInfo.getAdjustInfoMap().values()) {
                adjustDyInfos[i] = costAdjustInfo.getCostAdjustBill();
                ++i;
                Object period = costAdjustInfo.getCostAdjustBill().get("period");
                periodAdjustInfoMap.putIfAbsent(period, new ArrayList());
                List adjustInfoList = (List)periodAdjustInfoMap.get(period);
                adjustInfoList.add(costAdjustInfo.getCostAdjustEntryId());
            }
            SaveServiceHelper.save((DynamicObject[])adjustDyInfos);
            HashSet<Long> adjustIdSet = new HashSet<Long>(16);
            for (DynamicObject info : adjustDyInfos) {
                adjustIdSet.add(info.getLong("id"));
            }
            DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((Object[])adjustIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
            OperateOption option = OperateOption.create();
            option.setVariableValue("ignoreop", "true");
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("ignoreValidation", "true");
            OperationResult opResult = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])dynamicObjectArray, (OperateOption)option);
            if (!opResult.isSuccess()) {
                throw new KDBizException(opResult.getAllErrorOrValidateInfo() + "\r\n" + opResult.getMessage());
            }
            for (List entryIdList : periodAdjustInfoMap.values()) {
                this.ctx.getBalanceCalculator().updateBalance4CostAdjust(entryIdList.toArray());
            }
        }
    }

    private void afterEndCalculated() {
    }

    protected LocalRow getGroupedRow(Long rowId) {
        return this.ctx.getGroupBillHolder().getGroupedLocalRow(rowId, this.calbycostelement);
    }

    protected final void getCostPrice4CostRecord(LocalRow row, String priceObject) {
        if (!"1".equals(row.getRowtype())) {
            return;
        }
        CostDomainDataInfo domainInfo = this.domainMap.get(row.getCostDomainId());
        CostPriceResultInfo priceResult = this.getCostPrice(row.getHeadid(), row.getEntryId(), row.getRowtype(), priceObject);
        row.setPriceResult(priceResult);
        if (priceResult == null || !priceResult.isSuccess()) {
            domainInfo.setHasPriceFailedBill(true);
        }
    }

    protected void loopInBillGetPrice(LocalRow groupedRow) {
        if (!groupedRow.isCostDetermined() && !groupedRow.isGroupCostCalculated().booleanValue() && this.isPriced && "0".equals(groupedRow.getQueuetype()) && groupedRow.isDestBill() && this.ctx.enableLoopInBill()) {
            this.getCostPrice4CostRecord(groupedRow, "D");
        }
    }

    protected void doCalculate(AccountTypeContext ctx, Long rowId, LocalRow localRow) throws KDBizException {
        if (rowId == null) {
            return;
        }
        LocalRow groupedRow = this.getGroupedRow(rowId);
        if (groupedRow == null) {
            if ("OUT".equals(localRow.getCalbilltype()) && "0".equals(localRow.getQueuetype()) && ctx.enableNoSrcOutReturn()) {
                this.getCostPrice4CostRecord(localRow, "I");
            }
            this.calculateOut(localRow);
        } else {
            if (!groupedRow.isCostDetermined() && groupedRow.isGroupCostCalculated().booleanValue() && groupedRow.isDestBill()) {
                ArrayList<LocalRow> localRows = new ArrayList<LocalRow>(1);
                localRows.add(groupedRow);
                this.afterCalcGroupCost(localRows);
            }
            this.loopInBillGetPrice(groupedRow);
            groupedRow.setBizbillid(localRow.getBizbillid());
            groupedRow.setBizbillentryid(localRow.getBizbillentryid());
            groupedRow.setBilltypenum(localRow.getBilltypenum());
            groupedRow.setBilltype(localRow.getBilltype());
            groupedRow.setBillnumber(localRow.getBillnumber());
            groupedRow.setBizTypeId(localRow.getBizTypeId());
            groupedRow.setCalbilltype(localRow.getCalbilltype());
            groupedRow.setBizDate(localRow.getBizDate());
            groupedRow.setAuditTime(localRow.getAuditTime());
            groupedRow.setEntrySeq(localRow.getEntrySeq());
            groupedRow.setBaseUnitId(localRow.getBaseUnitId());
            groupedRow.setQtyPrecision(localRow.getQtyPrecision());
            this.calculateOut(groupedRow);
        }
    }

    protected void calculateOut(LocalRow row) {
        String currentRowType = row.getQueuetype();
        if ("0".equals(currentRowType)) {
            this.calInQueueCost(row);
        } else {
            this.calOutQueueCost(row);
        }
    }

    protected void sumToTotal(CostAdjustInfo adjustInfo, CostDomainDataInfo domainInfo) {
        domainInfo.setCurrentTotalCost(domainInfo.getCurrentTotalCost().add(adjustInfo.getAdjustAmt()));
        for (Long elementId : this.elementMap.keySet()) {
            BigDecimal elementTotalCost = domainInfo.getCurrentTotalElementCostMap().get(elementId);
            BigDecimal rowElementCost = adjustInfo.getAdjustCost(elementId);
            elementTotalCost = elementTotalCost.add(rowElementCost);
            domainInfo.getCurrentTotalElementCostMap().put(elementId, elementTotalCost.stripTrailingZeros());
        }
    }

    private void substractToTotal(CostAdjustInfo adjustInfo, CostDomainDataInfo domainInfo) {
        domainInfo.setCurrentTotalCost(domainInfo.getCurrentTotalCost().subtract(adjustInfo.getAdjustAmt()));
        for (Long elementId : this.elementMap.keySet()) {
            BigDecimal elementTotalCost = domainInfo.getCurrentTotalElementCostMap().get(elementId);
            BigDecimal rowElementCost = adjustInfo.getAdjustCost(elementId);
            elementTotalCost = elementTotalCost.subtract(rowElementCost);
            domainInfo.getCurrentTotalElementCostMap().put(elementId, elementTotalCost.stripTrailingZeros());
        }
    }

    private void joinCalculate(CostAdjustInfo adjustInfo, CostDomainDataInfo domainInfo) {
        if (adjustInfo == null) {
            return;
        }
        CalOutRptHolder holder = domainInfo.getHolder();
        int index = holder.createNewEntry(adjustInfo);
        StringBuilder formula = new StringBuilder();
        formula.append(this.toBigDecimalString(BigDecimal.ZERO.setScale(domainInfo.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(BigDecimal.ZERO.setScale(domainInfo.getPricePrecision())));
        formula.append('=');
        formula.append(this.toBigDecimalString(adjustInfo.getAdjustAmt().setScale(domainInfo.getAmtPrecision(), RoundingMode.HALF_UP)));
        if ("A".equals(adjustInfo.getCallBillType())) {
            holder.setInFormula(index, formula.toString());
        } else {
            holder.setOutFormula(index, formula.toString());
        }
        formula.setLength(0);
        BigDecimal currentTotalQty = domainInfo.getCurrentTotalQty();
        BigDecimal currentTotalCost = domainInfo.getCurrentTotalCost();
        formula.append(this.toBigDecimalString(currentTotalQty.setScale(domainInfo.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(domainInfo.getCurrentUnitCost().setScale(domainInfo.getPricePrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        formula.append(this.toBigDecimalString(currentTotalCost.setScale(domainInfo.getAmtPrecision(), RoundingMode.HALF_UP)));
        formula.append('\n');
        holder.setBalanceFormula(index, formula.toString());
        HashMap<Long, Integer> subIndexMap = new HashMap<Long, Integer>(this.elementMap.size());
        for (Map.Entry<Long, CostSubElement> entry : this.elementMap.entrySet()) {
            Long elementId = entry.getKey();
            BigDecimal elementCost = adjustInfo.getAdjustCost(elementId);
            BigDecimal elementTotalCost = domainInfo.getCurrentTotalElementCostMap().get(elementId);
            if (elementCost.compareTo(BigDecimal.ZERO) == 0 && elementTotalCost.compareTo(BigDecimal.ZERO) == 0) continue;
            int subIndex = holder.createNewSubEntry(index, entry.getValue().getName());
            formula.setLength(0);
            formula.append(this.toBigDecimalString(adjustInfo.getAdjustCost(elementId).setScale(domainInfo.getAmtPrecision(), RoundingMode.HALF_UP)));
            if ("A".equals(adjustInfo.getCallBillType())) {
                holder.setInFormula(subIndex, formula.toString());
            } else {
                holder.setOutFormula(subIndex, formula.toString());
            }
            formula.setLength(0);
            formula.append(this.toBigDecimalString(currentTotalQty.setScale(domainInfo.getQtyPrecision(), RoundingMode.HALF_UP)));
            formula.append('*');
            formula.append(currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? this.toBigDecimalString(BigDecimal.ZERO.setScale(domainInfo.getPricePrecision(), RoundingMode.HALF_UP)) : this.toBigDecimalString(elementTotalCost.divide(currentTotalQty, domainInfo.getPricePrecision(), RoundingMode.HALF_UP)));
            formula.append('=');
            formula.append(this.toBigDecimalString(elementTotalCost.setScale(domainInfo.getAmtPrecision(), RoundingMode.HALF_UP)));
            formula.append('\n');
            holder.setBalanceFormula(subIndex, formula.toString());
            subIndexMap.put(elementId, subIndex);
        }
        if ("A".equals(adjustInfo.getCallBillType())) {
            this.sumToTotal(adjustInfo, domainInfo);
        } else {
            this.substractToTotal(adjustInfo, domainInfo);
        }
        formula.setLength(0);
        currentTotalCost = domainInfo.getCurrentTotalCost();
        currentTotalQty = domainInfo.getCurrentTotalQty();
        domainInfo.setCurrentUnitCost(currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : currentTotalCost.divide(currentTotalQty, 10, RoundingMode.HALF_UP));
        formula.append(this.toBigDecimalString(currentTotalQty.setScale(domainInfo.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(domainInfo.getCurrentUnitCost().setScale(domainInfo.getPricePrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        formula.append(this.toBigDecimalString(currentTotalCost.setScale(domainInfo.getAmtPrecision(), RoundingMode.HALF_UP)));
        holder.appendBalanceFormula(index, formula.toString());
        for (Map.Entry<Long, CostSubElement> entry : subIndexMap.entrySet()) {
            formula.setLength(0);
            BigDecimal elementTotalCost = domainInfo.getCurrentTotalElementCostMap().get(entry.getKey());
            BigDecimal elementUnitCost = currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : elementTotalCost.divide(currentTotalQty, 10, RoundingMode.HALF_UP);
            domainInfo.getCurrentElementUnitCost().put(entry.getKey(), elementUnitCost);
            formula.append(this.toBigDecimalString(currentTotalQty.setScale(domainInfo.getQtyPrecision(), RoundingMode.HALF_UP)));
            formula.append('*');
            formula.append(this.toBigDecimalString(elementUnitCost.setScale(domainInfo.getPricePrecision(), RoundingMode.HALF_UP)));
            formula.append('=');
            formula.append(this.toBigDecimalString(elementTotalCost.setScale(domainInfo.getAmtPrecision(), RoundingMode.HALF_UP)));
            holder.appendBalanceFormula((Integer)((Object)entry.getValue()), formula.toString());
        }
    }

    private void joinCalculate(LocalRow row, String exDescription, CostPriceResultInfo priceInfo) {
        String costPriceSourceStr;
        CostDomainDataInfo domainInfo = this.domainMap.get(row.getCostDomainId());
        CalOutRptHolder holder = domainInfo.getHolder();
        int index = holder.createNewEntry(row);
        String costpricesource = row.getCostpricesource();
        if (StringUtils.isNotEmpty((String)costpricesource) && StringUtils.isNotEmpty((String)(costPriceSourceStr = CostPriceSourceTypeEnum.getAllNameByCostPriceSources(costpricesource)))) {
            holder.setDescribe(index, costPriceSourceStr);
        }
        String billtypestr = row.getBilltype();
        if (!"cal_costadjustbill".equals(row.getBilltypenum())) {
            String vouStr = null;
            if (!row.isCostDetermined()) {
                vouStr = ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1", (String)"CalculateOutCostPlugin_30", (String)"fi-calx-algox", (Object[])new Object[0]);
            }
            if (!StringUtils.isEmpty(vouStr)) {
                billtypestr = row.getBilltype() + "(" + vouStr + ")";
            }
            holder.setBillType(index, billtypestr);
        }
        if (exDescription != null) {
            holder.setBillType(index, billtypestr + exDescription);
        } else if (row.isPriced()) {
            CostPriceResultInfo billPriceInfo = row.getPriceResult();
            if (billPriceInfo.isSuccess()) {
                Iterator<Map.Entry<Long, BigDecimal>> msg = String.format(ResManager.loadKDString((String)"%1$s(\u6765\u6e90\u4e8e\u53d6\u4ef7)", (String)"WeightedAvgAT_2", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
                holder.setBillType(index, (String)((Object)msg));
            } else {
                holder.setBillType(index, billtypestr + "(" + billPriceInfo.getErrMsg() + ")");
            }
        }
        if (priceInfo != null && priceInfo.isSuccess()) {
            BigDecimal currentUnitCost = priceInfo.getTotalUnitCost();
            domainInfo.setCurrentUnitCost(currentUnitCost);
            for (Map.Entry entry : priceInfo.getCostSubElementUnitcostMap().entrySet()) {
                domainInfo.getCurrentElementUnitCost().put((Long)entry.getKey(), (BigDecimal)entry.getValue());
            }
            for (Map.Entry<Long, BigDecimal> entry : domainInfo.getCurrentElementUnitCost().entrySet()) {
                Long elementId = entry.getKey();
                BigDecimal unitCost = entry.getValue();
                row.setDirectUnitCost(entry.getKey(), unitCost);
                row.setDirectCost(elementId, unitCost.multiply(row.getBaseqty()).setScale(domainInfo.getAmtPrecision(), RoundingMode.HALF_UP));
            }
            row.refreshDirectActualCostByElement();
        }
        StringBuilder formula = new StringBuilder();
        BigDecimal currentTotalQty = domainInfo.getCurrentTotalQty();
        BigDecimal bigDecimal = domainInfo.getCurrentTotalCost();
        formula.append(this.toBigDecimalString(currentTotalQty.setScale(domainInfo.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(domainInfo.getCurrentUnitCost().setScale(domainInfo.getPricePrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        formula.append(this.toBigDecimalString(bigDecimal.setScale(row.getAmtprecision(), RoundingMode.HALF_UP)));
        formula.append('\n');
        holder.setBalanceFormula(index, formula.toString());
        HashMap<Long, Integer> subIndexMap = new HashMap<Long, Integer>(this.elementMap.size());
        for (Map.Entry<Long, CostSubElement> entry : this.elementMap.entrySet()) {
            Long elementId = entry.getKey();
            BigDecimal elementCost = row.getCost(elementId);
            BigDecimal elementTotalCost = domainInfo.getCurrentTotalElementCostMap().get(elementId);
            if (priceInfo == null && elementCost.compareTo(BigDecimal.ZERO) == 0 && elementTotalCost.compareTo(BigDecimal.ZERO) == 0) continue;
            int subIndex = holder.createNewSubEntry(index, entry.getValue().getName());
            formula.setLength(0);
            formula.append(this.toBigDecimalString(row.getCost(elementId).setScale(row.getAmtprecision(), RoundingMode.HALF_UP)));
            if ("0".equals(row.getQueuetype())) {
                holder.setInFormula(subIndex, formula.toString());
            } else {
                holder.setOutFormula(subIndex, formula.toString());
            }
            formula.setLength(0);
            BigDecimal unitElementTotalCost = domainInfo.getCurrentElementUnitCost().get(elementId);
            formula.append(this.toBigDecimalString(currentTotalQty.setScale(domainInfo.getQtyPrecision(), RoundingMode.HALF_UP)));
            formula.append('*');
            formula.append(this.toBigDecimalString(unitElementTotalCost.setScale(domainInfo.getPricePrecision(), RoundingMode.HALF_UP)));
            formula.append('=');
            formula.append(this.toBigDecimalString(elementTotalCost.setScale(row.getAmtprecision(), RoundingMode.HALF_UP)));
            formula.append('\n');
            holder.setBalanceFormula(subIndex, formula.toString());
            subIndexMap.put(elementId, subIndex);
        }
        formula.setLength(0);
        formula.append(this.toBigDecimalString(row.getBaseqty().setScale(domainInfo.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(row.getUnitActualCost().setScale(domainInfo.getPricePrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        formula.append(this.toBigDecimalString(row.getActualCost().setScale(row.getAmtprecision(), RoundingMode.HALF_UP)));
        if ("0".equals(row.getQueuetype())) {
            holder.setInFormula(index, formula.toString());
        } else {
            holder.setOutFormula(index, formula.toString());
        }
        if ("0".equals(row.getQueuetype())) {
            this.sumToTotal(row);
        } else {
            this.substractToTotal(row);
        }
        formula.setLength(0);
        BigDecimal bigDecimal2 = domainInfo.getCurrentTotalCost();
        currentTotalQty = domainInfo.getCurrentTotalQty();
        domainInfo.setCurrentUnitCost(currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : bigDecimal2.divide(currentTotalQty, 10, RoundingMode.HALF_UP));
        formula.append(this.toBigDecimalString(currentTotalQty.setScale(domainInfo.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(domainInfo.getCurrentUnitCost().setScale(domainInfo.getPricePrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        formula.append(this.toBigDecimalString(bigDecimal2.setScale(domainInfo.getAmtPrecision(), RoundingMode.HALF_UP)));
        holder.appendBalanceFormula(index, formula.toString());
        for (Map.Entry<Long, CostSubElement> entry : subIndexMap.entrySet()) {
            formula.setLength(0);
            BigDecimal elementTotalCost = domainInfo.getCurrentTotalElementCostMap().get(entry.getKey());
            BigDecimal elementUnitCost = currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : elementTotalCost.divide(currentTotalQty, 10, RoundingMode.HALF_UP);
            domainInfo.getCurrentElementUnitCost().put(entry.getKey(), elementUnitCost);
            formula.append(this.toBigDecimalString(currentTotalQty.setScale(domainInfo.getQtyPrecision(), RoundingMode.HALF_UP)));
            formula.append('*');
            formula.append(this.toBigDecimalString(elementUnitCost.setScale(domainInfo.getPricePrecision(), RoundingMode.HALF_UP)));
            formula.append('=');
            formula.append(this.toBigDecimalString(elementTotalCost.setScale(row.getAmtprecision(), RoundingMode.HALF_UP)));
            holder.appendBalanceFormula((Integer)((Object)entry.getValue()), formula.toString());
        }
        this.dealSpCondition(row);
    }

    private void dealSpCondition(LocalRow row) {
        CostDomainDataInfo domainInfo = this.domainMap.get(row.getCostDomainId());
        CostAdjustInfo adjustInfo = null;
        BigDecimal currentTotalQty = domainInfo.getCurrentTotalQty();
        BigDecimal currentTotalCost = domainInfo.getCurrentTotalCost();
        if (currentTotalQty.compareTo(BigDecimal.ZERO) == 0 && currentTotalCost.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObject costAdjustOutBillType = (DynamicObject)this.ctx.getParamCache().getParamValue("costAdjustOutBillType");
            adjustInfo = this.createCostAdjustInfo(row, "B", "N", costAdjustOutBillType, domainInfo);
            for (Map.Entry<Long, BigDecimal> entry : domainInfo.getCurrentTotalElementCostMap().entrySet()) {
                BigDecimal totalCost = entry.getValue();
                Long elementId = entry.getKey();
                adjustInfo.setAdjustCost(this.elementMap.get(elementId), totalCost);
            }
            this.joinCalculate(adjustInfo, domainInfo);
        }
    }

    protected void substractToTotal(LocalRow row) {
        CostDomainDataInfo domainInfo = this.domainMap.get(row.getCostDomainId());
        domainInfo.setCurrentTotalQty(domainInfo.getCurrentTotalQty().subtract(row.getBaseqty()).stripTrailingZeros());
        domainInfo.setCurrentTotalCost(domainInfo.getCurrentTotalCost().subtract(row.getActualCost()).setScale(row.getAmtprecision(), RoundingMode.HALF_UP));
        for (Long elementId : this.elementMap.keySet()) {
            BigDecimal elementTotalCost = domainInfo.getCurrentTotalElementCostMap().get(elementId);
            BigDecimal rowElementCost = row.getCost(elementId);
            elementTotalCost = elementTotalCost.subtract(rowElementCost);
            domainInfo.getCurrentTotalElementCostMap().put(elementId, elementTotalCost.stripTrailingZeros());
        }
    }

    protected void sumToTotal(LocalRow row) {
        CostDomainDataInfo domainInfo = this.domainMap.get(row.getCostDomainId());
        domainInfo.setCurrentTotalQty(domainInfo.getCurrentTotalQty().add(row.getBaseqty()).stripTrailingZeros());
        domainInfo.setCurrentTotalCost(domainInfo.getCurrentTotalCost().add(row.getActualCost()).setScale(row.getAmtprecision(), RoundingMode.HALF_UP));
        for (Long elementId : this.elementMap.keySet()) {
            BigDecimal elementTotalCost = domainInfo.getCurrentTotalElementCostMap().get(elementId);
            BigDecimal rowElementCost = row.getCost(elementId);
            elementTotalCost = elementTotalCost.add(rowElementCost);
            domainInfo.getCurrentTotalElementCostMap().put(elementId, elementTotalCost.stripTrailingZeros());
        }
    }

    private void joinCalRpt(String description, CostPriceResultInfo priceInfo, CostDomainDataInfo domainInfo) {
        if (!priceInfo.isSuccess()) {
            domainInfo.setHasPriceFailed(true);
        }
        CalOutRptHolder holder = domainInfo.getHolder();
        int index = holder.createNewEntry();
        holder.setBillType(index, description);
        if (!priceInfo.isSuccess()) {
            holder.setInFormula(index, priceInfo.getErrMsg());
        } else {
            holder.setInFormula(index, this.toBigDecimalString(priceInfo.getTotalUnitCost().setScale(domainInfo.getPricePrecision(), RoundingMode.HALF_UP)));
            for (Map.Entry<Long, BigDecimal> priceEntry : priceInfo.getCostSubElementUnitcostMap().entrySet()) {
                int subIndex = holder.createNewSubEntry(index, this.elementMap.get(priceEntry.getKey()).getName());
                holder.setInFormula(subIndex, priceInfo.getSrcPriceName() + ":" + this.toBigDecimalString(priceEntry.getValue().setScale(domainInfo.getPricePrecision(), RoundingMode.HALF_UP)));
            }
        }
    }

    private void calOutQueueCost(LocalRow row) {
        CostPriceResultInfo priceInfo;
        CostDomainDataInfo domainInfo = this.domainMap.get(row.getCostDomainId());
        if ("2".equals(row.getRowtype())) {
            this.joinCalculate(row, null, null);
            return;
        }
        if (row.isCostDetermined()) {
            if (row.isDestBill() && !row.isGroupCostCalculated().booleanValue()) {
                domainInfo.getTempInGroupRow().add(row);
            } else {
                this.joinCalculate(row, null, null);
                if (row.isDestBill()) {
                    this.joinCalculate(this.addGroupBillCostAdjustInfo(row), domainInfo);
                }
            }
            return;
        }
        if (row.isDestBill()) {
            if (row.isGroupCostCalculated().booleanValue()) {
                this.joinCalculate(row, null, null);
                this.addCostUpdateInfo(row);
                CostAdjustInfo costAdjustInfo = this.addGroupBillCostAdjustInfo(row);
                if (costAdjustInfo != null) {
                    this.joinCalculate(costAdjustInfo, domainInfo);
                }
            } else {
                domainInfo.getTempInGroupRow().add(row);
            }
            return;
        }
        BigDecimal qty = row.getBaseqty();
        BigDecimal currentTotalQty = domainInfo.getCurrentTotalQty();
        if (domainInfo.getCurrentUnitCost().compareTo(BigDecimal.ZERO) == 0 && this.ctx.enableZeroPrice() && currentTotalQty.compareTo(BigDecimal.ZERO) == 0 && (priceInfo = this.getCostPrice(row.getHeadid(), row.getEntryId(), row.getRowtype(), "E")) != null) {
            this.joinCalRpt(ResManager.loadKDString((String)"\u96f6\u5355\u4ef7\u53d6\u4ef7\u7ed3\u679c", (String)"WeightedAvgAT_5", (String)"fi-calx-algox", (Object[])new Object[0]), priceInfo, domainInfo);
            this.joinCalculate(row, null, priceInfo);
            row.setGroupCostCalculated(true);
            this.addCostUpdateInfo(row);
            return;
        }
        if (domainInfo.getCurrentUnitCost().compareTo(BigDecimal.ZERO) < 0 && this.ctx.enableBalanceNeg() && (priceInfo = this.getCostPrice(row.getHeadid(), row.getEntryId(), row.getRowtype(), "H")) != null) {
            this.joinCalRpt(ResManager.loadKDString((String)"\u8d1f\u5355\u4ef7\u53d6\u4ef7\u7ed3\u679c", (String)"MovedAvgIntimeAT_0", (String)"fi-calx-algox", (Object[])new Object[0]), priceInfo, domainInfo);
            DynamicObject costAdjustOutBillType = (DynamicObject)this.ctx.getParamCache().getParamValue("costAdjustOutBillType");
            CostAdjustInfo adjustInfo = this.createCostAdjustInfo(row, "B", "N", costAdjustOutBillType, domainInfo);
            for (Map.Entry<Long, BigDecimal> priceEntry : priceInfo.getCostSubElementUnitcostMap().entrySet()) {
                Long elementId = priceEntry.getKey();
                BigDecimal newUnitCost = priceEntry.getValue();
                BigDecimal adjustUnitCost = domainInfo.getCurrentElementUnitCost().get(elementId).subtract(newUnitCost);
                adjustInfo.setAdjustCost(this.elementMap.get(elementId), adjustUnitCost.multiply(currentTotalQty).setScale(row.getAmtprecision(), RoundingMode.HALF_UP));
            }
            this.joinCalculate(adjustInfo, domainInfo);
        }
        for (Map.Entry<Long, BigDecimal> entry : domainInfo.getCurrentElementUnitCost().entrySet()) {
            Long elementId = entry.getKey();
            BigDecimal totalCost = domainInfo.getCurrentTotalElementCostMap().get(elementId);
            BigDecimal unitCost = entry.getValue();
            row.setDirectUnitCost(entry.getKey(), unitCost);
            if (qty.compareTo(currentTotalQty) == 0) {
                row.setDirectCost(entry.getKey(), totalCost);
                continue;
            }
            row.setDirectCost(elementId, unitCost.multiply(qty).setScale(domainInfo.getAmtPrecision(), RoundingMode.HALF_UP));
        }
        row.refreshDirectActualCostByElement();
        this.joinCalculate(row, null, null);
        row.setGroupCostCalculated(true);
        this.addCostUpdateInfo(row);
    }

    protected final CostPriceResultInfo getCostPrice(Long rowHeadId, Long rowEntryId, String rowType, String priceConstant) {
        CostPriceResultInfo result = null;
        if ("1".equals(rowType)) {
            result = this.ctx.getPriceHelper().getPriceFromEntryId("cal_costrecord_subentity", rowHeadId, rowEntryId, priceConstant);
        } else if ("2".equals(rowType)) {
            result = this.ctx.getPriceHelper().getPriceFromEntryId("cal_costadjust_subentity", rowHeadId, rowEntryId, priceConstant);
        }
        return result;
    }

    protected CostAdjustInfo createCostAdjustInfo(LocalRow row, String callBillType, String createType, DynamicObject costAdjustOutBillType, CostDomainDataInfo domainInfo) {
        CostAdjustInfo info = null;
        if ("1".equals(row.getRowtype())) {
            info = CostAdjustInfo.createCostAdjustByRecord(row.getHeadid(), row.getEntryId(), callBillType, createType, costAdjustOutBillType);
        } else if ("2".equals(row.getRowtype())) {
            info = CostAdjustInfo.createCostAdjustByAdjust(row.getHeadid(), row.getEntryId(), callBillType, createType, costAdjustOutBillType);
        }
        if (info != null) {
            domainInfo.getAdjustInfoMap().put(info.getCostAdjustEntryId(), info);
        }
        return info;
    }

    protected final CostAdjustInfo addGroupBillCostAdjustInfo(LocalRow row) {
        CostDomainDataInfo domainInfo = this.domainMap.get(row.getCostDomainId());
        if (!row.isGenGroupAdjBill()) {
            return null;
        }
        String callbilltype = null;
        callbilltype = row.getQueuetype().equals("0") ? "A" : "B";
        CostAdjustInfo adjustInfo = null;
        BigDecimal totalAdjustAmt = BigDecimal.ZERO;
        for (Map.Entry<Object, BigDecimal> entry : row.getGroupCostAmtMap().entrySet()) {
            BigDecimal adjustCost = BigDecimal.ZERO;
            adjustCost = row.isCalbycostelement() ? entry.getValue().abs().subtract(row.getCost((Long)entry.getKey()).abs()) : entry.getValue().abs().subtract(row.getCost((String)entry.getKey()).abs());
            if (adjustCost.compareTo(BigDecimal.ZERO) == 0) continue;
            if (adjustInfo == null) {
                adjustInfo = CostAdjustInfo.createCostAdjustByRecord(row.getHeadid(), row.getEntryId(), callbilltype, "F", null);
            }
            adjustCost = adjustCost.multiply(row.getSign());
            totalAdjustAmt = totalAdjustAmt.add(adjustCost);
            if (!row.isCalbycostelement()) continue;
            adjustInfo.setAdjustCost(this.elementMap.get((Long)entry.getKey()), adjustCost);
        }
        if (adjustInfo != null) {
            if (!row.isCalbycostelement()) {
                adjustInfo.setAdjustCost(this.elementMap.get(773175233367685120L), totalAdjustAmt);
            }
            domainInfo.getAdjustInfoMap().put(adjustInfo.getCostAdjustEntryId(), adjustInfo);
        }
        return adjustInfo;
    }

    private void calInQueueCost(LocalRow row) {
        CostDomainDataInfo domainInfo = this.domainMap.get(row.getCostDomainId());
        if ("2".equals(row.getRowtype())) {
            this.joinCalculate(row, null, null);
            return;
        }
        if (row.isCostDetermined()) {
            if (row.isDestBill() && !row.isGroupCostCalculated().booleanValue()) {
                domainInfo.getTempInGroupRow().add(row);
            } else {
                this.joinCalculate(row, null, null);
                if (row.isDestBill()) {
                    this.joinCalculate(this.addGroupBillCostAdjustInfo(row), domainInfo);
                }
            }
        } else if (row.isDestBill()) {
            if (row.isGroupCostCalculated().booleanValue()) {
                this.joinCalculate(row, null, null);
                this.addCostUpdateInfo(row);
                CostAdjustInfo costAdjustInfo = this.addGroupBillCostAdjustInfo(row);
                if (costAdjustInfo != null) {
                    this.joinCalculate(costAdjustInfo, domainInfo);
                }
            } else if (row.isPriced()) {
                CostPriceResultInfo priceResult = row.getPriceResult();
                if (priceResult.isSuccess()) {
                    this.joinCalculate(row, null, null);
                    this.addCostUpdateInfo(row);
                    this.joinCalculate(this.addGroupBillCostAdjustInfo(row), domainInfo);
                } else {
                    domainInfo.getTempInGroupRow().add(row);
                }
            } else {
                domainInfo.getTempInGroupRow().add(row);
            }
        } else {
            this.joinCalculate(row, null, null);
        }
        if (row.isDestBill() && row.isGroupCostCalculated().booleanValue() || row.isPriced() && row.getPriceResult().isSuccess()) {
            this.addCostUpdateInfo(row);
        }
    }

    protected void addCostUpdateInfo(LocalRow row) {
        CostDomainDataInfo domainInfo = this.domainMap.get(row.getCostDomainId());
        if (row.getUnitActualCost().compareTo(BigDecimal.ZERO) < 0) {
            domainInfo.getExceptionRow().add(row);
            return;
        }
        Object[] updateInfo = domainInfo.getToUpdatedRowMap().get(row.getEntryId());
        if (updateInfo == null) {
            updateInfo = this.ctx.createUpdateInfo(row);
            domainInfo.getToUpdatedRowMap().put(row.getEntryId(), updateInfo);
        }
        if (row.isDestBill()) {
            domainInfo.getToUpdatedGroupRowMap().put(row.getEntryId(), updateInfo);
        }
        this.ctx.setUpdateCost(row, updateInfo);
    }

    private LocalRow createCurrentRow(Row row) {
        LocalRow localRow = new LocalRow(this.calbycostelement, this.elementMap);
        localRow.setHeadid(row.getLong("id"));
        localRow.setEntyrId(row.getLong("entryid"));
        localRow.setCostaccountid(row.getLong("costaccount"));
        localRow.setLocalcurrencyid(row.getLong("localcurrency"));
        localRow.setPriceprecision(10);
        localRow.setAmtprecision(row.getInteger("amtprecision"));
        localRow.setQtyPrecision(row.getInteger("qtyprecision"));
        localRow.setRowtype(row.getString("rowtype"));
        BigDecimal signnum = BigDecimal.valueOf(row.getInteger("signnum").intValue());
        localRow.setSignnum(signnum);
        localRow.setBaseqty(row.getBigDecimal("baseqty").multiply(signnum));
        if ("2".equals(localRow.getRowtype())) {
            localRow.setSign(BigDecimal.valueOf(row.getBigDecimal("actualcost").signum()).multiply(signnum));
        } else if ("1".equals(localRow.getRowtype())) {
            localRow.setSign(BigDecimal.valueOf(localRow.getBaseqty().signum()));
        }
        localRow.setQueuetype(row.getString("queuetype"));
        localRow.setCalbilltype(row.getString("calbilltype"));
        localRow.setBizbillid(row.getLong("bizbillid"));
        localRow.setBizbillentryid(row.getLong("bizbillentryid"));
        localRow.setBizTypeId(row.getLong("biztypeid"));
        localRow.setBilltypenum(row.getString("billtypenum"));
        localRow.setBilltype(row.getString("billtypename"));
        localRow.setBillnumber(row.getString("billnumber"));
        localRow.setBizDate(row.getDate("bizdate"));
        localRow.setAuditTime(row.getDate("auditdate"));
        localRow.setPeriodid(row.getLong("periodid"));
        localRow.setBaseUnitId(row.getLong("baseunit"));
        localRow.setCostDomainId(row.getString("costdomainid"));
        localRow.setMaterialcost(row.getBigDecimal("materialcost").multiply(signnum));
        localRow.setProcesscost(row.getBigDecimal("processcost").multiply(signnum));
        localRow.setFee(row.getBigDecimal("fee").multiply(signnum));
        BigDecimal manufacturecost = BigDecimal.ZERO;
        BigDecimal resource = BigDecimal.ZERO;
        if (row.getBigDecimal("manufacturecost") != null) {
            manufacturecost = row.getBigDecimal("manufacturecost");
        }
        if (row.getBigDecimal("resource") != null) {
            resource = row.getBigDecimal("resource");
        }
        localRow.setManufacturecost(manufacturecost.multiply(signnum));
        localRow.setResource(resource.multiply(signnum));
        localRow.setEntrySeq(row.getInteger("entryseq"));
        boolean isVoucher = row.getBoolean("isvoucher");
        boolean isCalculated = row.getBoolean("iscalculated");
        boolean isrework = row.getBoolean("isrework");
        localRow.setCostDetermined(isVoucher || isCalculated && 2 == this.runningMode || isrework && this.ctx.enableRework());
        localRow.setVoucher(isVoucher);
        for (Long elementId : this.elementMap.keySet()) {
            BigDecimal elementCost = row.getBigDecimal(elementId.toString());
            if (elementCost == null) {
                elementCost = BigDecimal.ZERO;
            }
            localRow.setCost(elementId, elementCost.multiply(signnum));
        }
        localRow.refreshActualCost();
        localRow.setCostpricesource(row.getString("costpricesource"));
        localRow.setDesignatedcost(row.getBoolean("designatedcost"));
        return localRow;
    }

    protected void beforeCalculated() {
        for (Map.Entry<String, CostDomainDataInfo> e : this.domainMap.entrySet()) {
            CostDomainDataInfo domainInfo = e.getValue();
            BigDecimal totalQty = domainInfo.getCurrentTotalQty();
            BigDecimal totalCost = domainInfo.getCurrentTotalCost();
            BigDecimal currentUnitCost = totalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : totalCost.divide(totalQty, 10, RoundingMode.HALF_UP);
            domainInfo.setCurrentUnitCost(currentUnitCost);
            HashMap<Long, BigDecimal> currentElementUnitCost = new HashMap<Long, BigDecimal>();
            for (Map.Entry<Long, BigDecimal> entry : domainInfo.getCurrentTotalElementCostMap().entrySet()) {
                currentElementUnitCost.put(entry.getKey(), totalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : entry.getValue().divide(totalQty, 10, RoundingMode.HALF_UP));
            }
            domainInfo.setCurrentElementUnitCost(currentElementUnitCost);
        }
    }

    private String[] buildOrderByField() {
        String orderModel = CalDbParamServiceHelper.getString(CalDbParamConstant.CALCMOVE_ORDER_MODEL, null);
        if ("A".equals(orderModel)) {
            return new String[]{"bizdate", "auditdate", "queuetype desc", "entryid", "grouptype desc"};
        }
        return new String[]{"auditdate", "queuetype desc", "id", "entryid", "grouptype desc"};
    }

    protected void addRptBeginData() {
        for (Map.Entry<String, CostDomainDataInfo> e : this.domainMap.entrySet()) {
            CostDomainDataInfo domainInfo = e.getValue();
            CalOutRptHolder holder = domainInfo.getHolder();
            BigDecimal currentTotalQty = domainInfo.getCurrentTotalQty();
            BigDecimal currentTotalCost = domainInfo.getCurrentTotalCost();
            Map<Long, BigDecimal> currentTotalElementCost = domainInfo.getCurrentTotalElementCostMap();
            int pricePrecision = domainInfo.getCalPricePrecision();
            int index = holder.createNewEntry();
            holder.setBillType(index, ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"AbstractAccountType_4", (String)"fi-calx-algox", (Object[])new Object[0]));
            StringBuilder formula = new StringBuilder();
            formula.append(this.toBigDecimalString(currentTotalQty.setScale(domainInfo.getQtyPrecision(), RoundingMode.HALF_UP)));
            formula.append('*');
            BigDecimal unitActualCost = currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : currentTotalCost.divide(currentTotalQty, pricePrecision, RoundingMode.HALF_UP);
            formula.append(this.toBigDecimalString(unitActualCost));
            formula.append('=');
            formula.append(this.toBigDecimalString(currentTotalCost.setScale(domainInfo.getAmtPrecision(), RoundingMode.HALF_UP)));
            holder.setBalanceFormula(index, formula.toString());
            for (Map.Entry<Long, BigDecimal> entry : currentTotalElementCost.entrySet()) {
                Long elementId = entry.getKey();
                BigDecimal elementBalance = entry.getValue();
                if (elementBalance.compareTo(BigDecimal.ZERO) == 0) continue;
                int subIndex = holder.createNewSubEntry(index, this.elementMap.get(elementId).getName());
                formula.setLength(0);
                formula.append(this.toBigDecimalString(currentTotalQty.setScale(domainInfo.getQtyPrecision(), RoundingMode.HALF_UP)));
                formula.append('*');
                formula.append(this.toBigDecimalString(currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : elementBalance.divide(currentTotalQty, pricePrecision, RoundingMode.HALF_UP)));
                formula.append('=');
                formula.append(this.toBigDecimalString(elementBalance.setScale(domainInfo.getAmtPrecision(), RoundingMode.HALF_UP)));
                holder.setBalanceFormula(subIndex, formula.toString());
            }
        }
    }

    private void dealBalanceData(DataSet balanceData) {
        HashSet<Long> balanceIdSet = new HashSet<Long>(16);
        while (balanceData.hasNext()) {
            Row row = balanceData.next();
            Long balanceId = row.getLong("id");
            if (balanceIdSet.contains(balanceId)) continue;
            balanceIdSet.add(balanceId);
            String costDomainId = row.getString("costdomainid");
            CostDomainDataInfo domainInfo = this.domainMap.get(costDomainId);
            if (domainInfo.isEmptyRange()) {
                domainInfo.getHolder().addDivideBasisValue(row.getString("divideBasisValue"));
            }
            BigDecimal actualcost = row.getBigDecimal("actualcost");
            BigDecimal qty = row.getBigDecimal("baseqty");
            Map<Long, BigDecimal> currentTotalElementCost = domainInfo.getCurrentTotalElementCostMap();
            for (Long elementId : this.elementMap.keySet()) {
                BigDecimal elementBalance = currentTotalElementCost.get(elementId);
                currentTotalElementCost.put(elementId, elementBalance.add(row.getBigDecimal(elementId.toString())));
            }
            domainInfo.setCurrentTotalCost(domainInfo.getCurrentTotalCost().add(actualcost));
            domainInfo.setCurrentTotalQty(domainInfo.getCurrentTotalQty().add(qty));
        }
    }

    protected void initElementMap() {
        if (this.calbycostelement) {
            this.elementMap = this.ctx.getElementMap();
        } else {
            this.elementMap = new HashMap<Long, CostSubElement>();
            this.elementMap.put(773175233367685120L, this.ctx.getElementMap().get(773175233367685120L));
        }
    }

    protected String getBalanceRowType() {
        return "0";
    }

    protected String toBigDecimalString(BigDecimal bigdecimal) {
        String bgStr = bigdecimal.toPlainString();
        if (bigdecimal.signum() < 0) {
            bgStr = "(" + bgStr + ")";
        }
        return bgStr;
    }

    protected Map<Long, String> afterCalcGroupCost(List<LocalRow> inGroupRows) {
        List<String> implClassList = this.ctx.getCalGroupCostImplClasses();
        CalServiceHelper calServiceHelper = new CalServiceHelper();
        if (inGroupRows == null || inGroupRows.size() < 1) {
            return null;
        }
        BigDecimal actualCost = inGroupRows.get(0) == null ? BigDecimal.ZERO : inGroupRows.get(0).getActualCost();
        Long entryid = inGroupRows.get(0) == null ? Long.valueOf(0L) : inGroupRows.get(0).getEntryId();
        DiffAllocHelper.writeLog(logger, "AbstractAccountType_afterCalcGroupCost_billentryid:" + entryid + "_before_afterCalcGroupCost_actualcost:" + actualCost);
        Long currtime = System.currentTimeMillis();
        Map<Long, String> result = calServiceHelper.doBizChain(implClassList, inGroupRows);
        Long times = System.currentTimeMillis() - currtime;
        DiffAllocHelper.writeLog(logger, "AbstractAccountType_afterCalcGroupCost_time:" + times + "ms");
        actualCost = inGroupRows.get(0) == null ? BigDecimal.ZERO : inGroupRows.get(0).getActualCost();
        DiffAllocHelper.writeLog(logger, "AbstractAccountType_afterCalcGroupCost_billentryid:" + entryid + "_after_afterCalcGroupCost_actualcost:" + actualCost);
        return result;
    }
}

