/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.CostAccount;
import kd.fi.calx.algox.accounttype.IAccountType;
import kd.fi.calx.algox.function.AbstractAccountTypeFunction;
import kd.fi.calx.algox.function.AccountTypeContext;
import kd.fi.calx.algox.function.CommonInfo;

public class NoneAccountTypeFunction
extends AbstractAccountTypeFunction {
    private static final long serialVersionUID = 729220923445721258L;

    public NoneAccountTypeFunction(RowMeta rowMeta, CommonInfo commonInfo, Map<Long, CostAccount> costAccountMap) {
        super(rowMeta, commonInfo, costAccountMap);
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        try (DataSet dataSet = this.createDataSet(iterable).orderBy(new String[]{"bizbillentryid", "calbilltype desc", "grouptype desc"});){
            AccountTypeContext ctx = this.createContext(collector);
            for (Row row : dataSet.copy()) {
                ctx.getGroupBillHolder().addGroupRecord(row);
            }
            String accountTypeStr = dataSet.copy().next().getString("accountType");
            ArrayList<IAccountType> accountTypeList = new ArrayList<IAccountType>();
            IAccountType accountType = this.createAccountType(accountTypeStr, ctx, dataSet);
            if (accountType == null) {
                return;
            }
            accountTypeList.add(accountType);
            this.execute(ctx, accountTypeList);
        }
    }
}

