/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.CostAccount;
import kd.fi.calx.algox.accounttype.IAccountType;
import kd.fi.calx.algox.function.AbstractAccountTypeFunction;
import kd.fi.calx.algox.function.AccountTypeContext;
import kd.fi.calx.algox.function.CommonInfo;

public class OutAccountTypeFunction
extends AbstractAccountTypeFunction {
    private static final long serialVersionUID = -3337981435698990329L;

    public OutAccountTypeFunction(RowMeta rowMeta, CommonInfo commonInfo, Map<Long, CostAccount> costAccountMap) {
        super(rowMeta, commonInfo, costAccountMap);
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        try (DataSet dataSet = this.createDataSet(iterable);){
            DataSet[] CANDMDataSets;
            AccountTypeContext ctx = this.createContext(collector);
            DataSet groupDs = dataSet.copy().orderBy(new String[]{"bizbillentryid", "calbilltype desc", "grouptype desc"});
            for (Row row : groupDs) {
                ctx.getGroupBillHolder().addGroupRecord(row);
            }
            ArrayList<IAccountType> accountTypeList = new ArrayList<IAccountType>();
            DataSet CAandMSeqGroupSet = dataSet.copy().groupBy(new String[]{"material", "costaccount", "calRange", "periodid", "groupseq"}).finish().orderBy(new String[]{"groupseq"});
            ArrayList<String> filters = new ArrayList<String>(4);
            while (CAandMSeqGroupSet.hasNext()) {
                Row row = CAandMSeqGroupSet.next();
                Long costaccount = row.getLong("costaccount");
                Long material = row.getLong("material");
                Long calRange = row.getLong("calRange");
                Long periodid = row.getLong("periodid");
                int groupseq = row.getInteger("groupseq");
                filters.add("material = " + material + " and costaccount = " + costaccount + " and calRange = " + calRange + " and periodid = " + periodid + " and groupseq = " + groupseq);
            }
            if (filters.isEmpty()) {
                return;
            }
            for (DataSet CANDMDataSet : CANDMDataSets = dataSet.splitByFilter(filters.toArray(new String[0]), false)) {
                DataSet rptSet = CANDMDataSet.copy().groupBy(new String[]{"divideBasis", "divideBasisValue", "calRange", "calDimension", "calDimensionValue", "accountType", "isEmptyRange"}).min("ingroupseq").finish().orderBy(new String[]{"ingroupseq"});
                List<Map<String, Object>> groupList = this.getGroupList(rptSet);
                CANDMDataSet = CANDMDataSet.orderBy(new String[]{"ingroupseq", "bizbillentryid", "grouptype desc"});
                LinkedHashMap<String, AbstractAccountTypeFunction.CalRangeDataSet> calRangeDataMap = this.mergeCalRangeData(CANDMDataSet, groupList);
                for (AbstractAccountTypeFunction.CalRangeDataSet data : calRangeDataMap.values()) {
                    IAccountType accountType = this.createAccountType(data.getAccountType(), ctx, data.getDataSet());
                    if (accountType == null) continue;
                    accountTypeList.add(accountType);
                }
            }
            this.execute(ctx, accountTypeList);
        }
    }
}

