/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.util.HashSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.CalRange;
import kd.fi.calx.algox.CostAccount;

public class PrevCaldimensionFieldMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private CostAccount costAccount;

    public PrevCaldimensionFieldMapFunction(RowMeta rowMeta, Long costAccountId) {
        this.rowMeta = rowMeta;
        this.costAccount = new CostAccount(costAccountId);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public Object[] map(Row row) {
        String[] fieldNames;
        HashSet<String> fieldNamesSet = new HashSet<String>(16);
        for (String fieldName : fieldNames = this.rowMeta.getFieldNames()) {
            if (StringUtils.isBlank((String)fieldName)) continue;
            fieldNamesSet.add(fieldName);
        }
        Object[] newRow = new Object[this.rowMeta.getFieldCount()];
        for (String fieldName : this.rowMeta.getFieldNames()) {
            int fieldIndex = this.rowMeta.getFieldIndex(fieldName);
            newRow[fieldIndex] = row.get(fieldName);
        }
        int caldimensionIndex = this.rowMeta.getFieldIndex("caldimensionvalue");
        newRow[caldimensionIndex] = "0";
        boolean matchNotEmpty = false;
        CalRange target = null;
        int calrangeIndex = this.rowMeta.getFieldIndex("calrange");
        Long calrangeId = row.getLong(calrangeIndex);
        StringBuilder caldimensionSb = new StringBuilder();
        for (CalRange calrange : this.costAccount.getNotEmptyCalRange()) {
            if (calrangeId.longValue() != calrange.getRangeId().longValue()) continue;
            matchNotEmpty = true;
            caldimensionSb.append(calrangeId);
            caldimensionSb.append(",");
            target = calrange;
            break;
        }
        if (!matchNotEmpty) {
            CalRange emptyCalRange = this.costAccount.getEmptyCalRange();
            if (emptyCalRange != null) {
                caldimensionSb.append(emptyCalRange.getRangeId());
                caldimensionSb.append(",");
                String[] dividebasis = emptyCalRange.getDividebasis();
                if (dividebasis != null && dividebasis.length > 0) {
                    for (String dividebasisstr : dividebasis) {
                        int fieldIndex;
                        Object value;
                        String valueStr;
                        if (!fieldNamesSet.contains(dividebasisstr) || StringUtils.isEmpty((String)(valueStr = String.valueOf(value = row.get(fieldIndex = this.rowMeta.getFieldIndex(dividebasisstr)))))) continue;
                        caldimensionSb.append(valueStr);
                        caldimensionSb.append(",");
                    }
                }
            }
            target = emptyCalRange;
        }
        int materialindex = this.rowMeta.getFieldIndex("material");
        Long material = row.getLong(materialindex);
        if (target != null) {
            int materialgrouplnumindex = this.rowMeta.getFieldIndex("materialgrouplnum");
            String malGrouplongNumber = row.getString(materialgrouplnumindex);
            String spCaldimension = this.costAccount.getSpCaldimension(target.getRangeId().toString(), material.toString(), malGrouplongNumber);
            String caldimensionStr = null;
            if (spCaldimension == null) {
                caldimensionStr = target.getCaldimension();
            } else {
                String[] spArr = spCaldimension.split("@");
                caldimensionStr = spArr[1];
            }
            if (!StringUtils.isEmpty((String)caldimensionStr)) {
                String[] caldimensions;
                for (String caldimension : caldimensions = caldimensionStr.split(",")) {
                    int fieldIndex;
                    Object value;
                    String valueStr;
                    if (!fieldNamesSet.contains(caldimension) || StringUtils.isEmpty((String)(valueStr = String.valueOf(value = row.get(fieldIndex = this.rowMeta.getFieldIndex(caldimension)))))) continue;
                    caldimensionSb.append(valueStr);
                    caldimensionSb.append(",");
                }
            }
        }
        if (caldimensionSb.length() > 0) {
            caldimensionSb.append(material);
            newRow[caldimensionIndex] = caldimensionSb.toString();
        }
        return newRow;
    }
}

