/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.calx.algox.CalOutDataRangeHolder;

public class RecentCostUpdateInfoFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -3033451392389264826L;
    public static final String RECENTCOST_UPDATESQL = "update t_cal_recentcost set frecentcost = ?,frecentqty=?,fcalrptid=? where fid= ?";
    private Set<Long> costAccountSet = null;

    public RecentCostUpdateInfoFunction(CalOutDataRangeHolder holder) {
        this.costAccountSet = holder.getCostAccountSet();
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        Iterator<RowX> it = iterable.iterator();
        DBRoute calroute = new DBRoute("cal");
        while (it.hasNext()) {
            RowX row = it.next();
            params.add(new Object[]{row.getBigDecimal(1), row.getBigDecimal(2), row.getLong(3), row.getLong(0)});
            if (params.size() < 1000) continue;
            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_recentcost", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.in_range, this.costAccountSet)});){
                ctx.set();
                DB.executeBatch((DBRoute)calroute, (String)RECENTCOST_UPDATESQL, params);
            }
            params.clear();
        }
        if (params.size() > 0) {
            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_recentcost", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.in_range, this.costAccountSet)});){
                ctx.set();
                DB.executeBatch((DBRoute)calroute, (String)RECENTCOST_UPDATESQL, params);
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType)});
    }
}

