/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.CostSubElement;

public class SubElementCostDealFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -123814144988948840L;
    private RowMeta srcMeta;
    private RowMeta resultMeta;
    private Set<String> elementIdSet;
    private Set<String> elementUnitCostIdSet;
    private RowMeta rowMeta;

    public SubElementCostDealFunction(RowMeta srcMeta, Map<Long, CostSubElement> elementMap) {
        this.srcMeta = srcMeta;
        this.elementIdSet = new HashSet<String>(elementMap.size());
        for (Long elementId : elementMap.keySet()) {
            this.elementIdSet.add(elementId.toString());
        }
        this.resultMeta = this.buildResultMeta();
    }

    public SubElementCostDealFunction(RowMeta srcMeta, RowMeta rowMeta, Map<Long, CostSubElement> elementMap) {
        this(srcMeta, elementMap);
        this.rowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.resultMeta;
    }

    public void reduce(Iterable<RowX> paramIterable, Collector paramCollector) {
        Iterator<RowX> iterator = paramIterable.iterator();
        RowX row = null;
        RowMeta meta = this.srcMeta;
        if (this.rowMeta != null) {
            meta = this.rowMeta;
        }
        while (iterator.hasNext()) {
            RowX srcRow = iterator.next();
            if (row == null) {
                row = this.createEmptyRow(srcRow, this.resultMeta);
            }
            this.dealBalCompressBaseQty(row, srcRow);
            Long elementid = (Long)this.getRowValue(srcRow, meta, "elementid");
            if (elementid == null || !this.elementIdSet.contains(elementid.toString())) continue;
            BigDecimal cost = (BigDecimal)this.getRowValue(srcRow, meta, "cost");
            this.setRowValue(row, this.resultMeta, elementid.toString(), cost);
        }
        if (this.rowMeta != null) {
            BigDecimal actualCost = BigDecimal.ZERO;
            for (String elementKey : this.elementIdSet) {
                actualCost = actualCost.add((BigDecimal)this.getRowValue(row, this.resultMeta, elementKey));
            }
            this.setRowValue(row, this.resultMeta, "actualcost", actualCost);
        }
        paramCollector.collect(row);
    }

    private RowMeta buildResultMeta() {
        Field[] srcFields = this.srcMeta.getFields();
        ArrayList<Field> resultFieldList = new ArrayList<Field>(10);
        for (Field srcField : srcFields) {
            String srcFieldName = srcField.getName();
            if ("elementid".equals(srcFieldName) || "cost".equals(srcFieldName)) continue;
            resultFieldList.add(srcField);
        }
        this.elementUnitCostIdSet = new HashSet<String>(16);
        for (String elementKey : this.elementIdSet) {
            Field field = new Field(elementKey, (DataType)DataType.BigDecimalType);
            Field unitCostField = new Field(elementKey + "unitcost", (DataType)DataType.BigDecimalType);
            resultFieldList.add(field);
            resultFieldList.add(unitCostField);
            this.elementUnitCostIdSet.add(elementKey + "unitcost");
        }
        return new RowMeta(resultFieldList.toArray(new Field[resultFieldList.size()]));
    }

    private RowX createEmptyRow(RowX row, RowMeta rowMeta) {
        Field[] fields = rowMeta.getFields();
        Object[] values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = this.elementIdSet.contains(fields[i].getName()) || this.elementUnitCostIdSet.contains(fields[i].getName()) ? BigDecimal.ZERO : (this.rowMeta != null ? row.get(this.rowMeta.getFieldIndex(fields[i].getName())) : row.get(i));
        }
        return new RowX(values);
    }

    private Object getRowValue(RowX row, RowMeta rowMeta, String field) {
        return row.get(rowMeta.getFieldIndex(field));
    }

    private void setRowValue(RowX row, RowMeta rowMeta, String field, Object value) {
        row.set(rowMeta.getFieldIndex(field), value);
    }

    private void dealBalCompressBaseQty(RowX row, RowX srcRow) {
        BigDecimal baseQty;
        if (this.rowMeta == null) {
            return;
        }
        int baseQtyIndex = this.rowMeta.getFieldIndex("baseqty", false);
        if (baseQtyIndex > -1 && BigDecimal.ZERO.compareTo(baseQty = srcRow.getBigDecimal(baseQtyIndex)) != 0) {
            this.setRowValue(row, this.resultMeta, "baseqty", baseQty);
        }
    }
}

