/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.groupbill;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BillGroupRecord {
    private String id;
    private Set<Long> costFields;
    private boolean isCompleted;
    private Set<String> costColumn;
    private Set<Long> srcEntryIds = new HashSet<Long>();
    private Set<Long> destEntryIds = new HashSet<Long>();
    private Map<Long, Map<Long, ChildGroupInfo>> childGroupMap = new HashMap<Long, Map<Long, ChildGroupInfo>>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Set<Long> getCostFields() {
        return this.costFields;
    }

    public void setCostFields(Set<Long> costFields) {
        this.costFields = costFields;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setCompleted(boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public void addSrcEntryId(Long entryId, BigDecimal weight, BigDecimal occupiedqty, Long groupno, Boolean ischargeoffed) {
        this.srcEntryIds.add(entryId);
        Map childGroupInfo = this.childGroupMap.computeIfAbsent(groupno, k -> new HashMap());
        childGroupInfo.computeIfAbsent(entryId, k -> new ChildGroupInfo((Long)k, occupiedqty, weight, ischargeoffed));
    }

    public void addDestEntryId(Long entryId, BigDecimal weight, BigDecimal occupiedqty, Long groupno, Boolean ischargeoffed) {
        this.destEntryIds.add(entryId);
        Map childGroupInfo = this.childGroupMap.computeIfAbsent(groupno, k -> new HashMap());
        childGroupInfo.computeIfAbsent(entryId, k -> new ChildGroupInfo((Long)k, occupiedqty, weight, ischargeoffed));
    }

    public Set<Long> getSrcEntryIds() {
        return this.srcEntryIds;
    }

    public Set<Long> getDestEntryIds() {
        return this.destEntryIds;
    }

    public boolean hasSrcBills() {
        return this.srcEntryIds != null && !this.srcEntryIds.isEmpty();
    }

    public Set<String> getCostColumn() {
        return this.costColumn;
    }

    public void setCostColumn(Set<String> costColumn) {
        this.costColumn = costColumn;
    }

    public Collection<Map<Long, ChildGroupInfo>> getChildGroupInfo() {
        return this.childGroupMap.values();
    }

    public static class ChildGroupInfo {
        private Long entryId;
        private BigDecimal occupiedqty;
        private BigDecimal weight;
        private Boolean ischargeoffed = false;

        private ChildGroupInfo(Long entryId, BigDecimal occupiedqty, BigDecimal weight, Boolean ischargeoffed) {
            this.entryId = entryId;
            this.occupiedqty = occupiedqty;
            this.weight = weight;
            this.ischargeoffed = ischargeoffed;
        }

        public Long getEntryId() {
            return this.entryId;
        }

        public BigDecimal getOccupiedqty() {
            return this.occupiedqty;
        }

        public BigDecimal getWeight() {
            return this.weight;
        }

        public Boolean ischargeoffed() {
            return this.ischargeoffed;
        }
    }
}

