/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.groupbill;

import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.ReduceGroupFunction;
import kd.fi.calx.algox.DealAllRelaGidFunction;
import kd.fi.calx.algox.DealReplaceSrcBillFunction;
import kd.fi.calx.algox.DealTgtGid2RelaGidFunction;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.helper.BizGroupRecordHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;

public class BizGroupReplaceSrcBillHelper {
    public String replaceAndCache(String dsCacheId) {
        DataSet groupRecordDS = Algo.getCacheDataSet((String)dsCacheId).toDataSet(Algo.create((String)BizGroupRecordHelper.class.getName()), true);
        groupRecordDS = this.replace(groupRecordDS);
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout((long)CalDbParamServiceHelper.getInteger(CalDbParamConstant.BIZGROUP_CACHE_TIMEOUT).intValue(), TimeUnit.SECONDS);
        CachedDataSet cache = groupRecordDS.cache(cacheHint);
        String cacheId = cache.getCacheId();
        return cacheId;
    }

    public DataSet replace(DataSet groupBillRecordDS) {
        groupBillRecordDS = groupBillRecordDS.groupBy(new String[]{"costrecordentryid"}).reduceGroup((ReduceGroupFunction)new DealTgtGid2RelaGidFunction(groupBillRecordDS.getRowMeta()));
        groupBillRecordDS = groupBillRecordDS.groupBy(new String[]{"groupid"}).reduceGroup((ReduceGroupFunction)new DealAllRelaGidFunction(groupBillRecordDS.getRowMeta()));
        DataSet[] splitDs = groupBillRecordDS.splitByFilter(new String[]{"issrcandtgt=true", "issrcandtgt=false"}, false);
        DataSet containSrcAndTgtDs = splitDs[0];
        DataSet notContainSrcAndTgtDs = splitDs[1];
        containSrcAndTgtDs = containSrcAndTgtDs.groupBy(new String[]{"issrcandtgt"}).reduceGroup((ReduceGroupFunction)new DealReplaceSrcBillFunction(groupBillRecordDS.getRowMeta()));
        groupBillRecordDS = containSrcAndTgtDs.union(notContainSrcAndTgtDs);
        return groupBillRecordDS;
    }
}

