/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.groupbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.TimestampType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.ParamCache;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.accounttype.LocalRow;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.constant.CostPriceSourceTypeEnum;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.groupbill.BillGroupRecord;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CostPriceSourceTypeHelper;

public class GroupBillHolder {
    private Map<Long, CostSubElement> elementMap;
    private Map<String, BillGroupRecord> groupRecordMap = new HashMap<String, BillGroupRecord>();
    private Map<Long, BillGroupRecord> destRowRecordMap = new HashMap<Long, BillGroupRecord>();
    private Map<Long, List<BillGroupRecord>> srcRowRecordMap = new HashMap<Long, List<BillGroupRecord>>();
    private Map<Long, LocalRow> rowMap = new HashMap<Long, LocalRow>();
    private Map<Long, LocalRow> oldMap = new HashMap<Long, LocalRow>();
    private ParamCache paramCache;
    private Map<String, Integer> runningModeMap;
    private boolean enableRework = false;
    private CommonInfo commonInfo;

    public GroupBillHolder(Map<Long, CostSubElement> elementMap, Map<String, Integer> runningModeMap, ParamCache paramCache, boolean enableRework) {
        this.elementMap = elementMap;
        this.runningModeMap = runningModeMap;
        this.paramCache = paramCache;
        this.enableRework = enableRework;
    }

    public void addGroupRecord(Row row) {
        String groupId = row.getString("groupid");
        if (groupId == null || groupId.equals("0")) {
            return;
        }
        BillGroupRecord billGroupRecord = this.groupRecordMap.get(groupId);
        if (billGroupRecord != null) {
            return;
        }
        String billGroupBillInfoValuesListStr = row.getString("groupinfovalues");
        if (StringUtils.isEmpty((CharSequence)billGroupBillInfoValuesListStr)) {
            return;
        }
        List billGroupBillInfoValuesList = (List)SerializationUtils.fromJsonString((String)billGroupBillInfoValuesListStr, List.class);
        HashSet<String> groupsrcbillnoSet = new HashSet<String>(16);
        for (Object billGroupBillInfoValuesObj : billGroupBillInfoValuesList) {
            List billGroupBillInfoValues = (List)billGroupBillInfoValuesObj;
            String grouptype = (String)this.getGroupInfoValue(billGroupBillInfoValues, "grouptype");
            if (!"0".equals(grouptype)) continue;
            String groupsrcbillno = (String)this.getGroupInfoValue(billGroupBillInfoValues, "groupsrcbillno");
            groupsrcbillnoSet.add(groupsrcbillno);
        }
        String groupsrcbillnostr = null;
        StringBuilder groupsrcbillnoSb = new StringBuilder();
        if (!groupsrcbillnoSet.isEmpty()) {
            for (String groupsrcbillno : groupsrcbillnoSet) {
                groupsrcbillnoSb.append(groupsrcbillno);
                groupsrcbillnoSb.append(",");
            }
            if (groupsrcbillnoSb.length() != 0) {
                groupsrcbillnostr = groupsrcbillnoSb.substring(0, groupsrcbillnoSb.length() - 1);
            }
        }
        for (Object billGroupBillInfoValuesObj : billGroupBillInfoValuesList) {
            List billGroupBillInfoValues = (List)billGroupBillInfoValuesObj;
            this.addGroupRecord(billGroupBillInfoValues, row, groupsrcbillnostr);
        }
    }

    public void addGroupRecord(List<Object> billGroupBillInfoValues, Row row, String groupsrcbillnostr) {
        LocalRow localRow;
        boolean enablejoincalute = row.getBoolean("enablejoincalute");
        Long groupentryid = (Long)this.getGroupInfoValue(billGroupBillInfoValues, "groupentryid");
        Long costaccount = (Long)this.getGroupInfoValue(billGroupBillInfoValues, "groupcostaccount");
        String groupId = (String)this.getGroupInfoValue(billGroupBillInfoValues, "groupId");
        if (groupentryid == null || costaccount == null) {
            return;
        }
        BillGroupRecord groupRecord = this.groupRecordMap.get(groupId);
        if (groupRecord == null) {
            groupRecord = new BillGroupRecord();
            groupRecord.setId(groupId);
            groupRecord.setCompleted((Boolean)this.getGroupInfoValue(billGroupBillInfoValues, "iscompleted"));
            String elementIdStr = (String)this.getGroupInfoValue(billGroupBillInfoValues, "costfields");
            elementIdStr = elementIdStr.trim();
            if (elementIdStr.startsWith(",")) {
                elementIdStr = elementIdStr.substring(1);
            }
            String[] elementIdStrs = elementIdStr.split(",");
            HashSet<Long> costFieldSet = new HashSet<Long>(elementIdStrs.length);
            for (String elementIdstr : elementIdStrs) {
                if (elementIdstr == null || elementIdstr.isEmpty()) continue;
                costFieldSet.add(Long.valueOf(elementIdstr));
            }
            groupRecord.setCostFields(costFieldSet);
            String costcolumn = (String)this.getGroupInfoValue(billGroupBillInfoValues, "costcolumn");
            costcolumn = costcolumn.trim();
            if (costcolumn.startsWith(",")) {
                costcolumn = costcolumn.substring(1);
            }
            String[] costColumns = costcolumn.split(",");
            groupRecord.setCostColumn(new HashSet<String>(Arrays.asList(costColumns)));
            this.groupRecordMap.put(groupId, groupRecord);
        }
        if ((localRow = this.rowMap.get(groupentryid)) == null) {
            localRow = this.createGroupedLocalRow(billGroupBillInfoValues, groupsrcbillnostr, enablejoincalute);
            this.rowMap.put(groupentryid, localRow);
            String accounttype = (String)billGroupBillInfoValues.get(this.commonInfo.getGroupInfoRowMeta().getFieldIndex("groupaccounttype"));
            if (AccountTypeEnum.STANDARDCOST.getValue().equals(accounttype)) {
                LocalRow copyRow = this.createGroupedLocalRow(billGroupBillInfoValues, groupsrcbillnostr, enablejoincalute);
                this.oldMap.put(groupentryid, copyRow);
            }
        }
        String grouptype = (String)this.getGroupInfoValue(billGroupBillInfoValues, "grouptype");
        BigDecimal groupOccupiedQty = (BigDecimal)this.getGroupInfoValue(billGroupBillInfoValues, "groupoccupiedqty");
        Long groupGroupNo = (Long)this.getGroupInfoValue(billGroupBillInfoValues, "groupgroupno");
        Boolean ischargeoffed = (Boolean)this.getGroupInfoValue(billGroupBillInfoValues, "ischargeoffed");
        if (grouptype.equals("0")) {
            List<BillGroupRecord> recordList;
            groupRecord.addSrcEntryId(groupentryid, (BigDecimal)this.getGroupInfoValue(billGroupBillInfoValues, "groupweight"), groupOccupiedQty, groupGroupNo, Boolean.FALSE);
            localRow.setSrcBill(true);
            if (localRow.isGroupCostCalculated() == null && !localRow.isDestBill()) {
                localRow.setGroupCostCalculated(localRow.getQueuetype().equals("0") || localRow.isCostDetermined());
            }
            if ((recordList = this.getSrcRowRecordMap().get(groupentryid)) == null) {
                recordList = new ArrayList<BillGroupRecord>(8);
                this.getSrcRowRecordMap().put(groupentryid, recordList);
            }
            recordList.add(groupRecord);
        } else {
            groupRecord.addDestEntryId(groupentryid, (BigDecimal)this.getGroupInfoValue(billGroupBillInfoValues, "groupweight"), groupOccupiedQty, groupGroupNo, ischargeoffed);
            localRow.setDestBill(true);
            if (localRow.isGroupCostCalculated() == null) {
                localRow.setGroupCostCalculated(false);
            }
            this.getDestRowRecordMap().put(groupentryid, groupRecord);
        }
    }

    private <T> T getGroupInfoValue(List<Object> billGroupBillInfoValuesList, String fieldKey) {
        RowMeta groupInfoRowMeta = this.commonInfo.getGroupInfoRowMeta();
        Field field = groupInfoRowMeta.getField(fieldKey);
        int fieldIndex = groupInfoRowMeta.getFieldIndex(field.getAlias());
        Object groupInfoValue = billGroupBillInfoValuesList.get(fieldIndex);
        DataType fieldType = field.getDataType();
        Object value = fieldType instanceof LongType && groupInfoValue instanceof Integer ? Long.valueOf(((Integer)groupInfoValue).intValue()) : (fieldType instanceof IntegerType && groupInfoValue instanceof Long ? Integer.valueOf(((Long)groupInfoValue).intValue()) : (fieldType instanceof BigDecimalType && groupInfoValue instanceof Integer ? new BigDecimal((Integer)groupInfoValue) : (fieldType instanceof BigDecimalType && groupInfoValue instanceof Long ? new BigDecimal((Long)groupInfoValue) : ((fieldType instanceof DateType || fieldType instanceof TimestampType) && groupInfoValue instanceof Long ? new Date((Long)groupInfoValue) : groupInfoValue))));
        return (T)value;
    }

    private LocalRow createGroupedLocalRow(List<Object> billGroupBillInfoValuesList, String groupsrcbillnostr, boolean enablejoincalute) {
        Long costaccount = (Long)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupcostaccount");
        Boolean calbycostelement = this.paramCache.isCalByElement(costaccount);
        LocalRow localRow = new LocalRow(calbycostelement, this.elementMap);
        localRow.setHeadid((Long)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupbillheadid"));
        localRow.setEntyrId((Long)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupentryid"));
        localRow.setCostaccountid((Long)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupcostaccount"));
        localRow.setPeriodid((Long)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupperiodid"));
        Integer groupSignNum = (Integer)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupsignnum");
        BigDecimal signnum = BigDecimal.valueOf(groupSignNum.intValue());
        localRow.setSignnum(signnum);
        BigDecimal groupBaseQty = (BigDecimal)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupbaseqty");
        localRow.setBaseqty(groupBaseQty.multiply(signnum));
        localRow.setSign(BigDecimal.valueOf(localRow.getBaseqty().signum()));
        localRow.setLocalcurrencyid((Long)this.getGroupInfoValue(billGroupBillInfoValuesList, "grouplocalcurrency"));
        localRow.setPriceprecision(10);
        localRow.setAmtprecision((Integer)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupamtprecision"));
        localRow.setExratetable((Long)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupexratetable"));
        localRow.setRowtype("1");
        String convertmode = (String)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupconvertmode");
        if ("A".equals(convertmode)) {
            convertmode = "1";
        } else if ("B".equals(convertmode)) {
            convertmode = "2";
        }
        localRow.setConvertMode(convertmode);
        BigDecimal groupMaterialCost = (BigDecimal)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupmaterialcost");
        localRow.setMaterialcost(groupMaterialCost.multiply(signnum));
        BigDecimal groupProcessCost = (BigDecimal)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupprocesscost");
        localRow.setProcesscost(groupProcessCost.multiply(signnum));
        BigDecimal groupFee = (BigDecimal)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupfee");
        localRow.setFee(groupFee.multiply(signnum));
        BigDecimal groupManufActureCost = (BigDecimal)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupmanufacturecost");
        localRow.setManufacturecost(groupManufActureCost.multiply(signnum));
        BigDecimal groupResource = (BigDecimal)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupresource");
        localRow.setResource(groupResource.multiply(signnum));
        for (Long costField : this.elementMap.keySet()) {
            BigDecimal groupCostValue = (BigDecimal)this.getGroupInfoValue(billGroupBillInfoValuesList, "group" + costField);
            localRow.setCost(costField, groupCostValue.multiply(signnum));
        }
        localRow.refreshActualCost();
        boolean isCalculated = (Boolean)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupiscalculated");
        boolean isVoucher = (Boolean)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupisvoucher");
        boolean isrework = (Boolean)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupisrework");
        String accountType = (String)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupaccounttype");
        Integer runningMode = this.runningModeMap.get(accountType);
        localRow.setVoucher(isVoucher);
        if (runningMode == null || runningMode == 0) {
            localRow.setCostDetermined(true);
        } else {
            localRow.setCostDetermined(isVoucher || isCalculated && 2 == runningMode || isrework && this.enableRework);
        }
        Long periodId = this.paramCache.getCurrentPeriod(localRow.getCostaccountid());
        if ((accountType.equals(AccountTypeEnum.MOVEDAVG_INTIME.getValue()) || accountType.equals(AccountTypeEnum.FIFO.getValue())) && periodId != null && periodId < localRow.getPeriodid()) {
            localRow.setPeriodid(periodId);
        }
        localRow.setQueuetype((String)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupqueuetype"));
        localRow.setInitBill((Boolean)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupisinitbill"));
        String calModel = CalDbParamServiceHelper.getString(CalDbParamConstant.CALC_MODEL, null);
        if ("B".equals(calModel) && 0 != this.runningModeMap.get(AccountTypeEnum.MOVEDAVG_INTIME.getValue())) {
            localRow.setCostDomainId((String)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupcostdomainid"));
        }
        localRow.setBizEntityObject((String)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupbizentityobject"));
        localRow.setSubbillInvoiceverify((Boolean)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupissubbillinvoiceverify"));
        localRow.setInvTxZeroCost((Boolean)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupinvzerocost"));
        localRow.setSrcbillno(groupsrcbillnostr);
        localRow.setCostpricesource((String)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupcostpricesource"));
        localRow.setEnableJoinCalute(enablejoincalute);
        localRow.setDesignatedcost((Boolean)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupdesignatedcost"));
        localRow.setAuditTime((Date)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupauditdate"));
        RowMeta groupInfoRowMeta = this.commonInfo.getGroupInfoRowMeta();
        int addPriceFieldIndex = groupInfoRowMeta.getFieldIndex("groupaddpricefield", false);
        if (addPriceFieldIndex > -1) {
            localRow.setAddPricePercent((BigDecimal)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupaddpricefield"));
        }
        localRow.setBillnumber((String)this.getGroupInfoValue(billGroupBillInfoValuesList, "groupsrcbillno"));
        return localRow;
    }

    public LocalRow getGroupedLocalRow(Long id, boolean calbycostelement) {
        LocalRow row = this.rowMap.get(id);
        if (row == null) {
            return null;
        }
        if (!row.isDestBill() || row.isGroupCostCalculated().booleanValue()) {
            return row;
        }
        BillGroupRecord groupRecord = this.getDestRowRecordMap().get(id);
        if (groupRecord == null || !groupRecord.hasSrcBills()) {
            return null;
        }
        this.calculateGroupCost(groupRecord, calbycostelement);
        return row;
    }

    private void calculateGroupCost(BillGroupRecord groupRecord, boolean calbycostelement) {
        Set<Long> srcIdSet = groupRecord.getSrcEntryIds();
        Set<Long> destIdSet = groupRecord.getDestEntryIds();
        HashMap<Long, BigDecimal> srcLastQty = new HashMap<Long, BigDecimal>(srcIdSet.size());
        HashMap<String, BigDecimal> srcLastCost = new HashMap<String, BigDecimal>(srcIdSet.size());
        for (Long srcId : srcIdSet) {
            LocalRow srcRow = this.rowMap.get(srcId);
            Long periodId = this.paramCache.getCurrentPeriod(srcRow.getCostaccountid());
            Long l = periodId = periodId == null ? Long.valueOf(0L) : periodId;
            if (srcRow.getPeriodid() < periodId || srcRow.isInitBill()) {
                srcRow.setGroupCostCalculated(true);
            }
            if (!srcRow.isGroupCostCalculated().booleanValue()) {
                return;
            }
            srcLastQty.put(srcId, srcRow.getBaseqty());
            if (calbycostelement) {
                for (Long costSubElementId : groupRecord.getCostFields()) {
                    srcLastCost.put(srcId + "_" + costSubElementId, srcRow.getCost(costSubElementId));
                }
                continue;
            }
            for (String costColumn : groupRecord.getCostColumn()) {
                srcLastCost.put(srcId + "_" + costColumn, srcRow.getCost(costColumn));
            }
        }
        Collection<Map<Long, BillGroupRecord.ChildGroupInfo>> childGroups = groupRecord.getChildGroupInfo();
        for (Map<Long, BillGroupRecord.ChildGroupInfo> childGroup : childGroups) {
            this.calculateChildGroup(groupRecord, calbycostelement, srcLastQty, srcLastCost, childGroup);
        }
        for (Long destId : destIdSet) {
            this.refreshDestCostFromGroupCost(destId);
        }
    }

    private void refreshDestCostFromGroupCost(Long destId) {
        LocalRow destRow = this.rowMap.get(destId);
        boolean isVoucher = destRow.isCostDetermined();
        boolean isPriced = destRow.isPriced();
        Set purSet = (Set)this.paramCache.getParamValue("purBizEntityObjectSet");
        Set ominSet = (Set)this.paramCache.getParamValue("ominBizEntityObjectSet");
        if (!isVoucher && !isPriced) {
            for (Map.Entry<Object, BigDecimal> groupCostEntry : destRow.getGroupCostAmtMap().entrySet()) {
                if (destRow.isCalbycostelement()) {
                    Long subElementId = (Long)groupCostEntry.getKey();
                    if (purSet.contains(destRow.getBizEntityObject()) && destRow.isSubbillInvoiceverify() && "001".equals(this.elementMap.get(subElementId).getType()) || ominSet.contains(destRow.getBizEntityObject()) && destRow.isSubbillInvoiceverify() && "005".equals(this.elementMap.get(subElementId).getType())) continue;
                    destRow.setCost(subElementId, groupCostEntry.getValue());
                    continue;
                }
                String entryField = (String)groupCostEntry.getKey();
                if (purSet.contains(destRow.getBizEntityObject()) && destRow.isSubbillInvoiceverify() && "materialcost".equals(entryField) || ominSet.contains(destRow.getBizEntityObject()) && destRow.isSubbillInvoiceverify() && "processcost".equals(entryField)) continue;
                destRow.setCost(entryField, groupCostEntry.getValue());
            }
            destRow.refreshActualCost();
        }
        destRow.setGroupCostCalculated(true);
    }

    /*
     * WARNING - void declaration
     */
    private void calculateChildGroup(BillGroupRecord groupRecord, boolean calbycostelement, Map<Long, BigDecimal> srcLastQty, Map<String, BigDecimal> srcLastCost, Map<Long, BillGroupRecord.ChildGroupInfo> childGroup) {
        String msg;
        Object errorStr;
        LocalRow row;
        Long childEntryId;
        HashMap<Object, BigDecimal> srcTotalCost = new HashMap<Object, BigDecimal>();
        BigDecimal totalSrcQty = BigDecimal.ZERO;
        HashMap<LocalRow, BillGroupRecord.ChildGroupInfo> destChildInfo = new HashMap<LocalRow, BillGroupRecord.ChildGroupInfo>();
        BigDecimal totalDestWeight = BigDecimal.ZERO;
        Long destCurrencyId = null;
        Long srcCurrencyId = null;
        Integer destAmtPrecision = null;
        Long destExratetable = null;
        String convertMode = null;
        Set<Long> thisGroupSrcIds = groupRecord.getSrcEntryIds();
        int srcQtySignum = 0;
        HashMap<Long, BigDecimal> destQtyMap = new HashMap<Long, BigDecimal>(16);
        boolean isDestSameSignum = true;
        int destSignum = 0;
        HashSet<Long> destBillDocumentEntryIds = new HashSet<Long>(16);
        HashSet<Long> destBillAllEntryIds = new HashSet<Long>(16);
        BigDecimal destDocumentTotalCost = BigDecimal.ZERO;
        BigDecimal srcAllTotalCost = BigDecimal.ZERO;
        StringBuilder errorSb = new StringBuilder();
        for (BillGroupRecord.ChildGroupInfo childInfo : childGroup.values()) {
            childEntryId = childInfo.getEntryId();
            row = this.rowMap.get(childEntryId);
            BigDecimal actualCost = row.getActualCost();
            if (!thisGroupSrcIds.contains(row.getEntryId())) {
                destBillAllEntryIds.add(childEntryId);
                String costpricesource = row.getCostpricesource();
                costpricesource = CostPriceSourceTypeEnum.getLastByCostPriceSource(costpricesource);
                boolean coverdesigoutcost = this.commonInfo.isCoverdesigoutcost();
                if (CostPriceSourceTypeHelper.checkDisassemAdjustCostprice(row, coverdesigoutcost)) {
                    if (errorSb.length() == 0) {
                        errorSb.append(row.getBillnumber());
                    }
                    destBillDocumentEntryIds.add(childEntryId);
                    if (actualCost != null) {
                        destDocumentTotalCost = destDocumentTotalCost.add(actualCost);
                    }
                }
                int curTgtSigNum = row.getBaseqty().signum();
                if (destSignum != 0 && destSignum != curTgtSigNum) {
                    isDestSameSignum = false;
                    break;
                }
                destSignum = curTgtSigNum;
                continue;
            }
            if (actualCost == null) continue;
            srcAllTotalCost = srcAllTotalCost.add(actualCost);
        }
        if (destBillAllEntryIds.size() == destBillDocumentEntryIds.size()) {
            errorStr = "";
            if (errorSb.length() > 0) {
                errorStr = errorSb.toString();
            }
            msg = String.format(ResManager.loadKDString((String)"\u6240\u6709\u7684\u76ee\u6807\u5355\uff08\u5355\u53f7\uff1a%1$s\uff09\u4e0d\u5141\u8bb8\u90fd\u6307\u5b9a\u6210\u672c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u76ee\u6807\u5355\u7684\u6210\u672c\u3002", (String)"GroupRelationCostCalculator_1", (String)"fi-calx-algox", (Object[])new Object[0]), errorStr);
            throw new KDBizException(msg);
        }
        if (!destBillDocumentEntryIds.isEmpty() && srcAllTotalCost != null && srcAllTotalCost.compareTo(BigDecimal.ZERO) != 0 && destDocumentTotalCost.abs().compareTo(srcAllTotalCost.abs()) > 0) {
            errorStr = "";
            if (errorSb.length() > 0) {
                errorStr = errorSb.toString();
            }
            msg = String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\uff08\u5355\u53f7\uff1a%1$s\uff09\u6307\u5b9a\u603b\u6210\u672c\u5927\u4e8e\u6e90\u5355\u7684\u603b\u6210\u672c\uff0c\u8bf7\u91cd\u65b0\u6307\u5b9a\u76ee\u6807\u5355\u7684\u6210\u672c\u3002", (String)"GroupRelationCostCalculator_2", (String)"fi-calx-algox", (Object[])new Object[0]), errorStr);
            throw new KDBizException(msg);
        }
        if (!isDestSameSignum) {
            this.calculateDestCostBySrcPrice(groupRecord, calbycostelement, srcLastQty, srcLastCost, childGroup);
            return;
        }
        for (BillGroupRecord.ChildGroupInfo childInfo : childGroup.values()) {
            childEntryId = childInfo.getEntryId();
            row = this.rowMap.get(childEntryId);
            Boolean ischargeoffed = childInfo.ischargeoffed();
            if (thisGroupSrcIds.contains(row.getEntryId())) {
                int signum;
                if (srcQtySignum == 0) {
                    srcQtySignum = row.getBaseqty().signum();
                }
                BigDecimal occupiedQty = childInfo.getOccupiedqty();
                BigDecimal lastQty = srcLastQty.get(childEntryId);
                srcCurrencyId = row.getLocalcurrencyid();
                if (calbycostelement) {
                    for (Long l : groupRecord.getCostFields()) {
                        void var34_46;
                        BigDecimal bigDecimal = (BigDecimal)srcTotalCost.get(l);
                        String key = childEntryId + "_" + l;
                        BigDecimal thisCost = null;
                        if (occupiedQty.compareTo(lastQty) == 0) {
                            thisCost = srcLastCost.get(key);
                        } else {
                            thisCost = row.getCost(l).multiply(occupiedQty).divide(row.getBaseqty(), row.getAmtprecision(), RoundingMode.HALF_UP);
                            signum = row.getCost(l).signum();
                            thisCost = thisCost.abs().multiply(new BigDecimal(signum));
                        }
                        srcLastCost.put(key, srcLastCost.get(key).subtract(thisCost));
                        if (bigDecimal != null) {
                            BigDecimal bigDecimal2 = bigDecimal.add(thisCost);
                        } else {
                            BigDecimal bigDecimal3 = thisCost;
                        }
                        srcTotalCost.put(l, (BigDecimal)var34_46);
                    }
                } else {
                    for (String string : groupRecord.getCostColumn()) {
                        String string2 = childEntryId + "_" + string;
                        BigDecimal thisCost = null;
                        BigDecimal cost = (BigDecimal)srcTotalCost.get(string);
                        if (occupiedQty.compareTo(lastQty) == 0) {
                            thisCost = srcLastCost.get(string2);
                        } else {
                            thisCost = row.getCost(string).multiply(occupiedQty).divide(row.getBaseqty(), row.getAmtprecision(), RoundingMode.HALF_UP);
                            signum = row.getCost(string).signum();
                            thisCost = thisCost.abs().multiply(new BigDecimal(signum));
                        }
                        srcLastCost.put(string2, srcLastCost.get(string2).subtract(thisCost));
                        cost = cost != null ? cost.add(thisCost) : thisCost;
                        srcTotalCost.put(string, cost);
                    }
                }
                srcLastQty.put(childEntryId, lastQty.subtract(occupiedQty));
                totalSrcQty = totalSrcQty.add(occupiedQty);
                continue;
            }
            destQtyMap.put(childEntryId, row.getBaseqty());
            Long periodId = this.paramCache.getCurrentPeriod(row.getCostaccountid());
            periodId = periodId == null ? Long.valueOf(0L) : periodId;
            destCurrencyId = row.getLocalcurrencyid();
            destAmtPrecision = row.getAmtprecision();
            destExratetable = row.getExratetable();
            convertMode = row.getConvertMode();
            String costpricesource = row.getCostpricesource();
            costpricesource = CostPriceSourceTypeEnum.getLastByCostPriceSource(costpricesource);
            boolean coverdesigoutcost = this.commonInfo.isCoverdesigoutcost();
            if (row.getPeriodid().compareTo(periodId) < 0 || CostPriceSourceTypeHelper.checkDisassemAdjustCostprice(row, coverdesigoutcost)) {
                if (ischargeoffed.booleanValue()) continue;
                if (srcTotalCost.entrySet().isEmpty()) {
                    if (calbycostelement) {
                        for (Long l : groupRecord.getCostFields()) {
                            srcTotalCost.put(l, BigDecimal.ZERO.subtract(row.getCost(l).abs()));
                        }
                    } else {
                        for (String string : groupRecord.getCostColumn()) {
                            srcTotalCost.put(string, BigDecimal.ZERO.subtract(row.getCost(string).abs()));
                        }
                    }
                } else {
                    for (Map.Entry entry : srcTotalCost.entrySet()) {
                        Object costField = entry.getKey();
                        if (calbycostelement) {
                            srcTotalCost.put(costField, ((BigDecimal)entry.getValue()).subtract(row.getCost((Long)costField).abs()));
                            continue;
                        }
                        srcTotalCost.put(costField, ((BigDecimal)entry.getValue()).subtract(row.getCost((String)costField).abs()));
                    }
                }
                totalSrcQty = totalSrcQty.subtract(row.getBaseqty().abs());
                continue;
            }
            if (row.getPeriodid().compareTo(periodId) < 0) continue;
            destChildInfo.put(row, childInfo);
            if (ischargeoffed.booleanValue()) continue;
            totalDestWeight = totalDestWeight.add(childInfo.getWeight());
        }
        if (destChildInfo.isEmpty()) {
            return;
        }
        if (srcCurrencyId == null) {
            return;
        }
        if (!srcCurrencyId.equals(destCurrencyId)) {
            this.exchangeAmt(srcTotalCost, srcCurrencyId, destCurrencyId, destAmtPrecision, destExratetable, convertMode);
        }
        if (groupRecord.isCompleted() || totalSrcQty.compareTo(BigDecimal.ZERO) == 0) {
            LinkedHashMap<LocalRow, BillGroupRecord.ChildGroupInfo> sortDestChildInfo = this.sortDestChildInfo(destChildInfo);
            this.divideByQty(srcTotalCost, sortDestChildInfo, totalDestWeight, groupRecord, calbycostelement, destQtyMap, srcQtySignum);
        } else {
            this.mutiplyByUnitCost(srcTotalCost, destChildInfo, totalSrcQty, calbycostelement);
        }
    }

    private LinkedHashMap<LocalRow, BillGroupRecord.ChildGroupInfo> sortDestChildInfo(Map<LocalRow, BillGroupRecord.ChildGroupInfo> destChildInfo) {
        ArrayList<LocalRow> allLocalRows = new ArrayList<LocalRow>(4);
        allLocalRows.addAll(destChildInfo.keySet());
        allLocalRows.sort(Comparator.comparing(LocalRow::getAuditTime).thenComparing(LocalRow::getCostpricesource));
        LinkedHashMap<LocalRow, BillGroupRecord.ChildGroupInfo> sortMap = new LinkedHashMap<LocalRow, BillGroupRecord.ChildGroupInfo>(4);
        for (LocalRow localRow : allLocalRows) {
            sortMap.put(localRow, destChildInfo.get(localRow));
        }
        return sortMap;
    }

    private void calculateDestCostBySrcPrice(BillGroupRecord groupRecord, boolean calbycostelement, Map<Long, BigDecimal> srcLastQty, Map<String, BigDecimal> srcLastCost, Map<Long, BillGroupRecord.ChildGroupInfo> childGroup) {
        HashMap<Object, BigDecimal> srcTotalCost = new HashMap<Object, BigDecimal>();
        BigDecimal totalSrcQty = BigDecimal.ZERO;
        BigDecimal totalDestQty = BigDecimal.ZERO;
        HashMap<LocalRow, BillGroupRecord.ChildGroupInfo> destChildInfo = new HashMap<LocalRow, BillGroupRecord.ChildGroupInfo>();
        Long destCurrencyId = null;
        Long srcCurrencyId = null;
        Integer destAmtPrecision = null;
        Long destExratetable = null;
        String convertMode = null;
        Set<Long> thisGroupSrcIds = groupRecord.getSrcEntryIds();
        for (BillGroupRecord.ChildGroupInfo childInfo : childGroup.values()) {
            Long childEntryId = childInfo.getEntryId();
            LocalRow row = this.rowMap.get(childEntryId);
            if (thisGroupSrcIds.contains(row.getEntryId())) {
                BigDecimal occupiedQty = childInfo.getOccupiedqty();
                BigDecimal lastQty = srcLastQty.get(childEntryId);
                srcCurrencyId = row.getLocalcurrencyid();
                if (calbycostelement) {
                    for (Long l : groupRecord.getCostFields()) {
                        BigDecimal cost = (BigDecimal)srcTotalCost.get(l);
                        String key = childEntryId + "_" + l;
                        BigDecimal thisCost = null;
                        thisCost = occupiedQty.compareTo(lastQty) == 0 ? srcLastCost.get(key) : row.getCost(l).multiply(occupiedQty).divide(row.getBaseqty(), row.getAmtprecision(), RoundingMode.HALF_UP);
                        srcLastCost.put(key, srcLastCost.get(key).subtract(thisCost));
                        cost = cost != null ? cost.add(thisCost) : thisCost;
                        srcTotalCost.put(l, cost);
                    }
                } else {
                    for (String string : groupRecord.getCostColumn()) {
                        String key = childEntryId + "_" + string;
                        BigDecimal thisCost = null;
                        BigDecimal cost = (BigDecimal)srcTotalCost.get(string);
                        thisCost = occupiedQty.compareTo(lastQty) == 0 ? srcLastCost.get(key) : row.getCost(string).multiply(occupiedQty).divide(row.getBaseqty(), row.getAmtprecision(), RoundingMode.HALF_UP);
                        srcLastCost.put(key, srcLastCost.get(key).subtract(thisCost));
                        cost = cost != null ? cost.add(thisCost) : thisCost;
                        srcTotalCost.put(string, cost);
                    }
                }
                srcLastQty.put(childEntryId, lastQty.subtract(occupiedQty));
                totalSrcQty = totalSrcQty.add(occupiedQty);
                continue;
            }
            destCurrencyId = row.getLocalcurrencyid();
            destAmtPrecision = row.getAmtprecision();
            destExratetable = row.getExratetable();
            convertMode = row.getConvertMode();
            destChildInfo.put(row, childInfo);
            totalDestQty = totalDestQty.add(row.getBaseqty());
        }
        if (destChildInfo.isEmpty()) {
            return;
        }
        if (srcCurrencyId == null) {
            return;
        }
        if (!srcCurrencyId.equals(destCurrencyId)) {
            this.exchangeAmt(srcTotalCost, srcCurrencyId, destCurrencyId, destAmtPrecision, destExratetable, convertMode);
        }
        this.mutiplyByUnitCost(srcTotalCost, destChildInfo, totalSrcQty, calbycostelement, groupRecord.isCompleted() && totalSrcQty.compareTo(totalDestQty) == 0);
    }

    protected void exchangeAmt(Map<Object, BigDecimal> srcTotalCost, Long srcCurrencyId, Long destCurrencyId, Integer destAmtPrecision, Long destExratetable, String convertMode) {
        BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)destExratetable, (Long)srcCurrencyId, (Long)destCurrencyId, (String)convertMode, (Date)new Date());
        if (exchangeRate == null) {
            DynamicObject exchangeRateObj = BusinessDataServiceHelper.loadSingleFromCache((Object)destExratetable, (String)"bd_exratetable", (String)"id,number,name");
            Map currencyMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{srcCurrencyId, destCurrencyId}, (String)"bd_currency");
            StringBuilder errorInfo = new StringBuilder();
            if (convertMode.equals("1")) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u201c%1$s\u201d\u4e2d\u4e0d\u5b58\u5728\u7531\u201c%2$s\u201d\u81f3\u201c%3$s\u201d\u7684\u76f4\u63a5\u6c47\u7387\u3002", (String)"GroupBillHolder_7", (String)"fi-calx-algox", (Object[])new Object[0]), exchangeRateObj.getString("name"), ((DynamicObject)currencyMap.get(srcCurrencyId)).getString("name"), ((DynamicObject)currencyMap.get(destCurrencyId)).getString("name")));
            } else {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u201c%1$s\u201d\u4e2d\u4e0d\u5b58\u5728\u7531\u201c%2$s\u201d\u81f3\u201c%3$s\u201d\u7684\u95f4\u63a5\u6c47\u7387\u3002", (String)"GroupBillHolder_8", (String)"fi-calx-algox", (Object[])new Object[0]), exchangeRateObj.getString("name"), ((DynamicObject)currencyMap.get(srcCurrencyId)).getString("name"), ((DynamicObject)currencyMap.get(destCurrencyId)).getString("name")));
            }
            throw new KDBizException(errorInfo.toString());
        }
        for (Map.Entry<Object, BigDecimal> entry : srcTotalCost.entrySet()) {
            BigDecimal cost = entry.getValue();
            cost = "1".equals(convertMode) ? cost.multiply(exchangeRate).setScale((int)destAmtPrecision, 4) : cost.divide(exchangeRate, (int)destAmtPrecision, 4);
            srcTotalCost.put(entry.getKey(), cost);
        }
    }

    private void mutiplyByUnitCost(Map<Object, BigDecimal> srcTotalCost, Map<LocalRow, BillGroupRecord.ChildGroupInfo> destChildInfo, BigDecimal totalSrcQty, boolean calbycostelement) {
        for (LocalRow destRow : destChildInfo.keySet()) {
            for (Map.Entry<Object, BigDecimal> entry : srcTotalCost.entrySet()) {
                Object costField = entry.getKey();
                BigDecimal groupCost = entry.getValue().multiply(destRow.getBaseqty()).divide(totalSrcQty, destRow.getAmtprecision(), RoundingMode.HALF_UP);
                BigDecimal currentGroupCost = destRow.getGroupCost(costField);
                currentGroupCost = currentGroupCost == null ? BigDecimal.ZERO : currentGroupCost;
                destRow.setGroupCost(costField, currentGroupCost.add(groupCost));
            }
        }
    }

    private void mutiplyByUnitCost(Map<Object, BigDecimal> srcTotalCost, Map<LocalRow, BillGroupRecord.ChildGroupInfo> destChildInfo, BigDecimal totalSrcQty, boolean calbycostelement, boolean isCompleted) {
        LocalRow maxQtyRow = null;
        BigDecimal destMaxQty = BigDecimal.ZERO;
        for (LocalRow destRow : destChildInfo.keySet()) {
            Long l;
            Long l2 = this.paramCache.getCurrentPeriod(destRow.getCostaccountid());
            Long l3 = l = l2 == null ? Long.valueOf(0L) : l2;
            if (destRow.getPeriodid().compareTo(l) < 0) continue;
            for (Map.Entry<Object, BigDecimal> entry : srcTotalCost.entrySet()) {
                Object object = entry.getKey();
                BigDecimal groupCost = entry.getValue().multiply(destRow.getBaseqty()).divide(totalSrcQty, destRow.getAmtprecision(), RoundingMode.HALF_UP);
                BigDecimal currentGroupCost = destRow.getGroupCost(object);
                currentGroupCost = currentGroupCost == null ? BigDecimal.ZERO : currentGroupCost;
                destRow.setGroupCost(object, currentGroupCost.add(groupCost));
            }
            if (destMaxQty.compareTo(destRow.getBaseqty().abs()) > 0) continue;
            destMaxQty = destRow.getBaseqty().abs();
            maxQtyRow = destRow;
        }
        if (isCompleted) {
            HashMap<Object, BigDecimal> destTotalCost = new HashMap<Object, BigDecimal>(srcTotalCost.size());
            for (LocalRow localRow : destChildInfo.keySet()) {
                BigDecimal destCost;
                Object costField;
                Long periodId = this.paramCache.getCurrentPeriod(localRow.getCostaccountid());
                Long l = periodId = periodId == null ? Long.valueOf(0L) : periodId;
                if (localRow.getPeriodid().compareTo(periodId) >= 0) {
                    for (Map.Entry<Object, BigDecimal> entry : localRow.getGroupCostAmtMap().entrySet()) {
                        Object costField2 = entry.getKey();
                        BigDecimal destCost2 = (BigDecimal)destTotalCost.get(costField2);
                        destCost2 = destCost2 == null ? BigDecimal.ZERO : destCost2;
                        destTotalCost.put(costField2, destCost2.add(entry.getValue()));
                    }
                    continue;
                }
                if (calbycostelement) {
                    Map<Long, BigDecimal> map = localRow.getElementCostMap();
                    for (Map.Entry<Object, BigDecimal> entry : map.entrySet()) {
                        costField = (Long)entry.getKey();
                        destCost = (BigDecimal)destTotalCost.get(costField);
                        destCost = destCost == null ? BigDecimal.ZERO : destCost;
                        destTotalCost.put(costField, destCost.add(entry.getValue()));
                    }
                    continue;
                }
                Map<String, BigDecimal> map = localRow.getEntryCostMap();
                for (Map.Entry<Object, BigDecimal> entry : map.entrySet()) {
                    costField = (String)entry.getKey();
                    destCost = (BigDecimal)destTotalCost.get(costField);
                    destCost = destCost == null ? BigDecimal.ZERO : destCost;
                    destTotalCost.put(costField, destCost.add(entry.getValue()));
                }
            }
            for (Map.Entry entry : srcTotalCost.entrySet()) {
                Object costField = entry.getKey();
                BigDecimal bigDecimal = ((BigDecimal)entry.getValue()).subtract((BigDecimal)destTotalCost.get(costField));
                if (bigDecimal.compareTo(BigDecimal.ZERO) == 0 || maxQtyRow == null) continue;
                BigDecimal bigDecimal3 = maxQtyRow.getGroupCost(costField);
                bigDecimal3 = bigDecimal3 == null ? BigDecimal.ZERO : bigDecimal3;
                maxQtyRow.setGroupCost(costField, bigDecimal3.add(bigDecimal));
            }
        }
    }

    private void divideByQty(Map<Object, BigDecimal> srcTotalCost, Map<LocalRow, BillGroupRecord.ChildGroupInfo> destChildInfo, BigDecimal totalDestWeight, BillGroupRecord groupRecord, boolean calbycostelement, Map<Long, BigDecimal> destQtyMap, int srcQtySignum) {
        BigDecimal totalDestQty = BigDecimal.ZERO;
        for (BigDecimal qty : destQtyMap.values()) {
            totalDestQty = totalDestQty.add(qty);
        }
        int destCostSigum = totalDestQty.signum() * srcQtySignum;
        HashMap<Object, BigDecimal> currentTotalCostMap = new HashMap<Object, BigDecimal>();
        int destSize = destChildInfo.size();
        int i = 0;
        for (Map.Entry<LocalRow, BillGroupRecord.ChildGroupInfo> rowEntry : destChildInfo.entrySet()) {
            Object costField;
            boolean isNegate;
            LocalRow destRow = rowEntry.getKey();
            BillGroupRecord.ChildGroupInfo childInfo = rowEntry.getValue();
            Boolean ischargeoffed = childInfo.ischargeoffed();
            int destQtySignum = destQtyMap.get(childInfo.getEntryId()).signum();
            boolean bl = isNegate = destQtySignum * srcQtySignum == -1;
            if (i == destSize - 1) {
                for (Map.Entry<Object, BigDecimal> entry : srcTotalCost.entrySet()) {
                    costField = entry.getKey();
                    BigDecimal currentTotalCost = (BigDecimal)currentTotalCostMap.get(costField);
                    currentTotalCost = currentTotalCost == null ? BigDecimal.ZERO : currentTotalCost;
                    BigDecimal groupCost = entry.getValue().multiply(new BigDecimal(destCostSigum)).subtract(currentTotalCost);
                    destRow.setGroupCost(costField, groupCost.multiply(destRow.getBaseqty().abs()).divide(childInfo.getOccupiedqty().abs(), destRow.getAmtprecision(), RoundingMode.HALF_UP));
                }
            } else {
                for (Map.Entry<Object, BigDecimal> entry : srcTotalCost.entrySet()) {
                    costField = entry.getKey();
                    if (BigDecimal.ZERO.compareTo(totalDestWeight) == 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6210\u7ec4\u5173\u7cfb\u6743\u91cd\u4e3a\u96f6\uff0c\u8bf7\u68c0\u67e5\u6210\u7ec4\u5173\u7cfb\u8bb0\u5f55\u4ee5\u53ca\u6210\u7ec4\u5173\u7cfb\u914d\u7f6e\u3002", (String)"GroupBillHolder_6", (String)"fi-calx-algox", (Object[])new Object[0]));
                    }
                    BigDecimal groupCost = entry.getValue().multiply(childInfo.getWeight()).divide(totalDestWeight, destRow.getAmtprecision(), RoundingMode.HALF_UP);
                    if (isNegate) {
                        groupCost = groupCost.negate();
                    }
                    destRow.setGroupCost(costField, groupCost.multiply(destRow.getBaseqty().abs()).divide(childInfo.getOccupiedqty().abs(), destRow.getAmtprecision(), RoundingMode.HALF_UP));
                    if (ischargeoffed.booleanValue()) continue;
                    BigDecimal currentTotalCost = (BigDecimal)currentTotalCostMap.get(costField);
                    currentTotalCost = currentTotalCost == null ? groupCost : currentTotalCost.add(groupCost);
                    currentTotalCostMap.put(costField, currentTotalCost);
                }
            }
            ++i;
        }
    }

    public Map<Long, BillGroupRecord> getDestRowRecordMap() {
        return this.destRowRecordMap;
    }

    public Map<Long, List<BillGroupRecord>> getSrcRowRecordMap() {
        return this.srcRowRecordMap;
    }

    public void setCommonInfo(CommonInfo commonInfo) {
        this.commonInfo = commonInfo;
    }

    public CommonInfo getCommonInfo() {
        return this.commonInfo;
    }

    public Map<Long, LocalRow> getOldMap() {
        return this.oldMap;
    }
}

