/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.calx.algox.CalOutDataRangeHolder;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;

public class BizGroupRecordHelper
implements Serializable {
    private static Log log = LogFactory.getLog(BizGroupRecordHelper.class);
    private static final long serialVersionUID = -5214537893789017233L;
    private String cacheId = null;
    private Map<Long, Set<Object>> costAccount2MaterialidMap = null;
    private String selectFields = null;
    private Map<String, Object> paramMap = new HashMap<String, Object>(4);

    public BizGroupRecordHelper(CalOutDataRangeHolder holder, String selectFields) {
        this.selectFields = selectFields;
        this.paramMap.put("needAfterGroup", holder.isNeedCalculatedLater());
        this.costAccount2MaterialidMap = new HashMap<Long, Set<Object>>(4);
        for (CalOutDataRangeHolder.CalOutRange calOutRange : holder.getCalOutRangeList()) {
            Set<Object> materialIds;
            Long costAccountId = calOutRange.getCostAccountId();
            List<Set<Object>> materialSetList = calOutRange.getMaterialSetList();
            if (calOutRange.isAllMaterial()) {
                this.costAccount2MaterialidMap.put(costAccountId, null);
                continue;
            }
            if (this.costAccount2MaterialidMap.containsKey(costAccountId)) {
                materialIds = this.costAccount2MaterialidMap.get(costAccountId);
                if (materialIds == null) continue;
                for (Set<Object> objects : materialSetList) {
                    materialIds.addAll(objects);
                }
                continue;
            }
            materialIds = new HashSet(16);
            for (Set<Object> objects : materialSetList) {
                materialIds.addAll(objects);
            }
            this.costAccount2MaterialidMap.put(costAccountId, materialIds);
        }
    }

    public BizGroupRecordHelper(DiffAllocParamterEntry paramEntry, String selectFields) {
        this.selectFields = selectFields;
        this.costAccount2MaterialidMap = new HashMap<Long, Set<Object>>(4);
        Long costAccountId1 = paramEntry.getCostAccountId();
        Set<Object> matIdSet = paramEntry.getMatIdSet();
        this.costAccount2MaterialidMap = Collections.singletonMap(costAccountId1, matIdSet);
    }

    public BizGroupRecordHelper(DiffAllocParamter allocParam, String selectFields) {
        this.selectFields = selectFields;
        this.costAccount2MaterialidMap = new HashMap<Long, Set<Object>>(4);
        Map<String, DiffAllocParamterEntry> entrys = allocParam.getEntityEntry();
        for (DiffAllocParamterEntry entry : entrys.values()) {
            Long costAccountId = entry.getCostAccountId();
            Set<Object> matIdSet = entry.getMatIdSet();
            if (matIdSet == null || matIdSet.isEmpty()) {
                this.costAccount2MaterialidMap.put(costAccountId, null);
                continue;
            }
            matIdSet = new HashSet<Object>(matIdSet);
            if (this.costAccount2MaterialidMap.containsKey(costAccountId)) {
                Set<Object> orginMatIds = this.costAccount2MaterialidMap.get(costAccountId);
                if (orginMatIds == null || orginMatIds.isEmpty()) continue;
                orginMatIds.addAll(matIdSet);
                continue;
            }
            this.costAccount2MaterialidMap.put(costAccountId, matIdSet);
        }
    }

    public DataSet getGroupBillRecordDS() {
        if (this.cacheId == null) {
            this.cacheId = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalGroupRecordService", (String)"getGroupRecordDSWithParam", (Object[])new Object[]{this.costAccount2MaterialidMap, this.selectFields, this.paramMap});
            if (this.cacheId.startsWith(Exception.class.getName())) {
                throw new KDBizException(this.cacheId);
            }
        }
        DataSet groupRecordDS = Algo.getCacheDataSet((String)this.cacheId).toDataSet(Algo.create((String)BizGroupRecordHelper.class.getName()), false);
        return groupRecordDS;
    }

    public void close() {
        if (this.cacheId != null) {
            try {
                Algo.removeCacheDataSet((String)this.cacheId);
                this.cacheId = null;
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }
}

