/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CommonSettingHelper;

public class CBFieldsQueryHelper {
    private Map<String, String> fieldStrCache = new HashMap<String, String>();
    private Map<String, Field[]> simpleFieldStrCache = new HashMap<String, Field[]>();
    private String[] fields;

    public CBFieldsQueryHelper() {
        String calDimensionStr = CommonSettingHelper.getCalDimensionStr();
        String divideBasis = CommonSettingHelper.getDivideBasisStr();
        if (!divideBasis.contains("calorg")) {
            divideBasis = "calorg," + divideBasis;
        }
        this.fields = (divideBasis + "," + calDimensionStr).split(",");
    }

    public String[] getCaldimensionAndDivideBasisFields() {
        return this.fields;
    }

    public String getAllCalFields(String billEntityNumber) {
        String fieldStr = this.fieldStrCache.get(billEntityNumber);
        if (fieldStr != null) {
            return fieldStr;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntityNumber);
        StringBuilder sb = new StringBuilder();
        for (String field : this.fields) {
            IDataEntityProperty property = entityType.findProperty(field);
            if (property == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u3010%1$s\u3011\u4e0d\u5b58\u5728\u5c5e\u6027%2$s", (String)"CBFieldsQueryHelper_2", (String)"fi-calx-algox", (Object[])new Object[0]), entityType.getName(), field);
                throw new KDBizException(msg);
            }
            IDataEntityType parentProp = property.getParent();
            boolean isEntryProp = parentProp instanceof EntryType;
            if (isEntryProp) {
                sb.append(parentProp.getName());
                sb.append('.');
            }
            sb.append(field);
            if (isEntryProp) {
                sb.append(" as ");
                sb.append(field);
            }
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        fieldStr = sb.toString();
        this.fieldStrCache.put(billEntityNumber, fieldStr);
        return fieldStr;
    }

    public Field[] getAllCalSimpleFields(String billEntityNumber) {
        Field[] fieldArrray = this.simpleFieldStrCache.get(billEntityNumber);
        if (fieldArrray != null) {
            return fieldArrray;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntityNumber);
        ArrayList<Field> dynamicFields = new ArrayList<Field>(16);
        for (String field : this.fields) {
            IDataEntityProperty property = entityType.findProperty(field);
            if (property == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u3010%1$s\u3011\u4e0d\u5b58\u5728\u5c5e\u6027%2$s", (String)"CBFieldsQueryHelper_2", (String)"fi-calx-algox", (Object[])new Object[0]), entityType.getName(), field);
                throw new KDBizException(msg);
            }
            if (entityType.findProperty(field) instanceof BasedataProp) {
                dynamicFields.add(new Field(field, (DataType)DataType.LongType));
                continue;
            }
            dynamicFields.add(new Field(field, (DataType)DataType.StringType));
        }
        this.simpleFieldStrCache.put(billEntityNumber, dynamicFields.toArray(new Field[0]));
        return dynamicFields.toArray(new Field[0]);
    }

    public String getDimFileds(String billEntityNumber) {
        return this.getDimFileds(billEntityNumber, true);
    }

    public String getDimFileds(String billEntityNumber, boolean showError) {
        String[] dynamicFileds = CalBalanceModelHelper.getDimField().toArray(new String[0]);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntityNumber);
        StringBuilder sb = new StringBuilder();
        for (String field : dynamicFileds) {
            IDataEntityProperty property = entityType.findProperty(field);
            if (property == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u3010%1$s\u3011\u4e0d\u5b58\u5728\u5c5e\u6027%2$s", (String)"CBFieldsQueryHelper_2", (String)"fi-calx-algox", (Object[])new Object[0]), entityType.getName(), field);
                if (!showError) continue;
                throw new KDBizException(msg);
            }
            IDataEntityType parentProp = property.getParent();
            boolean isEntryProp = parentProp instanceof EntryType;
            if (isEntryProp) {
                sb.append(parentProp.getName());
                sb.append('.');
            }
            sb.append(field);
            if (isEntryProp) {
                sb.append(" as ");
                sb.append(field);
            }
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

