/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.constant.CalDbParamConstant;

public class CalDbParamServiceHelper {
    private static final String KEY_NAME = "key";
    private static final String VALUE_NAME = "value";
    private static final String ORG_NAME = "org";

    public static String getString(String key, String orgId) {
        Long orgid = orgId == null ? Long.valueOf(0L) : Long.valueOf(orgId);
        String paramValue = null;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cal_dbparam");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        QFilter keyFilter = new QFilter(KEY_NAME, "=", (Object)key);
        filters.add(keyFilter);
        String cacheKey = key;
        if (StringUtils.isNotEmpty((String)orgId)) {
            QFilter orgIdFilter = new QFilter(ORG_NAME, "=", (Object)orgid);
            filters.add(orgIdFilter);
            cacheKey = cacheKey + orgid;
        }
        if ((paramValue = (String)ThreadCache.get((Object)cacheKey)) == null) {
            DynamicObject[] paramDycs = BusinessDataServiceHelper.load((String)"cal_dbparam", (String)"key,value,org", (QFilter[])filters.toArray(new QFilter[0]));
            if (paramDycs.length < 1) {
                DynamicObject newParamDyc = new DynamicObject((DynamicObjectType)entityType);
                String defaultValue = CalDbParamConstant.keyDefaultValueMap.get(key);
                newParamDyc.set(KEY_NAME, (Object)key);
                newParamDyc.set(ORG_NAME, (Object)orgid);
                newParamDyc.set(VALUE_NAME, (Object)defaultValue);
                paramValue = defaultValue;
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newParamDyc});
            } else {
                paramValue = paramDycs[0].getString(VALUE_NAME);
            }
            if (paramValue != null) {
                ThreadCache.put((Object)cacheKey, (Object)paramValue);
            }
        }
        return paramValue;
    }

    public static Integer getInteger(String key) {
        return CalDbParamServiceHelper.getInteger(key, null);
    }

    public static Integer getInteger(String key, String orgId) {
        String param = CalDbParamServiceHelper.getString(key, orgId);
        if (StringUtils.isEmpty((String)param)) {
            return null;
        }
        return Integer.valueOf(param);
    }

    public static Long getLong(String key) {
        return CalDbParamServiceHelper.getLong(key, null);
    }

    public static Long getLong(String key, String orgId) {
        String param = CalDbParamServiceHelper.getString(key, orgId);
        if (StringUtils.isEmpty((String)param)) {
            return null;
        }
        return Long.valueOf(param);
    }

    public static BigDecimal getBigDecimal(String key) {
        return CalDbParamServiceHelper.getBigDecimal(key, null);
    }

    public static BigDecimal getBigDecimal(String key, String orgId) {
        String param = CalDbParamServiceHelper.getString(key, orgId);
        if (StringUtils.isEmpty((String)param)) {
            return null;
        }
        return new BigDecimal(param);
    }

    public static Boolean getBoolean(String key) {
        return CalDbParamServiceHelper.getBoolean(key, null);
    }

    public static Boolean getBoolean(String key, String orgId) {
        String param = CalDbParamServiceHelper.getString(key, orgId);
        if (StringUtils.isEmpty((String)param)) {
            return null;
        }
        return Boolean.valueOf(param);
    }
}

