/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import java.io.IOException;
import java.util.Date;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CalLogLevelEnum;

public class CalLogManager {
    private final Date initTime;
    private Long startTime;
    private StringBuilder logSB = new StringBuilder();
    private String logLevels = CalDbParamServiceHelper.getString(CalDbParamConstant.DBLOG_LEVEL, null);

    public CalLogManager() {
        this.initTime = TimeServiceHelper.now();
        this.startTime = TimeServiceHelper.now().getTime();
    }

    public void error(String log, Object params, String type) {
        this.log(CalLogLevelEnum.ERROR.getValue(), log, params, type);
    }

    public void info(String log, Object params, String type) {
        this.log(CalLogLevelEnum.INFO.getValue(), log, params, type);
    }

    public void warn(String log, Object params, String type) {
        this.log(CalLogLevelEnum.WARN.getValue(), log, params, type);
    }

    private void log(String level, String log, Object params, String type) {
        if (!this.logLevels.contains(level)) {
            return;
        }
        Date endTime = TimeServiceHelper.now();
        String paramStr = null;
        try {
            paramStr = JSONUtils.toString((Object)params);
        }
        catch (IOException e) {
            paramStr = IOException.class.getName();
        }
        log = log + this.logSB.toString();
        log = log.length() > 0 ? "{sart-" + log + "-end}" : log;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cal_dblog");
        DynamicObject newDyc = new DynamicObject((DynamicObjectType)entityType);
        newDyc.set("starttime", (Object)this.initTime);
        newDyc.set("endtime", (Object)endTime);
        newDyc.set("creater", (Object)RequestContext.get().getCurrUserId());
        newDyc.set("traceid", (Object)RequestContext.get().getTraceId());
        newDyc.set("level", (Object)level);
        newDyc.set("log", (Object)log.substring(0, Math.min(log.length(), 250)));
        newDyc.set("log_tag", (Object)log);
        newDyc.set("param", (Object)paramStr.substring(0, Math.min(paramStr.length(), 250)));
        newDyc.set("param_tag", (Object)paramStr);
        newDyc.set("type", (Object)type);
        newDyc.set("time", (Object)(endTime.getTime() - this.initTime.getTime()));
        try (TXHandle txHandle = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDyc});
        }
    }

    public void appenInfo(Object msg) {
        this.appenLog(CalLogLevelEnum.INFO.getValue(), msg);
    }

    public void appenWarn(Object msg) {
        this.appenLog(CalLogLevelEnum.WARN.getValue(), msg);
    }

    public void appenError(Object msg) {
        this.appenLog(CalLogLevelEnum.ERROR.getValue(), msg);
    }

    private void appenLog(String level, Object msg) {
        if (!this.logLevels.contains(level)) {
            return;
        }
        try {
            msg = JSONUtils.toString((Object)msg);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.logSB.length() > 0) {
            this.logSB.append(",");
        }
        this.logSB.append(msg);
        this.logSB.append("-");
        this.logSB.append(TimeServiceHelper.now().getTime() - this.startTime);
        this.startTime = TimeServiceHelper.now().getTime();
    }
}

