/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.calx.algox.accounttype.LocalRow;
import kd.fi.calx.algox.processor.IBizProcessor;

public class CalServiceHelper {
    private static final Log logger = LogFactory.getLog(CalServiceHelper.class);

    public Map<Long, String> doBizChain(List<String> implClassList, List<LocalRow> rows) throws KDBizException {
        Map<Long, String> result = new HashMap<Long, String>(16);
        if (implClassList == null || implClassList.isEmpty() || rows == null || rows.isEmpty()) {
            return result;
        }
        try {
            for (int i = 0; i < implClassList.size(); ++i) {
                String className = implClassList.get(i);
                IBizProcessor process = null;
                if (process != null) {
                    long startTime = System.currentTimeMillis();
                    if (process != null) {
                        result = process.doProcessor(rows);
                        logger.info(process.getClass().getName() + "\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
                    }
                    if (result == null || result.isEmpty()) continue;
                    return result;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("CalServiceHelper->doBizChain error", (Throwable)e);
            if (result == null) {
                result = new HashMap(16);
            }
            result.put(rows.get(0).getHeadid(), ResManager.loadKDString((String)"\u914d\u7f6e\u8be5\u63a5\u53e3\u5b9e\u4f8b\u5316\u51fa\u73b0\u5f02\u5e38", (String)"CalServiceHelper_1", (String)"fi-calx-algox", (Object[])new Object[0]));
            throw new KDBizException((Throwable)e, null, new Object[0]);
        }
        if (implClassList.size() == 0) {
            logger.info("\u6ca1\u6709\u914d\u7f6e\u76f8\u5e94\u63a5\u53e3");
        }
        return result;
    }

    public static IBizProcessor getProcessByName(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> process = Class.forName(className);
        return (IBizProcessor)process.newInstance();
    }

    public static List<String> getServiceSetting(String serviceType, String actionName) {
        String fields = "entry.exeseq,entry.implclass";
        QFilter settingFilter = new QFilter("servicetype", "=", (Object)serviceType);
        settingFilter.and(new QFilter("actionname", "=", (Object)actionName));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)("CalServiceHelper.getServiceSetting." + serviceType + actionName), (String)"cal_actionchain", (String)fields, (QFilter[])new QFilter[]{settingFilter}, (String)"entry.exeseq");
        ArrayList<String> implList = new ArrayList<String>(32);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String implClassStr = row.get("entry.implclass").toString();
            implList.add(implClassStr);
        }
        return implList;
    }
}

