/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;

public class CalculateParamHelper {
    public static CalCulateOutParams buildDistributedParam(boolean isCostCall, boolean isConcurrency, DynamicObject calOutDyc, Long schemeId) {
        CalCulateOutParams param = new CalCulateOutParams();
        DynamicObjectCollection checkEntryDycs = calOutDyc.getDynamicObjectCollection("checkentry");
        HashMap<String, Map<Long, String>> allCheckItemMap = new HashMap<String, Map<Long, String>>(16);
        param.setWriteRpt(calOutDyc.getBoolean("cbxwriterpt"));
        param.setMatrix(calOutDyc.getBoolean("cbxmatrix"));
        param.setWriteErrRpt(calOutDyc.getBoolean("cbxwriteerrrpt"));
        param.setWeightavgRunningMode(calOutDyc.getInt("weightavg"));
        param.setSppriceRunningMode(calOutDyc.getInt("spprice"));
        param.setMovedavgRunningMode(calOutDyc.getInt("movedavg"));
        param.setFifoRunningMode(calOutDyc.getInt("fifo"));
        param.setFifoPeriodRunningMode(calOutDyc.getInt("fifo_period"));
        param.setConcurrency(calOutDyc.getInt("concurrency"));
        param.setCostatenddateenable(calOutDyc.getBoolean("costatenddateenable"));
        param.setCostatenddate(calOutDyc.getDate("costatenddate"));
        param.setVoucherdutweightedavgat(calOutDyc.getBoolean("voucherdutweightedavgat"));
        param.setDesigoutweightedavgat(calOutDyc.getBoolean("desigoutweightedavgat"));
        param.setCoverdesigoutcost(calOutDyc.getBoolean("coverdesigoutcost"));
        for (DynamicObject checkEntryDyc : checkEntryDycs) {
            Boolean ischeck = checkEntryDyc.getBoolean("ischeck");
            if (!ischeck.booleanValue()) continue;
            Long itemId = checkEntryDyc.getDynamicObject("checkitem").getLong("id");
            String level = checkEntryDyc.getString("level");
            String purpose = checkEntryDyc.getString("purpose");
            HashMap<Long, String> checkItemMap = (HashMap<Long, String>)allCheckItemMap.get(purpose);
            if (checkItemMap == null) {
                checkItemMap = new HashMap<Long, String>(16);
            }
            checkItemMap.put(itemId, level);
            allCheckItemMap.put(purpose, checkItemMap);
        }
        param.setCheckItems(allCheckItemMap);
        if (isCostCall) {
            return param;
        }
        DynamicObjectCollection calOutEntryDycs = calOutDyc.getDynamicObjectCollection("entry");
        int size = calOutEntryDycs.size();
        if (size == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u5f55\u5165\u4e00\u6761\u6709\u6548\u6838\u7b97\u8303\u56f4\u5206\u5f55\u8fdb\u884c\u51fa\u5e93\u6838\u7b97\u3002", (String)"CalculateOutCostPlugin_12", (String)"fi-calx-algox", (Object[])new Object[0]));
        }
        HashSet<Long> periodidSet = new HashSet<Long>(16);
        for (int i = 0; i < size; ++i) {
            DynamicObject calEntryDyc = (DynamicObject)calOutEntryDycs.get(i);
            DynamicObject costAccount = calEntryDyc.getDynamicObject("costaccount");
            if (costAccount == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u8fdb\u884c\u51fa\u5e93\u6838\u7b97\u3002", (String)"CalculateOutCostPlugin_18", (String)"fi-calx-algox", (Object[])new Object[0]), i + 1);
                throw new KDBizException(msg);
            }
            DynamicObject periodObj = calEntryDyc.getDynamicObject("period");
            if (periodObj == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\u5c1a\u672a\u8fdb\u884c\u671f\u95f4\u521d\u59cb\u5316\u3002", (String)"CalculateOutCostPlugin_19", (String)"fi-calx-algox", (Object[])new Object[0]), i + 1);
                throw new KDBizException(msg);
            }
            Long periodid = periodObj.getLong("id");
            periodidSet.add(periodid);
            DynamicObject calRangeObj = calEntryDyc.getDynamicObject("calrange");
            Set<Object> matIds = CalculateParamHelper.analyseMaterialSet(calEntryDyc);
            if (!isConcurrency) {
                param.addEntry(costAccount.getLong("id"), calRangeObj == null ? null : Long.valueOf(calRangeObj.getLong("id")), matIds);
                continue;
            }
            param.addEntryNoHandle(costAccount.getLong("id"), calRangeObj == null ? null : Long.valueOf(calRangeObj.getLong("id")), matIds);
        }
        boolean costatenddateenable = param.isCostatenddateenable();
        if ((0 != param.getRunningModeMap().get(AccountTypeEnum.WEIGHTAVG.getValue()) || 0 != param.getRunningModeMap().get(AccountTypeEnum.SPPRICE.getValue())) && costatenddateenable) {
            String msg;
            Date costatenddate = param.getCostatenddate();
            if (null == costatenddate) {
                msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u622a\u6b62\u65e5\u671f\u3002", (String)"CalculateOutCostPlugin_39", (String)"fi-calx-algox", (Object[])new Object[0]), new Object[0]);
                throw new KDBizException(msg);
            }
            if (!periodidSet.isEmpty() && periodidSet.size() > 1) {
                msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u622a\u6b62\u65e5\u671f\u5f00\u542f\u65f6\u6240\u9009\u6210\u672c\u8d26\u7c3f\u7684\u671f\u95f4\u5fc5\u987b\u76f8\u540c\u3002", (String)"CalculateOutCostPlugin_28", (String)"fi-calx-algox", (Object[])new Object[0]), new Object[0]);
                throw new KDBizException(msg);
            }
            for (int i = 0; i < size; ++i) {
                DynamicObject calEntryDyc = (DynamicObject)calOutEntryDycs.get(i);
                DynamicObject periodObj = calEntryDyc.getDynamicObject("period");
                Date enddate = periodObj.getDate("enddate");
                Date begindate = periodObj.getDate("begindate");
                if (begindate.getTime() <= costatenddate.getTime() && costatenddate.getTime() <= enddate.getTime()) continue;
                String msg2 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u622a\u6b62\u65e5\u671f\u5fc5\u987b\u5728\u8d26\u7c3f\u671f\u95f4\u4ee5\u5185\u3002", (String)"CalculateOutCostPlugin_29", (String)"fi-calx-algox", (Object[])new Object[0]), i + 1);
                throw new KDBizException(msg2);
            }
        }
        param.setQuerySchemeId(schemeId);
        String billnofilterjson = calOutDyc.getString("billnofilterjson_tag");
        if (!StringUtils.isEmpty((CharSequence)billnofilterjson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billnofilterjson, FilterCondition.class);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cal_costrecord_subentity");
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
            filterBuilder.buildFilter();
            QFilter billnofilter = filterBuilder.getQFilter();
            if (billnofilter != null) {
                param.setBillNoFilterStr(billnofilter.toString());
            }
        }
        return param;
    }

    private static Set<Object> analyseMaterialSet(DynamicObject calEntryDyc) {
        DynamicObjectCollection materialGroupCol = calEntryDyc.getDynamicObjectCollection("materialgroup");
        DynamicObjectCollection materialFromCol = calEntryDyc.getDynamicObjectCollection("materialfrom");
        DynamicObject materialTo = calEntryDyc.getDynamicObject("materialto");
        HashSet<Object> materialSet = null;
        if (materialGroupCol != null && !materialGroupCol.isEmpty()) {
            HashSet<String> longNumbers = new HashSet<String>(materialGroupCol.size());
            materialGroupCol.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject p0, DynamicObject p1) {
                    String p0longnumber = p0.getDynamicObject("fbasedataid").getString("longnumber");
                    String p1longnumber = p1.getDynamicObject("fbasedataid").getString("longnumber");
                    return Integer.compare(p0longnumber.length(), p1longnumber.length());
                }
            });
            for (DynamicObject materialGroup : materialGroupCol) {
                boolean hasParentGroup = false;
                String longNum = materialGroup.getDynamicObject("fbasedataid").getString("longnumber");
                for (String longNumber : longNumbers) {
                    if (!longNum.startsWith(longNumber)) continue;
                    hasParentGroup = true;
                    break;
                }
                if (hasParentGroup) continue;
                longNumbers.add(longNum);
            }
            materialSet = new HashSet(16);
            for (String longNumber : longNumbers) {
                QFilter groupFilter = new QFilter("group.longnumber", "like", (Object)(longNumber + "%"));
                DynamicObjectCollection materialCol = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material.id", (QFilter[])groupFilter.toArray());
                for (DynamicObject material : materialCol) {
                    materialSet.add(material.get("material.id"));
                }
            }
            if (materialSet == null || materialSet.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7269\u6599\u5206\u7c7b\u4e0b\u6ca1\u6709\u7269\u6599\u3002", (String)"CalculateOutCostPlugin_10", (String)"fi-calx-algox", (Object[])new Object[0]));
            }
        } else if (materialTo != null) {
            if (materialFromCol == null || materialFromCol.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7269\u6599\u4ece\u201d\u3002", (String)"CalculateOutCostPlugin_9", (String)"fi-calx-algox", (Object[])new Object[0]));
            }
            String fromMaterialNo = ((DynamicObject)materialFromCol.get(0)).getDynamicObject("fbasedataid").getString("number");
            String toMaterialNo = materialTo.getString("number");
            QFilter materialFilter = new QFilter("number", ">=", (Object)fromMaterialNo);
            materialFilter.and(new QFilter("number", "<=", (Object)toMaterialNo));
            DynamicObjectCollection materialDyC = QueryServiceHelper.query((String)"bd_material", (String)"id", (QFilter[])materialFilter.toArray());
            materialSet = new HashSet(16);
            for (DynamicObject dynamicObject : materialDyC) {
                materialSet.add(dynamicObject.get("id"));
            }
            if (materialSet.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u201c\u7269\u6599\u4ece\u201d\u3001\u201c\u7269\u6599\u81f3\u201d\u4e0b\u6ca1\u6709\u7269\u6599\u3002", (String)"CalculateOutCostPlugin_11", (String)"fi-calx-algox", (Object[])new Object[0]));
            }
        } else if (materialFromCol != null && !materialFromCol.isEmpty()) {
            materialSet = new HashSet<Object>();
            for (DynamicObject material : materialFromCol) {
                materialSet.add(material.get("fbasedataid_id"));
            }
        }
        return materialSet;
    }
}

