/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CommonSettingHelper {
    public static final long ID = 683799445774680063L;

    public static String getDivideBasisStr() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        String divideBasisStr = setting.getString("dividebasiscols");
        if (divideBasisStr.startsWith(",")) {
            divideBasisStr = divideBasisStr.substring(1, divideBasisStr.length());
        }
        if (divideBasisStr.endsWith(",")) {
            divideBasisStr = divideBasisStr.substring(0, divideBasisStr.length() - 1);
        }
        return divideBasisStr;
    }

    public static String getCalDimensionStr() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        String calDimensionStr = setting.getString("caldimensioncols");
        if (calDimensionStr.startsWith(",")) {
            calDimensionStr = calDimensionStr.substring(1, calDimensionStr.length());
        }
        if (calDimensionStr.endsWith(",")) {
            calDimensionStr = calDimensionStr.substring(0, calDimensionStr.length() - 1);
        }
        return calDimensionStr;
    }

    public static Set<String> getExFieldSet() {
        HashSet<String> exFieldSet = new HashSet<String>();
        QFilter filter = new QFilter("sourcebill.number", "=", (Object)"im_purinbill");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection purRules = QueryServiceHelper.query((String)"cal_calbillrule", (String)"id,fieldmap.calfield,fieldmap.isextendfield", (QFilter[])filter.toArray(), null);
        for (DynamicObject rule : purRules) {
            if (!rule.getBoolean("fieldmap.isextendfield")) continue;
            exFieldSet.add(rule.getString("fieldmap.calfield"));
        }
        return exFieldSet;
    }

    public static void setExFieldValue(MainEntityType destEntiyType, MainEntityType srcEntityType, DynamicObject destInfo, DynamicObject srcInfo) {
        Set<String> exFieldSet = CommonSettingHelper.getExFieldSet();
        if (exFieldSet != null && !exFieldSet.isEmpty()) {
            for (String exField : exFieldSet) {
                IDataEntityProperty srcProperty = srcEntityType.findProperty(exField);
                IDataEntityProperty destProperty = destEntiyType.findProperty(exField);
                if (srcProperty == null || destProperty == null) continue;
                destInfo.set(exField, srcInfo.get(exField));
            }
        }
    }

    public static DynamicObject getSettingObj() {
        DynamicObject setting = BusinessDataServiceHelper.loadSingleFromCache((Object)683799445774680063L, (String)"cal_setting");
        return setting;
    }

    public static DynamicObject getCostAdjustOutBillType() {
        return CommonSettingHelper.getBillType("caloutbilltypes", "im_SalOutBill_STD_BT_S");
    }

    public static DynamicObject getCostAdjustInBillType() {
        return CommonSettingHelper.getBillType("calinbilltypes", "im_PurInBill_STD_BT_S");
    }

    private static DynamicObject getBillType(String billTypeName, String defaultBillTypeNum) {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection billTypes = setting.getDynamicObjectCollection(billTypeName);
        DynamicObject[] defaultBillTypes = BusinessDataServiceHelper.load((String)"bos_billtype", (String)"billtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)defaultBillTypeNum)});
        DynamicObject defaultBillType = null;
        if (defaultBillTypes != null && defaultBillTypes.length > 0) {
            defaultBillType = defaultBillTypes[0];
        }
        boolean isContain = false;
        if (billTypes.size() >= 1) {
            for (DynamicObject billtype : billTypes) {
                DynamicObject billTypeDyc = billtype.getDynamicObject("fbasedataid");
                if (billTypeDyc == null || defaultBillType == null || !defaultBillType.getString("id").equals(billTypeDyc.getString("id"))) continue;
                isContain = true;
                break;
            }
            if (isContain) {
                return defaultBillType;
            }
            return ((DynamicObject)billTypes.get(0)).getDynamicObject("fbasedataid");
        }
        return null;
    }

    public static Set<Long> getNotUpdBalBizType() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection bizTypeColl = setting.getDynamicObjectCollection("notupdatebalance");
        HashSet<Long> bizTypeIdSet = new HashSet<Long>(16);
        for (DynamicObject bizType : bizTypeColl) {
            DynamicObject bizTypeDyc = bizType.getDynamicObject("fbasedataid");
            if (bizTypeDyc == null) continue;
            bizTypeIdSet.add(bizTypeDyc.getLong("id"));
        }
        return bizTypeIdSet;
    }

    public static void setExFieldValue(Set<String> exFieldSet, MainEntityType destEntiyType, MainEntityType srcEntityType, DynamicObject destInfo, DynamicObject srcInfo) {
        if (exFieldSet != null && !exFieldSet.isEmpty()) {
            for (String exField : exFieldSet) {
                IDataEntityProperty srcProperty = srcEntityType.findProperty(exField);
                IDataEntityProperty destProperty = destEntiyType.findProperty(exField);
                if (srcProperty == null || destProperty == null) continue;
                if (srcProperty instanceof BasedataProp) {
                    destInfo.set(exField, srcInfo.get(exField + "_id"));
                    continue;
                }
                destInfo.set(exField, srcInfo.get(exField));
            }
        }
    }

    public static Set<Long> getZeroInOutBizTypeIds() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection col = setting.getDynamicObjectCollection("zeroinoutbiztype");
        HashSet<Long> billtypeids = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : col) {
            DynamicObject bizDyc = dynamicObject.getDynamicObject("fbasedataid");
            if (bizDyc == null) continue;
            billtypeids.add(bizDyc.getLong("id"));
        }
        return billtypeids;
    }
}

