/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DbInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.helper.AutoSortHelperNew;
import kd.fi.calx.algox.helper.CalDLockHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.PeriodHelper;
import kd.fi.calx.algox.util.DateUtils;

public class CostAccountGroupRecordHelper {
    public static final String UPDATE_ISBEFOREPERIOD = "update t_cal_atgrouprecord_entry set fisbeforeperiod = '1' where fcostaccountid = ? and fperiodid < ?";
    public static final String UPDATE_NOTISBEFOREPERIOD = "update t_cal_atgrouprecord_entry set fisbeforeperiod = '0' where fcostaccountid = ? and fperiodid >= ?";
    public static final int BATCH_SIZE = 50000;
    private static final String QUERY_NOTCREATED_GROUPRECORD = "select fid from t_cal_groupbillrecord where fid not in (select fbizgrouprecordid from t_cal_accountgrouprecord)";
    private static final String QUERY_NOTCREATED_GROUPRECORD_BYTIME_SQL = "select a.fid from t_cal_groupbillrecord  a left join t_cal_accountgrouprecord b on a.fid = b.fbizgrouprecordid and a.fupdatetime = b.fupdatetime and b.fupdatetime >= ? and b.fupdatetime <= ? where  a.fupdatetime >= ? and a.fupdatetime <= ? and b.fid is null;";
    private static Log log = LogFactory.getLog(CostAccountGroupRecordHelper.class);
    private static final String DLOCK_KEY = "cal_refreshGroupLock#";

    public static void refreshGroupRecordByTime() {
        Boolean isNewGroup = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.ACCOUNTGROUP_NEWMODEL);
        if (isNewGroup.booleanValue()) {
            return;
        }
        Throwable throwable = null;
        try (TXHandle handle = TX.required();){
            HashSet<Long> bizRecordIdSet = new HashSet<Long>(16);
            log.info("\u67e5\u8be2\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb\u5f00\u59cb");
            List<DbInput> inputs = CostAccountGroupRecordHelper.getDbInputs();
            DataSet splitDataSet = Algo.create((String)CostAccountGroupRecordHelper.class.getName()).createDataSet((Input[])inputs.toArray(new DbInput[inputs.size()]));
            for (Row row : splitDataSet) {
                bizRecordIdSet.add(row.getLong("fid"));
            }
            if (bizRecordIdSet.isEmpty()) {
                return;
            }
            try {
                CostAccountGroupRecordHelper.refreshGroupRecordByBiz(bizRecordIdSet, null);
            }
            catch (Throwable e) {
                handle.markRollback();
                log.error("\u5237\u65b0\u8d26\u7c3f\u7ea7\u6210\u7ec4\u5173\u7cfb\u51fa\u73b0\u5f02\u5e38", e);
                throw e;
            }
        }
    }

    private static List<DbInput> getDbInputs() {
        Date nowDate;
        ArrayList<DbInput> inputs = new ArrayList<DbInput>(16);
        Integer splitDay = CalDbParamServiceHelper.getInteger("gen_group_split_day");
        Integer beforeDay = CalDbParamServiceHelper.getInteger("gen_group_start_before_day");
        Date startDate = DateUtils.addDateTime(TimeServiceHelper.now(), 5, 0 - beforeDay);
        int diffDay = CostAccountGroupRecordHelper.getDateDiffDay(startDate, nowDate = TimeServiceHelper.now());
        int batch = diffDay / splitDay;
        batch = batch == 0 ? 1 : batch;
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("fid", (DataType)DataType.LongType)});
        for (int i = 0; i < batch; ++i) {
            Date curEndDate = DateUtils.addDateTime(startDate, 5, splitDay);
            if (i == batch - 1) {
                curEndDate = nowDate;
            }
            Object[] params = new Object[]{startDate, curEndDate, startDate, curEndDate};
            DbInput input = new DbInput(CostAccountGroupRecordHelper.class.getName(), "cal", QUERY_NOTCREATED_GROUPRECORD_BYTIME_SQL, params, rowMeta);
            inputs.add(input);
            startDate = curEndDate;
        }
        return inputs;
    }

    public static void refreshGroupRecordByTimeWithoutSort() {
        Throwable throwable = null;
        try (TXHandle handle = TX.required();){
            Date maxAccountDate;
            DynamicObject maxBizRecord = QueryServiceHelper.queryOne((String)"cal_groupbillrecord", (String)"max(updatetime) as maxtime", null);
            if (maxBizRecord == null) {
                return;
            }
            Date maxBizDate = maxBizRecord.getDate("maxtime");
            if (maxBizDate == null) {
                return;
            }
            DynamicObject maxCostAccountRecord = QueryServiceHelper.queryOne((String)"cal_account_grouprecord", (String)"max(updatetime) as maxtime", null);
            Date date = maxAccountDate = maxCostAccountRecord == null ? null : maxCostAccountRecord.getDate("maxtime");
            if (maxAccountDate != null && maxAccountDate.compareTo(maxBizDate) >= 0) {
                return;
            }
            try {
                QFilter[] bizRecordFilter = null;
                if (maxAccountDate != null) {
                    bizRecordFilter = new QFilter("updatetime", ">", (Object)maxAccountDate).toArray();
                }
                DataSet bizDataSet = QueryServiceHelper.queryDataSet((String)CostAccountGroupRecordHelper.class.getName(), (String)"cal_groupbillrecord", (String)"id", bizRecordFilter, null);
                HashSet<Long> bizRecordIdSet = new HashSet<Long>(16);
                while (bizDataSet.hasNext()) {
                    bizRecordIdSet.add(bizDataSet.next().getLong("id"));
                }
                CostAccountGroupRecordHelper.createAccountRecordByBizRecord(bizRecordIdSet, null, false);
                QFilter deleteFilter = new QFilter("bizgrouprecordid", "in", bizRecordIdSet);
                DeleteServiceHelper.delete((String)"cal_account_grouprecord", (QFilter[])deleteFilter.toArray());
            }
            catch (KDBizException kde) {
                handle.markRollback();
                log.error("CostAccountGroupRecordHelper->refreshGroupRecordByTimeWithoutSort error", (Throwable)kde);
                throw kde;
            }
            catch (Throwable e) {
                handle.markRollback();
                log.error("\u5237\u65b0\u8d26\u7c3f\u7ea7\u6210\u7ec4\u5173\u7cfb\u51fa\u73b0\u5f02\u5e38", e);
                throw e;
            }
        }
    }

    public static void refreshGroupRecordByBizRecordNoSort(Set<Long> costAccountIds) {
        DataSet dataSet = DB.queryDataSet((String)CostAccountGroupRecordHelper.class.getName(), (DBRoute)new DBRoute("cal"), (String)QUERY_NOTCREATED_GROUPRECORD);
        if (dataSet.isEmpty()) {
            return;
        }
        HashSet<Long> bizRecordIdSet = new HashSet<Long>();
        for (Row row : dataSet) {
            bizRecordIdSet.add(row.getLong("fid"));
        }
        CostAccountGroupRecordHelper.createAccountRecordByBizRecord(bizRecordIdSet, costAccountIds, false);
    }

    public static void rebuildAllGroupRecord() {
        try (TXHandle handle = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"cal_account_grouprecord", null);
                DataSet bizDataSet = QueryServiceHelper.queryDataSet((String)CostAccountGroupRecordHelper.class.getName(), (String)"cal_groupbillrecord", (String)"id", null, null);
                HashSet<Long> bizRecordIdSet = new HashSet<Long>(16);
                while (bizDataSet.hasNext()) {
                    bizRecordIdSet.add(bizDataSet.next().getLong("id"));
                }
                CostAccountGroupRecordHelper.createAccountRecordByBizRecord(bizRecordIdSet, null, false);
                new AutoSortHelperNew().rebuildAllSortResult();
            }
            catch (KDBizException kde) {
                handle.markRollback();
                log.error("\u5237\u65b0\u8d26\u7c3f\u7ea7\u6210\u7ec4\u5173\u7cfb\u51fa\u73b0\u5f02\u5e38", (Throwable)kde);
                throw kde;
            }
            catch (Throwable e) {
                handle.markRollback();
                log.error("\u5237\u65b0\u8d26\u7c3f\u7ea7\u6210\u7ec4\u5173\u7cfb\u51fa\u73b0\u5f02\u5e38", e);
                throw e;
            }
        }
    }

    private static List<DynamicObject> saveCostGroupRecord(List<DynamicObject> recordObjList) {
        Throwable throwable;
        TXHandle h;
        if (recordObjList == null || recordObjList.isEmpty()) {
            return recordObjList;
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(50000);
        Iterator<DynamicObject> it = recordObjList.iterator();
        while (it.hasNext()) {
            if (saveList.size() >= 50000) {
                h = TX.requiresNew();
                throwable = null;
                try {
                    SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h != null) {
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
                saveList.clear();
            }
            saveList.add(it.next());
        }
        if (!saveList.isEmpty()) {
            h = TX.requiresNew();
            throwable = null;
            try {
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        return recordObjList;
    }

    public static void refreshGroupRecordByBiz(Set<Long> bizRecordIdSet, Set<Long> costAccountIds) {
        CostAccountGroupRecordHelper.createAccountRecordByBizRecord(bizRecordIdSet, costAccountIds, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void refreshGroupRecordByBizRecord() {
        DataSet dataSet = DB.queryDataSet((String)CostAccountGroupRecordHelper.class.getName(), (DBRoute)new DBRoute("cal"), (String)QUERY_NOTCREATED_GROUPRECORD);
        if (dataSet.isEmpty()) {
            return;
        }
        ArrayList setList = new ArrayList(1024);
        int i = 0;
        int max = 10000;
        HashSet<Long> bizRecordIdSet = new HashSet<Long>(1024);
        setList.add(bizRecordIdSet);
        for (Row row : dataSet) {
            if (i >= max) {
                bizRecordIdSet = new HashSet(1024);
                i = 0;
                setList.add(bizRecordIdSet);
            }
            bizRecordIdSet.add(row.getLong("fid"));
            ++i;
        }
        try (ThreadPool pool = ThreadPools.newFixedThreadPool((String)"calgrouprecordrefresh", (int)5);){
            for (final Set set : setList) {
                pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        try (TXHandle tx = TX.requiresNew();){
                            CostAccountGroupRecordHelper.refreshGroupRecordByBiz(set, null);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAccountRecordByBizRecord(Set<Long> bizRecordIds, Set<Long> costAccountIds, boolean isSort) {
        if (bizRecordIds.isEmpty()) {
            return;
        }
        log.info("createAccountRecordByBizRecord.bizRecordIds.size:" + bizRecordIds.size());
        int batchSize = CalDbParamServiceHelper.getInteger(CalDbParamConstant.GENACTGROUP_BATCHSIZE);
        try (DLock lock = null;
             TXHandle handle = TX.required();){
            lock = DLock.createReentrant((String)(DLOCK_KEY + CacheKeyUtil.getAcctId()));
            CalDLockHelper.releaseLockAfterTxEnd(Collections.singletonList(lock));
            if (!lock.tryLock()) {
                ErrorCode errorCode = new ErrorCode("refresActGroupRunning", ResManager.loadKDString((String)"\u540e\u53f0\u6b63\u5728\u5237\u65b0\u6210\u7ec4\u5173\u7cfb\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CostAccountGroupRecordHelper_2", (String)"fi-calx-algox", (Object[])new Object[0]));
                throw new KDBizException(errorCode, new Object[0]);
            }
            String selectFields = "id,groupsettingtype,groupsetting,costcolumn,costfields,iscompleted,updatetime,entryentity.type as type,entryentity.bizbillid as bizbillid,entryentity.billentryid as calentryid,entryentity.occupiedqty as occupiedqty,entryentity.weight as weight,entryentity.groupno as groupno";
            Lists.partition(new ArrayList<Long>(bizRecordIds), (int)batchSize).forEach(list -> {
                ArrayList<OrmInput> billInputs = new ArrayList<OrmInput>(16);
                QFilter bizRecordIdsFilter = new QFilter("id", "in", list);
                OrmInput input = new OrmInput(CostAccountGroupRecordHelper.class.getName(), "cal_groupbillrecord", selectFields, new QFilter[]{bizRecordIdsFilter});
                billInputs.add(input);
                DataSet bizDataSet = Algo.create((String)CostAccountGroupRecordHelper.class.getName()).createDataSet(billInputs.toArray(new Input[billInputs.size()]));
                DataSet bizDataSetCopy = bizDataSet.copy();
                HashSet<Long> calEntryIdSet = new HashSet<Long>(50000);
                DataSet costRecordSet = null;
                HashSet<DataSet> costRecordDataSets = new HashSet<DataSet>(16);
                HashSet<Long> bizBillIdSet = new HashSet<Long>(16);
                QFilter recordFilter = new QFilter("issplitcreate", "=", (Object)false);
                recordFilter.and("billstatus", "=", (Object)"C");
                while (bizDataSetCopy.hasNext()) {
                    Row row = bizDataSetCopy.next();
                    if (calEntryIdSet.size() >= 50000) {
                        if (costRecordSet == null) {
                            costRecordSet = CostAccountGroupRecordHelper.getCostRecordDataSetNew(calEntryIdSet, recordFilter, bizBillIdSet);
                        } else {
                            costRecordDataSets.add(CostAccountGroupRecordHelper.getCostRecordDataSetNew(calEntryIdSet, recordFilter, bizBillIdSet));
                        }
                        calEntryIdSet = new HashSet(50000);
                        bizBillIdSet = new HashSet(16);
                    }
                    calEntryIdSet.add(row.getLong("calentryid"));
                    bizBillIdSet.add(row.getLong("bizbillid"));
                }
                if (!calEntryIdSet.isEmpty()) {
                    if (costRecordSet == null) {
                        costRecordSet = CostAccountGroupRecordHelper.getCostRecordDataSetNew(calEntryIdSet, recordFilter, bizBillIdSet);
                    } else {
                        costRecordDataSets.add(CostAccountGroupRecordHelper.getCostRecordDataSetNew(calEntryIdSet, recordFilter, bizBillIdSet));
                    }
                }
                if (costRecordSet != null) {
                    if (!costRecordDataSets.isEmpty()) {
                        costRecordSet = costRecordSet.union(costRecordDataSets.toArray(new DataSet[0]));
                    }
                    Set<Long> isReturnBillSetting = CostAccountGroupRecordHelper.getIsReturnBillGroupBillSetting();
                    DataSet accountGroupRecordSet = bizDataSet.join(costRecordSet, JoinType.INNER).on("calentryid", "calentryid").select(new String[]{"id", "groupsettingtype", "groupsetting", "costfields", "costcolumn", "iscompleted", "updatetime", "type", "calentryid", "weight", "occupiedqty", "groupno"}, new String[]{"costaccount", "booktype", "isingroup", "period", "entryid", "materialid", "accounttype"}).finish().orderBy(new String[]{"id", "booktype"});
                    HashMap<String, GroupRecord> recordMap = new HashMap<String, GroupRecord>();
                    HashMap<Long, Long> currentPeriodCache = new HashMap<Long, Long>();
                    while (accountGroupRecordSet.hasNext()) {
                        Row row = accountGroupRecordSet.next();
                        Long bizGroupId = row.getLong("id");
                        Long booktype = row.getLong("booktype");
                        Long materialid = row.getLong("materialid");
                        String key = bizGroupId + "&" + booktype;
                        GroupRecord record = (GroupRecord)recordMap.get(key);
                        if (record == null) {
                            record = new GroupRecord(bizGroupId, booktype, row.getString("groupsettingtype"), row.getLong("groupsetting"), row.getDate("updatetime"), row.getBoolean("iscompleted"), row.getBoolean("isingroup"), row.getString("costcolumn"), row.getString("costfields"));
                            recordMap.put(key, record);
                        }
                        Long costAccountId = row.getLong("costaccount");
                        Long period = row.getLong("period");
                        Long currentPeriod = (Long)currentPeriodCache.get(costAccountId);
                        if (currentPeriod == null) {
                            DynamicObject currentPeriodObj = PeriodHelper.getCurrentPeriod(costAccountId);
                            if (currentPeriodObj == null) {
                                currentPeriod = 0L;
                                currentPeriodCache.put(costAccountId, 0L);
                            } else {
                                currentPeriod = currentPeriodObj.getLong("id");
                                currentPeriodCache.put(costAccountId, currentPeriod);
                            }
                        }
                        Long calentryid = row.getLong("calentryid");
                        Long entryid = row.getLong("entryid");
                        String type = row.getString("type");
                        BigDecimal weight = row.getBigDecimal("weight");
                        BigDecimal occupiedqty = row.getBigDecimal("occupiedqty");
                        Long groupno = row.getLong("groupno");
                        String accounttype = row.getString("accounttype");
                        Long groupSettingId = row.getLong("groupsetting");
                        if ("0".equals(type)) {
                            record.addSrcEntry(costAccountId, calentryid, entryid, period, materialid, period.compareTo(currentPeriod) < 0, weight, occupiedqty, groupno);
                            continue;
                        }
                        if ("D".equals(accounttype) && isReturnBillSetting.contains(groupSettingId)) continue;
                        record.addTargetEntry(costAccountId, calentryid, entryid, period, materialid, period.compareTo(currentPeriod) < 0, weight, occupiedqty, groupno);
                    }
                    ArrayList<DynamicObject> recordObjList = new ArrayList<DynamicObject>(recordMap.size());
                    for (Object record : recordMap.values()) {
                        if (!((GroupRecord)record).isValid()) continue;
                        recordObjList.add(((GroupRecord)record).obj);
                    }
                    HashSet<Long> ids = new HashSet<Long>(batchSize);
                    for (Long id : list) {
                        ids.add(id);
                    }
                    if (isSort) {
                        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbizbillid", FilterType.in_range, bizBillIdSet)});){
                            ctx.set();
                            new AutoSortHelperNew().refreshSortResult(ids, recordObjList);
                        }
                    } else {
                        CostAccountGroupRecordHelper.saveCostGroupRecord(recordObjList);
                    }
                }
            });
        }
    }

    public static Set<Long> getIsReturnBillGroupBillSetting() {
        HashSet<Long> isReturnBillSettings = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostAccountGroupRecordHelper.class.getName(), (String)"cal_billgroupsetting", (String)"id,isreturnbill", null, null);){
            for (Row row : dataSet) {
                boolean isreturnbill = row.getBoolean("isreturnbill");
                if (!isreturnbill) continue;
                isReturnBillSettings.add(row.getLong("id"));
            }
        }
        return isReturnBillSettings;
    }

    private static DataSet getCostRecordDataSetNew(Set<Long> calEntryIdSet, QFilter recordFilter, Set<Long> bizBillIdSet) {
        log.info("getCostRecordDataSet->calEntryIdSet.size:" + calEntryIdSet.size());
        QFilter filter = new QFilter("entry.calentryid", "in", calEntryIdSet);
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbizbillid", FilterType.in_range, bizBillIdSet)});){
            ctx.set();
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostAccountGroupRecordHelper.class.getName(), (String)"cal_costrecord", (String)"costaccount,costaccount.booktype as booktype,costaccount.booktype.isingroup as isingroup,period,entry.id as entryid,entry.calentryid as calentryid,entry.material as materialid,entry.accounttype as accounttype", (QFilter[])new QFilter[]{recordFilter, filter}, null);
            return dataSet;
        }
    }

    private static int getDateDiffDay(Date minPeriodStartDate, Date nowDate) {
        return (int)((nowDate.getTime() - minPeriodStartDate.getTime()) / 86400000L);
    }

    private static class GroupRecord {
        private Set<Long> costaccountIds = new HashSet<Long>();
        private DynamicObject obj;
        private boolean isingroup;
        private Set<String> srcBill = new HashSet<String>(16);
        private Set<String> targetBill = new HashSet<String>(16);

        private GroupRecord(Long bizGroupId, Long booktypeid, String groupsettingtype, Long groupsetting, Date updatetime, boolean iscompleted, boolean isingroup, String costcolumn, String costfields) {
            this.obj = BusinessDataServiceHelper.newDynamicObject((String)"cal_account_grouprecord");
            this.obj.set("bizgrouprecordid", (Object)bizGroupId);
            this.obj.set("costaccounttype", (Object)booktypeid);
            this.obj.set("groupsettingtype", (Object)groupsettingtype);
            this.obj.set("groupsetting", (Object)groupsetting);
            this.obj.set("updatetime", (Object)updatetime);
            this.obj.set("iscompleted", (Object)iscompleted);
            this.obj.set("createtime", (Object)new Date());
            this.obj.set("costcolumn", (Object)costcolumn);
            this.obj.set("costfields", (Object)costfields);
            this.isingroup = isingroup;
        }

        private void addSrcEntry(long costaccountid, long calentryid, long entryid, long period, long materialid, boolean isbeforeperiod, BigDecimal weight, BigDecimal occupiedqty, Long groupno) {
            String key = entryid + "@" + groupno;
            if (this.srcBill.contains(key)) {
                return;
            }
            this.srcBill.add(key);
            this.costaccountIds.add(costaccountid);
            DynamicObject entry = this.createEntry(costaccountid, calentryid, entryid, period, materialid, isbeforeperiod, weight, occupiedqty, groupno);
            entry.set("type", (Object)"0");
        }

        private void addTargetEntry(long costaccountid, long calentryid, long entryid, long period, long materialid, boolean isbeforeperiod, BigDecimal weight, BigDecimal occupiedqty, Long groupno) {
            String key = entryid + "@" + groupno;
            if (this.targetBill.contains(key)) {
                return;
            }
            this.targetBill.add(key);
            this.costaccountIds.add(costaccountid);
            DynamicObject entry = this.createEntry(costaccountid, calentryid, entryid, period, materialid, isbeforeperiod, weight, occupiedqty, groupno);
            entry.set("type", (Object)"1");
        }

        private DynamicObject createEntry(long costaccountid, long calentryid, long entryid, long period, long materialId, boolean isbeforeperiod, BigDecimal weight, BigDecimal occupiedqty, Long groupno) {
            DynamicObject entry = this.obj.getDynamicObjectCollection("entryentity").addNew();
            entry.set("calentryid", (Object)calentryid);
            entry.set("costrecordentryid", (Object)entryid);
            entry.set("costaccount", (Object)costaccountid);
            entry.set("period", (Object)period);
            entry.set("isbeforeperiod", (Object)isbeforeperiod);
            entry.set("material", (Object)materialId);
            entry.set("weight", (Object)weight);
            entry.set("occupiedqty", (Object)occupiedqty);
            entry.set("groupno", (Object)groupno);
            return entry;
        }

        private boolean isValid() {
            if (this.srcBill.isEmpty() || this.targetBill.isEmpty()) {
                return false;
            }
            return this.isingroup || this.costaccountIds.size() <= 1;
        }
    }
}

