/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.CostPriceResultInfo;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CommonSettingHelper;
import kd.fi.calx.algox.helper.CostPriceSubelementHelper;
import kd.fi.calx.algox.helper.PeriodHelper;
import kd.fi.calx.algox.processor.IBizPlugin;
import kd.fi.calx.algox.util.DateUtils;

public class CostPrice4CalxHelper {
    private static Log log = LogFactory.getLog(CostPrice4CalxHelper.class);
    private static final long costPricePageId = 752057291171328000L;
    private static final long priceLibPageId = 747819409392815104L;
    private static final String splitRegExp = "[\\+\\-\\*\\/\\(\\)]";
    private Map<String, DynamicObject> priceSchemeMap = null;
    private Map<String, DynamicObject> priceLibMap = null;
    private Map<Long, String> srcVarsMap = new HashMap<Long, String>(16);
    private Map<Long, String> srcExpMap = new HashMap<Long, String>(16);
    private Map<String, DynamicObject> costPriceTypeMap = null;
    private Map<String, String> costPriceExtPluginMap = new HashMap<String, String>(16);
    private Map<String, QFilter> costPriceTypeBaseFilterMap = new HashMap<String, QFilter>(16);
    private Map<Long, DynamicObject> costAccountCurrentPeriodMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, DynamicObjectCollection> beforePeriodCols = new HashMap<Long, DynamicObjectCollection>(16);
    private Map<Long, Long> periodTypeMap = new HashMap<Long, Long>(16);
    private Map<String, CostPriceResultInfo> costPriceResultInfoMap = new HashMap<String, CostPriceResultInfo>(16);
    private StringBuilder cal_balance_ex = new StringBuilder();
    private StringBuilder cal_costrecord_ex = new StringBuilder();
    private StringBuilder cal_costadjustbill_ex = new StringBuilder();
    private Map<String, String> costRecordFieldMap = new HashMap<String, String>(16);
    protected boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private Set<Long> notEmptyCalRangeIds = new HashSet<Long>(16);
    private Map<Long, Set<Long>> currentSubElementsMap = new HashMap<Long, Set<Long>>();

    public CostPrice4CalxHelper() {
        this.costRecordFieldMap.put("calorg", "calorg");
        this.costRecordFieldMap.put("costaccount", "costaccount");
        this.costRecordFieldMap.put("material", "entry.material");
        this.costRecordFieldMap.put("owner", "entry.owner");
        this.costRecordFieldMap.put("storageorgunit", "storageorgunit");
        this.costRecordFieldMap.put("warehouse", "entry.warehouse");
        this.costRecordFieldMap.put("location", "entry.location");
        this.costRecordFieldMap.put("lot", "entry.lot");
        this.costRecordFieldMap.put("project", "entry.project");
        this.costRecordFieldMap.put("assist", "entry.assist");
        this.costRecordFieldMap.put("calrange", "entry.calrange");
        String dividebasisStr = CommonSettingHelper.getDivideBasisStr();
        String caldimensionStr = CommonSettingHelper.getCalDimensionStr();
        String[] calRealDims = (dividebasisStr + "," + caldimensionStr).split(",");
        MainEntityType costRecordDataEntity = EntityMetadataCache.getDataEntityType((String)"cal_costrecord_subentity");
        MainEntityType costAdjustDataEntity = EntityMetadataCache.getDataEntityType((String)"cal_costadjustbill");
        List<String> calDimList = Arrays.asList("calorg,costaccount,material,owner,storageorgunit,warehouse,location,lot,project,assist".split(","));
        for (String dim : calRealDims) {
            if (calDimList.contains(dim)) continue;
            this.cal_balance_ex.append(',');
            this.cal_balance_ex.append(dim);
            IDataEntityProperty costRecordEntity = costRecordDataEntity.findProperty(dim);
            if (costRecordEntity != null && costRecordEntity.getParent() instanceof EntryType) {
                String entryName = costRecordEntity.getParent().getName();
                this.cal_costrecord_ex.append(',');
                this.cal_costrecord_ex.append(entryName);
                this.cal_costrecord_ex.append('.');
                this.cal_costrecord_ex.append(dim);
                this.cal_costrecord_ex.append(" as ");
                this.cal_costrecord_ex.append(dim);
                this.costRecordFieldMap.put(dim, entryName + "." + dim);
            } else {
                this.cal_costrecord_ex.append(',');
                this.cal_costrecord_ex.append(dim);
                this.costRecordFieldMap.put(dim, dim);
            }
            IDataEntityProperty costAdjustEntity = costAdjustDataEntity.findProperty(dim);
            if (costAdjustEntity != null && costAdjustEntity.getParent() instanceof EntryType) {
                String entryName = costAdjustEntity.getParent().getName();
                this.cal_costadjustbill_ex.append(',');
                this.cal_costadjustbill_ex.append(entryName);
                this.cal_costadjustbill_ex.append('.');
                this.cal_costadjustbill_ex.append(dim);
                this.cal_costadjustbill_ex.append(" as ");
                this.cal_costadjustbill_ex.append(dim);
                continue;
            }
            this.cal_costadjustbill_ex.append(',');
            this.cal_costadjustbill_ex.append(dim);
        }
        this.costPriceTypeMap = new HashMap<String, DynamicObject>(16);
        QFilter costPriceFilter = new QFilter("id", "=", (Object)752057291171328000L);
        DynamicObjectCollection costPrices = QueryServiceHelper.query((String)"cal_costprice", (String)"entry.pricenum,entry.entityobject.number,entry.billfilter_tag,entry.priceplugin.plugin,entry.beforeperiod, entry.type", (QFilter[])costPriceFilter.toArray());
        for (DynamicObject dynamicObject : costPrices) {
            this.costPriceTypeMap.put(dynamicObject.getString("entry.pricenum"), dynamicObject);
            this.costPriceExtPluginMap.put(dynamicObject.getString("entry.pricenum"), dynamicObject.getString("entry.priceplugin.plugin"));
        }
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        Map calrangeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])filter.toArray());
        for (DynamicObject info : calrangeMap.values()) {
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
            if (entry == null || entry.size() <= 0) continue;
            this.notEmptyCalRangeIds.add(info.getLong("id"));
        }
        this.currentSubElementsMap = CostPriceSubelementHelper.getSubelementMapByScheme();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CostPriceResultInfo getPriceFromEntryId(String calEntity, Long id, Long entryId, String priceObject) {
        String errmsg = "";
        String costPriceSchemeNum = "";
        String costPriceSchemeName = "";
        CostPriceResultInfo resultInfo = null;
        String costPriceDimKey = "errMsg";
        if ("cal_costrecord".equals(calEntity)) {
            calEntity = "cal_costrecord_subentity";
        } else if ("cal_costadjustbill".equals(calEntity)) {
            calEntity = "cal_costadjust_subentity";
        }
        try (AlgoContext context = Algo.newContext();){
            DynamicObject matchSchemeInfo = this.getMatchPriceScheme(priceObject);
            costPriceSchemeNum = matchSchemeInfo.getString("number");
            costPriceSchemeName = matchSchemeInfo.getString("name");
            Long schemeId = matchSchemeInfo.getLong("id");
            DynamicObject destDynamicObject = QueryServiceHelper.queryOne((String)calEntity, (String)this.selectFields(calEntity + "_dest"), (QFilter[])this.getDestFilter(calEntity, id, entryId).toArray());
            List<String> dimensionList = this.getPriceDimensionList(matchSchemeInfo, destDynamicObject);
            costPriceDimKey = this.getCostPriceDimKey(matchSchemeInfo, dimensionList, destDynamicObject);
            resultInfo = this.costPriceResultInfoMap.get(costPriceDimKey);
            if (resultInfo != null) {
                log.info("\u5206\u5f55id" + entryId + "\u53d6\u4ef7\u7ed3\u679c\u4e3a" + resultInfo);
                CostPriceResultInfo costPriceResultInfo = resultInfo;
                return costPriceResultInfo;
            }
            DynamicObjectCollection entryentitys = matchSchemeInfo.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject : entryentitys) {
                String costPriceNum = dynamicObject.getString("costprice");
                String pluginName = this.costPriceExtPluginMap.get(costPriceNum);
                if (StringUtils.isEmpty((String)pluginName)) {
                    resultInfo = this.getCostPriceFormMatchSchemeEntry(dynamicObject, destDynamicObject, dimensionList, priceObject, schemeId);
                    if (resultInfo == null) continue;
                    resultInfo.setSrcSchemeNum(costPriceSchemeNum);
                    resultInfo.setSrcSchemeName(costPriceSchemeName);
                    this.processPriceResult(resultInfo);
                    this.costPriceResultInfoMap.put(costPriceDimKey, resultInfo);
                    log.info("\u5206\u5f55id" + entryId + "\u53d6\u4ef7\u7ed3\u679c\u4e3a" + resultInfo);
                    CostPriceResultInfo costPriceResultInfo = resultInfo;
                    return costPriceResultInfo;
                }
                IBizPlugin plugin = CostPrice4CalxHelper.getProcessByName(pluginName);
                HashMap<String, Object> tMap = new HashMap<String, Object>(4);
                HashSet<Long> entryids = new HashSet<Long>(16);
                entryids.add(entryId);
                tMap.put("entryIds", entryids);
                tMap.put("costRecordIds", new Long[]{id});
                Map entryid2PriceMap = (Map)plugin.doPlugin(tMap, null);
                log.info("\u53d6\u4ef7\u63d2\u4ef6\u5206\u5f55id\u4e3a" + entryId + "\u53d6\u503c\u7ed3\u679c\u4e3a" + entryid2PriceMap);
                Iterator iters = entryid2PriceMap.entrySet().iterator();
                if (!iters.hasNext()) continue;
                Map.Entry entryid2Price = iters.next();
                Long eid = (Long)entryid2Price.getKey();
                BigDecimal price = (BigDecimal)entryid2Price.getValue();
                CostPriceResultInfo costPriceResultInfo = new CostPriceResultInfo();
                costPriceResultInfo.setSrcSchemeNum(costPriceSchemeNum);
                costPriceResultInfo.setSrcSchemeName(costPriceSchemeName);
                costPriceResultInfo.setEntryId(eid);
                costPriceResultInfo.setSuccess(true);
                costPriceResultInfo.setDetail(true);
                costPriceResultInfo.putCostSubElementUnitcostMap(773175233367685120L, price);
                costPriceResultInfo.refreshTotalUnitCost();
                log.info("\u5206\u5f55id" + entryId + "\u53d6\u4ef7\u63d2\u4ef6\u53d6\u503c\u7ed3\u679c\u4e3a" + costPriceResultInfo);
                CostPriceResultInfo costPriceResultInfo2 = costPriceResultInfo;
                return costPriceResultInfo2;
            }
            errmsg = ResManager.loadKDString((String)"\u5728\u76f8\u5e94\u7684\u53d6\u4ef7\u914d\u7f6e\u4e0b\u672a\u627e\u5230\u6210\u672c\u4ef7\u4fe1\u606f\u3002", (String)"CostPriceHelper_4", (String)"fi-calx-algox", (Object[])new Object[0]);
        }
        catch (Exception e) {
            errmsg = e.getMessage();
            log.error("CostPrice4CalxHelper->getPriceFromEntryId error", (Throwable)e);
        }
        resultInfo = this.getErrCostReslutInfo(errmsg, costPriceSchemeNum, costPriceSchemeName);
        this.processPriceResult(resultInfo);
        this.costPriceResultInfoMap.put(costPriceDimKey, resultInfo);
        log.info("\u5206\u5f55id" + entryId + "\u53d6\u4ef7\u5931\u8d25" + resultInfo);
        return resultInfo;
    }

    public static IBizPlugin getProcessByName(String className) {
        try {
            Class<?> process = Class.forName(className);
            return (IBizPlugin)process.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private CostPriceResultInfo getErrCostReslutInfo(String errmsg, String costPriceSchemeNum, String costPriceSchemeName) {
        CostPriceResultInfo resultInfo = new CostPriceResultInfo();
        resultInfo.setSuccess(false);
        StringBuilder msg = new StringBuilder();
        msg.append(String.format(ResManager.loadKDString((String)"\u672a\u53d6\u5230\u4ef7\u683c,\u539f\u56e0\u4e3a\uff1a%1$s", (String)"CostPriceHelper_1", (String)"fi-calx-algox", (Object[])new Object[0]), errmsg));
        resultInfo.setSrcSchemeNum(costPriceSchemeNum);
        resultInfo.setSrcSchemeName(costPriceSchemeName);
        resultInfo.setErrMsg(msg.toString());
        return resultInfo;
    }

    private void processPriceResult(CostPriceResultInfo priceResult) {
        if (!priceResult.isSuccess() && StringUtils.isEmpty((String)priceResult.getSrcSchemeNum())) {
            return;
        }
        if (!priceResult.isSuccess()) {
            StringBuilder errorMsg = new StringBuilder();
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\u3010%1$s\u3011\u53d6\u4ef7\u5f02\u5e38\uff1a", (String)"AbstractAccountType_11", (String)"fi-calx-algox", (Object[])new Object[0]), priceResult.getSrcSchemeNum());
            errorMsg.append(msg);
            errorMsg.append(priceResult.getErrMsg());
            priceResult.setErrMsg(errorMsg.toString());
            return;
        }
        if (!priceResult.isDetail()) {
            StringBuilder errorMsg = new StringBuilder();
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\u201c%1$s\u201d\u4e2d\u201c%2$s\u201d\u7684\u5355\u4ef7\u7c7b\u522b\u4e0d\u662f\u53d6\u5b50\u8981\u7d20\u6210\u672c\u65e0\u6cd5\u7528\u4e8e\u51fa\u5e93\u6838\u7b97", (String)"AbstractAccountType_81", (String)"fi-calx-algox", (Object[])new Object[0]), priceResult.getSrcSchemeNum(), priceResult.getSrcPriceName());
            errorMsg.append(msg);
            priceResult.setSuccess(false);
            priceResult.setErrMsg(errorMsg.toString());
            return;
        }
    }

    private CostPriceResultInfo getCostPriceFormMatchSchemeEntry(DynamicObject schemeEntry, DynamicObject destDynamicObject, List<String> dimensionList, String priceObject, Long schemeId) {
        try (DataSet srcDataSet = null;){
            String priceType = this.getCostPriceType(schemeEntry);
            String srcExp = this.getSrcExp(schemeEntry);
            String srcVars = this.getSrcVars(schemeEntry, srcExp);
            srcDataSet = this.getSrcDataSet(schemeEntry, destDynamicObject, dimensionList, srcVars, priceObject, schemeId);
            if (srcDataSet == null) {
                CostPriceResultInfo costPriceResultInfo = null;
                return costPriceResultInfo;
            }
            CostPriceResultInfo resultInfo = this.getCostPriceFromSrcDataSet(srcDataSet, srcVars, srcExp, priceType);
            if (resultInfo != null && resultInfo.isSuccess()) {
                resultInfo.setSrcPriceName(schemeEntry.getString("pricedisplay"));
            }
            CostPriceResultInfo costPriceResultInfo = resultInfo;
            return costPriceResultInfo;
        }
    }

    private CostPriceResultInfo getCostPriceFromSrcDataSet(DataSet srcDataSet, String srcVars, String srcExp, String priceType) {
        DataSet ds = null;
        if ("A".equals(priceType)) {
            ds = srcDataSet.orderBy(new String[]{"bookdate desc", "auditdate desc"}).top(1).join(srcDataSet, JoinType.LEFT).on("entryid", "entryid").select(new String[]{"entryid", "billno"}, ("costsubelement," + srcVars).split(",")).finish();
        } else if ("B".equals(priceType)) {
            GroupbyDataSet groupbyDataSet = srcDataSet.groupBy(new String[]{"costsubelement", "billno"});
            for (String var : srcVars.split(",")) {
                groupbyDataSet = groupbyDataSet.sum(var);
            }
            ds = groupbyDataSet.finish();
        } else if ("C".equals(priceType)) {
            ds = srcDataSet;
        }
        if (ds == null) {
            return null;
        }
        boolean hasDivided = srcExp.contains("/");
        if (hasDivided) {
            String qtyField = srcExp.split("/")[1].trim();
            srcExp = "case when " + qtyField + " == 0 then 0 else " + srcExp + " end";
        }
        ds = ds.select("billno," + srcExp + " as price,costsubelement").filter("price <> 0");
        CostPriceResultInfo resultInfo = null;
        for (Row row : ds) {
            if (resultInfo == null) {
                resultInfo = new CostPriceResultInfo();
                resultInfo.setSuccess(true);
                resultInfo.setDetail(true);
                resultInfo.setSrcBillno(row.getString("billno"));
            }
            Long costSubElementId = row.getLong("costsubelement");
            BigDecimal costPrice = row.getBigDecimal("price");
            if (costPrice == null || costPrice.compareTo(BigDecimal.ZERO) == 0) continue;
            resultInfo.putCostSubElementUnitcostMap(costSubElementId, costPrice);
        }
        if (resultInfo != null) {
            resultInfo.refreshTotalUnitCost();
        }
        return resultInfo;
    }

    private String getCostPriceType(DynamicObject schemeEntry) {
        DynamicObject costPriceType = this.getCostPriceTypeMap().get(schemeEntry.get("costprice"));
        return costPriceType.getString("entry.type");
    }

    private DataSet getSrcDataSet(DynamicObject schemeEntry, DynamicObject destDynamicObject, List<String> dimensionList, String srcVars, String priceObject, Long schemeId) {
        String costPriceNum = schemeEntry.getString("costprice");
        String entityType = this.getEntityTypeNum(schemeEntry);
        Set<Long> costSubElementIdSet = this.currentSubElementsMap.get(schemeId);
        if ("cal_costrecord_subentity".equals(entityType)) {
            QFilter srcFilter = this.getQuerySrcCostRecordFilter(costPriceNum, destDynamicObject, dimensionList, priceObject);
            if (costSubElementIdSet != null && costSubElementIdSet.size() > 0) {
                srcFilter.and("entry.subentrycostelement.costsubelement", "in", costSubElementIdSet);
            }
            DynamicObject costPriceType = this.getCostPriceTypeMap().get(costPriceNum);
            int beforePeriod = costPriceType.getInt("entry.beforeperiod");
            String priceType = costPriceType.getString("entry.type");
            Long costAccountId = destDynamicObject.getLong("costaccount");
            Date bookdate = destDynamicObject.getDate("bookdate");
            Long bizbillid = destDynamicObject.getLong("bizbillid");
            List<QFilter> filters = this.getCostRecordBeforePeriodFilters(beforePeriod, priceType, costAccountId, srcFilter, bookdate, bizbillid);
            ArrayList<OrmInput> ormInputs = new ArrayList<OrmInput>(16);
            String selectFields = "entry.id as entryid,billno,bookdate,auditdate,bizbillid,entry.subentrycostelement.costsubelement as costsubelement,entry.subentrycostelement.sub_baseqty as baseqty,entry.subentrycostelement.sub_actualcost as actualcost,entry.subentrycostelement.sub_unitactualcost as unitactualcost";
            RowMeta rowMeta = ORM.create().createRowMeta(entityType, selectFields);
            for (QFilter filter : filters) {
                OrmInput input = new OrmInput(this.getClass().getName() + "-costrecord", entityType, selectFields, filter.toArray(), rowMeta);
                ormInputs.add(input);
            }
            if (!ormInputs.isEmpty()) {
                DataSet srcDataSet = Algo.create((String)this.getClass().getName()).createDataSet((Input[])ormInputs.toArray(new OrmInput[0]));
                srcDataSet = "A".equals(priceType) ? srcDataSet.where("actualcost <> null and actualcost <> 0 and bizbillid <> " + bizbillid) : srcDataSet.where("actualcost <> null and actualcost <> 0");
                return srcDataSet;
            }
        } else if ("cal_balance".equals(entityType) || "cal_bal".equals(entityType)) {
            if (this.isNewBalance) {
                Long costAccountId = destDynamicObject.getLong("costaccount");
                DynamicObject currentPeriod = this.getCostAccountCurrentPeriod(costAccountId);
                int period = -1;
                if (currentPeriod != null) {
                    period = currentPeriod.getInt("periodyear") * 100 + currentPeriod.getInt("periodnumber");
                }
                QFilter srcFilter = this.getQuerySrcBalanceFilter(costPriceNum, destDynamicObject, dimensionList, period);
                String selectFileds = "id as entryid,'' as billno,0 as bookdate, 0 as auditdate, costsubelement,case when period ==" + period + " then actualcost else actualcost_bal end as periodbeginactualcost, case when period ==" + period + " then baseqty else baseqty_bal end as periodbeginqty, case when period ==" + period + " then actualcost_in else 0 end as periodinactualcost, case when period ==" + period + " then baseqty_in else 0 end as periodinqty";
                String srcDataSetCacheId = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalUncompressService", (String)"getBalancDataSetDetail", (Object[])new Object[]{false, false, null, Collections.singletonList(srcFilter)});
                DataSet srcDataSet = Algo.getCacheDataSet((String)srcDataSetCacheId).toDataSet(Algo.create((String)this.getClass().getName()), true);
                if (costSubElementIdSet != null && costSubElementIdSet.size() > 0) {
                    srcDataSet = srcDataSet.where(new QFilter("costsubelement", "in", costSubElementIdSet).toString());
                }
                srcDataSet = srcDataSet.select(selectFileds);
                return srcDataSet;
            }
            Long costAccountId = destDynamicObject.getLong("costaccount");
            DynamicObject currentPeriod = this.getCostAccountCurrentPeriod(costAccountId);
            int period = -1;
            if (currentPeriod != null) {
                period = currentPeriod.getInt("periodyear") * 100 + currentPeriod.getInt("periodnumber");
            }
            QFilter srcFilter = this.getQuerySrcBalanceFilter(costPriceNum, destDynamicObject, dimensionList, period);
            DataSet srcDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-balance"), (String)entityType, (String)"id as  entryid,period", (QFilter[])srcFilter.toArray(), null);
            DataSet tempDataSet = srcDataSet.copy();
            HashSet<Long> balidSet = new HashSet<Long>(16);
            for (Row row : tempDataSet) {
                balidSet.add(row.getLong("entryid"));
            }
            if (balidSet.isEmpty()) {
                return null;
            }
            QFilter detailFilter = new QFilter("balid", "in", balidSet);
            if (costSubElementIdSet != null && costSubElementIdSet.size() > 0) {
                detailFilter.and("costsubelement", "in", costSubElementIdSet);
            }
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-balancebegindetail"), (String)"cal_balance_detail", (String)"balid,costsubelement,periodbeginactualcost,periodbeginqty,periodinactualcost,periodinqty,periodendactualcost,periodendqty", (QFilter[])detailFilter.toArray(), null);
            srcDataSet = srcDataSet.join(detailDataSet, JoinType.LEFT).on("entryid", "balid").select(new String[]{"entryid", "period"}, new String[]{"costsubelement", "periodbeginactualcost", "periodbeginqty", "periodinactualcost", "periodinqty", "periodendactualcost", "periodendqty"}).finish().select("entryid,'' as billno,0 as bookdate, 0 as auditdate, costsubelement,case when period ==" + period + " then periodbeginactualcost else periodendactualcost end as periodbeginactualcost, case when period ==" + period + " then periodbeginqty else periodendqty end as periodbeginqty, case when period ==" + period + " then periodinactualcost else 0 end as periodinactualcost, case when period ==" + period + " then periodinqty else 0 end as periodinqty").where("periodbeginactualcost <> 0 or periodbeginqty <> 0 or periodinqty <> 0 or periodinactualcost <> 0");
            return srcDataSet;
        }
        return null;
    }

    private List<QFilter> getCostRecordBeforePeriodFilters(int beforePeriod, String priceType, Long costAccountId, QFilter srcFilter, Date bookdate, Long bizbillid) {
        DynamicObjectCollection beforePeriods;
        DynamicObject currentPeriod = this.getCostAccountCurrentPeriod(costAccountId);
        QFilter qFilter = new QFilter("costaccount", "=", (Object)costAccountId);
        Date startDate = null;
        Date endDate = null;
        if (beforePeriod == 0) {
            if ("B".equals(priceType)) {
                startDate = currentPeriod.getDate("begindate");
                endDate = currentPeriod.getDate("enddate");
            } else {
                endDate = bookdate;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endDate);
                calendar.add(1, -1);
                startDate = calendar.getTime();
            }
        } else if (beforePeriod > 0 && (beforePeriods = this.getCurrentPeriodBeforePeriod(currentPeriod)).size() > 0) {
            endDate = ((DynamicObject)beforePeriods.get(0)).getDate("enddate");
            int size = beforePeriods.size();
            startDate = size >= beforePeriod ? ((DynamicObject)beforePeriods.get(beforePeriod - 1)).getDate("begindate") : ((DynamicObject)beforePeriods.get(size - 1)).getDate("begindate");
        }
        List<QFilter> costAccountBookdatefilters = DateUtils.getDateSplitFilters(startDate, endDate, "bookdate");
        for (QFilter costAccountBookdatefilter : costAccountBookdatefilters) {
            costAccountBookdatefilter.and(qFilter);
            costAccountBookdatefilter.and(srcFilter);
        }
        return costAccountBookdatefilters;
    }

    private QFilter getQuerySrcBalanceFilter(String costPriceNum, DynamicObject destDynamicObject, List<String> dimensionList, int period) {
        DynamicObject costPriceType = this.getCostPriceTypeMap().get(costPriceNum);
        String srcBillType = costPriceType.getString("entry.entityobject.number");
        Long costAccountId = destDynamicObject.getLong("costaccount");
        QFilter baseFilter = new QFilter("costaccount", "=", (Object)costAccountId);
        baseFilter.and("period", "<=", (Object)period);
        baseFilter.and("endperiod", ">", (Object)period);
        String billfilter = costPriceType.getString("entry.billfilter_tag");
        baseFilter.and(this.getBillFilter(srcBillType, billfilter, costPriceNum));
        for (String dim : dimensionList) {
            Object value = destDynamicObject.get(dim);
            if (value == null || (!(value instanceof Long) || (Long)value == 0L) && (!(value instanceof String) || !StringUtils.isNotEmpty((String)((String)value)))) continue;
            baseFilter.and(dim, "=", value);
        }
        return baseFilter;
    }

    private QFilter getQuerySrcCostRecordFilter(String costPriceNum, DynamicObject destDynamicObject, List<String> dimensionList, String priceObject) {
        DynamicObject costPriceType = this.getCostPriceTypeMap().get(costPriceNum);
        String srcBillType = costPriceType.getString("entry.entityobject.number");
        Long costAccountId = destDynamicObject.getLong("costaccount");
        Long entryId = destDynamicObject.getLong("entryid");
        Long id = destDynamicObject.getLong("id");
        String priceType = costPriceType.getString("entry.type");
        if ("C".equals(priceType)) {
            return new QFilter("entry.id", "=", (Object)entryId).and("id", "=", (Object)id).and("entry.unitactualcost", "!=", (Object)0);
        }
        String billfilter = costPriceType.getString("entry.billfilter_tag");
        QFilter baseFilter = this.getBillFilter(srcBillType, billfilter, costPriceNum);
        for (String dim : dimensionList) {
            Object value = destDynamicObject.get(dim);
            if (value == null || (!(value instanceof Long) || (Long)value == 0L) && (!(value instanceof String) || !StringUtils.isNotEmpty((String)((String)value)))) continue;
            baseFilter.and(this.costRecordFieldMap.get(dim), "=", value);
        }
        if ("D".equals(priceObject)) {
            baseFilter.and("id", "!=", (Object)destDynamicObject.getLong("id"));
        }
        baseFilter.and("entry.unitactualcost", "!=", (Object)0);
        baseFilter.and("costaccount", "=", (Object)costAccountId);
        baseFilter.and("billstatus", "=", (Object)"C");
        return baseFilter;
    }

    private String getSrcExp(DynamicObject schemeEntry) {
        long schemeEntryId = schemeEntry.getLong("id");
        String srcExp = this.srcExpMap.get(schemeEntryId);
        if (srcExp != null) {
            return srcExp;
        }
        String srcPrices = schemeEntry.getString("srcprice");
        if (StringUtils.isNotEmpty((String)srcPrices)) {
            String[] srcNumbers = srcPrices.split(",");
            DynamicObject price = this.getPriceLibMap().get(srcNumbers[0]);
            srcExp = price.getString("entry.priceexp_tag");
            this.srcExpMap.put(schemeEntryId, srcExp);
        }
        srcExp = srcExp == null ? "" : srcExp;
        return srcExp;
    }

    private String getSrcVars(DynamicObject schemeEntry, String srcExp) {
        long schemeEntryId = schemeEntry.getLong("id");
        String srcVars = this.srcVarsMap.get(schemeEntryId);
        if (srcVars != null) {
            return srcVars;
        }
        String[] vars = srcExp.split(splitRegExp);
        HashSet<String> varSet = new HashSet<String>(16);
        for (String string : vars) {
            if (!StringUtils.isNotEmpty((String)string)) continue;
            varSet.add(string.trim());
        }
        srcVars = String.join((CharSequence)",", varSet);
        this.srcVarsMap.put(schemeEntryId, srcVars);
        return srcVars;
    }

    private Map<String, DynamicObject> getPriceLibMap() {
        if (this.priceLibMap == null) {
            this.priceLibMap = new HashMap<String, DynamicObject>(32);
            QFilter priceLibFilter = new QFilter("id", "=", (Object)747819409392815104L);
            priceLibFilter.and("entry.isdetail", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection priceLibs = QueryServiceHelper.query((String)"cal_pricelib", (String)"entry.id,entry.pricenum,entry.pricename,entry.costsubelement,entry.priceexp_tag", (QFilter[])priceLibFilter.toArray());
            for (DynamicObject dynamicObject : priceLibs) {
                this.priceLibMap.put(dynamicObject.getString("entry.pricenum"), dynamicObject);
            }
        }
        return this.priceLibMap;
    }

    private String getEntityTypeNum(DynamicObject schemeEntry) {
        String costPriceNum = schemeEntry.getString("costprice");
        DynamicObject costPriceType = this.getCostPriceTypeMap().get(costPriceNum);
        String entityTypeNum = costPriceType.getString("entry.entityobject.number");
        if ("cal_costrecord".equals(entityTypeNum)) {
            entityTypeNum = "cal_costrecord_subentity";
        }
        return entityTypeNum;
    }

    private Map<String, DynamicObject> getCostPriceTypeMap() {
        return this.costPriceTypeMap;
    }

    private String getCostPriceDimKey(DynamicObject matchSchemeInfo, List<String> dimensionList, DynamicObject destDynamicObject) {
        StringBuilder dimKey = new StringBuilder();
        dimKey.append(matchSchemeInfo.getPkValue());
        dimKey.append("_");
        for (String string : dimensionList) {
            Object value = destDynamicObject.get(string);
            if (value != null) {
                dimKey.append(value);
            }
            dimKey.append("_");
        }
        return dimKey.toString();
    }

    private List<String> getPriceDimensionList(DynamicObject matchSchemeInfo, DynamicObject destDynamicObject) {
        String pricedimension = matchSchemeInfo.getString("pricedimension");
        String dividebasis = destDynamicObject.getString("dividebasis");
        String caldimension = destDynamicObject.getString("caldimension");
        Long calRangeid = destDynamicObject.getLong("calrange");
        ArrayList<String> dimensionList = new ArrayList<String>(16);
        dimensionList.add("costaccount");
        dimensionList.add("material");
        if (("B".equals(pricedimension) || "C".equals(pricedimension)) && StringUtils.isNotEmpty((String)dividebasis)) {
            if (this.notEmptyCalRangeIds.contains(calRangeid)) {
                dimensionList.add("calrange");
            } else {
                for (String div : dividebasis.split(",")) {
                    dimensionList.add(div);
                }
            }
        }
        if ("C".equals(pricedimension) && StringUtils.isNotEmpty((String)caldimension)) {
            for (String cal : caldimension.split(",")) {
                dimensionList.add(cal);
            }
        }
        return dimensionList;
    }

    private QFilter getDestFilter(String calEntity, Long id, Long entryId) {
        if ("cal_costrecord_subentity".equals(calEntity)) {
            return new QFilter("entry.id", "=", (Object)entryId).and("id", "=", (Object)id);
        }
        return new QFilter("entryentity.id", "=", (Object)entryId).and("id", "=", (Object)id);
    }

    private DynamicObject getMatchPriceScheme(String priceObject) {
        DynamicObject matchSchemeInfo;
        if (this.priceSchemeMap == null) {
            DynamicObject[] matchSchemeInfos;
            this.priceSchemeMap = new HashMap<String, DynamicObject>(16);
            QFilter q = new QFilter("entityobject", "=", (Object)"cal_out_calculate");
            q.and("enable", "=", (Object)"1");
            for (DynamicObject dynamicObject : matchSchemeInfos = BusinessDataServiceHelper.load((String)"cal_pricescheme", (String)"id,number,priceobject,entityobject,pricedimension,entry.costprice,entry.pricedisplay,entry.srcprice,entry.destprice", (QFilter[])q.toArray())) {
                this.priceSchemeMap.put(dynamicObject.getString("priceobject"), dynamicObject);
            }
        }
        if ((matchSchemeInfo = this.priceSchemeMap.get(priceObject)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\u3002", (String)"CostPriceHelper_2", (String)"fi-calx-algox", (Object[])new Object[0]));
        }
        return matchSchemeInfo;
    }

    private QFilter getBillFilter(String billType, String billfilter, String costPriceNum) {
        QFilter baseFilter = this.costPriceTypeBaseFilterMap.get(costPriceNum);
        if (baseFilter != null) {
            return baseFilter;
        }
        baseFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((String)billfilter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billfilter, FilterCondition.class);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billType);
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
            filterBuilder.buildFilter();
            List qFilters = filterBuilder.getQFilters();
            for (QFilter qFilter : qFilters) {
                baseFilter.and(qFilter);
            }
        }
        return baseFilter;
    }

    private DynamicObjectCollection getCurrentPeriodBeforePeriod(DynamicObject currentPeriod) {
        Long currentPeriodId = currentPeriod.getLong("id");
        DynamicObjectCollection cols = this.beforePeriodCols.get(currentPeriodId);
        if (cols != null) {
            return cols;
        }
        QFilter filterType = new QFilter("periodtype", "=", this.getPeriodType(currentPeriodId));
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currentPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", "<", (Object)currentPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", "<", (Object)currentPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)false);
        cols = QueryServiceHelper.query((String)"bd_period", (String)"id,begindate,enddate", (QFilter[])new QFilter[]{filterType, pfilter, q}, (String)"periodyear desc, periodnumber desc");
        this.beforePeriodCols.put(currentPeriodId, cols);
        return cols;
    }

    private Object getPeriodType(Long currentPeriodId) {
        DynamicObject period;
        Long periodType = this.periodTypeMap.get(currentPeriodId);
        if (periodType == null && (period = QueryServiceHelper.queryOne((String)"bd_period", (String)"periodtype", (QFilter[])new QFilter("id", "=", (Object)currentPeriodId).toArray())) != null) {
            periodType = period.getLong("periodtype");
            this.periodTypeMap.put(currentPeriodId, periodType);
        }
        return periodType;
    }

    private DynamicObject getCostAccountCurrentPeriod(long costAccountId) {
        DynamicObject currentPeriod = this.costAccountCurrentPeriodMap.get(costAccountId);
        if (currentPeriod == null) {
            currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
        }
        return currentPeriod;
    }

    private String selectFields(String s) {
        String resultStr = "";
        switch (s) {
            case "cal_costrecord_subentity_dest": {
                resultStr = "id,bookdate,bizbillid,entry.id as entryid,calorg,costaccount,entry.material as material,entry.calrange as calrange,entry.owner as owner, storageorgunit as storageorgunit, entry.warehouse as warehouse, entry.location as location, entry.lot as lot, entry.project as project, entry.assist as assist,costaccount.dividebasis.dividebasis as dividebasis,entry.caldimension.caldimension as caldimension" + this.cal_costrecord_ex.toString();
                break;
            }
            case "cal_costadjust_subentity_dest": {
                resultStr = "id,bookdate,0 as bizbillid,entryentity.id as entryid,calorg,costaccount,entryentity.material as material,entryentity.calrange as calrange,entryentity.owner as owner, entryentity.storageorgunit as storageorgunit, entryentity.warehouse as warehouse, entryentity.location as location, entryentity.lot as lot, entryentity.project as project, entryentity.assist as assist,costaccount.dividebasis.dividebasis as dividebasis,entryentity.caldimension.caldimension as caldimension" + this.cal_costadjustbill_ex.toString();
                break;
            }
        }
        return resultStr;
    }
}

