/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.calx.algox.CalOutDataRangeHolder;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;

public class CustomEventCallHelper {
    private static final String calDeliveryAccountingCode = "cal_delivery_accounting_notice";
    private static final Log logger = LogFactory.getLog(CustomEventCallHelper.class);

    public static void calDeliveryAccEventCall(CalOutDataRangeHolder holder, boolean isDetail, Set<Long> recordIds) {
        logger.info("\u51fa\u5e93\u6838\u7b97\u6210\u672c\u66f4\u65b0\u901a\u77e5\u4e8b\u4ef6\u8fdb\u5165");
        if (!CustomEventCallHelper.getEvenIsActive(calDeliveryAccountingCode)) {
            logger.info("\u51fa\u5e93\u6838\u7b97\u6210\u672c\u66f4\u65b0\u901a\u77e5\uff0c\u5f53\u524d\u4e8b\u4ef6\u5df2\u7981\u7528\u6216\u65e0\u6d3b\u8dc3\u7684\u8ba2\u9605\u4e8b\u4ef6\u3002");
            return;
        }
        try {
            if (!isDetail) {
                logger.info("\u51fa\u5e93\u6838\u7b97\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u8fbe\u5230\u9600\u503c\uff0c\u6309\u6838\u7b97\u7ec4\u7ec7\u7ef4\u5ea6\u53d1\u9001\u6d88\u606f");
                HashMap<Long, CalOutDataRangeHolder.CalOutRange> map = new HashMap<Long, CalOutDataRangeHolder.CalOutRange>(16);
                for (CalOutDataRangeHolder.CalOutRange calOutRange : holder.getCalOutRangeList()) {
                    map.putIfAbsent(calOutRange.getCostAccountId(), calOutRange);
                }
                Set idSet = map.keySet();
                QFilter filter = new QFilter("id", "in", idSet);
                filter.and("ismainaccount", "=", (Object)true);
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter[]{filter});
                Set ids = dynamicObjects.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
                ArrayList param = new ArrayList();
                for (CalOutDataRangeHolder.CalOutRange calOutRange : map.values()) {
                    if (!ids.contains(calOutRange.getCostAccountId())) continue;
                    HashMap<String, Object> valueMap = new HashMap<String, Object>(3);
                    valueMap.put("org", calOutRange.getCalOrgId());
                    valueMap.put("account", calOutRange.getCostAccountId());
                    valueMap.put("startDate", calOutRange.getStartDate());
                    valueMap.put("endDate", calOutRange.getEndDate());
                    valueMap.put("entityNumber", "cal_costrecord");
                    valueMap.put("materialId", Sets.newHashSet());
                    valueMap.put("bizObject", Sets.newHashSet());
                    valueMap.put("bizBillId", Sets.newHashSet());
                    valueMap.put("bizBillEntryId", Sets.newHashSet());
                    param.add(valueMap);
                }
                for (Map map2 : param) {
                    EventServiceHelper.triggerEventSubscribe((String)calDeliveryAccountingCode, (String)JSONUtils.toString((Object)map2));
                }
            } else {
                QFilter filter = new QFilter("id", "in", recordIds);
                filter.and("billtype.billformid", "=", (Object)"im_saloutbill");
                filter.and("costaccount.ismainaccount", "=", (Object)true);
                logger.info("\u51fa\u5e93\u6838\u7b97\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u672a\u8fbe\u5230\u9600\u503c\uff0c\u6309\u660e\u7ec6\u7ef4\u5ea6\u53d1\u9001\u6d88\u606f\uff0c\u6210\u672c\u8bb0\u5f55\u6761\u6570==>{}", (Object)recordIds.size());
                Map<String, Map<String, Object>> recodedList = CustomEventCallHelper.getRecodedList(filter);
                if (recodedList.isEmpty()) {
                    logger.info("\u51fa\u5e93\u6838\u7b97\u6210\u672c\u901a\u77e5\u67e5\u8be2\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u8fc7\u6ee4\u6761\u4ef6==>{}", (Object)filter);
                } else {
                    for (Map.Entry<String, Map<String, Object>> recodeEntry : recodedList.entrySet()) {
                        String key = recodeEntry.getKey();
                        Map<String, Object> valueParam = recodeEntry.getValue();
                        logger.info("\u51fa\u5e93\u6838\u7b97\u6210\u672c\u901a\u77e5\u6839\u636e\u6838\u7b97\u7ec4\u7ec7+\u8d26\u8584\u4f20\u9012\u53c2\u6570\uff0c\u53c2\u6570key==>{}", (Object)key);
                        EventServiceHelper.triggerEventSubscribe((String)calDeliveryAccountingCode, (String)JSONUtils.toString(valueParam));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.info("\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u8c03\u7528\u5931\u8d25,\u4e8b\u4ef6\u7f16\u7801==>{},\u5931\u8d25\u4fe1\u606f==>{}", (Object)calDeliveryAccountingCode, (Object)e);
        }
    }

    private static Map<String, Map<String, Object>> getRecodedList(QFilter filter) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_costrecord", (String)"calorg,costaccount,period.begindate as begindate,period.enddate as enddate,billtype.billformid as billtype,bizbillid,entry.material as material,entry.bizbillentryid as bizbillentryid", (QFilter[])new QFilter[]{filter});
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(16);
        HashMap<String, List> dynamicMap = new HashMap<String, List>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String key = dynamicObject.getString("calorg") + "@" + dynamicObject.getString("costaccount");
            dynamicMap.computeIfAbsent(key, s -> new ArrayList()).add(dynamicObject);
        }
        Integer patchSize = CalDbParamServiceHelper.getInteger(CalDbParamConstant.COST_UPDATE_NOTICE_BATCHSIZE);
        for (Map.Entry entry : dynamicMap.entrySet()) {
            List value = (List)entry.getValue();
            List patchList = Lists.partition((List)value, (int)patchSize);
            for (int i = 0; i < patchList.size(); ++i) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                List list = (List)patchList.get(i);
                DynamicObject dynamicObject = (DynamicObject)list.get(0);
                param.put("org", dynamicObject.getLong("calorg"));
                param.put("account", dynamicObject.getLong("costaccount"));
                param.put("startDate", dynamicObject.getDate("begindate"));
                param.put("endDate", dynamicObject.getDate("enddate"));
                param.put("entityNumber", "cal_costrecord");
                HashSet materialIds = new HashSet(list.size());
                HashSet<String> bizObject = new HashSet<String>(list.size());
                HashSet<Long> bizBillId = new HashSet<Long>(list.size());
                HashSet<Long> bizBillEntryId = new HashSet<Long>(list.size());
                for (DynamicObject object : list) {
                    bizObject.add(object.getString("billtype"));
                    bizBillId.add(object.getLong("bizbillid"));
                    bizBillEntryId.add(object.getLong("bizbillentryid"));
                }
                param.put("materialId", materialIds);
                param.put("bizObject", bizObject);
                param.put("bizBillId", bizBillId);
                param.put("bizBillEntryId", bizBillEntryId);
                resultMap.put((String)entry.getKey() + "@" + i, param);
            }
        }
        return resultMap;
    }

    private static boolean getEvenIsActive(String eventCode) {
        QFilter filter = new QFilter("numberview", "=", (Object)eventCode);
        filter.and("status", "=", (Object)true);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"evt_event", (String)"id", (QFilter[])new QFilter[]{filter});
        if (dynamicObject == null) {
            return false;
        }
        QFilter subFilter = new QFilter("event", "=", (Object)dynamicObject.getLong("id"));
        subFilter.and("status", "=", (Object)true);
        return QueryServiceHelper.exists((String)"evt_subscription", (QFilter[])new QFilter[]{subFilter});
    }
}

