/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.balance.BizDataType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.balance.BalanceServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.CostAdjustDetailParams;
import kd.fi.calx.algox.helper.AddDomainKeyFunction;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CommonSettingHelper;
import kd.fi.calx.algox.helper.PeriodHelper;
import kd.fi.calx.algox.util.CommonUtils;

public class FIFOPeriodDataCalculate {
    private long costAccountId;
    private long curPeriodId;
    private long prePeriodId;
    private int periodNum;
    private String dimFields;
    private Set<Long> materialSet;
    private Long calRangeId;
    private Set<DynamicObject> insertBalSet = new HashSet<DynamicObject>();
    private String totalKey;
    private boolean isStartPeriod;
    private long calOrgId;
    private boolean isRealTimeBal;
    private Date beginDate;
    private static final String[] PREVCOST_ADJUSTBILL_CREATETYPE = new String[]{"B", "U", "I", "J", "D", "B-A1"};
    private Set<Long> emptyRangeIds;

    public FIFOPeriodDataCalculate(long costAccountId, Long calRangeId, Set<Long> materialSet) {
        this.costAccountId = costAccountId;
        this.materialSet = materialSet;
        this.calRangeId = calRangeId;
        this.initBalanceDimFields();
        DynamicObject calSetInfo = QueryServiceHelper.queryOne((String)"cal_setting", (String)"dividebasiscols,caldimensioncols", (QFilter[])new QFilter("id", "=", (Object)683799445774680063L).toArray());
        String divideStr = calSetInfo.getString("dividebasiscols");
        String caldimensionStr = calSetInfo.getString("caldimensioncols");
        this.totalKey = CommonUtils.trimComma(divideStr) + "," + CommonUtils.trimComma(caldimensionStr);
        DynamicObject curPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
        if (curPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u6ca1\u6709\u8bbe\u7f6e\u5f53\u524d\u671f\u95f4\uff0c\u53ef\u80fd\u8fd8\u672a\u542f\u7528", (String)"CostRecordBuilder_4", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        DynamicObject startPeriod = PeriodHelper.getStartPeriod(costAccountId);
        this.curPeriodId = curPeriod.getLong("id");
        this.isStartPeriod = this.curPeriodId == startPeriod.getLong("id");
        this.periodNum = curPeriod.getInt("periodyear") * 100 + curPeriod.getInt("periodnumber");
        if (!this.isStartPeriod) {
            DynamicObject prePeriod = PeriodHelper.getPreviousPeriod(this.curPeriodId);
            this.prePeriodId = prePeriod.getLong("id");
        }
        this.calOrgId = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter("id", "=", (Object)costAccountId).toArray()).getLong("calorg");
        this.beginDate = curPeriod.getDate("begindate");
        this.emptyRangeIds = this.getEmptyEntryRangeIds();
    }

    private Set<Long> getEmptyEntryRangeIds() {
        QFilter filter = new QFilter("costaccount", "=", (Object)this.costAccountId);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        HashSet<Long> emptyEntryRangeIds = new HashSet<Long>(16);
        Map calRangeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])filter.toArray());
        for (DynamicObject rangDyc : calRangeMap.values()) {
            DynamicObjectCollection entryDycs = rangDyc.getDynamicObjectCollection("entry");
            if (!entryDycs.isEmpty()) continue;
            emptyEntryRangeIds.add(rangDyc.getLong("id"));
        }
        if (emptyEntryRangeIds.isEmpty()) {
            emptyEntryRangeIds.add(-1L);
        }
        return emptyEntryRangeIds;
    }

    public void calculate() {
        this.isRealTimeBal = true;
        try (DataSet balDataSet = this.getBalDataSet();
             DataSet billDataSet = this.getBillDataSet();){
            DataSet newBalDataSet = balDataSet.map((MapFunction)new AddDomainKeyFunction(this.emptyRangeIds, balDataSet.getRowMeta(), null, null, null, null, "domainkeyfield"));
            newBalDataSet = newBalDataSet.groupBy(new String[]{"domainkeyfield", "costelement", "costsubelement"}).sum("balqty").sum("balcost").finish();
            DataSet newbillDataSet = billDataSet.map((MapFunction)new AddDomainKeyFunction(this.emptyRangeIds, billDataSet.getRowMeta(), null, null, null, null, "domainkeyfield"));
            JoinDataSet joinDataSet = newBalDataSet.join(newbillDataSet);
            joinDataSet = joinDataSet.on("domainkeyfield", "domainkeyfield");
            joinDataSet = joinDataSet.on("costelement", "costelement");
            joinDataSet = joinDataSet.on("costsubelement", "costsubelement");
            DataSet finalDataSet = joinDataSet.select(new String[]{"domainkeyfield", "balqty", "balcost"}, new String[]{"id as billid", "detailid", "entityobject", "calbilltype", "bizdate", "billno", "auditdate", "entryseq", "costelement", "costsubelement", "entryid", "billqty", "billcost", "billunitcost", "priceprecision", "amtprecision", "qtyprecision"}).finish().orderBy(new String[]{"domainkeyfield", "costelement", "costsubelement", "bizdate desc", "auditdate desc", "billno desc", "entryseq desc"});
            HashMap map = new HashMap(512);
            for (Row row : finalDataSet) {
                BalInfo balInfo = new BalInfo();
                String key = row.getString("domainkeyfield") + row.getLong("costelement") + row.getLong("costsubelement");
                balInfo.setBalId(key);
                balInfo.setQty(row.getBigDecimal("balqty"));
                balInfo.setCost(row.getBigDecimal("balcost"));
                BigDecimal bigDecimal = row.getBigDecimal("balqty");
                ArrayList<BillInfo> list = (ArrayList<BillInfo>)map.get(balInfo);
                if (list == null) {
                    list = new ArrayList<BillInfo>(64);
                    map.put(balInfo, list);
                }
                String entityObject = row.getString("entityobject");
                String calbillType = row.getString("calbilltype");
                BigDecimal billQty = row.getBigDecimal("billqty");
                String billType = "";
                if ("calinitbill".equals(entityObject) || "IN".equals(calbillType) && billQty.signum() > 0 || "OUT".equals(calbillType) && billQty.signum() < 0) {
                    billType = "IN";
                }
                if ("OUT".equals(calbillType) && billQty.signum() > 0 || "IN".equals(calbillType) && billQty.signum() < 0) {
                    billType = "OUT";
                }
                if ((bigDecimal.signum() < 0 || !"IN".equals(billType)) && (bigDecimal.signum() >= 0 || !"OUT".equals(billType))) continue;
                BillInfo billInfo = new BillInfo();
                list.add(billInfo);
                billInfo.setDetailId(row.getLong("detailid"));
                billInfo.setBillId(row.getLong("billid"));
                billInfo.setQty(billQty);
                billInfo.setCost(row.getBigDecimal("billcost"));
                billInfo.setPrice(row.getBigDecimal("billunitcost"));
                billInfo.setAmtPrecision(row.getInteger("amtprecision"));
                billInfo.setPricePrecision(row.getInteger("priceprecision"));
                billInfo.setQtyPrecision(row.getInteger("qtyprecision"));
            }
            HashSet<Long> detailIdSet = new HashSet<Long>(map.size());
            HashSet<Long> billIdSet = new HashSet<Long>(map.size());
            HashMap<Long, BigDecimal[]> costMap = new HashMap<Long, BigDecimal[]>(map.size());
            block19: for (Map.Entry entry : map.entrySet()) {
                BalInfo balInfo = (BalInfo)entry.getKey();
                List list = (List)entry.getValue();
                if (list == null || list.isEmpty()) continue;
                BigDecimal balQty = balInfo.getQty().abs();
                BigDecimal balCost = balInfo.getCost();
                BigDecimal sumQty = BigDecimal.ZERO;
                BigDecimal sumCost = BigDecimal.ZERO;
                for (BillInfo billInfo : list) {
                    detailIdSet.add(billInfo.getDetailId());
                    billIdSet.add(billInfo.getBillId());
                    costMap.put(billInfo.getDetailId(), new BigDecimal[]{billInfo.getQty().abs().multiply(new BigDecimal(balInfo.getQty().signum())), billInfo.getCost().abs().multiply(new BigDecimal(balInfo.getQty().signum())), billInfo.getPrice()});
                    BigDecimal billQty = billInfo.getQty().abs();
                    BigDecimal billCost = billInfo.getCost().abs().multiply(new BigDecimal(balInfo.getQty().signum()));
                    int pricePrecision = billInfo.getPricePrecision();
                    sumQty = sumQty.add(billQty);
                    if (sumQty.compareTo(balQty) >= 0) {
                        BigDecimal newBillQty = balQty.subtract(sumQty.subtract(billQty)).multiply(new BigDecimal(balInfo.getQty().signum()));
                        BigDecimal newBillCost = balCost.subtract(sumCost);
                        BigDecimal newBillPrice = newBillQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : newBillCost.divide(newBillQty, pricePrecision, 4);
                        costMap.put(billInfo.getDetailId(), new BigDecimal[]{newBillQty, newBillCost, newBillPrice});
                        continue block19;
                    }
                    sumCost = sumCost.add(billCost);
                }
            }
            DataSet costRecordDataSet = this.getUnionDataSet(detailIdSet.toArray(new Long[0]), billIdSet, null);
            this.insertFIFOBalance(costRecordDataSet, costMap);
        }
    }

    public void calFIFOPeriodBal() {
        QFilter q = new QFilter("costaccount", "=", (Object)this.costAccountId);
        q.and("period", "=", (Object)this.curPeriodId);
        q.and("beginqty", "=", (Object)BigDecimal.ZERO);
        q.and("begincost", "=", (Object)BigDecimal.ZERO);
        if (!this.materialSet.isEmpty()) {
            q.and("material", "in", this.materialSet);
        }
        if (this.calRangeId != null && this.calRangeId != 0L) {
            q.and("calrange", "=", (Object)this.calRangeId);
        }
        DeleteServiceHelper.delete((String)"cal_balance_fifo_period", (QFilter[])q.toArray());
        this.delCurPeriodRelation();
    }

    public void handlePreCostAdjustBills() {
        this.delPreCostAdjustBills();
        DataSet inAdjustBills = this.getInAllAdjustSet();
        HashSet<Long> childRecordEntryIds = new HashSet<Long>(16);
        HashSet<Long> inCostAdjustIds = new HashSet<Long>(16);
        for (Row row : inAdjustBills.copy()) {
            childRecordEntryIds.add(row.getLong("invbillentryid"));
            inCostAdjustIds.add(row.getLong("id"));
        }
        HashSet<Long> motherRecordEntryIds = new HashSet<Long>(childRecordEntryIds.size());
        HashMap<Long, Long> childMotherRecordMap = new HashMap<Long, Long>(childRecordEntryIds.size());
        DataSet childRecordDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"entry.id,entry.ancestorentryid", (QFilter[])new QFilter("entry.id", "in", childRecordEntryIds).toArray(), null);
        for (Row row : childRecordDataSet) {
            motherRecordEntryIds.add(row.getLong("entry.ancestorentryid"));
            childMotherRecordMap.put(row.getLong("entry.id"), row.getLong("entry.ancestorentryid"));
        }
        Map inCostAdjustMap = BusinessDataServiceHelper.loadFromCache((Object[])inCostAdjustIds.toArray(), (String)"cal_costadjust_subentity");
        QFilter q = new QFilter("inbillentryid", "in", motherRecordEntryIds);
        DataSet relationDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_inoutrelation", (String)"inbillid,inbillentryid,inbillnunber,inqty,sumoutqty,entry.outbillid as outbillid,entry.outbillentryid as outbillentryid,entry.outqty as outqty,entry.outbillnumber as outbillnumber", (QFilter[])q.toArray(), null);
        HashMap<Long, RelationInfo> relationMap = new HashMap<Long, RelationInfo>(16);
        for (Object row : relationDataSet) {
            Long inEntryId = row.getLong("inbillentryid");
            RelationInfo relationInfo = (RelationInfo)relationMap.get(inEntryId);
            if (relationInfo == null) {
                relationInfo = new RelationInfo();
                row.getString("inbillnunber");
                row.getLong("inbillid");
                relationInfo.allQty = row.getBigDecimal("inqty");
                relationMap.put(inEntryId, relationInfo);
            }
            if (row.getLong("outbillentryid") == null || row.getLong("outbillentryid") == 0L) continue;
            RelationEntry relationEntry = new RelationEntry();
            relationEntry.billNumber = row.getString("outbillnumber");
            relationEntry.billId = row.getLong("outbillid");
            relationEntry.billEntryId = row.getLong("outbillentryid");
            relationEntry.qty = row.getBigDecimal("outqty");
            relationInfo.addEntry(relationEntry);
        }
        HashSet<DynamicObject> preCostAdjustBills = new HashSet<DynamicObject>(16);
        for (Object row : inAdjustBills) {
            Long inChildEntryId = row.getLong("invbillentryid");
            Long inEntryId = (Long)childMotherRecordMap.get(inChildEntryId);
            RelationInfo relationInfo = (RelationInfo)relationMap.get(inEntryId);
            if (relationInfo == null || relationInfo.entrys.isEmpty()) continue;
            Long costAdjustId = row.getLong("id");
            DynamicObject inCostAdjustInfo = (DynamicObject)inCostAdjustMap.get(costAdjustId);
            int amtPrecision = row.getInteger("amtprecision");
            DynamicObjectCollection costAdjustEntrys = inCostAdjustInfo.getDynamicObjectCollection("entryentity");
            DynamicObject inCostAdjustEntry = null;
            for (DynamicObject entry : costAdjustEntrys) {
                if (inChildEntryId.compareTo(entry.getLong("invbillentryid")) != 0) continue;
                inCostAdjustEntry = entry;
                break;
            }
            if (inCostAdjustEntry == null) continue;
            BigDecimal sumCost = BigDecimal.ZERO;
            BigDecimal inAdjustCost = inCostAdjustEntry.getBigDecimal("adjustamt");
            int i = 0;
            for (RelationEntry relationEntry : relationInfo.entrys) {
                BigDecimal diffCost;
                DynamicObject preCostAdjustInfo = this.createCostAdjustHead(inCostAdjustInfo);
                DynamicObject preCostAdjustEntry = this.addCostAdjustBillEntry(relationInfo, relationEntry, amtPrecision, inCostAdjustInfo, inCostAdjustEntry, preCostAdjustInfo);
                sumCost = sumCost.add(preCostAdjustEntry.getBigDecimal("adjustamt"));
                if (i == relationInfo.entrys.size() - 1 && relationInfo.isAllOut() && (diffCost = inAdjustCost.subtract(sumCost)).compareTo(BigDecimal.ZERO) != 0) {
                    preCostAdjustEntry.set("adjustamt", (Object)preCostAdjustEntry.getBigDecimal("adjustamt").add(diffCost));
                }
                if (preCostAdjustEntry.getBigDecimal("adjustamt").compareTo(BigDecimal.ZERO) != 0) {
                    preCostAdjustBills.add(preCostAdjustInfo);
                }
                ++i;
            }
        }
        if (!preCostAdjustBills.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])preCostAdjustBills.toArray(new DynamicObject[0]));
            HashSet<Long> outAdjustIdset = new HashSet<Long>(preCostAdjustBills.size());
            for (DynamicObject info : preCostAdjustBills) {
                outAdjustIdset.add(info.getLong("id"));
            }
            DynamicObject[] outCostAdjusts = BusinessDataServiceHelper.load((Object[])outAdjustIdset.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
            Map<Long, DynamicObject> inAdjEntryInfoMap = this.getInAdjEntryInfoMap(inCostAdjustMap.values().toArray(new DynamicObject[0]));
            List<CostAdjustDetailParams> paramsList = this.buildCostAdjustDetail(outCostAdjusts, inAdjEntryInfoMap);
            OperateOption option = OperateOption.create();
            String params = SerializationUtils.toJsonString(paramsList);
            option.setVariableValue("CostAdjustDetailParms", params);
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("ignoreValidation", "true");
            OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])outCostAdjusts, (OperateOption)option);
            if (!result.isSuccess()) {
                StringBuilder msg = new StringBuilder();
                msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff1a", (String)"GPAPrevCostAdjustHelper_1", (String)"fi-calx-algox", (Object[])new Object[0]));
                String errorMsg = result.getMessage();
                if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                    msg.append(errorMsg).append('\n');
                }
                List errors = result.getAllErrorOrValidateInfo();
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
                throw new KDBizException(msg.toString());
            }
        }
    }

    private Map<Long, DynamicObject> getInAdjEntryInfoMap(DynamicObject[] inCostAdjusts) {
        HashMap<Long, DynamicObject> entryInfosMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject inCostAdjust : inCostAdjusts) {
            DynamicObjectCollection entrys = inCostAdjust.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                entryInfosMap.put(entry.getLong("id"), entry);
            }
        }
        return entryInfosMap;
    }

    private List<CostAdjustDetailParams> buildCostAdjustDetail(DynamicObject[] outCostAdjusts, Map<Long, DynamicObject> inAdjEntryInfoMap) {
        ArrayList<CostAdjustDetailParams> paramsList = new ArrayList<CostAdjustDetailParams>();
        for (DynamicObject outDynamic : outCostAdjusts) {
            DynamicObjectCollection outcostadjustEntry = outDynamic.getDynamicObjectCollection("entryentity");
            block1: for (DynamicObject outentry : outcostadjustEntry) {
                long entryId = outentry.getLong("id");
                Long srcBillEntryId = outentry.getLong("srcbillentryid");
                if (!inAdjEntryInfoMap.containsKey(srcBillEntryId)) continue;
                DynamicObjectCollection inEntryDetails = inAdjEntryInfoMap.get(srcBillEntryId).getDynamicObjectCollection("subentryentity");
                for (DynamicObject detail : inEntryDetails) {
                    BigDecimal subAdjustamt = detail.getBigDecimal("sub_adjustamt");
                    if (subAdjustamt == null || subAdjustamt.compareTo(BigDecimal.ZERO) == 0) continue;
                    CostAdjustDetailParams param = new CostAdjustDetailParams();
                    param.setAdjustAmt(outentry.getBigDecimal("adjustamt"));
                    param.setEntryid(entryId);
                    param.setCostElementId(detail.getLong("costelement.id"));
                    param.setCostSubElementId(detail.getLong("costsubelement.id"));
                    paramsList.add(param);
                    continue block1;
                }
            }
        }
        return paramsList;
    }

    private DynamicObject addCostAdjustBillEntry(RelationInfo relationInfo, RelationEntry relationEntry, int amtPrecision, DynamicObject inCostAdjustInfo, DynamicObject inCostAdjustEntry, DynamicObject preCostAdjustBillInfo) {
        DynamicObject entry = preCostAdjustBillInfo.getDynamicObjectCollection("entryentity").addNew();
        entry.set("storageorgunit", inCostAdjustEntry.get("storageorgunit"));
        entry.set("material", inCostAdjustEntry.get("material"));
        entry.set("mversion", inCostAdjustEntry.get("mversion"));
        entry.set("assist", inCostAdjustEntry.get("assist"));
        entry.set("lot", inCostAdjustEntry.get("lot"));
        entry.set("baseunit", inCostAdjustEntry.get("baseunit"));
        BigDecimal inAdjustAmt = inCostAdjustEntry.getBigDecimal("adjustamt");
        BigDecimal allQty = relationInfo.allQty;
        BigDecimal outQty = relationEntry.qty;
        BigDecimal outAdjustAmt = inAdjustAmt.multiply(outQty).divide(allQty, amtPrecision, 4);
        entry.set("adjustamt", (Object)outAdjustAmt);
        entry.set("warehouse", inCostAdjustEntry.get("warehouse"));
        entry.set("location", inCostAdjustEntry.get("location"));
        entry.set("ownertype", (Object)"bos_org");
        entry.set("owner", inCostAdjustEntry.get("owner"));
        entry.set("ecostcenter", inCostAdjustEntry.get("ecostcenter"));
        entry.set("project", inCostAdjustEntry.get("project"));
        preCostAdjustBillInfo.set("biztype", (Object)"B");
        entry.set("invbizdate", inCostAdjustEntry.get("invbizdate"));
        entry.set("invauditdate", inCostAdjustEntry.get("invauditdate"));
        entry.set("invbizentityobject", (Object)"cal_costrecord");
        entry.set("invbillid", (Object)relationEntry.billId);
        entry.set("invbillentryid", (Object)relationEntry.billEntryId);
        entry.set("invbillnum", (Object)relationEntry.billNumber);
        entry.set("srcbilltype", (Object)986031578352241664L);
        entry.set("srcbizentityobject", (Object)"cal_costadjust_subentity");
        entry.set("srcbillnum", inCostAdjustInfo.get("billno"));
        entry.set("srcentryseq", inCostAdjustEntry.get("seq"));
        entry.set("srcbillid", inCostAdjustInfo.get("id"));
        entry.set("srcbillentryid", inCostAdjustEntry.get("id"));
        entry.set("invtype", inCostAdjustEntry.get("invtype"));
        entry.set("invstatus", inCostAdjustEntry.get("invstatus"));
        entry.set("calrange", inCostAdjustEntry.get("calrange"));
        entry.set("caldimension", inCostAdjustEntry.get("caldimension"));
        entry.set("accounttype", inCostAdjustEntry.get("accounttype"));
        Set<String> exFieldSet = CommonSettingHelper.getExFieldSet();
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        CommonSettingHelper.setExFieldValue(exFieldSet, costAdjustEntityType, costAdjustEntityType, entry, inCostAdjustEntry);
        return entry;
    }

    private DynamicObject createCostAdjustHead(DynamicObject costAdjustInfo) {
        DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjust_subentity");
        costAdjustBill.set("calorg", (Object)costAdjustInfo.getDynamicObject("calorg"));
        costAdjustBill.set("costaccount", (Object)costAdjustInfo.getDynamicObject("costaccount"));
        String number = this.createBillNo(costAdjustBill, String.valueOf(costAdjustInfo.getDynamicObject("calorg").getPkValue()));
        costAdjustBill.set("billno", (Object)number);
        costAdjustBill.set("billstatus", (Object)"B");
        costAdjustBill.set("biztype", (Object)"B");
        costAdjustBill.set("billtype", (Object)costAdjustInfo.getDynamicObject("billtype"));
        costAdjustBill.set("currency", costAdjustInfo.get("currency"));
        costAdjustBill.set("period", costAdjustInfo.get("period"));
        costAdjustBill.set("createtype", (Object)"V");
        costAdjustBill.set("difftype", (Object)"B");
        costAdjustBill.set("adminorg", (Object)costAdjustInfo.getDynamicObject("adminorg"));
        costAdjustBill.set("bizdate", (Object)costAdjustInfo.getDate("bizdate"));
        costAdjustBill.set("bookdate", (Object)costAdjustInfo.getDate("bookdate"));
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date date = TimeServiceHelper.now();
        costAdjustBill.set("creator", (Object)userId);
        costAdjustBill.set("createtime", (Object)date);
        costAdjustBill.set("modifier", (Object)userId);
        costAdjustBill.set("modifytime", (Object)date);
        costAdjustBill.set("auditor", (Object)userId);
        costAdjustBill.set("auditdate", (Object)date);
        costAdjustBill.set("cstype", (Object)"bd_customer");
        return costAdjustBill;
    }

    private String createBillNo(DynamicObject bill, String orgId) {
        String billNo = CodeRuleServiceHelper.getNumber(null, (DynamicObject)bill, (String)orgId);
        if (StringUtils.isEmpty((CharSequence)billNo) || "".equals(billNo.trim())) {
            billNo = String.valueOf(System.currentTimeMillis());
        }
        return billNo;
    }

    private DataSet getInAllAdjustSet() {
        QFilter filter = new QFilter("createtype", "in", (Object)PREVCOST_ADJUSTBILL_CREATETYPE);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("costaccount", "=", (Object)this.costAccountId);
        filter.and("entryentity.invbizdate", "<", (Object)this.beginDate);
        filter.and("period", "=", (Object)this.curPeriodId);
        filter.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.FIN_FOUT_PERIOD.getValue());
        if (this.calRangeId != null && this.calRangeId != 0L) {
            filter.and("entryentity.calrange", "=", (Object)this.calRangeId);
        }
        if (!this.materialSet.isEmpty()) {
            filter.and("entryentity.material", "in", this.materialSet);
        }
        DataSet inAllAdjustSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_subentity", (String)"id,currency.amtprecision as amtprecision,entryentity.id as entryid,entryentity.invbillentryid as invbillentryid", (QFilter[])filter.toArray(), null);
        return inAllAdjustSet;
    }

    private void delPreCostAdjustBills() {
        QFilter filter = new QFilter("createtype", "=", (Object)"V");
        filter.and("billstatus", "=", (Object)"C");
        filter.and("costaccount", "=", (Object)this.costAccountId);
        filter.and("period", "=", (Object)this.curPeriodId);
        filter.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.FIN_FOUT_PERIOD.getValue());
        if (this.calRangeId != null && this.calRangeId != 0L) {
            filter.and("entryentity.calrange", "=", (Object)this.calRangeId);
        }
        if (!this.materialSet.isEmpty()) {
            filter.and("entryentity.material", "in", this.materialSet);
        }
        HashSet<Long> outAdjustIds = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_subentity", (String)"id", (QFilter[])filter.toArray(), null);){
            for (Row row : dataSet) {
                outAdjustIds.add(row.getLong("id"));
            }
        }
        if (outAdjustIds.isEmpty()) {
            return;
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("unwriteoff", "true");
        op.setVariableValue("ishasright", "true");
        op.setVariableValue("ignoreValidation", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costadjust_subentity", (Object[])outAdjustIds.toArray(), (OperateOption)op);
        if (!result.isSuccess()) {
            List errors = result.getAllErrorOrValidateInfo();
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff1a", (String)"GPAPrevCostAdjustHelper_0", (String)"fi-calx-algox", (Object[])new Object[0]));
            String errorMsg = result.getMessage();
            if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                msg.append(errorMsg).append('\n');
            }
            if (!errors.isEmpty()) {
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
                throw new KDBizException(msg.toString());
            }
        } else {
            DeleteServiceHelper.delete((String)"cal_costadjust_subentity", (QFilter[])new QFilter[]{new QFilter("id", "in", outAdjustIds)});
        }
    }

    private void delCurPeriodRelation() {
        QFilter q = new QFilter("costaccount", "=", (Object)this.costAccountId);
        if (!this.materialSet.isEmpty()) {
            q.and("material", "in", this.materialSet);
        }
        QFilter q1 = new QFilter("inbilldate", ">=", (Object)this.beginDate);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_inoutrelation", (String)"id", (QFilter[])new QFilter[]{q, q1}, null);){
            HashSet<Long> relationIds = new HashSet<Long>(16);
            for (Row row : dataSet) {
                relationIds.add(row.getLong("id"));
            }
            if (!relationIds.isEmpty()) {
                Lists.partition(new ArrayList(relationIds), (int)1000).forEach(list -> DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"cal_inoutrelation"), (Object[])list.toArray()));
            }
        }
        QFilter q2 = new QFilter("entry.outbilldate", ">=", (Object)this.beginDate);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_inoutrelation", (String)"entry.id", (QFilter[])new QFilter[]{q, q2}, null);){
            HashSet<Long> relationEntryIds = new HashSet<Long>(16);
            for (Row row : dataSet) {
                relationEntryIds.add(row.getLong("entry.id"));
            }
            if (!relationEntryIds.isEmpty()) {
                Lists.partition(new ArrayList(relationEntryIds), (int)1000).forEach(list -> {
                    String delEntrySql = "delete from t_cal_inoutrelationentry where fentryid in (" + StringUtils.join((Object[])list.toArray(), (char)',') + ")";
                    DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)delEntrySql);
                });
            }
        }
    }

    private void insertFIFOBalance(DataSet billDataSet, Map<Long, BigDecimal[]> costMap) {
        Object row2;
        HashSet<Long> calRangeSet = new HashSet<Long>(16);
        for (Object row2 : billDataSet.copy()) {
            long calRangeId = row2.getLong("calRange");
            if (calRangeId == 0L) continue;
            calRangeSet.add(calRangeId);
        }
        DataSet calRangeDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_calrange", (String)"id,entry.id", (QFilter[])new QFilter("id", "in", calRangeSet).toArray(), null);
        row2 = null;
        try {
            calRangeSet.clear();
            for (Row row3 : calRangeDataSet) {
                if (row3.getLong("entry.id") == 0L) continue;
                calRangeSet.add(row3.getLong("id"));
            }
        }
        catch (Throwable throwable) {
            row2 = throwable;
            throw throwable;
        }
        finally {
            if (calRangeDataSet != null) {
                if (row2 != null) {
                    try {
                        calRangeDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)row2).addSuppressed(throwable);
                    }
                } else {
                    calRangeDataSet.close();
                }
            }
        }
        if (!calRangeSet.isEmpty()) {
            DataSet divideDataSet;
            calRangeDataSet = billDataSet.copy().filter(new QFilter("calrange", "in", calRangeSet).toString());
            if (!calRangeDataSet.isEmpty()) {
                this.handleCalRangeDataSet(calRangeDataSet, costMap);
            }
            if (!(divideDataSet = billDataSet.copy().filter(new QFilter("calrange", "not in", calRangeSet).toString())).isEmpty()) {
                this.handleDivideDataSet(divideDataSet, costMap);
            }
        } else {
            this.handleDivideDataSet(billDataSet.copy(), costMap);
        }
        QFilter q = new QFilter("costaccount", "=", (Object)this.costAccountId);
        if (!this.materialSet.isEmpty()) {
            q.and("material", "in", this.materialSet);
        }
        if (this.calRangeId != null && this.calRangeId != 0L) {
            q.and("calrange", "=", (Object)this.calRangeId);
        }
        String entityName = "cal_balance_fifo_period";
        if (this.isRealTimeBal) {
            entityName = "cal_balance_fifo";
        }
        DeleteServiceHelper.delete((String)entityName, (QFilter[])q.toArray());
        if (!this.insertBalSet.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.insertBalSet.toArray(new DynamicObject[0]));
        }
    }

    private void handleCalRangeDataSet(DataSet finalDataSet, Map<Long, BigDecimal[]> costMap) {
        for (Row row : finalDataSet) {
            long caldimensionid = row.getLong("caldimension");
            String caldimension = row.getString("caldimensionstr");
            String calKey = "";
            calKey = caldimensionid != 0L ? "calrange," + CommonUtils.trimComma(caldimension) : "calrange";
            calKey = calKey + ",costelement,costsubelement";
            String[] onFields = calKey.split(",");
            this.insertBalSet(onFields, row, costMap);
        }
    }

    private void handleDivideDataSet(DataSet finalDataSet, Map<Long, BigDecimal[]> costMap) {
        for (Row row : finalDataSet) {
            long caldimensionid = row.getLong("caldimension");
            String dividebasis = row.getString("dividebasisstr");
            String caldimension = row.getString("caldimensionstr");
            String calKey = "";
            calKey = caldimensionid != 0L ? CommonUtils.trimComma(dividebasis) + "," + CommonUtils.trimComma(caldimension) : CommonUtils.trimComma(dividebasis);
            calKey = calKey + ",costelement,costsubelement";
            String[] onFields = calKey.split(",");
            this.insertBalSet(onFields, row, costMap);
        }
    }

    private DataSet getBalDataSet() {
        QFilter q = new QFilter("costaccount", "=", (Object)this.costAccountId);
        q.and("period", "<", (Object)this.periodNum);
        q.and("endperiod", ">=", (Object)this.periodNum);
        if (!this.materialSet.isEmpty()) {
            q.and("material", "in", this.materialSet);
        }
        if (this.calRangeId != null && this.calRangeId != 0L) {
            q.and("calrange", "=", (Object)this.calRangeId);
        }
        if (CalBalanceModelHelper.isNewBalance()) {
            String selectFileds = this.getBalSelects(false) + ",id as detailbalid,costelement,costsubelement,baseqty_bal as balqty,actualcost_bal as balcost";
            Boolean balCompress = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
            if (balCompress.booleanValue()) {
                HashSet<String> otherDims = new HashSet<String>(16);
                otherDims.add("id");
                otherDims.add("costelement");
                otherDims.add("costsubelement");
                otherDims.add("caldimension.caldimension");
                otherDims.add("costaccount.dividebasis.dividebasis");
                String cacheId = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalUncompressService", (String)"getBalancDataSetDetail", (Object[])new Object[]{false, false, otherDims, Collections.singletonList(q)});
                DataSet data = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)this.getClass().getName()), true);
                data = data.select(selectFileds);
                return data;
            }
            return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bal", (String)selectFileds, (QFilter[])q.toArray(), null);
        }
        DataSet balDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance", (String)this.getBalSelects(false), (QFilter[])q.toArray(), null);
        HashSet<Long> balIdSet = new HashSet<Long>();
        for (Row row : balDataSet.copy()) {
            balIdSet.add(row.getLong("id"));
        }
        DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_detail", (String)"id,balid,costelement,costsubelement,periodendqty as balqty,periodendactualcost as balcost", (QFilter[])new QFilter("balid", "in", balIdSet).toArray(), null);
        return balDataSet.join(detailDataSet, JoinType.LEFT).on("id", "balid").select(this.getBalSelects(true).split(","), new String[]{"id as detailbalid", "costelement", "costsubelement", "balqty", "balcost"}).finish();
    }

    private void insertBalSet(String[] onFields, Row row, Map<Long, BigDecimal[]> costMap) {
        BigDecimal[] costs;
        String entityName = "cal_balance_fifo_period";
        if (this.isRealTimeBal) {
            entityName = "cal_balance_fifo";
        }
        DynamicObject balInfo = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        long detailId = row.getLong("detailid");
        balInfo.set("costaccount", (Object)this.costAccountId);
        balInfo.set("calorg", (Object)this.calOrgId);
        balInfo.set("currency", row.get("currency"));
        balInfo.set("baseunit", row.get("baseunit"));
        balInfo.set("material", row.get("material"));
        balInfo.set("auditdate", row.get("auditdate"));
        balInfo.set("billno", row.get("billno"));
        balInfo.set("billentryid", row.get("eid"));
        balInfo.set("bizdate", row.get("bizdate"));
        balInfo.set("calrange", row.get("calrange"));
        if (!this.isRealTimeBal) {
            balInfo.set("period", (Object)this.curPeriodId);
        }
        BigDecimal[] bigDecimalArray = costs = costMap == null ? null : costMap.get(detailId);
        if (costs != null) {
            balInfo.set("endqty", (Object)costs[0]);
            balInfo.set("endcost", (Object)costs[1]);
            balInfo.set("endunitcost", (Object)costs[2]);
        } else {
            balInfo.set("endqty", row.get("billqty"));
            balInfo.set("endcost", row.get("billcost"));
            balInfo.set("endunitcost", row.get("unitactualcost"));
        }
        balInfo.set("entryseq", row.get("entryseq"));
        for (String field : onFields) {
            balInfo.set(field, row.get(field));
        }
        this.insertBalSet.add(balInfo);
    }

    private String getBalSelects(boolean isAlias) {
        if (isAlias) {
            return this.dimFields + ",id,calorg,calrange,caldimensionstr,dividebasisstr";
        }
        return this.dimFields + ",id,calorg,calrange,caldimension.caldimension as caldimensionstr,costaccount.dividebasis.dividebasis as dividebasisstr";
    }

    private DataSet getBillDataSet() {
        DataSet dataSet = null;
        if (this.isStartPeriod) {
            QFilter q = new QFilter("costaccount", "=", (Object)this.costAccountId);
            q.and("period", "=", (Object)this.curPeriodId);
            if (!this.materialSet.isEmpty()) {
                q.and("entryentity.material", "in", this.materialSet);
            }
            if (this.calRangeId != null && this.calRangeId != 0L) {
                q.and("entryentity.calrange", "=", (Object)this.calRangeId);
            }
            q.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.FIFO.getValue());
            q.and("billstatus", "=", (Object)"C");
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_initbill", (String)this.getInitBillSelects(), (QFilter[])q.toArray(), null);
        } else {
            QFilter q = new QFilter("costaccount", "=", (Object)this.costAccountId);
            q.and("period", "<=", (Object)this.prePeriodId);
            if (!this.materialSet.isEmpty()) {
                q.and("entryentity.material", "in", this.materialSet);
            }
            if (this.calRangeId != null && this.calRangeId != 0L) {
                q.and("entryentity.calrange", "=", (Object)this.calRangeId);
            }
            q.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.FIFO.getValue());
            q.and("billstatus", "=", (Object)"C");
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_initbill", (String)this.getInitBillSelects(), (QFilter[])q.toArray(), null);
            q = new QFilter("costaccount", "=", (Object)this.costAccountId);
            q.and("period", "<=", (Object)this.prePeriodId);
            Date[] periodDates = PeriodHelper.getPeriodStartAndEndTime(this.prePeriodId);
            if (periodDates != null && periodDates.length > 1) {
                q.and("bookdate", "<=", (Object)periodDates[1]);
            }
            if (!this.materialSet.isEmpty()) {
                q.and("entry.material", "in", this.materialSet);
            }
            if (this.calRangeId != null && this.calRangeId != 0L) {
                q.and("entry.calrange", "=", (Object)this.calRangeId);
            }
            q.and("entry.accounttype", "=", (Object)AccountTypeEnum.FIFO.getValue());
            q.and("isinitbill", "=", (Object)Boolean.FALSE);
            q.and("issplitcreate", "=", (Object)Boolean.FALSE);
            q.and("billstatus", "=", (Object)"C");
            DataSet costRecordDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)this.getBillSelects(), (QFilter[])q.toArray(), null);
            HashSet<Long> bizBillIds = new HashSet<Long>(16);
            HashSet<Long> ancestorEntryids = new HashSet<Long>(16);
            for (Row row : costRecordDS.copy()) {
                ancestorEntryids.add(row.getLong("entryid"));
                bizBillIds.add(row.getLong("bizbillid"));
            }
            q = new QFilter("costaccount", "=", (Object)this.costAccountId);
            q.and("period", "<=", (Object)this.prePeriodId);
            if (periodDates != null && periodDates.length > 1) {
                q.and("bookdate", "<=", (Object)periodDates[1]);
            }
            q.and("issplitcreate", "=", (Object)Boolean.TRUE);
            q.and("entry.ancestorentryid", "in", ancestorEntryids);
            q.and("bizbillid", "in", bizBillIds);
            DataSet childCostRecordDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)"entry.ancestorentryid,entry.id", (QFilter[])q.toArray(), null);
            HashMap<Long, Long> childMotherRecordMap = new HashMap<Long, Long>(16);
            for (Row row : childCostRecordDS) {
                childMotherRecordMap.put(row.getLong("entry.id"), row.getLong("entry.ancestorentryid"));
            }
            q = new QFilter("costaccount", "=", (Object)this.costAccountId);
            q.and("period", "<=", (Object)this.prePeriodId);
            if (periodDates != null && periodDates.length > 1) {
                q.and("bookdate", "<=", (Object)periodDates[1]);
            }
            HashSet<Object> allIdSet = new HashSet<Object>(16);
            allIdSet.addAll(childMotherRecordMap.keySet());
            allIdSet.addAll(ancestorEntryids);
            q.and("entryentity.invbillentryid", "in", allIdSet);
            HashMap<Long, HashMap<Long, BigDecimal>> adjustAmtMap = new HashMap<Long, HashMap<Long, BigDecimal>>(16);
            DataSet costAdjustDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_subentity", (String)"entryentity.invbillentryid,entryentity.subentryentity.costsubelement,entryentity.subentryentity.sub_adjustamt", (QFilter[])q.toArray(), null);
            for (Row row : costAdjustDS) {
                HashMap<Long, BigDecimal> subelementAmtMap = (HashMap<Long, BigDecimal>)adjustAmtMap.get(row.getLong("entryentity.invbillentryid"));
                if (subelementAmtMap == null) {
                    subelementAmtMap = new HashMap<Long, BigDecimal>(16);
                    adjustAmtMap.put(row.getLong("entryentity.invbillentryid"), subelementAmtMap);
                }
                subelementAmtMap.put(row.getLong("entryentity.subentryentity.costsubelement"), row.getBigDecimal("entryentity.subentryentity.sub_adjustamt"));
            }
            HashMap<String, BigDecimal> motherRecord_adjustAmtMap = new HashMap<String, BigDecimal>(16);
            for (Map.Entry e : childMotherRecordMap.entrySet()) {
                long childEntryId = (Long)e.getKey();
                long ancestorEntryId = (Long)e.getValue();
                Map subelementAmtMap = (Map)adjustAmtMap.get(childEntryId);
                if (subelementAmtMap == null) continue;
                for (Map.Entry e1 : subelementAmtMap.entrySet()) {
                    long subElementId = (Long)e1.getKey();
                    BigDecimal adjustAmt = (BigDecimal)e1.getValue();
                    BigDecimal totalAmt = (BigDecimal)motherRecord_adjustAmtMap.get(ancestorEntryId + "|" + subElementId);
                    if (totalAmt == null) {
                        totalAmt = BigDecimal.ZERO;
                    }
                    totalAmt = totalAmt.add(adjustAmt);
                    motherRecord_adjustAmtMap.put(ancestorEntryId + "|" + subElementId, totalAmt);
                }
            }
            for (Long entryid : ancestorEntryids) {
                Map subelementAmtMap = (Map)adjustAmtMap.get(entryid);
                if (subelementAmtMap == null) continue;
                for (Map.Entry e1 : subelementAmtMap.entrySet()) {
                    long subElementId = (Long)e1.getKey();
                    BigDecimal adjustAmt = (BigDecimal)e1.getValue();
                    BigDecimal totalAmt = (BigDecimal)motherRecord_adjustAmtMap.get(entryid + "|" + subElementId);
                    if (totalAmt == null) {
                        totalAmt = BigDecimal.ZERO;
                    }
                    totalAmt = totalAmt.add(adjustAmt);
                    motherRecord_adjustAmtMap.put(entryid + "|" + subElementId, totalAmt);
                }
            }
            costRecordDS = costRecordDS.map((MapFunction)new AddAdjustAmtFunction(costRecordDS.getRowMeta(), motherRecord_adjustAmtMap));
            dataSet = dataSet.union(costRecordDS);
        }
        return dataSet;
    }

    private String getBillSelects() {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity");
        String entryName = "entry";
        for (String field : fields = this.dimFields.split(",")) {
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        selects.append("id,bizbillid,entry.subentrycostelement.costelement as costelement,entry.subentrycostelement.costsubelement as costsubelement,calbilltype,");
        selects.append("entry.baseqty as billqty,entry.subentrycostelement.sub_actualcost as billcost,entry.subentrycostelement.sub_unitactualcost as billunitcost,entry.subentrycostelement.id as detailid,entry.id as entryid,");
        selects.append("10 as priceprecision,localcurrency.amtprecision as amtprecision,entry.baseunit.precision as qtyprecision,");
        selects.append("bizdate,billno,auditdate,entry.seq as entryseq,'costrecord' as entityobject");
        selects.append(",calorg,entry.calrange as calrange,entry.caldimension.caldimension as caldimensionstr,costaccount.dividebasis.dividebasis as dividebasisstr");
        return selects.toString();
    }

    private String getInitBillSelects() {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_initbill");
        String entryName = "entryentity";
        for (String field : fields = this.dimFields.split(",")) {
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        selects.append("id,0L as bizbillid,entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,'IN' as calbilltype,");
        selects.append("entryentity.baseqty as billqty,entryentity.subentryentity.sub_amount as billcost,entryentity.subentryentity.sub_price as billunitcost,entryentity.subentryentity.id as detailid,entryentity.id as entryid,");
        selects.append("10 as priceprecision,localcurrency.amtprecision as amtprecision,entryentity.baseunit.precision as qtyprecision,");
        selects.append("bizdate,billno,auditdate,entryentity.seq as entryseq,'calinitbill' as entityobject");
        selects.append(",calorg,entryentity.calrange as calrange,entryentity.caldimension.caldimension as caldimensionstr,costaccount.dividebasis.dividebasis as dividebasisstr");
        return selects.toString();
    }

    private void initBalanceDimFields() {
        HashSet<BizDataType> bizDataTypeSet = new HashSet<BizDataType>(16);
        bizDataTypeSet.add(BizDataType.MAIN);
        bizDataTypeSet.add(BizDataType.DIM);
        ArrayList<String> dimFieldList = new ArrayList<String>(32);
        String balanceEntity = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balancemodel";
        Map fieldMap = BalanceServiceHelper.loadBizData((String)balanceEntity, bizDataTypeSet);
        if (fieldMap.get(BizDataType.MAIN) != null) {
            dimFieldList.addAll((Collection)fieldMap.get(BizDataType.MAIN));
        }
        if (fieldMap.get(BizDataType.DIM) != null) {
            dimFieldList.addAll((Collection)fieldMap.get(BizDataType.DIM));
        }
        if (dimFieldList.isEmpty()) {
            dimFieldList.add("costaccount");
            dimFieldList.add("storageorgunit");
            dimFieldList.add("ownertype");
            dimFieldList.add("owner");
            dimFieldList.add("material");
            dimFieldList.add("assist");
            dimFieldList.add("lot");
            dimFieldList.add("warehouse");
            dimFieldList.add("location");
            dimFieldList.add("invtype");
            dimFieldList.add("invstatus");
            dimFieldList.add("project");
            dimFieldList.add("mversion");
        }
        StringBuilder sb = new StringBuilder();
        for (String field : dimFieldList) {
            if ("costelement".equals(field) || "costsubelement".equals(field)) continue;
            sb.append(field).append(",");
        }
        this.dimFields = sb.substring(0, sb.length() - 1);
    }

    private DataSet getUnionDataSet(Long[] billDetailIds, Set<Long> billIds, String entityName) {
        QFilter q = new QFilter("entry.subentrycostelement.id", "in", (Object)billDetailIds);
        q.and("id", "in", billIds);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)this.getCostRecordSelects(), (QFilter[])q.toArray(), null);
        q = new QFilter("entryentity.subentryentity.id", "in", (Object)billDetailIds);
        q.and("id", "in", billIds);
        DataSet initDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_initbill", (String)this.getInitSelects(), (QFilter[])q.toArray(), null);
        return initDataSet.union(costRecordDataSet);
    }

    private String getCostRecordSelects() {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        String entryName = "entry";
        for (String field : fields = this.totalKey.split(",")) {
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        selects.append("id as billid,billno as billno,bizdate,billtype.number as billtypenumber,billtype.name as billtypename,costaccount,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,");
        selects.append("entry.caldimension as caldimension,entry.caldimension.caldimension as caldimensionstr,auditdate,'0' as createtype,");
        selects.append("entry.baseqty as billqty,entry.material as material,entry.material.name as materialname,entry.material.number as materialnum,localcurrency as currency,10 as priceprecision,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as displaypricepc,entry.signnum as signnum,");
        selects.append("entry.baseunit as baseunit,entry.baseunit.precision as qtyprecision,entry.calrange as calrange,entry.calentryid as calentryid,entry.queuetype as queuetype,bizentityobject.number as bizentityobject,period as period,entry.seq as entryseq");
        selects.append(",entry.subentrycostelement.costelement as costelement,entry.subentrycostelement.costsubelement as costsubelement,entry.subentrycostelement.sub_actualcost billcost,entry.subentrycostelement.sub_unitactualcost as unitactualcost,entry.subentrycostelement.id as detailid,entry.id as eid");
        return selects.toString();
    }

    private String getInitSelects() {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_initbill");
        String entryName = "entryentity";
        for (String field : fields = this.totalKey.split(",")) {
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        String s = ResManager.loadKDString((String)"\u521d\u59cb\u6838\u7b97\u5355", (String)"FIFOCalculate_6", (String)"fi-cal-business", (Object[])new Object[0]);
        selects.append("id as billid,billno as billno,bizdate,'cal_initbill' as billtypenumber,'").append(s).append("' as billtypename,costaccount,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,");
        selects.append("entryentity.caldimension as caldimension,entryentity.caldimension.caldimension as caldimensionstr,auditdate,'0' as createtype,");
        selects.append("entryentity.baseqty as billqty,entryentity.material as material,entryentity.material.name as materialname,entryentity.material.number as materialnum,localcurrency as currency,10 as priceprecision,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as displaypricepc,1 as signnum,");
        selects.append("entryentity.baseunit as baseunit,entryentity.baseunit.precision as qtyprecision,entryentity.calrange as calrange,0 as calentryid,'0' as queuetype,'cal_initbill' as bizentityobject,0 as period,entryentity.seq as entryseq");
        selects.append(",entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,entryentity.subentryentity.sub_amount as billcost,entryentity.subentryentity.sub_price as unitactualcost,entryentity.subentryentity.id as detailid,entryentity.id as eid");
        return selects.toString();
    }

    private static class AddAdjustAmtFunction
    extends MapFunction {
        private static final long serialVersionUID = -5124479994753421306L;
        private RowMeta rowMeta;
        private Map<String, BigDecimal> motherRecord_adjustAmtMap;

        public AddAdjustAmtFunction(RowMeta rowMeta, Map<String, BigDecimal> motherRecord_adjustAmtMap) {
            this.rowMeta = rowMeta;
            this.motherRecord_adjustAmtMap = motherRecord_adjustAmtMap;
        }

        public RowMeta getResultRowMeta() {
            return this.rowMeta;
        }

        public Object[] map(Row row) {
            RowMeta resultRowMeta = this.getResultRowMeta();
            Object[] newRow = new Object[resultRowMeta.getFieldCount()];
            for (String fieldName : resultRowMeta.getFieldNames()) {
                int fieldIndex = resultRowMeta.getFieldIndex(fieldName);
                newRow[fieldIndex] = row.get(fieldName);
            }
            long entryId = row.getLong("entryid");
            long subElementId = row.getLong("costsubelement");
            BigDecimal adjustAmt = this.motherRecord_adjustAmtMap.get(entryId + "|" + subElementId);
            if (adjustAmt != null) {
                int billCostIndex = resultRowMeta.getFieldIndex("billcost");
                int billUnitCostIndex = resultRowMeta.getFieldIndex("billunitcost");
                BigDecimal newBillCost = row.getBigDecimal("billcost").add(adjustAmt);
                newRow[billCostIndex] = newBillCost;
                newRow[billUnitCostIndex] = newBillCost.divide(row.getBigDecimal("billqty"), 10, 4);
            }
            return newRow;
        }
    }

    private static class RelationEntry {
        private String billNumber;
        private Long billId;
        private Long billEntryId;
        private BigDecimal qty = BigDecimal.ZERO;

        private RelationEntry() {
        }
    }

    private static class RelationInfo {
        private BigDecimal allQty = BigDecimal.ZERO;
        private List<RelationEntry> entrys = new ArrayList<RelationEntry>(16);

        private RelationInfo() {
        }

        private void addEntry(RelationEntry entry) {
            this.entrys.add(entry);
        }

        private boolean isAllOut() {
            BigDecimal sumOutQty = BigDecimal.ZERO;
            for (RelationEntry entry : this.entrys) {
                sumOutQty = sumOutQty.add(entry.qty);
            }
            return this.allQty.compareTo(sumOutQty) == 0;
        }
    }

    private static class BalInfo {
        private String balId;
        private BigDecimal qty;
        private BigDecimal cost;

        private BalInfo() {
        }

        public String getBalId() {
            return this.balId;
        }

        public void setBalId(String balId) {
            this.balId = balId;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public BigDecimal getCost() {
            return this.cost;
        }

        public void setCost(BigDecimal cost) {
            this.cost = cost;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BalInfo)) {
                return false;
            }
            return this.balId.equals(((BalInfo)obj).getBalId());
        }

        public int hashCode() {
            return this.balId.hashCode();
        }
    }

    private static class BillInfo {
        private long billId;
        private long billEntryId;
        private long detailId;
        private Date bizDate;
        private Date auditDate;
        private String billNo;
        private int entrySeq;
        private BigDecimal qty = BigDecimal.ZERO;
        private BigDecimal cost = BigDecimal.ZERO;
        private BigDecimal price = BigDecimal.ZERO;
        private String type;
        private int qtyPrecision;
        private int amtPrecision;
        private int pricePrecision;
        private long currencyId;
        private long baseUnitId;
        private long materialId;

        private BillInfo() {
        }

        public long getBillId() {
            return this.billId;
        }

        public void setBillId(long billId) {
            this.billId = billId;
        }

        public long getBillEntryId() {
            return this.billEntryId;
        }

        public void setBillEntryId(long billEntryId) {
            this.billEntryId = billEntryId;
        }

        public Date getBizDate() {
            return this.bizDate;
        }

        public void setBizDate(Date bizDate) {
            this.bizDate = bizDate;
        }

        public Date getAuditDate() {
            return this.auditDate;
        }

        public void setAuditDate(Date auditDate) {
            this.auditDate = auditDate;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public void setBillNo(String billNo) {
            this.billNo = billNo;
        }

        public int getEntrySeq() {
            return this.entrySeq;
        }

        public void setEntrySeq(int entrySeq) {
            this.entrySeq = entrySeq;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public BigDecimal getCost() {
            return this.cost;
        }

        public void setCost(BigDecimal cost) {
            this.cost = cost;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getQtyPrecision() {
            return this.qtyPrecision;
        }

        public void setQtyPrecision(int qtyPrecision) {
            this.qtyPrecision = qtyPrecision;
        }

        public int getAmtPrecision() {
            return this.amtPrecision;
        }

        public void setAmtPrecision(int amtPrecision) {
            this.amtPrecision = amtPrecision;
        }

        public int getPricePrecision() {
            return this.pricePrecision;
        }

        public void setPricePrecision(int pricePrecision) {
            this.pricePrecision = pricePrecision;
        }

        public long getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(long currencyId) {
            this.currencyId = currencyId;
        }

        public long getBaseUnitId() {
            return this.baseUnitId;
        }

        public void setBaseUnitId(long baseUnitId) {
            this.baseUnitId = baseUnitId;
        }

        public long getMaterialId() {
            return this.materialId;
        }

        public void setMaterialId(long materialId) {
            this.materialId = materialId;
        }

        public long getDetailId() {
            return this.detailId;
        }

        public void setDetailId(long detailId) {
            this.detailId = detailId;
        }
    }
}

