/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.BalanceDimFieldParser;
import kd.fi.calx.algox.CalOutDataRangeHolder;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.CostAdjustDetailParams;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.function.PrevCaldimensionFieldMapFunction;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CommonSettingHelper;
import kd.fi.calx.algox.helper.PeriodHelper;
import kd.fi.calx.algox.util.ArrayUtils;

public class GPAPrevCostAdjustHelper {
    private static final Log logger = LogFactory.getLog(GPAPrevCostAdjustHelper.class);
    private static final String[] PREVCOST_ADJUSTBILL_CREATETYPE = new String[]{"B", "U", "I", "J", "D", "B-A1"};
    private BalanceDimFieldParser balanceDimFieldParser;
    private Set<String> dimFields;
    private Set<Long> inAdjBillIdSet;
    private boolean daily_bal = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.DAILY_BAL);

    public GPAPrevCostAdjustHelper() {
        this.balanceDimFieldParser = new BalanceDimFieldParser();
        this.dimFields = this.balanceDimFieldParser.getDimFields();
        this.inAdjBillIdSet = new HashSet<Long>(16);
    }

    public void dealOutAdjustGpa(CalOutDataRangeHolder holder) {
        for (CalOutDataRangeHolder.CalOutRange range : holder.getCalOutRangeList()) {
            OperationResult result;
            Object row3;
            Long period = range.getPeriodId();
            Set<Long> materialSet = this.getMaterialSetByRange(range);
            Long costaccountId = range.getCostAccountId();
            Long calRangeId = range.getCalRangeId();
            Long calOrgId = range.getCalOrgId();
            AppParam appParam = new AppParam("/KIUHEXROK3D", "10", calOrgId, Long.valueOf(0L));
            Boolean deleteprecostadj = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"deleteprecostadj");
            String prevCostParam = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"prevcostadjustparam");
            if (deleteprecostadj == null || deleteprecostadj.booleanValue() || !"no".equals(prevCostParam)) {
                this.unauditVCreateTypeAdjust(period, materialSet, costaccountId, calRangeId);
            }
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> prevCostParam:" + prevCostParam);
            if (!"proportion".equals(prevCostParam) && !"all".equals(prevCostParam)) continue;
            DataSet inAllAdjustSet = this.getInAllAdjustSet(period, materialSet, costaccountId, calRangeId);
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> dealOutAdjustGpa inAllAdjustSet0");
            HashSet<Long> recordEntryIds = new HashSet<Long>(16);
            HashSet<Long> materialEntryIds = new HashSet<Long>(16);
            HashSet<Long> recordIds = new HashSet<Long>(16);
            for (Row row2 : inAllAdjustSet.copy()) {
                recordEntryIds.add(row2.getLong("invbillentryid"));
                materialEntryIds.add(row2.getLong("material"));
                recordIds.add(row2.getLong("invbillid"));
            }
            if (recordEntryIds.isEmpty() || recordIds.isEmpty()) continue;
            inAllAdjustSet = inAllAdjustSet.map((MapFunction)new PrevCaldimensionFieldMapFunction(inAllAdjustSet.getRowMeta(), costaccountId));
            DataSet inRecordSet = this.getCostRecordBaseqty(recordEntryIds, recordIds);
            String[] joinDims = this.dimFields.toArray(new String[0]);
            String[] leftFields = ArrayUtils.concatAll(new String[]{"calorg", "id", "entryid", "invbillentryid", "createtype", "accounttype", "periodid", "entryseq", "adjustamt", "invbizdate", "amtprecision", "singleadjustamt", "calrange", "caldimensionvalue"}, new String[][]{joinDims});
            String[] rightFields = new String[]{"baseqty"};
            inAllAdjustSet = inAllAdjustSet.leftJoin(inRecordSet).on("invbillentryid", "entryid").select(leftFields, rightFields).finish();
            DataSet unRepeatAdjustSet = inAllAdjustSet.groupBy(new String[]{"invbillentryid", "createtype", "caldimensionvalue"}).max("baseqty").sum("adjustamt").finish();
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> dealOutAdjustGpa inAllAdjustSet1");
            DataSet inSumAdjustSet = unRepeatAdjustSet.groupBy(new String[]{"createtype", "caldimensionvalue"}).sum("baseqty").sum("adjustamt").finish();
            JoinDataSet joinAdjustSet = inAllAdjustSet.leftJoin(inSumAdjustSet);
            joinAdjustSet = this.joinOnSelectDims(joinAdjustSet, new String[]{"createtype", "caldimensionvalue"});
            inAllAdjustSet = joinAdjustSet.select(inAllAdjustSet.getRowMeta().getFieldNames(), new String[]{"baseqty as  totaladjustqty", "adjustamt as totaladjustcost"}).finish();
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> dealOutAdjustGpa inAllAdjustSet2");
            inAllAdjustSet = this.getBalanceSetQty(range, period, costaccountId, inAllAdjustSet, materialEntryIds, new String[]{"caldimensionvalue"});
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> dealOutAdjustGpa inAllAdjustSet3");
            ArrayList<DynamicObject> outCostAdjustList = new ArrayList<DynamicObject>(16);
            inAllAdjustSet = inAllAdjustSet.filter("totaladjustqty > periodendqty or periodendqty is null");
            for (Object row3 : inAllAdjustSet) {
                DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> dealOutAdjustGpa inAllAdjustSet4");
                DynamicObject outCostAdjustBill = this.dealGPARageOutCost((Row)row3, prevCostParam);
                if (outCostAdjustBill == null) continue;
                outCostAdjustList.add(outCostAdjustBill);
            }
            if (outCostAdjustList == null || outCostAdjustList.size() <= 0) continue;
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> outCostAdjustList=" + outCostAdjustList.size());
            SaveServiceHelper.save((DynamicObject[])outCostAdjustList.toArray(new DynamicObject[outCostAdjustList.size()]));
            HashSet<Long> outAdjustIdset = new HashSet<Long>(outCostAdjustList.size());
            row3 = outCostAdjustList.iterator();
            while (row3.hasNext()) {
                DynamicObject info = (DynamicObject)row3.next();
                outAdjustIdset.add(info.getLong("id"));
            }
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> outcostAdjustSetIds:" + outAdjustIdset);
            DynamicObject[] outCostAdjusts = BusinessDataServiceHelper.load((Object[])outAdjustIdset.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> inAdjBillIdSet:" + this.inAdjBillIdSet);
            DynamicObject[] inCostAdjusts = BusinessDataServiceHelper.load((Object[])this.inAdjBillIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
            Map<Long, DynamicObject> inAdjEntryInfoMap = this.getInAdjEntryInfoMap(inCostAdjusts);
            List<CostAdjustDetailParams> paramsList = this.buildCostAdjustDetail(outCostAdjusts, inAdjEntryInfoMap);
            OperateOption option = OperateOption.create();
            String params = SerializationUtils.toJsonString(paramsList);
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> outCostAdjustList params:" + params);
            option.setVariableValue("CostAdjustDetailParms", params);
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("ignoreValidation", "true");
            if (!this.daily_bal) {
                option.setVariableValue("not_update_bal", "true");
            }
            if (!(result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])outCostAdjusts, (OperateOption)option)).isSuccess()) {
                StringBuilder msg = new StringBuilder();
                msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff1a", (String)"GPAPrevCostAdjustHelper_1", (String)"fi-calx-algox", (Object[])new Object[0]));
                String errorMsg = result.getMessage();
                if (!StringUtils.isBlank((String)errorMsg)) {
                    msg.append(errorMsg);
                }
                List errors = result.getAllErrorOrValidateInfo();
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
                throw new KDBizException(msg.toString());
            }
            if (this.inAdjBillIdSet == null || this.inAdjBillIdSet.size() <= 0) continue;
            this.inAdjBillIdSet.clear();
        }
    }

    private DataSet getCostRecordBaseqty(Set<Long> recordEntryIds, Set<Long> recordIds) {
        QFilter recordFilter = new QFilter("entry.id", "in", recordEntryIds);
        if (recordIds != null && recordIds.size() > 0) {
            recordFilter.and("id", "in", recordIds);
        }
        String recordFields = "entry.id as entryid,entry.baseqty as baseqty";
        DataSet inRecordSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)recordFields, (QFilter[])recordFilter.toArray(), null);
        return inRecordSet;
    }

    private DataSet getBalanceSetQty(CalOutDataRangeHolder.CalOutRange range, Long period, Long costaccountId, DataSet inAllAdjustSet, Set<Long> materialEntryIds, String[] joinDims) {
        DynamicObject currentPeriod;
        QFilter filter = new QFilter("costaccount", "=", (Object)costaccountId);
        if (materialEntryIds != null && materialEntryIds.size() > 0) {
            filter.and("material", "in", materialEntryIds);
        }
        if ((currentPeriod = PeriodHelper.getCurrentPeriod(costaccountId)) != null) {
            int periodNum = currentPeriod.getInt("periodyear") * 100 + currentPeriod.getInt("periodnumber");
            filter.and("period", "<", (Object)periodNum);
            filter.and("endperiod", ">=", (Object)periodNum);
        }
        if (range.getCalRangeId() != null) {
            filter.and("calrange", "=", (Object)range.getCalRangeId());
        }
        String balanceEntity = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balance";
        DataSet balanceSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)balanceEntity, (String)this.getBalanceBizField(), (QFilter[])filter.toArray(), null);
        if (CalBalanceModelHelper.isNewBalance()) {
            balanceSet = this.groupIgnoreElement(balanceSet);
        }
        balanceSet = balanceSet.map((MapFunction)new PrevCaldimensionFieldMapFunction(balanceSet.getRowMeta(), costaccountId));
        balanceSet = balanceSet.groupBy(joinDims).sum("periodendqty").finish();
        JoinDataSet joinDataSet = inAllAdjustSet.join(balanceSet, JoinType.LEFT);
        joinDataSet = this.joinOnSelectDims(joinDataSet, joinDims);
        inAllAdjustSet = joinDataSet.select(inAllAdjustSet.getRowMeta().getFieldNames(), new String[]{"periodendqty"}).finish();
        return inAllAdjustSet;
    }

    private Set<Long> getMaterialSetByRange(CalOutDataRangeHolder.CalOutRange range) {
        HashSet<Long> materialSet = new HashSet<Long>(16);
        if (range.getMaterialSetList() != null && !range.getMaterialSetList().isEmpty()) {
            for (Set<Object> matSet : range.getMaterialSetList()) {
                for (Object mat : matSet) {
                    materialSet.add(Long.valueOf(mat.toString()));
                }
            }
        }
        return materialSet;
    }

    private DataSet getInAllAdjustSet(Long period, Set<Long> materialSet, Long costaccountId, Long calRangeId) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("createtype", "in", (Object)PREVCOST_ADJUSTBILL_CREATETYPE);
        if (costaccountId != null) {
            filter.and("costaccount", "=", (Object)costaccountId);
            DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costaccountId);
            if (currentPeriod != null) {
                Date beginDate = currentPeriod.getDate("begindate");
                filter.and("entryentity.invbizdate", "<", (Object)beginDate);
            }
        }
        if (period != null) {
            filter.and("period", "=", (Object)period);
        }
        if (calRangeId != null) {
            filter.and("entryentity.calrange", "=", (Object)calRangeId);
        }
        if (materialSet != null && materialSet.size() > 0) {
            filter.and("entryentity.material", "in", materialSet);
        }
        HashSet<String> accounttypeStr = new HashSet<String>(16);
        accounttypeStr.add(AccountTypeEnum.WEIGHTAVG.getValue());
        accounttypeStr.add(AccountTypeEnum.SPPRICE.getValue());
        filter.and("entryentity.accounttype", "in", accounttypeStr);
        DataSet inAllAdjustSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_subentity", (String)this.getCostAdjustBizField(), (QFilter[])new QFilter[]{filter}, null);
        return inAllAdjustSet;
    }

    private void unauditVCreateTypeAdjust(Long period, Set<Long> materialSet, Long costaccountId, Long calRangeId) {
        QFilter filter = new QFilter("createtype", "=", (Object)"V");
        filter.and("billstatus", "=", (Object)"C");
        if (costaccountId != null) {
            filter.and("costaccount", "=", (Object)costaccountId);
        }
        if (period != null) {
            filter.and("period", "=", (Object)period);
        }
        if (calRangeId != null) {
            filter.and("entryentity.calrange", "=", (Object)calRangeId);
        }
        if (materialSet != null && materialSet.size() > 0) {
            filter.and("entryentity.material", "in", materialSet);
        }
        HashSet<String> accounttypeStr = new HashSet<String>(16);
        accounttypeStr.add(AccountTypeEnum.WEIGHTAVG.getValue());
        accounttypeStr.add(AccountTypeEnum.SPPRICE.getValue());
        filter.and("entryentity.accounttype", "in", accounttypeStr);
        StringBuilder fields = new StringBuilder();
        MainEntityType calEntityType = EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity");
        Set selectorsSet = calEntityType.getAllFields().keySet();
        for (String o : selectorsSet) {
            fields.append(o).append(',');
        }
        fields.setLength(fields.length() - 1);
        DynamicObject[] outAdjusts = BusinessDataServiceHelper.load((String)"cal_costadjust_subentity", (String)fields.toString(), (QFilter[])filter.toArray());
        HashSet<Long> outAdjustIds = new HashSet<Long>(16);
        if (outAdjusts != null && outAdjusts.length > 0) {
            OperationResult result;
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper unauditVCreateTypeAdjust_> outAdjusts:" + outAdjusts.length);
            OperateOption op = OperateOption.create();
            DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"\u524d\u671f\u6210\u672c\u5904\u7406\u8c03\u7528\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u5f00\u59cb:%1$s", (String)"GPAPrevCostAdjustHelper_2", (String)"fi-calx-algox", (Object[])new Object[0]), outAdjusts[0].getString("billno")));
            op.setVariableValue("unwriteoff", "true");
            op.setVariableValue("ishasright", "true");
            op.setVariableValue("ignoreValidation", "true");
            if (!this.daily_bal) {
                op.setVariableValue("not_update_bal", "true");
            }
            if (!(result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costadjust_subentity", (DynamicObject[])outAdjusts, (OperateOption)op)).isSuccess()) {
                List errors = result.getAllErrorOrValidateInfo();
                StringBuilder msg = new StringBuilder();
                msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff1a", (String)"GPAPrevCostAdjustHelper_0", (String)"fi-calx-algox", (Object[])new Object[0]));
                String errorMsg = result.getMessage();
                if (!StringUtils.isBlank((String)errorMsg)) {
                    msg.append(errorMsg);
                }
                if (!errors.isEmpty()) {
                    HashSet<String> msgSet = new HashSet<String>(16);
                    for (IOperateInfo error : errors) {
                        OperateInfo operror = (OperateInfo)error;
                        msgSet.add(operror.getMessage());
                    }
                    for (String msgString : msgSet) {
                        msg.append(msgString).append('\n');
                    }
                    throw new KDBizException(msg.toString());
                }
            } else {
                for (DynamicObject outAdjust : outAdjusts) {
                    Long id = outAdjust.getLong("id");
                    outAdjustIds.add(id);
                }
                DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"\u524d\u671f\u6210\u672c\u5904\u7406\u8c03\u7528\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u7ed3\u675f:%1$s", (String)"GPAPrevCostAdjustHelper_3", (String)"fi-calx-algox", (Object[])new Object[0]), outAdjusts[0].getString("billno")));
                DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"\u524d\u671f\u6210\u672c\u5904\u7406\u8c03\u7528\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u4fe1\u606f:%1$s", (String)"GPAPrevCostAdjustHelper_4", (String)"fi-calx-algox", (Object[])new Object[0]), result.getMessage()));
                DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"\u524d\u671f\u6210\u672c\u5904\u7406\u8c03\u7528\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u6210\u529fID:%1$s", (String)"GPAPrevCostAdjustHelper_5", (String)"fi-calx-algox", (Object[])new Object[0]), result.getSuccessPkIds().get(0)));
                DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"\u524d\u671f\u6210\u672c\u5904\u7406\u8c03\u7528\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u5220\u9664\u5f00\u59cb:%1$s", (String)"GPAPrevCostAdjustHelper_6", (String)"fi-calx-algox", (Object[])new Object[0]), filter));
                DeleteServiceHelper.delete((String)"cal_costadjust_subentity", (QFilter[])new QFilter[]{new QFilter("id", "in", outAdjustIds)});
                DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"\u524d\u671f\u6210\u672c\u5904\u7406\u8c03\u7528\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u5220\u9664\u7ed3\u675f:%1$s", (String)"GPAPrevCostAdjustHelper_7", (String)"fi-calx-algox", (Object[])new Object[0]), filter));
            }
        }
    }

    private DynamicObject dealGPARageOutCost(Row row, String prevCostParam) {
        BigDecimal periodbeginqty;
        BigDecimal outAdjustAmt = new BigDecimal("0");
        BigDecimal totaladjustqty = row.getBigDecimal("totaladjustqty");
        if (totaladjustqty != null) {
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> totaladjustqty=" + totaladjustqty.doubleValue());
        }
        if ((periodbeginqty = row.getBigDecimal("periodendqty")) != null) {
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> periodbeginqty =" + periodbeginqty.doubleValue());
        } else {
            periodbeginqty = BigDecimal.ZERO;
        }
        DynamicObject outCostAdjustBill = null;
        if (totaladjustqty != null && periodbeginqty != null && totaladjustqty.compareTo(periodbeginqty) > 0) {
            BigDecimal totaladjustcost = row.getBigDecimal("totaladjustcost");
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> totaladjustcost=" + totaladjustcost.doubleValue());
            BigDecimal sinaleadjustcost = row.getBigDecimal("singleadjustamt");
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> sinaleadjustcost=" + sinaleadjustcost.doubleValue());
            if (periodbeginqty.compareTo(BigDecimal.ZERO) > 0) {
                DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> PrevCostAdjustConstant prevCostParam=" + prevCostParam);
                if ("proportion".equals(prevCostParam) && totaladjustcost.compareTo(BigDecimal.ZERO) != 0 && totaladjustqty.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal allTotalCost = totaladjustcost.multiply(totaladjustqty.subtract(periodbeginqty)).divide(totaladjustqty, 10, RoundingMode.HALF_UP);
                    outAdjustAmt = allTotalCost.multiply(sinaleadjustcost).divide(totaladjustcost, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                }
                if ("all".equals(prevCostParam)) {
                    outAdjustAmt = sinaleadjustcost;
                }
            } else {
                outAdjustAmt = sinaleadjustcost;
            }
            if (outAdjustAmt.compareTo(BigDecimal.ZERO) != 0) {
                outCostAdjustBill = this.createCostAdjustBill(row.getLong("id"), row.getLong("invbillentryid"), outAdjustAmt);
            }
        }
        return outCostAdjustBill;
    }

    private DynamicObject createCostAdjustBill(Long adjustId, Long invenrtyid, BigDecimal outAdjustAmt) {
        DynamicObject costAdjustInfo = BusinessDataServiceHelper.loadSingle((Object)adjustId, (String)"cal_costadjustbill");
        DynamicObject outCostAdjustBill = this.createCostAdjustHead(costAdjustInfo);
        this.addCostAdjustBillEntry(invenrtyid, outAdjustAmt, costAdjustInfo, outCostAdjustBill);
        return outCostAdjustBill;
    }

    private DynamicObject createCostAdjustHead(DynamicObject costAdjustInfo) {
        DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjust_subentity");
        costAdjustBill.set("calorg", (Object)costAdjustInfo.getDynamicObject("calorg"));
        costAdjustBill.set("costaccount", (Object)costAdjustInfo.getDynamicObject("costaccount"));
        String number = this.createBillNo(costAdjustBill, String.valueOf(costAdjustInfo.getDynamicObject("calorg").getPkValue()));
        costAdjustBill.set("billno", (Object)number);
        costAdjustBill.set("billstatus", (Object)"B");
        costAdjustBill.set("biztype", (Object)"B");
        costAdjustBill.set("billtype", (Object)costAdjustInfo.getDynamicObject("billtype"));
        costAdjustBill.set("currency", costAdjustInfo.get("currency"));
        costAdjustBill.set("period", costAdjustInfo.get("period"));
        costAdjustBill.set("createtype", (Object)"V");
        costAdjustBill.set("difftype", (Object)"B");
        costAdjustBill.set("adminorg", (Object)costAdjustInfo.getDynamicObject("adminorg"));
        costAdjustBill.set("bizdate", (Object)costAdjustInfo.getDate("bizdate"));
        costAdjustBill.set("bookdate", (Object)costAdjustInfo.getDate("bookdate"));
        Long userId = RequestContext.get().getCurrUserId();
        Date date = TimeServiceHelper.now();
        costAdjustBill.set("creator", (Object)userId);
        costAdjustBill.set("createtime", (Object)date);
        costAdjustBill.set("modifier", (Object)userId);
        costAdjustBill.set("modifytime", (Object)date);
        costAdjustBill.set("auditor", (Object)userId);
        costAdjustBill.set("auditdate", (Object)date);
        costAdjustBill.set("cstype", (Object)"bd_customer");
        return costAdjustBill;
    }

    private String createBillNo(DynamicObject bill, String orgId) {
        String billNo = CodeRuleServiceHelper.getNumber(null, (DynamicObject)bill, (String)orgId);
        if (StringUtils.isEmpty((String)billNo) || "".equals(billNo.trim())) {
            billNo = String.valueOf(System.currentTimeMillis());
        }
        return billNo;
    }

    private void addCostAdjustBillEntry(Long invenrtyid, BigDecimal outAdjustAmt, DynamicObject costAdjustInfo, DynamicObject costAdjustBillHead) {
        boolean isIntimeAccType;
        DynamicObjectCollection costAdjustEntrys = costAdjustInfo.getDynamicObjectCollection("entryentity");
        DynamicObject costAdjustEntry = null;
        for (DynamicObject entry : costAdjustEntrys) {
            if (invenrtyid.compareTo(entry.getLong("invbillentryid")) != 0) continue;
            costAdjustEntry = entry;
            break;
        }
        if (costAdjustEntry == null) {
            return;
        }
        DynamicObject entry = costAdjustBillHead.getDynamicObjectCollection("entryentity").addNew();
        entry.set("storageorgunit", costAdjustEntry.get("storageorgunit"));
        entry.set("material", costAdjustEntry.get("material"));
        entry.set("mversion", costAdjustEntry.get("mversion"));
        entry.set("assist", costAdjustEntry.get("assist"));
        entry.set("lot", costAdjustEntry.get("lot"));
        entry.set("baseunit", costAdjustEntry.get("baseunit"));
        if (outAdjustAmt != null) {
            DiffAllocHelper.writeLog(logger, "GPAPrevCostAdjustHelper_> addCostAdjustBillEntry outAdjustAmt=" + outAdjustAmt.doubleValue());
        }
        entry.set("adjustamt", (Object)outAdjustAmt);
        entry.set("warehouse", costAdjustEntry.get("warehouse"));
        entry.set("location", costAdjustEntry.get("location"));
        entry.set("ownertype", (Object)"bos_org");
        entry.set("owner", costAdjustEntry.get("owner"));
        entry.set("ecostcenter", costAdjustEntry.get("ecostcenter"));
        entry.set("project", costAdjustEntry.get("project"));
        costAdjustBillHead.set("biztype", (Object)"B");
        entry.set("invbizdate", costAdjustEntry.get("invbizdate"));
        entry.set("invauditdate", costAdjustEntry.get("invauditdate"));
        entry.set("invbizentityobject", (Object)"cal_costrecord");
        entry.set("srcbilltype", (Object)986031578352241664L);
        entry.set("srcbizentityobject", (Object)"cal_costadjust_subentity");
        entry.set("srcbillnum", costAdjustInfo.get("billno"));
        entry.set("srcentryseq", costAdjustEntry.get("seq"));
        entry.set("srcbillid", costAdjustInfo.get("id"));
        entry.set("srcbillentryid", costAdjustEntry.get("id"));
        entry.set("invtype", costAdjustEntry.get("invtype"));
        entry.set("invstatus", costAdjustEntry.get("invstatus"));
        entry.set("calrange", costAdjustEntry.get("calrange"));
        entry.set("caldimension", costAdjustEntry.get("caldimension"));
        entry.set("accounttype", costAdjustEntry.get("accounttype"));
        String accType = costAdjustEntry.getString("accounttype");
        boolean bl = isIntimeAccType = AccountTypeEnum.MOVEDAVG_INTIME.getValue().equals(accType) || AccountTypeEnum.FIFO.getValue().equals(accType);
        if (isIntimeAccType) {
            entry.set("invbillid", costAdjustEntry.get("invbillid"));
            entry.set("invbillentryid", costAdjustEntry.get("invbillentryid"));
            entry.set("invbillnum", costAdjustEntry.get("invbillnum"));
            entry.set("inventryseq", costAdjustEntry.get("inventryseq"));
        }
        Set<String> exFieldSet = CommonSettingHelper.getExFieldSet();
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        CommonSettingHelper.setExFieldValue(exFieldSet, costAdjustEntityType, costAdjustEntityType, entry, costAdjustEntry);
        this.inAdjBillIdSet.add(costAdjustInfo.getLong("id"));
    }

    private List<CostAdjustDetailParams> buildCostAdjustDetail(DynamicObject[] outCostAdjusts, Map<Long, DynamicObject> inAdjEntryInfoMap) {
        ArrayList<CostAdjustDetailParams> paramsList = new ArrayList<CostAdjustDetailParams>();
        for (DynamicObject outDynamic : outCostAdjusts) {
            DynamicObjectCollection outcostadjustEntry = outDynamic.getDynamicObjectCollection("entryentity");
            block1: for (DynamicObject outentry : outcostadjustEntry) {
                long entryId = outentry.getLong("id");
                Long srcBillEntryId = outentry.getLong("srcbillentryid");
                if (!inAdjEntryInfoMap.containsKey(srcBillEntryId)) continue;
                DynamicObjectCollection inEntryDetails = inAdjEntryInfoMap.get(srcBillEntryId).getDynamicObjectCollection("subentryentity");
                for (DynamicObject detail : inEntryDetails) {
                    BigDecimal subAdjustamt = detail.getBigDecimal("sub_adjustamt");
                    if (subAdjustamt == null || subAdjustamt.compareTo(BigDecimal.ZERO) == 0) continue;
                    CostAdjustDetailParams param = new CostAdjustDetailParams();
                    param.setAdjustAmt(outentry.getBigDecimal("adjustamt"));
                    param.setEntryid(entryId);
                    param.setCostElementId(detail.getLong("costelement.id"));
                    param.setCostSubElementId(detail.getLong("costsubelement.id"));
                    paramsList.add(param);
                    continue block1;
                }
            }
        }
        return paramsList;
    }

    private String getCostAdjustBizField() {
        StringBuilder select = new StringBuilder();
        String costAdjustFields = this.balanceDimFieldParser.getCostAdjustFields();
        select.append(costAdjustFields);
        select.append("id,billno,difftype,entryentity.id as entryid,entryentity.seq as entryseq,calorg");
        select.append(",isvoucher,TO_INT(period.periodyear*100+period.periodnumber) as periodid,billstatus,createtype,entryentity.adjustamt as adjustamt,entryentity.adjustamt as singleadjustamt");
        select.append(",currency as localcurrency,currency.amtprecision as amtprecision,currency.priceprecision as priceprecision");
        select.append(",entryentity.accounttype as accounttype,entryentity.invbizdate as invbizdate,entryentity.calrange as calrange");
        select.append(",entryentity.material.group.longnumber as materialgrouplnum,'0' as caldimensionvalue");
        select.append(",entryentity.invbillid as invbillid,entryentity.invbillentryid as invbillentryid");
        return select.toString();
    }

    private JoinDataSet joinOnSelectDims(JoinDataSet joinDataSet, String[] joinDims) {
        for (String joinDim : joinDims) {
            joinDataSet = joinDataSet.on(joinDim, joinDim);
        }
        return joinDataSet;
    }

    private String getBalanceBizField() {
        StringBuilder select = new StringBuilder();
        for (String dimField : this.dimFields) {
            select.append(dimField).append(",");
        }
        if (CalBalanceModelHelper.isNewBalance()) {
            select.append("calrange,period,period as periodid,baseqty_bal as periodendqty");
        } else {
            select.append("calrange,period,period as periodid,periodendqty");
        }
        select.append(",material.group.longnumber as materialgrouplnum,'0' as caldimensionvalue,calorg");
        return select.toString();
    }

    private Map<Long, DynamicObject> getInAdjEntryInfoMap(DynamicObject[] inCostAdjusts) {
        HashMap<Long, DynamicObject> entryInfosMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject inCostAdjust : inCostAdjusts) {
            DynamicObjectCollection entrys = inCostAdjust.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                entryInfosMap.put(entry.getLong("id"), entry);
            }
        }
        return entryInfosMap;
    }

    private DataSet groupIgnoreElement(DataSet balanceSet) {
        StringBuilder groupFields = new StringBuilder();
        for (String dimField : this.dimFields) {
            if ("costsubelement".equals(dimField) || "costelement".equals(dimField)) continue;
            groupFields.append(dimField).append(",");
        }
        groupFields.append("calrange,period,periodid,materialgrouplnum,caldimensionvalue,calorg");
        GroupbyDataSet groupByDataSet = balanceSet.groupBy(groupFields.toString().split(","));
        Boolean balCompress = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        groupByDataSet = balCompress != false ? groupByDataSet.sum("periodendqty") : groupByDataSet.max("periodendqty");
        balanceSet = groupByDataSet.finish().select(balanceSet.getRowMeta().getFieldNames());
        return balanceSet;
    }
}

