/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;

public class JsonEntryFillFunction
extends GroupReduceFunction {
    private RowMeta destRowMeta;
    private List<String> subEntryFields;
    private String jsonSubEntry;
    private String jsonFieldName;
    private RowMeta srcRowMeta;
    private static final long serialVersionUID = 1L;
    private static final SimpleDateFormat dateSdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat dateTimeSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public JsonEntryFillFunction(String jsonSubEntry, RowMeta resultRowMeta, List<String> subEntryFields, String jsonFieldName) {
        this.jsonSubEntry = jsonSubEntry;
        this.destRowMeta = resultRowMeta;
        this.subEntryFields = subEntryFields;
        this.jsonFieldName = jsonFieldName;
    }

    public RowMeta getResultRowMeta() {
        return this.destRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        this.srcRowMeta = this.getSourceRowMeta();
        for (RowX rowX : iterable) {
            String json = rowX.getString(this.srcRowMeta.getFieldIndex(this.jsonFieldName));
            boolean isEmpty = false;
            JSONArray data = null;
            JSONArray index = null;
            if (StringUtils.isEmpty((String)json)) {
                isEmpty = true;
            } else {
                JSONObject jsonObject = JSON.parseObject((String)json);
                data = jsonObject.getJSONArray("data");
                index = jsonObject.getJSONArray("index");
                if (data == null || index == null || data.size() == 0) {
                    isEmpty = true;
                }
            }
            if (isEmpty) {
                RowX newRowX = this.buildNewRowX(rowX);
                for (String key : this.subEntryFields) {
                    this.setRowValue(newRowX, key, null);
                }
                collector.collect(newRowX);
                continue;
            }
            HashMap<String, Integer> keyMap = new HashMap<String, Integer>(16);
            if (index != null) {
                for (int i = 0; i < index.size(); ++i) {
                    keyMap.put(index.getString(i).toUpperCase(), i);
                }
            }
            String subEntryTypePre = this.jsonSubEntry + ".";
            if (data == null) continue;
            for (int i = 0; i < data.size(); ++i) {
                RowX newSubRowX = this.buildNewRowX(rowX);
                JSONArray dataRow = data.getJSONArray(i);
                for (String key : this.subEntryFields) {
                    String newKey = key.replace(subEntryTypePre, "");
                    if (newKey.indexOf(".id") > -1) {
                        newKey = newKey.substring(0, newKey.indexOf("."));
                    }
                    if ("COSTELEMENT".equals(newKey)) {
                        newKey = "COSTELEMENT_ID";
                    }
                    if ("COSTSUBELEMENT".equals(newKey)) {
                        newKey = "COSTSUBELEMENT_ID";
                    }
                    Object value = dataRow.get(((Integer)keyMap.get(newKey)).intValue());
                    this.setRowValue(newSubRowX, key, value);
                }
                collector.collect(newSubRowX);
            }
        }
    }

    private void setRowValue(RowX newRowX, String key, Object object) {
        if (object == null) {
            this.setNullValue(newRowX, key);
            return;
        }
        String str = object.toString();
        int index = this.destRowMeta.getFieldIndex(key);
        DataType dt = this.destRowMeta.getField(index).getDataType();
        if (dt.equals((Object)DataType.BigDecimalType)) {
            newRowX.set(index, (Object)new BigDecimal(str));
        } else if (dt.equals((Object)DataType.BooleanType)) {
            newRowX.set(index, (Object)Boolean.parseBoolean(str));
        } else if (dt.equals((Object)DataType.DoubleType)) {
            newRowX.set(index, (Object)Double.parseDouble(str));
        } else if (dt.equals((Object)DataType.IntegerType)) {
            newRowX.set(index, (Object)Integer.parseInt(str));
        } else if (dt.equals((Object)DataType.LongType)) {
            newRowX.set(index, (Object)Long.parseLong(str));
        } else if (dt.equals((Object)DataType.StringType)) {
            newRowX.set(index, (Object)str);
        } else if (dt.equals((Object)DataType.TimestampType)) {
            Date returnDate;
            try {
                returnDate = str.trim().length() == 10 ? dateSdf.parse(str) : dateTimeSdf.parse(str);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            newRowX.set(index, (Object)returnDate);
        }
    }

    private RowX buildNewRowX(RowX rowX) {
        RowX newRowX = new RowX(this.destRowMeta.getFields().length);
        for (String key : this.srcRowMeta.getFieldNames()) {
            if (this.jsonFieldName.equals(key)) continue;
            newRowX.set(this.destRowMeta.getFieldIndex(key), rowX.get(this.srcRowMeta.getFieldIndex(key)));
        }
        return newRowX;
    }

    private void setNullValue(RowX newRowX, String key) {
        int index = this.destRowMeta.getFieldIndex(key);
        DataType dt = this.destRowMeta.getField(index).getDataType();
        if (dt.equals((Object)DataType.BigDecimalType)) {
            newRowX.set(index, (Object)BigDecimal.ZERO);
        } else if (dt.equals((Object)DataType.BooleanType)) {
            newRowX.set(index, (Object)Boolean.FALSE);
        } else if (dt.equals((Object)DataType.DoubleType)) {
            newRowX.set(index, (Object)0.0);
        } else if (dt.equals((Object)DataType.IntegerType)) {
            newRowX.set(index, (Object)0);
        } else if (dt.equals((Object)DataType.LongType)) {
            newRowX.set(index, (Object)0L);
        } else if (dt.equals((Object)DataType.StringType)) {
            newRowX.set(index, (Object)" ");
        } else if (dt.equals((Object)DataType.TimestampType)) {
            newRowX.set(index, null);
        }
    }
}

