/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.DiffAllocServiceNew;
import kd.fi.calx.algox.diff.function.DealAlgoNoUpdateCalFields;
import kd.fi.calx.algox.diff.function.NegativeUnPriceDmsValFilter;
import kd.fi.calx.algox.diff.function.NegativeUnitPriceCreateInStdBill;
import kd.fi.calx.algox.diff.function.NegativeUnitPriceCreateOutStdBill;
import kd.fi.calx.algox.diff.function.TestFunction;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.diff.helper.ExFieldHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.JsonEntryServiceHelper;
import kd.fi.calx.algox.helper.PeriodHelper;
import kd.fi.calx.algox.util.CommonUtils;

public class NegativeUnitPriceProcess {
    private static final Log logger = LogFactory.getLog(NegativeUnitPriceProcess.class);

    public void negativeUnitPriceDeal(DiffAllocParamter param, DiffAllocParamterEntry paramEntry, String calcDirection) {
        DataSet balActualCostDs;
        boolean inBizType = "in".equals(calcDirection);
        if (inBizType && paramEntry.getMatIdSet() != null) {
            paramEntry.setInitMatIdSet(paramEntry.getMatIdSet());
        }
        HashSet<Long> stdIds = new HashSet<Long>(16);
        logger.info("\u8fdb\u5165\u5b9e\u9645\u6210\u672c\u8d1f\u5355\u4ef7\u5904\u7406,\u5f53\u524d\u6279\u7269\u6599==>{},\u5f53\u524d\u8ba1\u7b97\u65b9\u5411\u5165\u5e93\u65b9\u5411==>{},\u5206\u644a\u7ef4\u5ea6==>{}", new Object[]{paramEntry.getInitMatIdSet(), inBizType, paramEntry.getNegativeAllocDimKeyCols()});
        String diffAllocDims = DiffAllocHelper.mergDiffAllocDims(param.getAllocDims(), param.getEquationSetDims());
        if (!diffAllocDims.contains("material")) {
            diffAllocDims = diffAllocDims + ",material";
        }
        if ((balActualCostDs = this.getBalActualCost(diffAllocDims, paramEntry)) != null) {
            DataSet inComeStandCostDs = this.getInAndOutComeStandCost(diffAllocDims, paramEntry, "0");
            DataSet inComeDiffDataSet = this.getInAndOutComeDiff(diffAllocDims, paramEntry, "0");
            DataSet actCostDs = balActualCostDs.union(new DataSet[]{inComeStandCostDs, inComeDiffDataSet});
            DataSet actCostCopy = actCostDs.copy();
            if (inBizType) {
                actCostDs = actCostDs.filter((FilterFunction)new NegativeUnPriceDmsValFilter(actCostDs.getRowMeta(), param, paramEntry));
                actCostDs = actCostDs.groupBy(diffAllocDims.split(",")).sum("balqty").sum("balactcost").sum("standardcost").sum("qty").sum("diff").finish();
                actCostDs = actCostDs.select(diffAllocDims + ",qty,balqty,balactcost,balactcost+standardcost+diff as actcost,balqty+qty as actqty").filter("actqty<>0");
                actCostDs = actCostDs.select(diffAllocDims + ",qty,balqty,balactcost,actcost/actqty as unitactcost").filter("unitactcost<0");
            } else {
                actCostDs = this.getOutDirectionDs(param, diffAllocDims, paramEntry, actCostDs);
            }
            if (inBizType && actCostDs.isEmpty()) {
                param.setExeOutNegative(false);
                inBizType = false;
                actCostDs = this.getOutDirectionDs(param, diffAllocDims, paramEntry, actCostCopy);
            } else {
                actCostCopy.close();
            }
            if (!actCostDs.isEmpty()) {
                HashSet<String> keyCols = new HashSet<String>(16);
                HashSet<Object> materials = new HashSet<Object>(16);
                for (Row actCostD : actCostDs.copy()) {
                    materials.add(actCostD.getLong("material"));
                }
                Map<String, String> stdHeadData = this.buildStdHeadData(diffAllocDims, paramEntry, materials);
                DataSet perStandCostBalDetailDs = this.getStandCostBalDetail(diffAllocDims, paramEntry, materials);
                DataSet stdCostDiffBillDetailDs = this.getInStdCostDiffBillDetail(actCostDs, inBizType, diffAllocDims, paramEntry, materials);
                if (inBizType) {
                    DynamicObject billType = (DynamicObject)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)paramEntry.getCalOrgId(), (Long)0L, (String)"handcostadjustbilltype");
                    if (billType == null) {
                        QFilter q = new QFilter("number", "=", (Object)"im_PurInBill_STD_BT_S");
                        billType = QueryServiceHelper.queryOne((String)"bos_billtype", (String)"id", (QFilter[])q.toArray());
                    }
                    DataSet detailsUnionDs = perStandCostBalDetailDs.union(stdCostDiffBillDetailDs);
                    detailsUnionDs = detailsUnionDs.groupBy((diffAllocDims + ",costelement,costsubelement").split(",")).sum("diff_g_bal").sum("diff_h_bal").sum("diff_k_bal").sum("diff_p_bal").sum("diff_q_bal").sum("diff_r_bal").sum("diff_m_bal").sum("diff_s_bal").sum("diff_t_bal").sum("diff_c_bal").sum("diff_x_bal").sum("diff_w_bal").sum("diff_y_bal").sum("ddiff_g").sum("ddiff_h").sum("ddiff_k").sum("ddiff_p").sum("ddiff_q").sum("ddiff_r").sum("ddiff_m").sum("ddiff_s").sum("ddiff_t").sum("ddiff_c").sum("ddiff_x").sum("ddiff_w").sum("ddiff_y").finish();
                    JoinDataSet joinDataSet = detailsUnionDs.join(actCostDs);
                    for (String field : diffAllocDims.split(",")) {
                        joinDataSet.on(field, field);
                    }
                    detailsUnionDs = joinDataSet.select(detailsUnionDs.getRowMeta().getFieldNames(), new String[]{"balqty", "balactcost", "qty"}).finish();
                    detailsUnionDs = detailsUnionDs.groupBy(diffAllocDims.split(",")).reduceGroup((ReduceGroupFunctionWithCollector)new NegativeUnitPriceCreateInStdBill(param.getPrecision(), stdHeadData, diffAllocDims, keyCols, paramEntry.getEndDate(), paramEntry.getPeriodId(), billType.getLong("id")));
                    for (Row detailsUnionD : detailsUnionDs) {
                        stdIds.add(detailsUnionD.getLong("stdId"));
                    }
                    if (!keyCols.isEmpty()) {
                        Set<Long> currCrossEntryIDs = this.deleteStdBillByCalcBefore(param, paramEntry, keyCols, materials, stdIds);
                        param.getStdBillIds().addAll(stdIds);
                        DiffAllocServiceNew service = new DiffAllocServiceNew();
                        param.setNegativeCalc(true);
                        param.setCrossRecordEntryIds(currCrossEntryIDs);
                        paramEntry.setMatIdSet(materials);
                        paramEntry.setAllocDimKeyCols(keyCols);
                        service.doAlloc(param, paramEntry, null);
                    }
                } else {
                    DynamicObject billType = (DynamicObject)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)paramEntry.getCalOrgId(), (Long)0L, (String)"costsumbilltype");
                    if (billType == null) {
                        QFilter q = new QFilter("number", "=", (Object)"im_PurInBill_STD_BT_S");
                        billType = QueryServiceHelper.queryOne((String)"bos_billtype", (String)"id", (QFilter[])q.toArray());
                    }
                    perStandCostBalDetailDs = perStandCostBalDetailDs.addField("0.00", "outdiff_g").addField("0.00", "outdiff_h").addField("0.00", "outdiff_k").addField("0.00", "outdiff_p").addField("0.00", "outdiff_q").addField("0.00", "outdiff_r").addField("0.00", "outdiff_m").addField("0.00", "outdiff_s").addField("0.00", "outdiff_t").addField("0.00", "outdiff_c").addField("0.00", "outdiff_x").addField("0.00", "outdiff_w").addField("0.00", "outdiff_y");
                    stdCostDiffBillDetailDs = stdCostDiffBillDetailDs.addField("0.00", "outdiff_g").addField("0.00", "outdiff_h").addField("0.00", "outdiff_k").addField("0.00", "outdiff_p").addField("0.00", "outdiff_q").addField("0.00", "outdiff_r").addField("0.00", "outdiff_m").addField("0.00", "outdiff_s").addField("0.00", "outdiff_t").addField("0.00", "outdiff_c").addField("0.00", "outdiff_x").addField("0.00", "outdiff_w").addField("0.00", "outdiff_y");
                    DataSet outStdCostDiffBillDetail = this.getOutStdCostDiffBillDetail(diffAllocDims, paramEntry, materials);
                    DataSet allDetailsDs = perStandCostBalDetailDs.union(new DataSet[]{stdCostDiffBillDetailDs, outStdCostDiffBillDetail});
                    allDetailsDs = allDetailsDs.groupBy((diffAllocDims + ",costelement,costsubelement").split(",")).sum("diff_g_bal").sum("diff_h_bal").sum("diff_k_bal").sum("diff_p_bal").sum("diff_q_bal").sum("diff_r_bal").sum("diff_m_bal").sum("diff_s_bal").sum("diff_t_bal").sum("diff_c_bal").sum("diff_x_bal").sum("diff_w_bal").sum("diff_y_bal").sum("ddiff_g").sum("ddiff_h").sum("ddiff_k").sum("ddiff_p").sum("ddiff_q").sum("ddiff_r").sum("ddiff_m").sum("ddiff_s").sum("ddiff_t").sum("ddiff_c").sum("ddiff_x").sum("ddiff_w").sum("ddiff_y").sum("outdiff_g").sum("outdiff_h").sum("outdiff_k").sum("outdiff_p").sum("outdiff_q").sum("outdiff_r").sum("outdiff_m").sum("outdiff_s").sum("outdiff_t").sum("outdiff_c").sum("outdiff_x").sum("outdiff_w").sum("outdiff_y").finish();
                    JoinDataSet joinDataSet = allDetailsDs.join(actCostDs);
                    for (String field : diffAllocDims.split(",")) {
                        joinDataSet.on(field, field);
                    }
                    allDetailsDs = joinDataSet.select(allDetailsDs.getRowMeta().getFieldNames(), new String[]{"qty", "balqty", "outqty"}).finish();
                    allDetailsDs = allDetailsDs.groupBy(diffAllocDims.split(",")).reduceGroup((ReduceGroupFunctionWithCollector)new NegativeUnitPriceCreateOutStdBill(param.getPrecision(), stdHeadData, diffAllocDims, keyCols, paramEntry.getEndDate(), paramEntry.getPeriodId(), billType.getLong("id")));
                    for (Row allDetailsD : allDetailsDs) {
                        stdIds.add(allDetailsD.getLong("stdId"));
                    }
                    if (!stdIds.isEmpty()) {
                        param.getStdBillIds().addAll(stdIds);
                    }
                }
            }
        }
    }

    private DataSet getInStdCostDiffBillDetail(DataSet actCostDs, boolean inBizType, String diffAllocDims, DiffAllocParamterEntry paramEntry, Set<Object> materials) {
        boolean balNeUnitPrice = false;
        if (inBizType && !(actCostDs = actCostDs.filter("balqty<>0").select(diffAllocDims + ",balactcost/balqty as unitprice").filter("unitprice<0")).isEmpty()) {
            balNeUnitPrice = true;
        }
        QFilter filter = new QFilter("costaccount", "=", (Object)paramEntry.getCostAccountId());
        filter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        filter.and("period", "=", (Object)paramEntry.getPeriodId());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("isupdatecost", "=", (Object)true);
        filter.and("createtype", "not in", (Object)Sets.newHashSet((Object[])new String[]{"C1", "G"}));
        filter.and("entryentity.accounttype", "=", (Object)"D");
        filter.and("entryentity.material", "in", materials);
        filter.and("entryentity.queuetype", "=", (Object)"0");
        String dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_stdcostdiffbill", diffAllocDims, "");
        if (inBizType && balNeUnitPrice) {
            dySelectFields = dySelectFields + ",srcsys as srcsys";
        }
        String jsonSelectFields = dySelectFields + ",entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,entryentity.subentryentity.ddiff_g*entryentity.signnum as ddiff_g,entryentity.subentryentity.ddiff_h*entryentity.signnum as ddiff_h,entryentity.subentryentity.ddiff_k*entryentity.signnum as ddiff_k,entryentity.subentryentity.ddiff_p*entryentity.signnum as ddiff_p,entryentity.subentryentity.ddiff_q*entryentity.signnum as ddiff_q,entryentity.subentryentity.ddiff_r*entryentity.signnum as ddiff_r,entryentity.subentryentity.ddiff_m*entryentity.signnum as ddiff_m,entryentity.subentryentity.ddiff_s*entryentity.signnum as ddiff_s,entryentity.subentryentity.ddiff_t*entryentity.signnum as ddiff_t,entryentity.subentryentity.ddiff_c*entryentity.signnum as ddiff_c,entryentity.subentryentity.ddiff_x*entryentity.signnum as ddiff_x,entryentity.subentryentity.ddiff_w*entryentity.signnum as ddiff_w,entryentity.subentryentity.ddiff_y*entryentity.signnum as ddiff_y,entryentity.noupdatecalfields as noupdatecalfields";
        DataSet allDataSet = JsonEntryServiceHelper.queryJsonSubEntryDataSet("kd.fi.calx.algox.helper.diff.NegativeUnitPriceProcess.getStdCostDiffBillDetail", "cal_stdcostdiffbill", jsonSelectFields, "entryentity.subentryentity", filter.toArray(), null);
        String[] fieldNames = allDataSet.getRowMeta().getFieldNames();
        StringJoiner joiner = new StringJoiner(",");
        for (String fieldName : fieldNames) {
            if (fieldName.equalsIgnoreCase("NOUPDATECALFIELDS")) continue;
            joiner.add(fieldName.toLowerCase());
        }
        String selectSql = joiner + ",noupdatecalfields";
        allDataSet = allDataSet.select(selectSql);
        allDataSet = allDataSet.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(allDataSet.getRowMeta()));
        String groupField = diffAllocDims + ",costelement,costsubelement";
        if (inBizType && balNeUnitPrice) {
            JoinDataSet joinDataSet = allDataSet.leftJoin(actCostDs);
            for (String field : diffAllocDims.split(",")) {
                joinDataSet.on(field, field);
            }
            allDataSet = joinDataSet.select(allDataSet.getRowMeta().getFieldNames(), new String[]{"unitprice"}).finish();
            allDataSet = allDataSet.filter("(unitprice=null) or (unitprice !=null and srcsys='A')");
        }
        allDataSet = allDataSet.groupBy(groupField.split(",")).sum("ddiff_g").sum("ddiff_h").sum("ddiff_k").sum("ddiff_p").sum("ddiff_q").sum("ddiff_r").sum("ddiff_m").sum("ddiff_s").sum("ddiff_t").sum("ddiff_c").sum("ddiff_x").sum("ddiff_w").sum("ddiff_y").finish();
        allDataSet = allDataSet.addField("0.00", "diff_g_bal").addField("0.00", "diff_h_bal").addField("0.00", "diff_k_bal").addField("0.00", "diff_p_bal").addField("0.00", "diff_q_bal").addField("0.00", "diff_r_bal").addField("0.00", "diff_m_bal").addField("0.00", "diff_s_bal").addField("0.00", "diff_t_bal").addField("0.00", "diff_c_bal").addField("0.00", "diff_x_bal").addField("0.00", "diff_w_bal").addField("0.00", "diff_y_bal");
        return allDataSet.select(groupField + ",diff_g_bal,diff_h_bal,diff_k_bal,diff_p_bal,diff_q_bal,diff_r_bal,diff_m_bal,diff_s_bal,diff_t_bal,diff_c_bal,diff_x_bal,diff_w_bal,diff_y_bal,ddiff_g,ddiff_h,ddiff_k,ddiff_p,ddiff_q,ddiff_r,ddiff_m,ddiff_s,ddiff_t,ddiff_c,ddiff_x,ddiff_w,ddiff_y");
    }

    private DataSet getOutStdCostDiffBillDetail(String diffAllocDims, DiffAllocParamterEntry paramEntry, Set<Object> materials) {
        QFilter filter = new QFilter("costaccount", "=", (Object)paramEntry.getCostAccountId());
        filter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        filter.and("period", "=", (Object)paramEntry.getPeriodId());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("isupdatecost", "=", (Object)true);
        filter.and("createtype", "not in", (Object)Sets.newHashSet((Object[])new String[]{"C1", "G"}));
        filter.and("entryentity.accounttype", "=", (Object)"D");
        filter.and("entryentity.material", "in", materials);
        filter.and("entryentity.queuetype", "=", (Object)"1");
        String dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_stdcostdiffbill", diffAllocDims, "");
        String jsonSelectFields = dySelectFields + ",entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,entryentity.subentryentity.ddiff_g*entryentity.signnum as ddiff_g,entryentity.subentryentity.ddiff_h*entryentity.signnum as ddiff_h,entryentity.subentryentity.ddiff_k*entryentity.signnum as ddiff_k,entryentity.subentryentity.ddiff_p*entryentity.signnum as ddiff_p,entryentity.subentryentity.ddiff_q*entryentity.signnum as ddiff_q,entryentity.subentryentity.ddiff_r*entryentity.signnum as ddiff_r,entryentity.subentryentity.ddiff_m*entryentity.signnum as ddiff_m,entryentity.subentryentity.ddiff_s*entryentity.signnum as ddiff_s,entryentity.subentryentity.ddiff_t*entryentity.signnum as ddiff_t,entryentity.subentryentity.ddiff_c*entryentity.signnum as ddiff_c,entryentity.subentryentity.ddiff_x*entryentity.signnum as ddiff_x,entryentity.subentryentity.ddiff_w*entryentity.signnum as ddiff_w,entryentity.subentryentity.ddiff_y*entryentity.signnum as ddiff_y,entryentity.noupdatecalfields as noupdatecalfields";
        DataSet allDataSet = JsonEntryServiceHelper.queryJsonSubEntryDataSet("kd.fi.calx.algox.helper.diff.NegativeUnitPriceProcess.getStdCostDiffBillDetail", "cal_stdcostdiffbill", jsonSelectFields, "entryentity.subentryentity", filter.toArray(), null);
        allDataSet = allDataSet.select(diffAllocDims + ",costelement,costsubelement,ddiff_g as outdiff_g,ddiff_h as outdiff_h,ddiff_k as outdiff_k,ddiff_p as outdiff_p,ddiff_q as outdiff_q,ddiff_r as outdiff_r,ddiff_m as outdiff_m,ddiff_s as outdiff_s,ddiff_t as outdiff_t,ddiff_c as outdiff_c,ddiff_x as outdiff_x,ddiff_w as outdiff_w,ddiff_y as outdiff_y,noupdatecalfields");
        allDataSet = allDataSet.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(allDataSet.getRowMeta()));
        String groupField = diffAllocDims + ",costelement,costsubelement";
        allDataSet = allDataSet.groupBy(groupField.split(",")).sum("outdiff_g").sum("outdiff_h").sum("outdiff_k").sum("outdiff_p").sum("outdiff_q").sum("outdiff_r").sum("outdiff_m").sum("outdiff_s").sum("outdiff_t").sum("outdiff_c").sum("outdiff_x").sum("outdiff_w").sum("outdiff_y").finish();
        allDataSet = allDataSet.addField("0.00", "diff_g_bal").addField("0.00", "diff_h_bal").addField("0.00", "diff_k_bal").addField("0.00", "diff_p_bal").addField("0.00", "diff_q_bal").addField("0.00", "diff_r_bal").addField("0.00", "diff_m_bal").addField("0.00", "diff_s_bal").addField("0.00", "diff_t_bal").addField("0.00", "diff_c_bal").addField("0.00", "diff_x_bal").addField("0.00", "diff_w_bal").addField("0.00", "diff_y_bal").addField("0.00", "ddiff_g").addField("0.00", "ddiff_p").addField("0.00", "ddiff_h").addField("0.00", "ddiff_k").addField("0.00", "ddiff_q").addField("0.00", "ddiff_r").addField("0.00", "ddiff_m").addField("0.00", "ddiff_s").addField("0.00", "ddiff_t").addField("0.00", "ddiff_c").addField("0.00", "ddiff_x").addField("0.00", "ddiff_w").addField("0.00", "ddiff_y");
        return allDataSet.select(groupField + ",diff_g_bal,diff_h_bal,diff_k_bal,diff_p_bal,diff_q_bal,diff_r_bal,diff_m_bal,diff_s_bal,diff_t_bal,diff_c_bal,diff_x_bal,diff_w_bal,diff_y_bal,ddiff_g,ddiff_h,ddiff_k,ddiff_p,ddiff_q,ddiff_r,ddiff_m,ddiff_s,ddiff_t,ddiff_c,ddiff_x,ddiff_w,ddiff_y,outdiff_g,outdiff_h,outdiff_k,outdiff_p,outdiff_q,outdiff_r,outdiff_m,outdiff_s,outdiff_t,outdiff_c,outdiff_x,outdiff_w,outdiff_y");
    }

    private DataSet getInAndOutComeDiff(String diffAllocDims, DiffAllocParamterEntry paramEntry, String queueType) {
        QFilter filter = new QFilter("costaccount", "=", (Object)paramEntry.getCostAccountId());
        filter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        filter.and("period", "=", (Object)paramEntry.getPeriodId());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("isupdatecost", "=", (Object)true);
        filter.and("createtype", "not in", (Object)Sets.newHashSet((Object[])new String[]{"C1", "G"}));
        filter.and("entryentity.accounttype", "=", (Object)"D");
        if (!paramEntry.getInitMatIdSet().isEmpty()) {
            filter.and("entryentity.material", "in", paramEntry.getInitMatIdSet());
        }
        filter.and("entryentity.queuetype", "=", (Object)queueType);
        String dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_stdcostdiffbill", diffAllocDims, "");
        DataSet stdCostBalanceData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.helper.diff.NegativeUnitPriceProcess.getInComeDiff", (String)"cal_stdcostdiffbill", (String)(dySelectFields + ",0.00 as balqty,0.00 as balactcost,0.00 as standardcost,0.00 as qty,entryentity.adjustamt*entryentity.signnum as diff,entryentity.noupdatecalfields as noupdatecalfields"), (QFilter[])filter.toArray(), null);
        stdCostBalanceData = stdCostBalanceData.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(stdCostBalanceData.getRowMeta()));
        stdCostBalanceData = stdCostBalanceData.groupBy(diffAllocDims.split(",")).sum("balqty").sum("balactcost").sum("standardcost").sum("qty").sum("diff").finish();
        return stdCostBalanceData;
    }

    public DataSet getInAndOutComeStandCost(String diffAllocDims, DiffAllocParamterEntry paramEntry, String queueType) {
        QFilter filter = new QFilter("costaccount", "=", (Object)paramEntry.getCostAccountId());
        filter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        filter.and("period", "=", (Object)paramEntry.getPeriodId());
        filter.and("isinitbill", "=", (Object)false);
        filter.and("issplitcreate", "=", (Object)false);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("entry.queuetype", "=", (Object)queueType);
        if (!paramEntry.getInitMatIdSet().isEmpty()) {
            filter.and("entry.material", "in", paramEntry.getInitMatIdSet());
        }
        filter.and("entry.accounttype", "=", (Object)"D");
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_costrecord_subentity", diffAllocDims, "");
        dySelectStr = dySelectStr + ",0.00 as balqty,0.00 as balactcost,entry.standardcost*entry.signnum as standardcost,entry.baseqty*entry.signnum qty,0.00 as diff,entry.noupdatecalfields noupdatecalfields";
        DataSet stdCostBalanceData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.helper.diff.NegativeUnitPriceProcess.getInComeStandCost", (String)"cal_costrecord_subentity", (String)dySelectStr, (QFilter[])filter.toArray(), null);
        stdCostBalanceData = stdCostBalanceData.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(stdCostBalanceData.getRowMeta()));
        stdCostBalanceData = stdCostBalanceData.groupBy(diffAllocDims.split(",")).sum("balqty").sum("balactcost").sum("standardcost").sum("qty").sum("diff").finish();
        if ("1".equals(queueType)) {
            QFilter stdFilter = new QFilter("costaccount", "=", (Object)paramEntry.getCostAccountId());
            stdFilter.and("calorg", "=", (Object)paramEntry.getCalOrgId());
            stdFilter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
            stdFilter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
            stdFilter.and("period", "=", (Object)paramEntry.getPeriodId());
            stdFilter.and("billstatus", "=", (Object)"C");
            stdFilter.and("isupdatecost", "=", (Object)true);
            stdFilter.and("createtype", "=", (Object)"G");
            stdFilter.and("entryentity.accounttype", "=", (Object)"D");
            if (!paramEntry.getInitMatIdSet().isEmpty()) {
                stdFilter.and("entryentity.material.id", "in", paramEntry.getMatIdSet());
            }
            stdFilter.and("entryentity.queuetype", "=", (Object)queueType);
            String dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_stdcostdiffbill", diffAllocDims, "");
            DataSet stdCostBillData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.helper.diff.NegativeUnitPriceProcess.getInComeDiff", (String)"cal_stdcostdiffbill", (String)(dySelectFields + ",0.00 as balqty,0.00 as balactcost,entryentity.adjustamt*entryentity.signnum as standardcost,0.00 as qty,0.00 as diff,entryentity.noupdatecalfields as noupdatecalfields"), (QFilter[])stdFilter.toArray(), null);
            stdCostBillData = stdCostBillData.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(stdCostBillData.getRowMeta()));
            DataSet dataSet = stdCostBalanceData.union(stdCostBillData);
            dataSet = dataSet.groupBy(diffAllocDims.split(",")).sum("balqty").sum("balactcost").sum("standardcost").sum("qty").sum("diff").finish();
            return dataSet;
        }
        return stdCostBalanceData;
    }

    public DataSet getBalActualCost(String diffAllocDims, DiffAllocParamterEntry paramEntry) {
        List<Integer> historyPeriodNumbers = PeriodHelper.getHistoryPeriodNumbers(paramEntry.getCostAccountId(), paramEntry.getPeriodId(), "<");
        int periodBatchSize = CalDbParamServiceHelper.getInteger("period_batch_size");
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_bal", diffAllocDims, "");
        String selectStr = dySelectStr + ",actualcost_bal as balactcost,0.00 as standardcost,0.00 as qty,0.00 as diff";
        DataSet dataSet = null;
        Boolean balCompress = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        for (List periods : Lists.partition(historyPeriodNumbers, (int)periodBatchSize)) {
            QFilter filter = new QFilter("period", "in", (Object)periods);
            filter.and("endperiod", ">=", (Object)paramEntry.getPeriod());
            filter.and("costaccount", "=", (Object)paramEntry.getCostAccountId());
            filter.and("accounttype", "=", (Object)"D");
            if (!paramEntry.getInitMatIdSet().isEmpty()) {
                filter.and("material", "in", paramEntry.getInitMatIdSet());
            }
            if (balCompress.booleanValue()) {
                qFilterList.add(filter);
                continue;
            }
            if (dataSet == null) {
                dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.helper.diff.NegativeUnitPriceProcess.getBalActualCost", (String)"cal_bal", (String)selectStr, (QFilter[])filter.toArray(), (String)null);
                continue;
            }
            DataSet result = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.helper.diff.NegativeUnitPriceProcess.getBalActualCost", (String)"cal_bal", (String)selectStr, (QFilter[])filter.toArray(), (String)null);
            dataSet = dataSet.union(result);
        }
        if (balCompress.booleanValue()) {
            String cacheId = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalUncompressService", (String)"getBalancDataSetDetail", (Object[])new Object[]{false, false, null, qFilterList});
            DataSet result = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)"getBalanceDmData"), true);
            dataSet = result = result.select(selectStr);
        }
        if (dataSet == null) {
            return dataSet;
        }
        QFilter qFilter = new QFilter("period", "<", (Object)paramEntry.getPeriod());
        qFilter.and("endperiod", ">=", (Object)paramEntry.getPeriod());
        qFilter.and("costaccount", "=", (Object)paramEntry.getCostAccountId());
        qFilter.and("accounttype", "=", (Object)"D");
        if (!paramEntry.getInitMatIdSet().isEmpty()) {
            qFilter.and("material", "in", paramEntry.getInitMatIdSet());
        }
        qFilter.and("costsubelement.id", "=", (Object)773175233367685120L);
        DataSet qtyDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.helper.diff.NegativeUnitPriceProcess.getBalActualCost", (String)"cal_bal", (String)(dySelectStr + ",baseqty_bal as balqty"), (QFilter[])qFilter.toArray(), (String)null);
        qtyDataSet = qtyDataSet.groupBy(diffAllocDims.split(",")).sum("balqty").finish();
        JoinDataSet join = dataSet.leftJoin(qtyDataSet);
        for (String field : diffAllocDims.split(",")) {
            join.on(field, field);
        }
        dataSet = join.select(dataSet.getRowMeta().getFieldNames(), new String[]{"balqty"}).finish();
        dataSet = dataSet.select(diffAllocDims + ",balqty,balactcost,standardcost,qty,diff");
        return dataSet.groupBy(diffAllocDims.split(",")).max("balqty").sum("balactcost").sum("standardcost").sum("qty").sum("diff").finish();
    }

    private DataSet getStandCostBalDetail(String diffAllocDims, DiffAllocParamterEntry paramEntry, Set<Object> materials) {
        QFilter filter = new QFilter("period", "<", (Object)paramEntry.getPeriod());
        filter.and("endperiod", ">=", (Object)paramEntry.getPeriod());
        filter.and("costaccount", "=", (Object)paramEntry.getCostAccountId());
        filter.and("material", "in", materials);
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_standcost_bal", diffAllocDims, "");
        String selectStr = dySelectStr + ",costelement,costsubelement,diff_g_bal,diff_h_bal,diff_k_bal,diff_p_bal,diff_q_bal,diff_r_bal,diff_m_bal,diff_s_bal,diff_t_bal,diff_c_bal,diff_x_bal,diff_w_bal,diff_y_bal";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.helper.diff.NegativeUnitPriceProcess.getStandCostBalDetail", (String)"cal_standcost_bal", (String)selectStr, (QFilter[])filter.toArray(), null);
        String groupField = diffAllocDims + ",costelement,costsubelement";
        dataSet = dataSet.groupBy(groupField.split(",")).sum("diff_g_bal").sum("diff_h_bal").sum("diff_k_bal").sum("diff_p_bal").sum("diff_q_bal").sum("diff_r_bal").sum("diff_m_bal").sum("diff_s_bal").sum("diff_t_bal").sum("diff_c_bal").sum("diff_x_bal").sum("diff_w_bal").sum("diff_y_bal").finish();
        dataSet = dataSet.addField("0.00", "ddiff_g").addField("0.00", "ddiff_h").addField("0.00", "ddiff_k").addField("0.00", "ddiff_p").addField("0.00", "ddiff_q").addField("0.00", "ddiff_r").addField("0.00", "ddiff_m").addField("0.00", "ddiff_s").addField("0.00", "ddiff_t").addField("0.00", "ddiff_c").addField("0.00", "ddiff_x").addField("0.00", "ddiff_w").addField("0.00", "ddiff_y");
        return dataSet.select(groupField + ",diff_g_bal,diff_h_bal,diff_k_bal,diff_p_bal,diff_q_bal,diff_r_bal,diff_m_bal,diff_s_bal,diff_t_bal,diff_c_bal,diff_x_bal,diff_w_bal,diff_y_bal,ddiff_g,ddiff_h,ddiff_k,ddiff_p,ddiff_q,ddiff_r,ddiff_m,ddiff_s,ddiff_t,ddiff_c,ddiff_x,ddiff_w,ddiff_y");
    }

    private DataSetX test(DataSetX testX) {
        TestFunction test = new TestFunction(testX.getRowMeta());
        return testX.reduceGroup((GroupReduceFunction)test);
    }

    public Map<String, String> buildStdHeadData(String diffAllocDims, DiffAllocParamterEntry entry, Set<Object> matIds) {
        HashMap<String, String> dataMap = new HashMap<String, String>(1000);
        QFilter filter = new QFilter("period", "<=", (Object)entry.getPeriod());
        filter.and("endperiod", ">", (Object)entry.getPeriod());
        filter.and("costaccount", "=", (Object)entry.getCostAccountId());
        filter.and("material", "in", matIds);
        filter.and("costsubelement", "=", (Object)773175233367685120L);
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_bal", diffAllocDims, "");
        String selectStr = dySelectStr + ",calorg as org,costaccount as account,currency,storageorgunit as storageorg,baseunit,invtype,invstatus,owner,calrange,caldimension,period,warehouse as store,location as position,stocktype";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_bal", (String)selectStr, (QFilter[])filter.toArray(), (String)null);
        DataSet result = dataSet.groupBy(diffAllocDims.split(",")).max("org").max("account").max("currency").max("storageorg").max("material").max("baseunit").max("invtype").max("invstatus").max("owner").max("calrange").max("caldimension").max("period").max("store").max("position").max("stocktype").finish();
        for (Row row : result) {
            StringBuilder key = new StringBuilder();
            for (String field : diffAllocDims.split(",")) {
                key.append(row.getString(field)).append("@");
            }
            String mapKey = key.substring(0, key.toString().length() - 1);
            String value = row.getString("org") + "@" + row.getString("account") + "@" + row.getString("currency") + "@" + row.getString("storageorg") + "@" + row.getString("material") + "@" + row.getString("baseunit") + "@" + row.getString("invtype") + "@" + row.getString("invstatus") + "@" + row.getString("owner") + "@" + row.getString("calrange") + "@" + row.getString("caldimension") + "@" + row.getString("period") + "@" + row.getString("store") + "@" + row.getString("position") + "@" + row.getString("stocktype");
            dataMap.put(mapKey, value);
        }
        return dataMap;
    }

    private Set<Long> deleteStdBillByCalcBefore(DiffAllocParamter param, DiffAllocParamterEntry paramEntry, Set<String> keyCols, Set<Object> materials, Set<Long> stds) {
        HashSet<Long> currCrossEntryIDs = new HashSet<Long>(16);
        QFilter filter = new QFilter("id", "not in", stds);
        filter.and("srcsys", "!=", (Object)"B");
        filter.and("ischargeoffed", "=", (Object)Boolean.FALSE);
        filter.and("ischargeoff", "=", (Object)Boolean.FALSE);
        filter.and("createtype", "in", (Object)Sets.newHashSet((Object[])new String[]{"W", "G"}));
        filter.and("entryentity.material", "in", materials);
        filter.and("costaccount", "=", (Object)paramEntry.getCostAccountId());
        filter.and("calorg", "=", (Object)paramEntry.getCalOrgId());
        filter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        filter.and("period", "=", (Object)paramEntry.getPeriodId());
        filter.and("entryentity.accounttype", "=", (Object)"D");
        String diffAllocDims = DiffAllocHelper.mergDiffAllocDims(param.getAllocDims(), param.getEquationSetDims());
        if (!diffAllocDims.contains("material")) {
            diffAllocDims = diffAllocDims + ",material";
        }
        String dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_stdcostdiffbill", diffAllocDims, "");
        dySelectFields = dySelectFields + ",id,remark,entryentity.id entryid,entryentity.invbillentryid invbillentryid,entryentity.noupdatecalfields noupdatecalfields";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.helper.diff.NegativeUnitPriceProcess.deleteStdBillByCalcBefore", (String)"cal_stdcostdiffbill", (String)dySelectFields, (QFilter[])filter.toArray(), null);
        if ((dataSet = dataSet.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(dataSet.getRowMeta()))).isEmpty()) {
            return currCrossEntryIDs;
        }
        String remark = ResManager.loadKDString((String)"\u8de8\u671f", (String)"CostAdjustBillHelper_0", (String)"fi-calx-algox", (Object[])new Object[0]);
        String unDiffAllocRemark = ResManager.loadKDString((String)"\u672a\u5206\u644a\u5dee\u5f02\u5dee\u5f02\u5206\u644a\u751f\u6210", (String)"UnDiffAllocWizardCostAdjustHelper_0", (String)"fi-calx-algox", (Object[])new Object[0]);
        HashSet<Long> stdEntryIds = new HashSet<Long>(16);
        HashSet<Long> stdIds = new HashSet<Long>(16);
        for (Row row : dataSet) {
            Object remarkContains;
            String valuesKeyCol = this.getValuesKeyCol(row, diffAllocDims);
            if (!keyCols.contains(valuesKeyCol) || ((String)(remarkContains = row.getString("remark"))).contains(unDiffAllocRemark)) continue;
            if (((String)remarkContains).contains(remark)) {
                currCrossEntryIDs.add(row.getLong("invbillentryid"));
                continue;
            }
            stdEntryIds.add(row.getLong("entryid"));
            stdIds.add(row.getLong("id"));
        }
        if (!stdEntryIds.isEmpty()) {
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete t_cal_stdcostdiffentry where fentryid in (" + this.getStringIds(stdEntryIds) + ")"));
            QFilter stdFilter = new QFilter("id", "in", stdIds);
            stdFilter.and("costaccount", "=", (Object)paramEntry.getCostAccountId());
            stdFilter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
            stdFilter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
            DataSet stdDs = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.helper.diff.NegativeUnitPriceProcess.deleteStdBillByCalcBefore", (String)"cal_stdcostdiffbill", (String)"id,entryentity.id entryid", (QFilter[])new QFilter[]{stdFilter}, null);
            HashSet<Long> delStdIds = new HashSet<Long>(16);
            for (Row stdD : stdDs) {
                if (stdD.getLong("entryid") != 0L) continue;
                delStdIds.add(stdD.getLong("id"));
            }
            if (!delStdIds.isEmpty()) {
                DeleteServiceHelper.delete((String)"cal_stdcostdiffbill", (QFilter[])new QFilter[]{new QFilter("id", "in", delStdIds)});
            }
            QFilter groupFilter = new QFilter("entryentity.srcbillentryid", "in", stdEntryIds);
            groupFilter.and("costaccount", "=", (Object)paramEntry.getCostAccountId());
            groupFilter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
            groupFilter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
            DataSet groupDs = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.helper.diff.NegativeUnitPriceProcess.deleteStdBillByCalcBefore", (String)"cal_stdcostdiffbill", (String)"id,entryentity.id entryid", (QFilter[])new QFilter[]{groupFilter}, null);
            if (!groupDs.isEmpty()) {
                HashSet<Long> delGrpEntryIds = new HashSet<Long>(16);
                HashSet<Long> deGrpStdIds = new HashSet<Long>(16);
                for (Row groupD : groupDs) {
                    delGrpEntryIds.add(groupD.getLong("entryid"));
                    deGrpStdIds.add(groupD.getLong("id"));
                }
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete t_cal_stdcostdiffentry where fentryid in (" + this.getStringIds(delGrpEntryIds) + ")"));
                DataSet grpStdDs = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.helper.diff.NegativeUnitPriceProcess.deleteStdBillByCalcBefore", (String)"cal_stdcostdiffbill", (String)"id,entryentity.id entryid", (QFilter[])new QFilter[]{new QFilter("id", "in", deGrpStdIds)}, null);
                HashSet<Long> delIds = new HashSet<Long>(16);
                for (Row stdD : grpStdDs) {
                    if (stdD.getLong("entryid") != 0L) continue;
                    delIds.add(stdD.getLong("id"));
                }
                if (!delIds.isEmpty()) {
                    DeleteServiceHelper.delete((String)"cal_stdcostdiffbill", (QFilter[])new QFilter[]{new QFilter("id", "in", delIds)});
                }
            }
        }
        QFilter qFilter = new QFilter("dimskeycol", "in", keyCols);
        qFilter.and("alloctime", ">", (Object)param.getStartTime());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"calx_diffallocrpt", (String)"id", (QFilter[])new QFilter[]{qFilter});
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            idSet.add(dynamicObject.getLong("id"));
        }
        if (!idSet.isEmpty()) {
            DeleteServiceHelper.delete((String)"calx_diffallocrpt", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
        }
        return currCrossEntryIDs;
    }

    private String getValuesKeyCol(Row row, String diffAllocDims) {
        HashSet calSysDefaultDims = Sets.newHashSet((Object[])new String[]{"configuredcode", "assist", "tracknumber", "project", "lot", "costaccount", "material", "calorg"});
        StringBuilder costDomainStr = new StringBuilder();
        String[] dims = diffAllocDims.split(",");
        List<String> dimsKeys = Arrays.asList(dims);
        Collections.sort(dimsKeys);
        for (String field : dimsKeys) {
            if (!calSysDefaultDims.contains(field)) continue;
            costDomainStr.append(row.get(field));
        }
        return CommonUtils.getSHA256Base64Str(costDomainStr.toString());
    }

    private String getStringIds(Set<Long> ids) {
        StringJoiner stringJoiner = new StringJoiner(",");
        for (Long id : ids) {
            stringJoiner.add(id.toString());
        }
        return stringJoiner.toString();
    }

    private DataSet getOutDirectionDs(DiffAllocParamter param, String diffAllocDims, DiffAllocParamterEntry paramEntry, DataSet actCostDs) {
        DataSet outComeStandCostDs = this.getInAndOutComeStandCost(diffAllocDims, paramEntry, "1");
        outComeStandCostDs = outComeStandCostDs.select(diffAllocDims + ",standardcost as outcost,qty as outqty,diff as outdiff");
        DataSet outComeDiffDataSet = this.getInAndOutComeDiff(diffAllocDims, paramEntry, "1");
        outComeDiffDataSet = outComeDiffDataSet.select(diffAllocDims + ",standardcost as outcost,qty as outqty,diff as outdiff");
        DataSet outUnion = outComeStandCostDs.union(outComeDiffDataSet);
        actCostDs = actCostDs.addField("0.00", "outcost").addField("0.00", "outqty").addField("0.00", "outdiff");
        outUnion = outUnion.addField("0.00", "balqty").addField("0.00", "balactcost").addField("0.00", "standardcost").addField("0.00", "qty").addField("0.00", "diff");
        outUnion = outUnion.select(diffAllocDims + ",balqty,balactcost,standardcost,qty,diff,outcost,outqty,outdiff");
        actCostDs = actCostDs.union(outUnion);
        actCostDs = actCostDs.filter((FilterFunction)new NegativeUnPriceDmsValFilter(actCostDs.getRowMeta(), param, paramEntry));
        actCostDs = actCostDs.groupBy(diffAllocDims.split(",")).sum("balqty").sum("balactcost").sum("standardcost").sum("qty").sum("diff").sum("outcost").sum("outqty").sum("outdiff").finish();
        actCostDs = actCostDs.select(diffAllocDims + ",qty,balqty,outqty,balactcost+standardcost+diff as inactcost,outcost+outdiff as outactcost,balqty+qty-outqty as actqty").filter("actqty<>0");
        actCostDs = actCostDs.select(diffAllocDims + ",qty,balqty,outqty,inactcost-outactcost as actcost,actqty").filter("actqty<>0");
        actCostDs = actCostDs.select(diffAllocDims + ",qty,balqty,outqty,actcost/actqty as unitactcost").filter("unitactcost<0");
        return actCostDs;
    }
}

