/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PeriodHelper {
    public static DynamicObject getCurrentPeriod(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getDynamicObject("currentperiod");
        }
        return null;
    }

    public static Map<Long, DynamicObject> getCurrentPeriods(Set<Long> costAccountID) {
        return PeriodHelper.getSysPeriods(costAccountID);
    }

    public static Map<Long, DynamicObject> getSysPeriods(Set<Long> costAccountIdSet) {
        QFilter filter = new QFilter("entry.costaccount.id", "in", costAccountIdSet);
        String fields = "org,entry.currentperiod,entry.startperiod,entry.costaccount,entry.currentperiod.begindate,entry.currentperiod.enddate,entry.startperiod.begindate,entry.startperiod.enddate,entry.calpolicy,entry.calpolicy.periodtype,entry.isenabled";
        DynamicObject[] sysPeriod = BusinessDataServiceHelper.load((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter});
        HashMap<Long, DynamicObject> periodMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject period : sysPeriod) {
            DynamicObjectCollection entrys = period.getDynamicObjectCollection("entry");
            for (DynamicObject entryInfo : entrys) {
                long recordCostAccountID = entryInfo.getLong("costaccount.id");
                periodMap.put(recordCostAccountID, entryInfo.getDynamicObject("currentperiod"));
            }
        }
        return periodMap;
    }

    public static DynamicObject getCurrentPeriodType(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getDynamicObject("calpolicy.periodtype");
        }
        return null;
    }

    public static Date getCurrentPeriodenddate(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getDate("currentperiod.enddate");
        }
        return null;
    }

    public static DynamicObject getPeriodByDate(Date date, Long costAccountID) {
        QFilter filter = new QFilter("id", "=", (Object)costAccountID);
        String fields = "calpolicy,calpolicy.periodtype";
        DynamicObject value = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)fields, (QFilter[])new QFilter[]{filter});
        return PeriodHelper.getPeriodByDate(date, null, value.getLong("calpolicy.periodtype"));
    }

    public static int compare2period(DynamicObject period1, DynamicObject period2) {
        int result = 1;
        if (period1.get("begindate").equals(period2.get("begindate")) && period1.get("enddate").equals(period2.get("enddate"))) {
            result = 0;
        } else if (period1.getDate("begindate").after(period2.getDate("enddate")) || period1.get("begindate").equals(period2.get("enddate"))) {
            result = 1;
        } else if (period1.getDate("enddate").before(period2.getDate("begindate")) || period1.get("enddate").equals(period2.get("begindate"))) {
            result = -1;
        }
        return result;
    }

    public static DynamicObject getPeriodByDate(Date date, String selectField, long periodType) {
        if (selectField == null) {
            selectField = "id,name,number,beginDate,enddate";
        }
        QFilter f = new QFilter("beginDate", "<=", (Object)date);
        QFilter g = new QFilter("enddate", ">=", (Object)date);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)false);
        return QueryServiceHelper.queryOne((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t, q});
    }

    public static DynamicObject getPeriodByNumber(int year, int periodNum, String selectField, long periodType) {
        if (selectField == null) {
            selectField = "id,name,number,beginDate,enddate";
        }
        QFilter f = new QFilter("periodyear", "=", (Object)year);
        QFilter g = new QFilter("periodnumber", "=", (Object)periodNum);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        return QueryServiceHelper.queryOne((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t});
    }

    public static DynamicObject getPreviousPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", "<", (Object)currPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", "<", (Object)currPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)false);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter, q}, (String)"periodyear desc, periodnumber desc");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static DynamicObject getNextPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", ">", (Object)currPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", ">", (Object)currPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)false);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter, q}, (String)"periodyear asc, periodnumber asc");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static DynamicObject getStartPeriod(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getDynamicObject("startperiod");
        }
        return null;
    }

    public static DynamicObject getSysCtrlEntity(Long costAccountID) {
        DynamicObject retValue = null;
        QFilter filter = new QFilter("entry.costaccount.id", "=", (Object)costAccountID);
        String fields = "org,entry.currentperiod,entry.startperiod,entry.costaccount,entry.currentperiod.begindate,entry.currentperiod.enddate,entry.startperiod.begindate,entry.startperiod.enddate,entry.calpolicy,entry.calpolicy.periodtype,entry.isenabled";
        DynamicObject sysPeriod = BusinessDataServiceHelper.loadSingle((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter});
        if (sysPeriod == null) {
            return null;
        }
        DynamicObjectCollection entrys = sysPeriod.getDynamicObjectCollection("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entryInfo = (DynamicObject)entrys.get(i);
            long recordCostAccountID = entryInfo.getLong("costaccount.id");
            if (costAccountID != recordCostAccountID) continue;
            retValue = entryInfo;
            break;
        }
        return retValue;
    }

    public static DynamicObject getPeriodByYearMonth(long costAccountID, String selectField, int year, int month) {
        QFilter filter = new QFilter("id", "=", (Object)costAccountID);
        String fields = "calpolicy,calpolicy.periodtype";
        DynamicObject value = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)fields, (QFilter[])new QFilter[]{filter});
        if (selectField == null) {
            selectField = "id,name,number,beginDate,enddate";
        }
        QFilter f = new QFilter("periodyear", "=", (Object)year);
        QFilter g = new QFilter("periodnumber", "=", (Object)month);
        QFilter t = new QFilter("periodtype", "=", (Object)value.getLong("calpolicy.periodtype"));
        QFilter q = new QFilter("isadjustperiod", "=", (Object)false);
        return BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t, q});
    }

    public static DynamicObjectCollection getSysCtrlEntity(Long[] costAccountIds, String selects) {
        QFilter filter = new QFilter("entry.costaccount.id", "in", (Object)costAccountIds);
        if (selects == null) {
            selects = "org,entry.currentperiod as currentperiod,entry.startperiod as startperiod,entry.costaccount as costaccount";
        }
        DynamicObjectCollection sysPeriods = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)selects, (QFilter[])new QFilter[]{filter});
        return sysPeriods;
    }

    public static boolean isEndInit(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getBoolean("isenabled");
        }
        return false;
    }

    public static Date[] getPeriodStartAndEndTime(Long periodId) {
        QFilter filter = new QFilter("id", "=", (Object)periodId);
        DynamicObject[] periods = BusinessDataServiceHelper.load((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter[]{filter});
        if (periods == null || periods.length < 1) {
            return null;
        }
        Date[] dates = new Date[]{periods[0].getDate("begindate"), periods[0].getDate("enddate")};
        return dates;
    }

    public static List<Integer> getHistoryPeriodNumbers(Long costAccount, Long curPeriod, String periodCompareStr) {
        QFilter qFilter = new QFilter("entry.costaccount", "=", (Object)costAccount);
        DynamicObject calSysObj = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.startperiod startperiod", (QFilter[])new QFilter[]{qFilter});
        Long startPeriod = calSysObj == null ? 0L : calSysObj.getLong("startperiod");
        ArrayList<Integer> list = new ArrayList<Integer>(16);
        list.add(0);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bd_period", (String)"periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)curPeriod)});
        if (dynamicObject == null) {
            return list;
        }
        QFilter filter = new QFilter("periodtype", "=", (Object)dynamicObject.getLong("periodtype"));
        filter.and("id", ">=", (Object)startPeriod);
        filter.and("id", periodCompareStr, (Object)curPeriod);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_period", (String)"periodyear,periodnumber", (QFilter[])new QFilter[]{filter});
        for (DynamicObject obj : dynamicObjects) {
            list.add(obj.getInt("periodyear") * 100 + obj.getInt("periodnumber"));
        }
        return list;
    }
}

