/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.param.AppParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.calx.algox.helper.PeriodHelper;

public class PrevCostAdjustHelper {
    public void dealAllDataSet(DataSet allDataSet, Long calOrgId, Long costAccountId, Map<Long, BigDecimal> outAdjustCostMap, int amtPrecision) {
        block9: {
            DataSet inAdjustSet;
            block10: {
                String prevCostAdjustParam;
                block11: {
                    AppParam appParam = new AppParam("/KIUHEXROK3D", "10", calOrgId, Long.valueOf(0L));
                    prevCostAdjustParam = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"prevcostadjustparam");
                    if ("no".equals(prevCostAdjustParam)) {
                        return;
                    }
                    DataSet allCopyDataSet = allDataSet.copy();
                    inAdjustSet = allCopyDataSet.filter("createtype in ('B','U','I','J','D','B-A1') and calbilltype = 'IN' and rowtype = '2'");
                    DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
                    Date beginDate = currentPeriod.getDate("begindate");
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    if ((inAdjustSet = inAdjustSet.filter("bizdate < to_date('" + sdf.format(beginDate) + "','yyyy-MM-dd HH:mm:ss')")).isEmpty()) {
                        return;
                    }
                    HashSet<Long> recordEntryIds = new HashSet<Long>();
                    for (Row row : inAdjustSet.copy()) {
                        recordEntryIds.add(row.getLong("costrecordentryid"));
                    }
                    QFilter recordF = new QFilter("entry.id", "in", recordEntryIds);
                    String recordFields = "entry.id as entryid,entry.baseqty as recordbaseqty";
                    DataSet recordSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)recordFields, (QFilter[])recordF.toArray(), null);
                    inAdjustSet = inAdjustSet.leftJoin(recordSet).on("costrecordentryid", "entryid").select(new String[]{"costrecordentryid", "entryid", "actualcost", "baseqty"}, new String[]{"recordbaseqty"}).finish();
                    DataSet inSumAdjustSet = inAdjustSet.copy().groupBy().sum("recordbaseqty").sum("actualcost").finish();
                    BigDecimal inRecordSumbaseqty = BigDecimal.ZERO;
                    BigDecimal inAdjustSumAmt = BigDecimal.ZERO;
                    BigDecimal beginBalanceSumQty = BigDecimal.ZERO;
                    if (inSumAdjustSet.hasNext()) {
                        Row row = inSumAdjustSet.next();
                        inRecordSumbaseqty = row.getBigDecimal("recordbaseqty");
                        inAdjustSumAmt = row.getBigDecimal("actualcost");
                    }
                    if (inAdjustSumAmt.compareTo(BigDecimal.ZERO) == 0) {
                        return;
                    }
                    DataSet balanceSet = allCopyDataSet.filter("rowtype = '0'");
                    if ((balanceSet = balanceSet.groupBy().sum("baseqty").finish()).hasNext()) {
                        Row row = balanceSet.next();
                        beginBalanceSumQty = row.getBigDecimal("baseqty");
                    }
                    if (inRecordSumbaseqty.compareTo(beginBalanceSumQty) <= 0) break block9;
                    if (beginBalanceSumQty.compareTo(BigDecimal.ZERO) <= 0) break block10;
                    if (!"proportion".equals(prevCostAdjustParam)) break block11;
                    BigDecimal allOutCostAmt = inAdjustSumAmt.divide(inRecordSumbaseqty, 10, 4).multiply(inRecordSumbaseqty.subtract(beginBalanceSumQty)).setScale(amtPrecision, 4);
                    BigDecimal allOutActualCostAmt = BigDecimal.ZERO;
                    Long lastEntryId = 0L;
                    for (Row row : inAdjustSet) {
                        Long entryId = row.getLong("entryid");
                        BigDecimal inAdjustAmt = row.getBigDecimal("actualcost");
                        BigDecimal outAdjustAmt = allOutCostAmt.multiply(inAdjustAmt.divide(inAdjustSumAmt, 10, 4)).setScale(amtPrecision, 4);
                        outAdjustCostMap.put(entryId, outAdjustAmt);
                        lastEntryId = entryId;
                        allOutActualCostAmt = allOutActualCostAmt.add(outAdjustAmt);
                    }
                    BigDecimal diffAmt = allOutCostAmt.subtract(allOutActualCostAmt);
                    if (diffAmt.compareTo(BigDecimal.ZERO) == 0) break block9;
                    BigDecimal outAdjustAmt = outAdjustCostMap.get(lastEntryId);
                    outAdjustCostMap.put(lastEntryId, outAdjustAmt.add(diffAmt));
                    break block9;
                }
                if (!"all".equals(prevCostAdjustParam)) break block9;
                for (Row row : inAdjustSet) {
                    Long entryId = row.getLong("entryid");
                    BigDecimal inAdjustAmt = row.getBigDecimal("actualcost");
                    outAdjustCostMap.put(entryId, inAdjustAmt);
                }
                break block9;
            }
            for (Row row : inAdjustSet) {
                Long entryId = row.getLong("entryid");
                BigDecimal inAdjustAmt = row.getBigDecimal("actualcost");
                outAdjustCostMap.put(entryId, inAdjustAmt);
            }
        }
    }

    public JoinDataSet joinOnSelectDims(JoinDataSet joinDataSet, String[] joinDims) {
        for (String joinDim : joinDims) {
            joinDataSet.on(joinDim, joinDim);
        }
        return joinDataSet;
    }
}

