/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.util.CalLogUtils;

public class StopSyncSettingModifyHelper {
    private Set<String> currentSettingStr = new HashSet<String>();
    private Map<String, Object> currentSettingIdMap = new HashMap<String, Object>();
    private Map<String, String> finishMap = new HashMap<String, String>();
    private Set<String> newSettingStr = new HashSet<String>();
    private Map<String, Object> materialMap = new HashMap<String, Object>();
    private Map<String, Object> calOrgMap = new HashMap<String, Object>();
    private Set<Long> calOrgSet = null;
    private Long storageorgunit = null;
    private String accountType = null;
    private Long warehouse = null;
    private Set<Long> materialIdSet = null;

    public void modifySetting(Set<Long> calOrgSet, Long storageorgunit, String accountType, Long warehouse, Set<Long> materialIdSet, boolean isstopsync) {
        this.calOrgSet = calOrgSet;
        this.accountType = accountType;
        this.storageorgunit = storageorgunit;
        this.warehouse = warehouse;
        this.materialIdSet = materialIdSet;
        if (calOrgSet == null || calOrgSet.isEmpty()) {
            return;
        }
        if (isstopsync) {
            this.getCurrentSetting();
            this.getNewSetting(calOrgSet, storageorgunit, accountType, warehouse, materialIdSet);
            this.stopSynceService();
        } else {
            this.canStartSyncService();
            this.startSyncService();
        }
    }

    private void startSyncService() {
        QFilter q = new QFilter("calorg", "in", this.calOrgSet);
        if (this.storageorgunit != null && this.storageorgunit != 0L) {
            q.and("storageorgunit", "=", (Object)this.storageorgunit);
        }
        if (this.warehouse != null && this.warehouse != 0L) {
            q.and("warehouse", "=", (Object)this.warehouse);
        }
        if (StringUtils.isNotEmpty((String)this.accountType)) {
            q.and("accounttype", "=", (Object)this.accountType);
        }
        if (this.materialIdSet != null && !this.materialIdSet.isEmpty()) {
            q.and("material", "in", this.materialIdSet);
        }
        q.and("isfinish", "=", (Object)Character.valueOf('0'));
        q.and("stoptype", "=", (Object)"cal");
        DynamicObject[] settingLogs = BusinessDataServiceHelper.load((String)"cal_stopsyncbillset", (String)"id,calorg,material,stoptype,isfinish", (QFilter[])q.toArray());
        OperateOption op = OperateOption.create();
        op.setVariableValue("ishasright", "true");
        OperationServiceHelper.executeOperate((String)"startservice", (String)"cal_stopsyncbillset", (DynamicObject[])settingLogs, (OperateOption)op);
    }

    private void canStartSyncService() {
        QFilter q = new QFilter("billstatus", "in", (Object)new String[]{"A", "B"});
        q.and("calorg", "in", this.calOrgSet);
        if (this.materialIdSet != null && !this.materialIdSet.isEmpty()) {
            q.and("entryentity.material", "in", this.materialIdSet);
        }
        DataSet applyBillDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costupdateapplybill", (String)"billno", (QFilter[])q.toArray(), null);
        HashSet<String> billNos = new HashSet<String>();
        for (Row row : applyBillDataSet) {
            billNos.add(row.getString("billno"));
        }
        if (!billNos.isEmpty()) {
            String string = ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6210\u672c\u8c03\u6574\u7533\u8bf7\u5355\uff1a{0}\uff0c\u4e0d\u80fd\u542f\u52a8\u670d\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"StopSyncSettingModifyHelper_0", (String)"fi-cal-common", (Object[])new Object[0]);
            string = MessageFormat.format(string, String.join((CharSequence)",", billNos));
            throw new KDBizException(string);
        }
    }

    private void stopSynceService() {
        DynamicObject dynamicObject;
        QFilter q;
        this.currentSettingStr.retainAll(this.newSettingStr);
        String userId = RequestContext.get().getUserId();
        HashSet<Object> needFinishSettingIds = new HashSet<Object>();
        for (String string : this.currentSettingStr) {
            DynamicObject[] finish = this.finishMap.get(string);
            if (!"1".equals(finish)) continue;
            needFinishSettingIds.add(this.currentSettingIdMap.get(string));
        }
        DynamicObject[] needModifySettings = null;
        if (!needFinishSettingIds.isEmpty() && (needModifySettings = BusinessDataServiceHelper.load((String)"cal_stopsyncbillset", (String)"id,stoptime,stoper,starter,starttime,isfinish,failbill_tag", (QFilter[])(q = new QFilter("id", "in", needFinishSettingIds)).toArray())) != null) {
            for (DynamicObject dynamicObject2 : needModifySettings) {
                dynamicObject2.set("stoptime", (Object)TimeServiceHelper.now());
                dynamicObject2.set("stoper", (Object)userId);
                dynamicObject2.set("starter", null);
                dynamicObject2.set("starttime", null);
                dynamicObject2.set("isfinish", (Object)"0");
                dynamicObject2.set("failbill_tag", (Object)"");
            }
        }
        this.newSettingStr.removeAll(this.currentSettingStr);
        HashSet<DynamicObject> newSettings = null;
        if (!this.newSettingStr.isEmpty()) {
            newSettings = new HashSet<DynamicObject>(this.newSettingStr.size());
            for (String newSetting : this.newSettingStr) {
                DynamicObject syncBillSetting = BusinessDataServiceHelper.newDynamicObject((String)"cal_stopsyncbillset");
                syncBillSetting.set("stoptype", (Object)"cal");
                syncBillSetting.set("calorg", this.calOrgMap.get(newSetting));
                syncBillSetting.set("storageorgunit", (Object)this.storageorgunit);
                syncBillSetting.set("accounttype", (Object)this.accountType);
                syncBillSetting.set("warehouse", (Object)this.warehouse);
                syncBillSetting.set("material", this.materialMap.get(newSetting));
                syncBillSetting.set("stoptime", (Object)TimeServiceHelper.now());
                syncBillSetting.set("stoper", (Object)userId);
                syncBillSetting.set("starter", null);
                syncBillSetting.set("starttime", null);
                syncBillSetting.set("isfinish", (Object)"0");
                newSettings.add(syncBillSetting);
            }
        }
        Object[] stopSetting1 = null;
        Object[] stopSetting2 = null;
        if (needModifySettings != null) {
            stopSetting1 = SaveServiceHelper.save((DynamicObject[])needModifySettings);
        }
        if (newSettings != null) {
            stopSetting2 = SaveServiceHelper.save((DynamicObject[])newSettings.toArray(new DynamicObject[0]));
        }
        HashSet<Object> stopSetIds = new HashSet<Object>();
        if (stopSetting1 != null) {
            for (Object object : stopSetting1) {
                dynamicObject = (DynamicObject)object;
                stopSetIds.add(dynamicObject.getPkValue());
            }
        }
        if (stopSetting2 != null) {
            for (Object object : stopSetting2) {
                dynamicObject = (DynamicObject)object;
                stopSetIds.add(dynamicObject.getPkValue());
            }
        }
        if (!stopSetIds.isEmpty()) {
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"cal_stopsyncbillset", (String)"stoper.name,calorg.name,storageorgunit.name,warehouse.name,accounttype,material.name", (QFilter[])new QFilter("id", "in", stopSetIds).toArray());
            this.addLogs(dynamicObjectCollection, true);
        }
    }

    private void getNewSetting(Set<Long> calOrgSet, Long storageorgunit, String accountType, Long warehouse, Set<Long> materialIdSet) {
        storageorgunit = storageorgunit == null ? Long.valueOf(0L) : storageorgunit;
        accountType = accountType == null ? "" : accountType;
        warehouse = warehouse == null ? Long.valueOf(0L) : warehouse;
        for (Long calOrg : calOrgSet) {
            if (calOrg == null || calOrg == 0L) continue;
            if (materialIdSet == null || materialIdSet.isEmpty()) {
                String key = calOrg + "_" + storageorgunit + "_" + accountType + "_" + warehouse + "_0";
                this.newSettingStr.add(key);
                this.calOrgMap.put(key, calOrg);
                continue;
            }
            for (Long string : materialIdSet) {
                if (string == null) {
                    string = 0L;
                }
                String key = calOrg + "_" + storageorgunit + "_" + accountType + "_" + warehouse + "_" + string;
                this.newSettingStr.add(key);
                this.materialMap.put(key, string);
                this.calOrgMap.put(key, calOrg);
            }
        }
    }

    public void addLogs(DynamicObjectCollection array, boolean isStop) {
        if (array != null && array.size() > 0) {
            StringBuilder logdes = new StringBuilder();
            for (DynamicObject dynamicObject : array) {
                String str;
                String userName = "";
                userName = isStop ? dynamicObject.getString("stoper.name") : dynamicObject.getString("starter.name");
                if (StringUtils.isNotEmpty((String)userName)) {
                    logdes.append('\u3010').append(userName).append('\u3011');
                }
                String calorg = dynamicObject.getString("calorg.name");
                String storageorgunit = dynamicObject.getString("storageorgunit.name");
                String warehouse = dynamicObject.getString("warehouse.name");
                String accounttype = dynamicObject.getString("accounttype");
                String material = dynamicObject.getString("material.name");
                ArrayList<String> msg = new ArrayList<String>(8);
                if (StringUtils.isNotEmpty((String)calorg)) {
                    str = MessageFormat.format(ResManager.loadKDString((String)"\u914d\u7f6e\uff1a\u6838\u7b97\u7ec4\u7ec7\u3010{0}\u3011", (String)"StopSyncSettingModifyHelper_1", (String)"fi-cal-common", (Object[])new Object[0]), calorg);
                    msg.add(str);
                }
                if (StringUtils.isNotEmpty((String)storageorgunit)) {
                    str = MessageFormat.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u3010{0}\u3011", (String)"StopSyncSettingModifyHelper_2", (String)"fi-cal-common", (Object[])new Object[0]), storageorgunit);
                    msg.add(str);
                }
                if (StringUtils.isNotEmpty((String)warehouse)) {
                    str = MessageFormat.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u3010{0}\u3011", (String)"StopSyncSettingModifyHelper_3", (String)"fi-cal-common", (Object[])new Object[0]), warehouse);
                    msg.add(str);
                }
                if (StringUtils.isNotEmpty((String)accounttype)) {
                    String accountTypeName = AccountTypeEnum.getName(accounttype);
                    String str2 = MessageFormat.format(ResManager.loadKDString((String)"\u8ba1\u4ef7\u65b9\u6cd5\u3010{0}\u3011", (String)"StopSyncSettingModifyHelper_4", (String)"fi-cal-common", (Object[])new Object[0]), accountTypeName);
                    msg.add(str2);
                }
                if (StringUtils.isNotEmpty((String)material)) {
                    str = MessageFormat.format(ResManager.loadKDString((String)"\u7269\u6599\u3010{0}\u3011", (String)"StopSyncSettingModifyHelper_5", (String)"fi-cal-common", (Object[])new Object[0]), material);
                    msg.add(str);
                }
                if (!msg.isEmpty()) {
                    logdes.append(String.join((CharSequence)",", msg));
                }
                if (isStop) {
                    logdes.append(ResManager.loadKDString((String)"\u6838\u7b97\u5355\u540c\u6b65\u8fdb\u7a0b\u505c\u6b62\uff0c\u72b6\u6001\uff1a\u6210\u529f\u3002", (String)"StopSyncSettingModifyHelper_6", (String)"fi-cal-common", (Object[])new Object[0]));
                    logdes.append("\r\n");
                    continue;
                }
                logdes.append(ResManager.loadKDString((String)"\u6838\u7b97\u5355\u540c\u6b65\u8fdb\u7a0b\u542f\u52a8\uff0c\u72b6\u6001\uff1a\u6210\u529f\u3002", (String)"StopSyncSettingModifyHelper_7", (String)"fi-cal-common", (Object[])new Object[0]));
                logdes.append("\r\n");
            }
            if (isStop) {
                CalLogUtils.addLog(CalLogUtils.buildCalAppLog("cal_stopsyncbillset", ResManager.loadKDString((String)"\u505c\u6b62\u540c\u6b65", (String)"StopSyncSettingModifyHelper_8", (String)"fi-cal-common", (Object[])new Object[0]), logdes.toString(), RequestContext.get().getOrgId()));
            } else {
                CalLogUtils.addLog(CalLogUtils.buildCalAppLog("cal_stopsyncbillset", ResManager.loadKDString((String)"\u542f\u52a8\u540c\u6b65", (String)"StopSyncSettingModifyHelper_9", (String)"fi-cal-common", (Object[])new Object[0]), logdes.toString(), RequestContext.get().getOrgId()));
            }
        }
    }

    private void getCurrentSetting() {
        QFilter filter = new QFilter("stoptype", "=", (Object)"cal");
        DataSet currentSetting = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stopsyncbillset", (String)"id,calorg,storageorgunit,accounttype,warehouse,material,failbill_tag,isfinish", (QFilter[])filter.toArray(), null);
        for (Row row : currentSetting) {
            String calOrgId = row.getString("calorg");
            String storageorgunit = row.getString("storageorgunit");
            String accountType = row.getString("accounttype").trim();
            String warehouse = row.getString("warehouse");
            String materialId = row.getString("material");
            Object settingId = row.get("id");
            String finish = row.getString("isfinish");
            String string = calOrgId + "_" + storageorgunit + "_" + accountType + "_" + warehouse + "_" + materialId;
            this.currentSettingStr.add(string);
            this.currentSettingIdMap.put(string, settingId);
            this.finishMap.put(string, finish);
        }
    }
}

