/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.CalOutDataRangeHolder;
import kd.fi.calx.algox.CalRange;
import kd.fi.calx.algox.CostAccount;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.function.CostAdjustDeleteFunction;
import kd.fi.calx.algox.helper.AcctGroupModelHelper;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.GPAPrevCostAdjustHelper;
import kd.fi.calx.algox.matrix.DealDomainBalXFunction;
import kd.fi.calx.algox.matrix.function.DealDiffFunctoin;
import kd.fi.calx.algox.matrix.function.DealDomainInfoFunction;
import kd.fi.calx.algox.matrix.function.DealGroupAdjFunction;
import kd.fi.calx.algox.matrix.function.DealMatrixFunction;
import kd.fi.calx.algox.matrix.function.DealMatrixRptFunction;
import kd.fi.calx.algox.matrix.function.DealOutDiffFunction;
import kd.fi.calx.algox.matrix.function.DealSortIdFunction;
import kd.fi.calx.algox.matrix.function.DealSplitRecordFunction;
import kd.fi.calx.algox.matrix.function.DealTranInPriceFunction;
import kd.fi.calx.algox.matrix.function.DealUpdateBillFunctoin;
import kd.fi.calx.algox.matrix.function.DealUpdateBillToDBFunctoin;
import kd.fi.calx.algox.matrix.function.MatrixDataInputFactory;
import kd.fi.calx.algox.matrix.function.ModFunction;
import kd.fi.calx.algox.matrix.function.SumBillData2RptFunction;
import kd.fi.calx.algox.matrix.function.TransInQtyFunction;
import kd.fi.calx.algox.matrix.helper.MatrixDesignCostHelper;
import kd.fi.calx.algox.util.DataSetUtil;

public class CalOutByMatrixService {
    private final CalCulateOutParams param;
    private CalOutDataRangeHolder holder;
    private MatrixDataInputFactory dataFactory;
    private CommonInfo commonInfo;
    private static final String[] fixedFileds = new String[]{"id", "billno", "entryid", "calorg", "costaccount", "costaccountname", "calsystem", "calpolicy", "costtype", "costaccounttype", "calbilltype", "bizdate", "auditdate", "billnumber", "billtypenum", "billtypename", "bizbillid", "bizbillentryid", "calentryid", "rowtype", "queuetype", "signnum", "iscalculated", "periodid", "baseqty", "localcurrency", "amtprecision", "priceprecision", "isvoucher", "isfivoucher", "ispresent", "billstatus", "createtype", "actualcost", "materialcost", "fee", "processcost", "manufacturecost", "resource", "entryseq", "calrangeid", "baseunit", "qtyprecision", "ordercol", "costrecordentryid", "entrystatus", "subelementid", "cost", "fixedoutcost", "fixedincost", "begincost", "beginqty", "inqty", "outqty", "fixedoutqty", "materialGroupNo", "divideBasis", "divideBasisStr", "divideBasisValue", "calRange", "calDimension", "calDimensionStr", "calDimensionValue", "domainid"};
    private DataSetX fixGroupCostRecordX;
    private DataSetX balDomainDataX;
    private JobSession session;
    private static final String[] groupFields = new String[]{"groupgroupno", "grouptype", "groupid", "iscompleted", "groupweight", "groupoccupiedqty"};
    private static final String[] fields = new String[]{"id", "entryid", "billtypenum"};
    private Boolean isNewGroup = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.ACCOUNTGROUP_NEWMODEL);
    private DataSetX curAllBillDtlDx;
    private DataSetX unCalCostRecDx = null;
    private final String[] sortDataSels = new String[]{"domainid", "sortlistid", "groupno", "sortid", "material", "costaccount", "periodid", "calrange"};
    private DataSetX groupDataSetX = null;

    public CalOutByMatrixService(CalCulateOutParams param, CalOutDataRangeHolder holder, CommonInfo commonInfo) {
        this.param = param;
        this.holder = holder;
        this.dataFactory = new MatrixDataInputFactory(holder, param, commonInfo);
        this.dataFactory.setOnlyCurPeriodTgtBill(false);
        this.commonInfo = commonInfo;
        this.commonInfo.getParamCache().putParamValue("matrix_change_one", CalDbParamServiceHelper.getBoolean("matrix_change_one"));
        this.commonInfo.getParamCache().putParamValue("matrix_adj_enddiff", CalDbParamServiceHelper.getBoolean("matrix_adj_enddiff"));
        this.commonInfo.getParamCache().putParamValue("matrix_log", CalDbParamServiceHelper.getBoolean("matrix_log"));
        this.commonInfo.getParamCache().putParamValue("matrix_domainid_log", CalDbParamServiceHelper.getString("matrix_domainid_log", null));
        this.commonInfo.getParamCache().putParamValue("matrix_new_resolve", CalDbParamServiceHelper.getBoolean("matrix_new_resolve"));
        this.commonInfo.getParamCache().putParamValue("matrix_cover_zero", CalDbParamServiceHelper.getBoolean("matrix_cover_zero"));
        this.commonInfo.getParamCache().putParamValue("matrix_cover_neg", CalDbParamServiceHelper.getBoolean("matrix_cover_neg"));
        this.commonInfo.getParamCache().putParamValue("matrix_neg_rpt_sta", CalDbParamServiceHelper.getString("matrix_neg_rpt_sta", null));
        this.commonInfo.getParamCache().putParamValue("matrix_use_outprice", CalDbParamServiceHelper.getBoolean("matrix_use_outprice", null));
        this.commonInfo.getParamCache().putParamValue(CalDbParamConstant.MATRIX_WRITE_DTLRPT, CalDbParamServiceHelper.getBoolean(CalDbParamConstant.MATRIX_WRITE_DTLRPT, null));
        this.commonInfo.getParamCache().putParamValue(CalDbParamConstant.MATRIX_SAMEVAR_USE_BEGININ, CalDbParamServiceHelper.getBoolean(CalDbParamConstant.MATRIX_SAMEVAR_USE_BEGININ, null));
        commonInfo.getRunningModeMap().put(AccountTypeEnum.WEIGHTAVG.getValue(), 1);
        commonInfo.getRunningModeMap().put(AccountTypeEnum.SPPRICE.getValue(), 1);
        this.initCalRange(commonInfo, holder);
        new MatrixDesignCostHelper().setCalEndDate(holder, commonInfo);
    }

    public void close() {
        if (this.dataFactory != null) {
            this.dataFactory.closeBizGroup();
        }
    }

    public String calCulateOut(CalCulateOutParams param, CalOutDataRangeHolder holder, JobSession session) throws KDBizException {
        this.session = session;
        GPAPrevCostAdjustHelper costAdjustHelper = new GPAPrevCostAdjustHelper();
        costAdjustHelper.dealOutAdjustGpa(holder);
        DataSetX costAdjustBizData = this.delCostAdjDs(session);
        DataSetX fixedCostData = this.dealFixedCost(session, param);
        DataSetX transCostData = this.dealTransQty();
        DataSetX matrixData = this.dealMatrix(fixedCostData, transCostData);
        DataSetX updataBillData = this.updateBillCost(matrixData);
        updataBillData = updataBillData.leftJoin(costAdjustBizData).on("entryid", "id").select(updataBillData.getRowMeta().getFieldNames(), new String[0]);
        DataSetX toDBBillData = this.dealDiff(updataBillData);
        this.dealSplitBill(toDBBillData);
        this.writeCalReport(fixedCostData, transCostData, toDBBillData);
        toDBBillData = this.updateBillCostToDB(toDBBillData);
        toDBBillData = toDBBillData.select(fields);
        String resultId = this.commitCalculate(toDBBillData);
        return resultId;
    }

    private DataSetX delCostAdjDs(JobSession session) {
        QFilter createF = new QFilter("createtype", "in", (Object)new String[]{"F", "N"});
        DataSetX costAdjustBizData = session.fromInput(this.dataFactory.createCostAdjustBizDataInput(createF));
        costAdjustBizData = costAdjustBizData.groupBy(new String[]{"id"}).reduceGroup((GroupReduceFunction)new CostAdjustDeleteFunction(costAdjustBizData.getRowMeta(), this.commonInfo.getBalanceCalculator(), this.commonInfo.getRunningModeMap()));
        return costAdjustBizData;
    }

    private void dealSplitBill(DataSetX toDBBillData) {
        DataSetX splitedAllData = this.session.fromInput(this.dataFactory.createAllSplitData());
        splitedAllData = this.distinctDx(splitedAllData, null);
        JoinDataSetX splitUpdateData = toDBBillData.leftJoin(splitedAllData).on("entryid", "ancestorentryid").on("subelementid", "elementid").select(DataSetUtil.getAllFieldStr(toDBBillData), new String[]{"writeoffperiod", "writeoffendperiod", "writeoffstatus", "id childheadid", "entryid childid", "parentid parentid", "baseqty childbaseqty", "issplit childissplit", "isvoucher childisvoucher", "signnum groupsignnum", "materialcost childmaterialcost", "fee childfee", "processcost childprocesscost", "manufacturecost childmanufacturecost", "resource childresource", "ischargeoff childischargeoff", "ischargeoffed childischargeoffed", "elementid childsubeleid", "bizentityobject childbizentityobject"});
        splitUpdateData = splitUpdateData.groupBy(new String[]{"entryid", "subelementid"}).reduceGroup((GroupReduceFunction)new DealSplitRecordFunction(this.commonInfo, splitUpdateData.getRowMeta()));
        splitUpdateData = this.updateBillCostToDB((DataSetX)splitUpdateData);
        splitUpdateData.output((Output)new IgnoreOutput());
    }

    private void writeCalReport(DataSetX fixedCostData, DataSetX transCostData, DataSetX toDBBillData) {
        Boolean adjEndDiff = (Boolean)this.commonInfo.getParamCache().getParamValue("matrix_adj_enddiff");
        if (!this.commonInfo.isWriteRpt() && !adjEndDiff.booleanValue()) {
            return;
        }
        DataSetX sumToDBBillData = toDBBillData.groupBy(new String[]{"domainid", "subelementid", "periodid"}).reduceGroup((GroupReduceFunction)new SumBillData2RptFunction(toDBBillData.getRowMeta()));
        JoinDataSetX rptDsX = fixedCostData.leftJoin(sumToDBBillData).on("domainid", "domainid").on("periodid", "periodid").on("subelementid", "subelementid").select(fixedCostData.getRowMeta().getFieldNames(), new String[]{"tranincost", "tranoutcost", "tgtbaseqty", "outtgtbaseqty", "domainoutqty", "domainoutcost outcost", "billid", "dysortlistid", "priceinfostr", "rpterrortype"});
        String domainDetFields = "calorg,costaccount,material,dividebasis,caldimension,dividebasisvalue,caldimensionvalue,calrangeid,priceprecision,amtprecision,qtyprecision,calDimensionStr";
        this.balDomainDataX = this.balDomainDataX.groupBy((domainDetFields + ",domainid,periodid").split(",")).count("domainid", "count");
        rptDsX = rptDsX.join(this.balDomainDataX).on("domainid", "domainid").on("periodid", "periodid").select(rptDsX.getRowMeta().getFieldNames(), domainDetFields.split(","));
        Boolean writeDtlRpt = (Boolean)this.commonInfo.getParamCache().getParamValue(CalDbParamConstant.MATRIX_WRITE_DTLRPT);
        if (writeDtlRpt.booleanValue()) {
            String joinFields = "domainid,subelementid,periodid";
            String selectFields = "billno,queuetype,bizdate,auditdate,baseqty,cost,matrixtype,baseunit,localcurrency,adjinfo,entryid,costpricesource,costpricesourcetype,calremark,billtypename,createtype,rowtype,divprice,sub_unitactualcost";
            String allSelects = joinFields + "," + selectFields;
            String[] splitFields = allSelects.split(",");
            DataSetX dtlRptDx = this.fixGroupCostRecordX.select(splitFields).filter("matrixtype <> ''");
            DataSetX detailDomainBillDx = this.curAllBillDtlDx.select(splitFields).filter("matrixtype <> ''");
            DataSetX toDbBillDx = toDBBillData.select(splitFields).filter("matrixtype <> ''");
            dtlRptDx = dtlRptDx.union(detailDomainBillDx).union(toDbBillDx);
            rptDsX = rptDsX.leftJoin(dtlRptDx).on("domainid", "domainid").on("subelementid", "subelementid").on("periodid", "periodid").select(rptDsX.getRowMeta().getFieldNames(), selectFields.split(","));
        }
        rptDsX = rptDsX.groupBy(new String[]{"domainid"}).reduceGroup((GroupReduceFunction)new DealMatrixRptFunction(this.commonInfo, rptDsX.getRowMeta()));
        rptDsX.output((Output)new IgnoreOutput());
    }

    private DataSetX dealFixedCost(JobSession session, CalCulateOutParams param) {
        DataSetX interPeriodDataSetX = this.getInterPeriodCostData(session, param, Boolean.TRUE);
        DataSetX balanceData = this.getBalanceData(session, param, Boolean.TRUE);
        DataSetX fixDomainDataX = this.getFixDomainUnionDataX(session, interPeriodDataSetX.getRowMeta().getFieldNames());
        DataSetX allDataSetX = interPeriodDataSetX.union(balanceData).union(fixDomainDataX);
        allDataSetX = allDataSetX.groupBy(new String[]{"domainid", "subelementid", "periodid"}).sum("fixedoutcost").sum("fixedincost").sum("begincost").sum("beginqty").sum("inqty").sum("fixedinqty").sum("outqty").sum("fixedoutqty").sum("baseqty_out").sum("actualcost_out").max("maxrowbillid").max("maxrowentryid").max("needzeroprice");
        return allDataSetX;
    }

    private DataSetX getFixDomainDataX(JobSession session) {
        DataSetX fixDomainDataX = session.fromInput(this.dataFactory.createFixDomainData());
        fixDomainDataX = this.distinctDx(fixDomainDataX, null);
        return fixDomainDataX;
    }

    private DataSetX getFixDomainUnionDataX(JobSession session, String[] fieldNames) {
        DataSetX fixDomainDataX;
        Boolean writeDtlRpt = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.MATRIX_WRITE_DTLRPT);
        if (writeDtlRpt.booleanValue()) {
            QFilter createF = new QFilter("createtype", "not in", (Object)new String[]{"F", "N"});
            createF.and("billstatus", "=", (Object)"C");
            DataSetX costAdjustBizData = session.fromInput(this.dataFactory.createCostAdjustBizDataInput(createF));
            Input[] updateBillDataInput = this.dataFactory.createUpdateBillDataInput(null);
            DataSetX curAllBillDx = session.fromInput(updateBillDataInput);
            if (curAllBillDx.getRowMeta().getFieldIndex("addpricefield", false) > -1) {
                curAllBillDx = curAllBillDx.select(costAdjustBizData.getRowMeta().getFieldNames());
            }
            curAllBillDx = curAllBillDx.union(costAdjustBizData);
            curAllBillDx = this.distinctDx(curAllBillDx, null);
            DataSetX groupDataSetX = this.getGroupDataSetX();
            groupDataSetX = groupDataSetX.groupBy(new String[]{"groupcostrecordentryid"}).max("period");
            curAllBillDx = curAllBillDx.leftJoin(groupDataSetX).on("entryid", "groupcostrecordentryid").select(curAllBillDx.getRowMeta().getFieldNames(), new String[]{"groupcostrecordentryid"});
            curAllBillDx = this.joinNotCalCostRecBill(curAllBillDx);
            this.curAllBillDtlDx = curAllBillDx = curAllBillDx.groupBy(new String[]{"domainid", "subelementid"}).reduceGroup((GroupReduceFunction)new DealDomainBalXFunction(curAllBillDx.getRowMeta(), this.commonInfo));
            fixDomainDataX = curAllBillDx.groupBy(new String[]{"domainid", "subelementid", "periodid"}).sum("fixedoutcost").sum("fixedincost").sum("fixedinqty").sum("begincost").sum("beginqty").sum("inqty").sum("outqty").sum("fixedoutqty").sum("baseqty_out").sum("actualcost_out").max("maxrowbillid").max("maxrowentryid").max("needzeroprice");
        } else {
            fixDomainDataX = this.getFixDomainDataX(session);
        }
        fixDomainDataX = fixDomainDataX.select(fieldNames);
        return fixDomainDataX;
    }

    private DataSetX dealTransQty() {
        DataSetX transQtyData = this.fixGroupCostRecordX.groupBy(new String[]{"domainid", "subelementid", "srcdomainid", "periodid"}).sum("transinqty", "transqty").sum("transoutqty", "calouttransqty").sum("baseqty", "tgtbaseqty").sum("tranincost").sum("tranoutcost");
        return transQtyData;
    }

    private DataSetX dealMatrix(DataSetX fixedCostData, DataSetX transCostData) {
        JoinDataSetX allDataSetX = fixedCostData.leftJoin(transCostData).on("domainid", "domainid").on("periodid", "periodid").on("subelementid", "subelementid").select(new String[]{"domainid", "subelementid", "fixedoutcost", "fixedincost", "begincost", "beginqty", "inqty", "outqty", "fixedoutqty", "baseqty_out", "actualcost_out", "fixedinqty", "maxrowbillid", "maxrowentryid", "needzeroprice"}, new String[]{"srcdomainid", "transqty", "tranincost", "calouttransqty", "tranoutcost"});
        DataSetX sortDataSetX = this.session.fromInput(this.dataFactory.createOutSortInput());
        DataSetX materialGroupNoSet = this.session.fromInput(this.dataFactory.createMaterialGroupNoInput());
        sortDataSetX = sortDataSetX.leftJoin(materialGroupNoSet).on("material", "material").select(DataSetUtil.getAllFieldStr(sortDataSetX), new String[]{"materialGroupNo"});
        sortDataSetX = sortDataSetX.flatMap((FlatMapFunction)new DealDomainInfoFunction(sortDataSetX.getRowMeta(), this.commonInfo, this.holder.getCostAccountMap(), this.holder.getCalOutRangeList()));
        sortDataSetX = this.distinctDx(sortDataSetX, this.sortDataSels);
        allDataSetX = allDataSetX.leftJoin(sortDataSetX).on("domainid", "domainid").select(allDataSetX.getRowMeta().getFieldNames(), new String[]{"sortlistid", "groupno", "sortid", "material", "costaccount", "periodid", "calrange"});
        allDataSetX = allDataSetX.flatMap((FlatMapFunction)new DealSortIdFunction(this.commonInfo, allDataSetX.getRowMeta()));
        allDataSetX = allDataSetX.groupBy(new String[]{"dysortlistid"}).reduceGroup((GroupReduceFunction)new DealMatrixFunction(allDataSetX.getRowMeta(), this.commonInfo));
        return allDataSetX;
    }

    private DataSetX dealDiff(DataSetX billData) {
        billData = billData.groupBy(new String[]{"domainid", "subelementid"}).reduceGroup((GroupReduceFunction)new DealOutDiffFunction(this.commonInfo, billData.getRowMeta()));
        billData = billData.groupBy(new String[]{"groupid", "subelementid"}).reduceGroup((GroupReduceFunction)new DealDiffFunctoin(this.commonInfo, billData.getRowMeta(), billData.getRowMeta()));
        billData = billData.groupBy(new String[]{"domainid"}).reduceGroup((GroupReduceFunction)new DealGroupAdjFunction(this.commonInfo, billData.getRowMeta()));
        return billData;
    }

    private DataSetX updateBillCost(DataSetX matrixData) {
        DataSetX allGroupBillDataSet = this.getBillInputsByCostRecEntIds(this.session);
        QFilter filter = new QFilter("entry.queuetype", "=", (Object)"1");
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        Input[] updateBillDataInput = this.dataFactory.createUpdateBillDataInput(filter);
        DataSetX outUpdateBillDx = this.session.fromInput(updateBillDataInput);
        DataSetX allUpdateBillDataSet = allGroupBillDataSet.union(outUpdateBillDx);
        allUpdateBillDataSet = this.joinNotCalCostRecBill(allUpdateBillDataSet);
        allUpdateBillDataSet = allUpdateBillDataSet.distinct(allUpdateBillDataSet.getRowMeta().getFieldNames());
        DataSetX groupDataSetX = this.getGroupDataSetX();
        groupDataSetX = this.distinctDx(groupDataSetX, null);
        allUpdateBillDataSet = allUpdateBillDataSet.leftJoin(groupDataSetX).on("entryid", "groupcostrecordentryid").select(allUpdateBillDataSet.getRowMeta().getFieldNames(), new String[]{"type", "groupid", "iscompleted"});
        String[] beforeJoinSrcFields = allUpdateBillDataSet.getRowMeta().getFieldNames();
        allUpdateBillDataSet = allUpdateBillDataSet.leftJoin(this.fixGroupCostRecordX).on("entryid", "entryid").on("type", "grouptype").on("subelementid", "subelementid").select(allUpdateBillDataSet.getRowMeta().getFieldNames(), new String[]{"srcdomainid", "transinqty transqty", "isfixed", "cost interperiodcost", "transoutqty calouttransqty", "isfixedfee"});
        allUpdateBillDataSet = allUpdateBillDataSet.leftJoin(matrixData).on("srcdomainid", "domainid").on("subelementid", "subelementid").select(allUpdateBillDataSet.getRowMeta().getFieldNames(), new String[]{"calprice srccalprice"});
        allUpdateBillDataSet = allUpdateBillDataSet.leftJoin(matrixData).on("domainid", "domainid").on("subelementid", "subelementid").select(allUpdateBillDataSet.getRowMeta().getFieldNames(), new String[]{"calprice", "dysortlistid", "priceinfostr", "rpterrortype"});
        allUpdateBillDataSet = allUpdateBillDataSet.groupBy(beforeJoinSrcFields).reduceGroup((GroupReduceFunction)new DealTranInPriceFunction(this.commonInfo, allUpdateBillDataSet.getRowMeta()));
        allUpdateBillDataSet = allUpdateBillDataSet.groupBy(new String[]{"id", "entryid"}).reduceGroup((GroupReduceFunction)new DealUpdateBillFunctoin(this.commonInfo, allUpdateBillDataSet.getRowMeta()));
        return allUpdateBillDataSet;
    }

    private DataSetX getGroupDataSetX() {
        if (this.groupDataSetX == null) {
            this.groupDataSetX = this.session.fromInput(this.dataFactory.getGroupRecordDataSet());
        }
        return this.groupDataSetX;
    }

    private DataSetX joinNotCalCostRecBill(DataSetX srcDx) {
        Boolean writeDtlRpt = new MatrixDesignCostHelper().isWriteDtlRpt(this.commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return srcDx;
        }
        String billNoFilterStr = this.param.getBillNoFilterStr();
        if (StringUtils.isNotEmpty((String)billNoFilterStr)) {
            QFilter billNoFilter = QFilter.of((String)billNoFilterStr, (Object[])new Object[0]);
            if (this.unCalCostRecDx == null) {
                this.unCalCostRecDx = this.session.fromInput(this.dataFactory.createNotCalCostRecInput(billNoFilter));
            }
            srcDx = srcDx.leftJoin(this.unCalCostRecDx).on("entryid", "notcalentryid").select(srcDx.getRowMeta().getFieldNames(), new String[]{"notcalentryid"});
        }
        return srcDx;
    }

    private DataSetX getBillInputsByCostRecEntIds(JobSession session) {
        DataSet groupDataDs = null;
        if (AcctGroupModelHelper.isBizGroupModel()) {
            groupDataDs = this.dataFactory.getGroupRecordDataSetByBiz();
        } else {
            String selectFields = "id as groupid,iscompleted,entryentity.costrecordentryid as groupcostrecordentryid,entryentity.type as type,entryentity.bizbillid as bizbillid,entryentity.bookdate as bookdate,entryentity.period as period,entryentity.period.enddate as periodenddate";
            groupDataDs = this.dataFactory.createBillGroupDataSet(selectFields);
        }
        HashSet<Long> groupEntryIds = new HashSet<Long>(16);
        ArrayList<Input> billInputs = new ArrayList<Input>(16);
        Date maxDate = null;
        Date minDate = null;
        for (Row row : groupDataDs) {
            Long groupRecEntryId = row.getLong("groupcostrecordentryid");
            groupEntryIds.add(groupRecEntryId);
            Date endDate = row.getDate("periodenddate");
            Date bookDate = row.getDate("bookdate");
            if (maxDate == null || maxDate.compareTo(endDate) < 0) {
                maxDate = endDate;
            }
            if (bookDate != null && (minDate == null || minDate.after(bookDate))) {
                minDate = bookDate;
            }
            if (groupEntryIds.size() <= 50000) continue;
            QFilter filter = new QFilter("entry.id", "in", new ArrayList(groupEntryIds));
            filter = this.addBookDateFilter(maxDate, minDate, filter);
            Input[] updateBillDataInput = this.dataFactory.createUpdateBillDataInputNoBookDate(filter);
            billInputs.addAll(Arrays.asList(updateBillDataInput));
            groupEntryIds = new HashSet(50000);
            maxDate = null;
            minDate = null;
        }
        QFilter filter = new QFilter("entry.id", "in", new ArrayList(groupEntryIds));
        filter = this.addBookDateFilter(maxDate, minDate, filter);
        Input[] updateBillDataInput = this.dataFactory.createUpdateBillDataInputNoBookDate(filter);
        billInputs.addAll(Arrays.asList(updateBillDataInput));
        DataSetX billDataSet = session.fromInput(billInputs.toArray(new Input[0]));
        return billDataSet;
    }

    private DataSetX updateBillCostToDB(DataSetX billDataSet) {
        billDataSet = billDataSet.flatMap((FlatMapFunction)new ModFunction(billDataSet.getRowMeta(), "id"));
        billDataSet = billDataSet.groupBy(new String[]{"mod"}).reduceGroup((GroupReduceFunction)new DealUpdateBillToDBFunctoin(this.commonInfo, billDataSet.getRowMeta()));
        return billDataSet;
    }

    private String commitCalculate(DataSetX billDataSet) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("headid", (DataType)DataType.LongType), new Field("entryid", (DataType)DataType.LongType), new Field("billtypenum", (DataType)DataType.StringType)});
        DataSetOutput resultSet = new DataSetOutput(rowMeta);
        String resultId = resultSet.getId();
        billDataSet.output((Output)resultSet);
        return resultId;
    }

    private DataSetX getInterPeriodCostData(JobSession session, CalCulateOutParams param, Boolean isSum) {
        DataSetX groupDataX = session.fromInput(this.dataFactory.createBillGroupInput());
        DataSetX costRecordDataX = session.fromInput(this.dataFactory.createAllGroupData());
        JoinDataSetX allDataSetX = costRecordDataX.leftJoin(groupDataX).on("entryid", "groupentryid").select(costRecordDataX.getRowMeta().getFieldNames(), groupFields);
        allDataSetX = this.joinNotCalCostRecBill((DataSetX)allDataSetX);
        allDataSetX = this.distinctDx((DataSetX)allDataSetX, null);
        allDataSetX = allDataSetX.groupBy(new String[]{"groupid", "groupgroupno", "subelementid"}).reduceGroup((GroupReduceFunction)new TransInQtyFunction(this.commonInfo, allDataSetX.getRowMeta()));
        this.fixGroupCostRecordX = allDataSetX;
        if (isSum.booleanValue()) {
            allDataSetX = allDataSetX.groupBy(new String[]{"domainid", "periodid", "entryid", "matrixtype", "subelementid", "fixedinqty", "fixedoutqty"}).max("fixedoutcost").max("fixedincost").max("begincost").max("beginqty").max("inqty").max("outqty").max("baseqty_out").max("actualcost_out").max("maxrowbillid").max("maxrowentryid").max("needzeroprice");
            allDataSetX = allDataSetX.groupBy(new String[]{"domainid", "subelementid", "periodid"}).sum("fixedoutcost").sum("fixedincost").sum("fixedinqty").sum("begincost").sum("beginqty").sum("inqty").sum("outqty").sum("fixedoutqty").sum("baseqty_out").sum("actualcost_out").max("maxrowbillid").max("maxrowentryid").max("needzeroprice");
        } else {
            allDataSetX = this.doSameDataSetX((DataSetX)allDataSetX);
        }
        return allDataSetX;
    }

    private DataSetX getBalanceData(JobSession session, CalCulateOutParams param, Boolean isSum) {
        DataSetX balanceData = session.fromInput(this.dataFactory.createBalanceBizDataInput());
        DataSetX materialGroupNoSet = session.fromInput(this.dataFactory.createMaterialGroupNoInput());
        balanceData = balanceData.leftJoin(materialGroupNoSet).on("material", "material").select(DataSetUtil.getAllFieldStr(balanceData), new String[]{"materialGroupNo"});
        balanceData = this.distinctDx(balanceData, null);
        this.balDomainDataX = balanceData = balanceData.flatMap((FlatMapFunction)new DealDomainInfoFunction(balanceData.getRowMeta(), this.commonInfo, this.holder.getCostAccountMap(), this.holder.getCalOutRangeList()));
        balanceData = isSum != false ? balanceData.groupBy(new String[]{"domainid", "subelementid", "periodid"}).sum("fixedoutcost").sum("fixedincost").sum("fixedinqty").sum("begincost").sum("beginqty").sum("inqty").sum("outqty").sum("fixedoutqty").sum("baseqty_out").sum("actualcost_out").max("maxrowbillid").max("maxrowentryid").max("needzeroprice") : this.doSameDataSetX(balanceData);
        return balanceData;
    }

    private void initCalRange(CommonInfo commonInfo, CalOutDataRangeHolder holder) {
        HashMap<Long, CalRange> calRangeInfoMap = new HashMap<Long, CalRange>(16);
        for (Map.Entry<Long, CostAccount> range : holder.getCostAccountMap().entrySet()) {
            List<CalRange> noEmptyCalRanges;
            CalRange emptyCalRange = range.getValue().getEmptyCalRange();
            if (emptyCalRange != null) {
                calRangeInfoMap.put(emptyCalRange.getRangeId(), emptyCalRange);
            }
            if ((noEmptyCalRanges = range.getValue().getNotEmptyCalRange()) == null || noEmptyCalRanges.size() <= 0) continue;
            for (CalRange calRange : noEmptyCalRanges) {
                calRangeInfoMap.put(calRange.getRangeId(), calRange);
            }
        }
        commonInfo.setCalRangeInfoMap(calRangeInfoMap);
    }

    private DataSetX doSameDataSetX(DataSetX data) {
        String[] dynamicFileds = CalBalanceModelHelper.getDimField().toArray(new String[0]);
        return data.select(this.concat(fixedFileds, dynamicFileds));
    }

    private <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private QFilter addBookDateFilter(Date maxDate, Date minDate, QFilter filter) {
        if (minDate == null) {
            return filter;
        }
        filter = filter.and("bookdate", "<=", (Object)maxDate);
        if (this.getNewGroup()) {
            filter = filter.and("bookdate", ">=", (Object)minDate);
        }
        QFilter calEndDateFilter = new MatrixDesignCostHelper().getCalEndDateFilter(this.commonInfo);
        filter = filter.and(calEndDateFilter);
        return filter;
    }

    private boolean getNewGroup() {
        return this.isNewGroup;
    }

    private DataSetX distinctDx(DataSetX srcDx, String[] fields) {
        Boolean isDistinct = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.MATRIX_DISTINCT);
        if (isDistinct.booleanValue()) {
            fields = fields == null ? srcDx.getRowMeta().getFieldNames() : fields;
            srcDx = srcDx.distinct(fields);
        }
        return srcDx;
    }
}

