/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.MatrixTypeEnum;
import kd.fi.calx.algox.matrix.helper.MatrixDesignCostHelper;
import kd.fi.calx.algox.matrix.log.MatrixRemarkUtil;
import kd.fi.calx.algox.util.ArrayUtils;

public class DealDomainBalXFunction
extends GroupReduceFunction {
    private final RowMeta srcRowMeta;
    private final CommonInfo commonInfo;
    private RowMeta resultRowMeta;

    public DealDomainBalXFunction(RowMeta rowMeta, CommonInfo commonInfo) {
        this.srcRowMeta = rowMeta;
        this.commonInfo = commonInfo;
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        Iterator<RowX> it = iter.iterator();
        this.resultRowMeta = this.getResultRowMeta();
        boolean hasNoGroupInAmtNotZero = false;
        boolean hasGroupInBillTotal = false;
        boolean hasNoGroupInTotal = false;
        RowX minBookDateOutRow = null;
        while (it.hasNext()) {
            RowX row = it.next();
            minBookDateOutRow = this.dealPriceMaxBillIdAndEntryId(row, minBookDateOutRow);
            Object[] newRow = ArrayUtils.concatAll(Arrays.asList(row.values()).toArray(), new Object[][]{{"", "", "", "", Boolean.FALSE, Boolean.FALSE}});
            boolean notCalEntryId = new MatrixDesignCostHelper().isNotCalEntryId(this.srcRowMeta, row, this.commonInfo);
            if (notCalEntryId) {
                this.setLastRowIsNeedZeroPriceTotal(it, hasNoGroupInAmtNotZero, hasGroupInBillTotal, newRow, hasNoGroupInTotal, minBookDateOutRow);
                this.dealNotCalRow(collector, newRow);
                continue;
            }
            boolean hasNoGroupIn = new MatrixDesignCostHelper().hasNoGroupInBill(row, this.srcRowMeta, this.commonInfo);
            hasNoGroupInTotal = this.getTotalFlag(hasNoGroupInTotal, hasNoGroupIn);
            boolean hasNoGroupInQtyNotZeroAmtNotZero = new MatrixDesignCostHelper().hasNoGroupInQtyNotZeroAmtNotZero(row, this.srcRowMeta, this.commonInfo);
            hasNoGroupInAmtNotZero = this.getTotalFlag(hasNoGroupInAmtNotZero, hasNoGroupInQtyNotZeroAmtNotZero);
            boolean hasGroupInBill = new MatrixDesignCostHelper().hasGroupInBill(row, this.srcRowMeta, this.commonInfo);
            hasGroupInBillTotal = this.getTotalFlag(hasGroupInBillTotal, hasGroupInBill);
            this.setLastRowIsNeedZeroPriceTotal(it, hasNoGroupInAmtNotZero, hasGroupInBillTotal, newRow, hasNoGroupInTotal, minBookDateOutRow);
            new MatrixDesignCostHelper().dealDesignatedCostNotGroup(row, newRow, this.srcRowMeta, this.resultRowMeta, this.commonInfo);
            Integer signNum = row.getInteger(this.srcRowMeta.getFieldIndex("signnum"));
            BigDecimal signBigDec = new BigDecimal(signNum);
            this.dealSumQtyAndCost(row, signBigDec, newRow);
            this.dealFixedQtyAndCost(row, signBigDec, newRow);
            collector.collect(new RowX(newRow));
        }
    }

    private boolean getTotalFlag(boolean totalFlag, boolean curFlag) {
        totalFlag = curFlag ? true : totalFlag;
        return totalFlag;
    }

    private void setLastRowIsNeedZeroPriceTotal(Iterator<RowX> it, boolean hasNoGroupInAmtNotZero, boolean hasGroupInBillTotal, Object[] newRow, boolean hasNoGroupInTotal, RowX minBookDateOutRow) {
        if (!it.hasNext()) {
            int needZeroPriceTotalInt = new MatrixDesignCostHelper().getNeedZeroPriceTotalInt(hasNoGroupInAmtNotZero, hasGroupInBillTotal, hasNoGroupInTotal);
            newRow[this.resultRowMeta.getFieldIndex((String)"needzeroprice")] = needZeroPriceTotalInt;
            if (minBookDateOutRow != null) {
                Long billId = minBookDateOutRow.getLong(this.srcRowMeta.getFieldIndex("id"));
                Long entryId = minBookDateOutRow.getLong(this.srcRowMeta.getFieldIndex("entryid"));
                newRow[this.srcRowMeta.getFieldIndex((String)"maxrowbillid")] = billId;
                newRow[this.srcRowMeta.getFieldIndex((String)"maxrowentryid")] = entryId;
            }
        }
    }

    public RowMeta getResultRowMeta() {
        Field[] newFields = ArrayUtils.concatAll(this.srcRowMeta.getFields(), new Field[][]{{new Field("matrixtype", (DataType)DataType.StringType), new Field("adjinfo", (DataType)DataType.StringType), new Field("costpricesourcetype", (DataType)DataType.StringType), new Field("calremark", (DataType)DataType.StringType), new Field("divprice", (DataType)DataType.BooleanType), new Field("isdesignout", (DataType)DataType.BooleanType)}});
        RowMeta rowMeta = new RowMeta(newFields);
        return rowMeta;
    }

    private void dealSumQtyAndCost(RowX row, BigDecimal signBigDec, Object[] newRow) {
        boolean isOutQueueType;
        int sumInQtyIndex = this.resultRowMeta.getFieldIndex("inqty", false);
        int sumOutQtyIndex = this.resultRowMeta.getFieldIndex("outqty", false);
        String queueType = row.getString(this.resultRowMeta.getFieldIndex("queuetype"));
        boolean isInQueueType = "0".equals(queueType);
        if (isInQueueType) {
            newRow[sumInQtyIndex] = row.getBigDecimal(this.resultRowMeta.getFieldIndex("baseqty"));
        }
        if (isOutQueueType = "1".equals(queueType)) {
            newRow[sumOutQtyIndex] = row.getBigDecimal(this.resultRowMeta.getFieldIndex("baseqty"));
        }
    }

    private void dealFixedQtyAndCost(RowX row, BigDecimal signBigDec, Object[] newRow) {
        boolean isUpdateFixed;
        Boolean isVoucher = row.getBoolean(this.resultRowMeta.getFieldIndex("isvoucher"));
        String queueType = row.getString(this.resultRowMeta.getFieldIndex("queuetype"));
        Boolean isReWork = row.getBoolean(this.resultRowMeta.getFieldIndex("isrework"));
        Long gBillId = row.getLong(this.resultRowMeta.getFieldIndex("groupcostrecordentryid"));
        boolean isInQueue = "0".equals(queueType);
        boolean isOutQueue = "1".equals(queueType);
        boolean isOutVou = isOutQueue && isVoucher != false;
        boolean isNotGroup = gBillId == null || gBillId.equals(0L);
        String billTypeNum = row.getString(this.resultRowMeta.getFieldIndex("billtypenum"));
        boolean designAsFixedOut = new MatrixDesignCostHelper().getDesignAsFixedOutNotGroup(row, this.srcRowMeta, this.commonInfo);
        boolean zeroFixedOut = new MatrixDesignCostHelper().getZeroFixedOutNotGroup(row, this.srcRowMeta, this.commonInfo);
        boolean bl = isUpdateFixed = (isInQueue || isOutVou || isReWork != false || designAsFixedOut || zeroFixedOut) && isNotGroup;
        if ("cal_costadjustbill".equals(billTypeNum)) {
            isUpdateFixed = true;
        }
        int inQtyIndex = this.resultRowMeta.getFieldIndex("fixedinqty", false);
        int inCostIndex = this.resultRowMeta.getFieldIndex("fixedincost", false);
        int outQtyIndex = this.resultRowMeta.getFieldIndex("fixedoutqty", false);
        int outCostIndex = this.resultRowMeta.getFieldIndex("fixedoutcost", false);
        int matrixTypeIndex = this.resultRowMeta.getFieldIndex("matrixtype", false);
        int calRemarkIndex = this.resultRowMeta.getFieldIndex("calremark", false);
        if (isInQueue) {
            newRow[inQtyIndex] = BigDecimal.ZERO;
            newRow[inCostIndex] = BigDecimal.ZERO;
        }
        if (isOutQueue) {
            newRow[outQtyIndex] = BigDecimal.ZERO;
            newRow[outCostIndex] = BigDecimal.ZERO;
        }
        if (isUpdateFixed) {
            if (isInQueue) {
                newRow[inQtyIndex] = row.getBigDecimal(this.resultRowMeta.getFieldIndex("baseqty"));
                newRow[inCostIndex] = row.getBigDecimal(this.resultRowMeta.getFieldIndex("cost"));
                newRow[matrixTypeIndex] = MatrixTypeEnum.FIXEDIN.getValue();
            }
            if (isOutQueue) {
                newRow[outQtyIndex] = row.getBigDecimal(this.resultRowMeta.getFieldIndex("baseqty"));
                newRow[outCostIndex] = row.getBigDecimal(this.resultRowMeta.getFieldIndex("cost"));
                newRow[matrixTypeIndex] = MatrixTypeEnum.FIXEDOUT.getValue();
                if (designAsFixedOut) {
                    newRow[calRemarkIndex] = MatrixRemarkUtil.getDesignOut();
                }
                if (isOutVou) {
                    newRow[calRemarkIndex] = MatrixRemarkUtil.getHasVou();
                }
                if (isReWork.booleanValue()) {
                    newRow[calRemarkIndex] = MatrixRemarkUtil.getReWork();
                }
                if (zeroFixedOut) {
                    newRow[calRemarkIndex] = MatrixRemarkUtil.getZeroFixedOut();
                }
            }
        }
    }

    private void dealNotCalRow(Collector collector, Object[] newRow) {
        String queueType = (String)newRow[this.resultRowMeta.getFieldIndex("queuetype")];
        boolean isInQueue = "0".equals(queueType);
        String matrixType = isInQueue ? MatrixTypeEnum.NOTCALIN.getValue() : MatrixTypeEnum.NOTCALOUT.getValue();
        newRow[this.resultRowMeta.getFieldIndex((String)"matrixtype")] = matrixType;
        collector.collect(new RowX(newRow));
    }

    private RowX dealPriceMaxBillIdAndEntryId(RowX row, RowX minBookDateOutRow) {
        Date curBookDate;
        Date minBookDate;
        boolean isOutCostRec;
        String rowType = row.getString(this.srcRowMeta.getFieldIndex("rowtype"));
        String calBillType = row.getString(this.srcRowMeta.getFieldIndex("calbilltype"));
        boolean isOutBill = "OUT".equals(calBillType);
        boolean bl = isOutCostRec = "1".equals(rowType) && isOutBill;
        if (!isOutCostRec) {
            return minBookDateOutRow;
        }
        if (minBookDateOutRow == null) {
            minBookDateOutRow = row;
        }
        if ((minBookDate = minBookDateOutRow.getDate(this.srcRowMeta.getFieldIndex("bizdate"))).after(curBookDate = row.getDate(this.srcRowMeta.getFieldIndex("bizdate")))) {
            minBookDateOutRow = row;
        }
        return minBookDateOutRow;
    }
}

