/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.ParamCache;
import kd.fi.calx.algox.accounttype.CostAdjustInfo;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.obj.MatrixAfterCalDomainInfo;

public class MatrixEndCostDiffAdjHelper {
    private CommonInfo commonInfo;

    public void dealEndDiff(MatrixAfterCalDomainInfo matrixRptInfo, Long billId) {
        boolean isAdjEndDiff = this.dealDiff(matrixRptInfo, billId);
        if (isAdjEndDiff) {
            matrixRptInfo.setTotalOutCost(matrixRptInfo.getTotalOutCost().add(matrixRptInfo.getTotalEndCost()));
            for (Map.Entry<Long, BigDecimal> eleIdEndCost : matrixRptInfo.getEleIdEndCostMap().entrySet()) {
                BigDecimal outCost = matrixRptInfo.getEleIdOutCostMap().get(eleIdEndCost.getKey());
                outCost = this.getBigDecimalNotNull(outCost);
                outCost = outCost.add(eleIdEndCost.getValue());
                matrixRptInfo.getEleIdOutCostMap().put(eleIdEndCost.getKey(), outCost);
                eleIdEndCost.setValue(BigDecimal.ZERO);
            }
            matrixRptInfo.calEleCost2SumCost();
        }
    }

    private boolean dealDiff(MatrixAfterCalDomainInfo matrixRptInfo, Long billId) {
        boolean enableAdjDiff;
        if (billId == null || billId.equals(0L)) {
            return false;
        }
        Map<Long, BigDecimal> eleIdEndCostMap = matrixRptInfo.getEleIdEndCostMap();
        Long calOrgId = matrixRptInfo.getCalOrgId();
        BigDecimal currentTotalQty = matrixRptInfo.getTotalEndQty();
        BigDecimal currentTotalCost = matrixRptInfo.getTotalEndCost();
        Long accountId = matrixRptInfo.getAccountId();
        String domainKey = matrixRptInfo.getDomainKey();
        boolean hasEleNotZero = false;
        for (BigDecimal subCost : eleIdEndCostMap.values()) {
            if (BigDecimal.ZERO.compareTo(subCost) == 0) continue;
            hasEleNotZero = true;
            break;
        }
        boolean isAdjEndDiff = false;
        BigDecimal diffRange = this.getDiffRange(calOrgId);
        boolean isAdj = BigDecimal.ZERO.compareTo(currentTotalQty) == 0 && hasEleNotZero && currentTotalCost.abs().compareTo(diffRange) <= 0;
        String adjDiff = this.getCreateDiffBillType(calOrgId);
        boolean bl = enableAdjDiff = !"no".equals(adjDiff);
        if (enableAdjDiff && isAdj && billId != null && !billId.equals(0L)) {
            QFilter billIdf = new QFilter("id", "=", (Object)billId);
            billIdf.and("entry.costdomainkey", "=", (Object)domainKey);
            Long entryId = null;
            DataSet costRecBillDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"entry.id as entryid", (QFilter[])billIdf.toArray(), null);
            for (Row row : costRecBillDs) {
                entryId = row.getLong("entryid");
            }
            if (entryId == null) {
                return isAdjEndDiff;
            }
            CostAdjustInfo adjustInfo = CostAdjustInfo.createCostAdjustByRecord(billId, entryId, "B", "N", null);
            for (Map.Entry<Long, BigDecimal> entry : eleIdEndCostMap.entrySet()) {
                Long elementId = entry.getKey();
                BigDecimal totalCost = entry.getValue();
                CostSubElement subElement = this.getElementMap(accountId).get(elementId);
                if (subElement == null) continue;
                adjustInfo.setAdjustCost(subElement, totalCost);
            }
            this.flushCostAdjust(adjustInfo);
            isAdjEndDiff = true;
            matrixRptInfo.addBillDtlByAdj(this.commonInfo, adjustInfo);
        }
        return isAdjEndDiff;
    }

    private BigDecimal getDiffRange(Long calOrgId) {
        Object diffrangeOj = this.commonInfo.getParamCache().getParamValue(calOrgId, "diffrange");
        BigDecimal diffrangeqty = new BigDecimal(String.valueOf(diffrangeOj));
        return diffrangeqty;
    }

    private String getCreateDiffBillType(Long calOrgId) {
        ParamCache param = this.commonInfo.getParamCache();
        String creatediffbilltype = (String)param.getParamValue(calOrgId, "creatediffbilltype");
        return creatediffbilltype;
    }

    private void flushCostAdjust(CostAdjustInfo adjustInfo) {
        HashSet<DynamicObject> adjustDyInfos = new HashSet<DynamicObject>(0);
        HashMap periodAdjustInfoMap = new HashMap(16);
        if (adjustInfo.isEmptyEntry()) {
            return;
        }
        adjustDyInfos.add(adjustInfo.getCostAdjustBill());
        Object period = adjustInfo.getCostAdjustBill().get("period");
        periodAdjustInfoMap.putIfAbsent(period, new ArrayList());
        List adjustInfoList = (List)periodAdjustInfoMap.get(period);
        adjustInfoList.add(adjustInfo.getCostAdjustEntryId());
        SaveServiceHelper.save((DynamicObject[])adjustDyInfos.toArray(new DynamicObject[0]));
        HashSet<Long> adjustIdSet = new HashSet<Long>(16);
        for (DynamicObject info : adjustDyInfos) {
            adjustIdSet.add(info.getLong("id"));
        }
        DynamicObject[] auditAdjustDyInfos = BusinessDataServiceHelper.load((Object[])adjustIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreop", "true");
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignoreValidation", "true");
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])auditAdjustDyInfos, (OperateOption)option);
        if (!opResult.isSuccess()) {
            throw new KDBizException(opResult.getAllErrorOrValidateInfo() + "\r\n" + opResult.getMessage());
        }
        for (List entryIdList : periodAdjustInfoMap.values()) {
            this.commonInfo.getBalanceCalculator().updateBalance4CostAdjust(entryIdList.toArray());
        }
    }

    protected final Map<Long, CostSubElement> getElementMap(Long costAccountId) {
        Map<Long, CostSubElement> elementMap;
        if (this.commonInfo.getParamCache().isCalByElement(costAccountId)) {
            elementMap = this.commonInfo.getElementMap();
        } else {
            elementMap = new HashMap<Long, CostSubElement>(16);
            elementMap.put(773175233367685120L, this.commonInfo.getElementMap().get(773175233367685120L));
        }
        return elementMap;
    }

    public void setCommonInfo(CommonInfo commonInfo) {
        this.commonInfo = commonInfo;
    }

    public CommonInfo getCommonInfo() {
        return this.commonInfo;
    }

    private BigDecimal getBigDecimalNotNull(BigDecimal srcValue) {
        srcValue = srcValue == null ? BigDecimal.ZERO : srcValue;
        return srcValue;
    }
}

