/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.CostPriceResultInfo;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.RptErrorTypeEnum;
import kd.fi.calx.algox.matrix.helper.MatrixDesignCostHelper;
import kd.fi.calx.algox.matrix.obj.MatrixAfterCalDomainInfo;
import kd.fi.calx.algox.matrix.obj.MatrixBillDtl;
import kd.fi.calx.algox.report.CalOutRptHolder;
import kd.fi.calx.algox.report.RptStatus;

public class MatrixRptManager {
    private CommonInfo commonInfo;
    private RowMeta rowMeta;
    private MatrixAfterCalDomainInfo matrixDomainInfo;
    private CalOutRptHolder holder;

    public void writeRpt() {
        boolean isOnlyWriteErrRpt;
        this.dealRptStatus();
        boolean bl = isOnlyWriteErrRpt = this.commonInfo.isOnlyWriteErrRpt() && this.holder.getCalStatusValue().equals(RptStatus.SUCESS.getValue());
        if (isOnlyWriteErrRpt) {
            return;
        }
        this.createBeginEntry();
        this.createFixInEntry();
        this.createTranInEntry();
        this.createPriceEntry();
        this.createFixOutEntry();
        this.createTranOutEntry();
        this.createOutEntry();
        this.createNotCalInEntry();
        this.createNotCalOutEntry();
        this.createEndEntry();
        this.createRptDtl();
        this.save2Db();
    }

    private void createPriceEntry() {
        Boolean writeDtlRpt = new MatrixDesignCostHelper().isWriteDtlRpt(this.commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return;
        }
        CostPriceResultInfo priceResult = this.matrixDomainInfo.getPriceInfo();
        if (priceResult == null) {
            return;
        }
        int lastPriceIndex = this.holder.createNewEntry();
        StringBuilder sb = new StringBuilder();
        Integer pricePrecision = this.matrixDomainInfo.getPricePrecision();
        this.holder.setBillType(lastPriceIndex, priceResult.getSrcSchemeName());
        if (!priceResult.isSuccess()) {
            this.holder.setInFormula(lastPriceIndex, priceResult.getErrMsg());
        } else {
            BigDecimal outUnitActualCost = BigDecimal.ZERO;
            for (Map.Entry<Long, CostSubElement> priceEntry : this.commonInfo.getElementMap().entrySet()) {
                Long elementId = priceEntry.getKey();
                BigDecimal unitCost = priceResult.getCostSubElementUnitcostMap().get(elementId);
                if (unitCost == null) {
                    unitCost = BigDecimal.ZERO;
                }
                if (unitCost.compareTo(BigDecimal.ZERO) == 0) continue;
                outUnitActualCost = outUnitActualCost.add(unitCost);
                int subIndex = this.holder.createNewSubEntry(lastPriceIndex, priceEntry.getValue().getName());
                this.holder.setInFormula(subIndex, priceResult.getSrcPriceName() + ":" + this.toBigDecimalString(unitCost.setScale((int)pricePrecision, RoundingMode.HALF_UP)));
            }
            sb.append(priceResult.getSrcPriceName());
            sb.append(':');
            sb.append(this.toBigDecimalString(outUnitActualCost.setScale((int)pricePrecision, RoundingMode.HALF_UP)));
            String srcBillNo = priceResult.getSrcBillno();
            if (StringUtils.isNotEmpty((String)srcBillNo)) {
                sb.append("\n(").append(srcBillNo).append(")");
            }
            this.holder.setInFormula(lastPriceIndex, sb.toString());
        }
    }

    private void createNotCalOutEntry() {
        boolean hashNotZero;
        Boolean writeDtlRpt = new MatrixDesignCostHelper().isWriteDtlRpt(this.commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return;
        }
        boolean bl = hashNotZero = this.isHasNotZero(this.matrixDomainInfo.getEleIdNotCalOutCostMap()) || this.isHasNotZero(this.matrixDomainInfo.getEleIdNotCalOutQtyMap());
        if (!hashNotZero) {
            return;
        }
        BigDecimal totalNotCalOutQty = this.matrixDomainInfo.getTotalNotCalOutQty();
        BigDecimal totalNotCalOutCost = this.matrixDomainInfo.getTotalNotCalOutCost();
        Integer qtyPrecision = this.matrixDomainInfo.getQtyPrecision();
        Integer pricePrecision = this.matrixDomainInfo.getPricePrecision();
        Integer amtPrecision = this.matrixDomainInfo.getAmtPrecision();
        int outIndex = this.holder.createNewEntry();
        this.holder.setBillType(outIndex, ResManager.loadKDString((String)"\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u51fa\u5e93", (String)"MatrixRptManager_7", (String)"fi-calx-algox", (Object[])new Object[0]));
        StringBuilder outFormula = new StringBuilder();
        outFormula.append(this.toBigDecimalString(totalNotCalOutQty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
        outFormula.append('*');
        BigDecimal outUnitActualCost = totalNotCalOutCost.compareTo(BigDecimal.ZERO) == 0 || totalNotCalOutQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : totalNotCalOutCost.divide(totalNotCalOutQty, (int)pricePrecision, RoundingMode.HALF_UP);
        outFormula.append(this.toBigDecimalString(outUnitActualCost));
        outFormula.append('=');
        outFormula.append(this.toBigDecimalString(totalNotCalOutCost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
        this.holder.setOutFormula(outIndex, outFormula.toString());
        Long accountId = this.matrixDomainInfo.getAccountId();
        for (Map.Entry<Long, CostSubElement> eleIdElement : this.getElementMap(accountId).entrySet()) {
            BigDecimal cost = this.matrixDomainInfo.getEleIdNotCalOutCostMap().get(eleIdElement.getKey());
            BigDecimal qty = this.matrixDomainInfo.getEleIdNotCalOutQtyMap().get(eleIdElement.getKey());
            if (cost == null || cost.compareTo(BigDecimal.ZERO) == 0) continue;
            qty = this.getBigDecimalNotNull(qty);
            int subIndex = this.holder.createNewSubEntry(outIndex, eleIdElement.getValue().getName());
            StringBuilder endFormula = new StringBuilder();
            endFormula.append(this.toBigDecimalString(qty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
            endFormula.append('*');
            BigDecimal elementUnitActualCost = cost.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : cost.divide(qty, (int)pricePrecision, RoundingMode.HALF_UP);
            endFormula.append(this.toBigDecimalString(elementUnitActualCost));
            endFormula.append('=');
            endFormula.append(this.toBigDecimalString(cost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
            this.holder.setOutFormula(subIndex, endFormula.toString());
        }
    }

    private void createNotCalInEntry() {
        boolean hashNotZero;
        Boolean writeDtlRpt = new MatrixDesignCostHelper().isWriteDtlRpt(this.commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return;
        }
        boolean bl = hashNotZero = this.isHasNotZero(this.matrixDomainInfo.getEleIdNotCalInCostMap()) || this.isHasNotZero(this.matrixDomainInfo.getEleIdNotCalInQtyMap());
        if (!hashNotZero) {
            return;
        }
        BigDecimal totalNotCalInQty = this.matrixDomainInfo.getTotalNotCalInQty();
        BigDecimal totalNotCalInCost = this.matrixDomainInfo.getTotalNotCalInCost();
        Integer qtyPrecision = this.matrixDomainInfo.getQtyPrecision();
        Integer pricePrecision = this.matrixDomainInfo.getPricePrecision();
        Integer amtPrecision = this.matrixDomainInfo.getAmtPrecision();
        String tranInTitle = ResManager.loadKDString((String)"\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u5165\u5e93", (String)"MatrixRptManager_6", (String)"fi-calx-algox", (Object[])new Object[0]);
        int tranInIndex = this.holder.createNewEntry();
        this.holder.setBillType(tranInIndex, tranInTitle);
        StringBuilder tranInFormula = new StringBuilder();
        tranInFormula.append(this.toBigDecimalString(totalNotCalInQty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
        tranInFormula.append('*');
        BigDecimal tranIinUnitActualCost = totalNotCalInCost.compareTo(BigDecimal.ZERO) == 0 || totalNotCalInQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : totalNotCalInCost.divide(totalNotCalInQty, (int)pricePrecision, RoundingMode.HALF_UP);
        tranInFormula.append(this.toBigDecimalString(tranIinUnitActualCost));
        tranInFormula.append('=');
        tranInFormula.append(this.toBigDecimalString(totalNotCalInCost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
        this.holder.setInFormula(tranInIndex, tranInFormula.toString());
        Long accountId = this.matrixDomainInfo.getAccountId();
        for (Map.Entry<Long, CostSubElement> eleIdElement : this.getElementMap(accountId).entrySet()) {
            BigDecimal cost = this.matrixDomainInfo.getEleIdNotCalInCostMap().get(eleIdElement.getKey());
            BigDecimal qty = this.matrixDomainInfo.getEleIdNotCalInQtyMap().get(eleIdElement.getKey());
            if (cost == null || cost.compareTo(BigDecimal.ZERO) == 0) continue;
            qty = this.getBigDecimalNotNull(qty);
            int subIndex = this.holder.createNewSubEntry(tranInIndex, eleIdElement.getValue().getName());
            StringBuilder endFormula = new StringBuilder();
            endFormula.append(this.toBigDecimalString(qty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
            endFormula.append('*');
            BigDecimal elementUnitActualCost = cost.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : cost.divide(qty, (int)pricePrecision, RoundingMode.HALF_UP);
            endFormula.append(this.toBigDecimalString(elementUnitActualCost));
            endFormula.append('=');
            endFormula.append(this.toBigDecimalString(cost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
            this.holder.setInFormula(subIndex, endFormula.toString());
        }
    }

    private boolean isHasNotZero(Map<Long, BigDecimal> eleIdValueMap) {
        boolean hasNotZero = false;
        for (BigDecimal value : eleIdValueMap.values()) {
            if (value.compareTo(BigDecimal.ZERO) == 0) continue;
            hasNotZero = true;
            break;
        }
        return hasNotZero;
    }

    private void createRptDtl() {
        Map<String, MatrixBillDtl> eIdMatBillDtlMap = this.matrixDomainInfo.getEIdMatBillDtlMap();
        Map<String, List<MatrixBillDtl>> eIdAllNoZeroBillDtlsMap = this.matrixDomainInfo.getEIdAllNoZeroBillDtlsMap();
        int noZeroBillDtlSize = 0;
        for (List<MatrixBillDtl> value : eIdAllNoZeroBillDtlsMap.values()) {
            noZeroBillDtlSize += value.size();
        }
        long[] newIds = DB.genLongIds((String)"t_cal_caloutrpt_dtl", (int)(eIdMatBillDtlMap.size() + noZeroBillDtlSize));
        int i = 0;
        HashMap<String, MatrixBillDtl> newEIdMatBillDtlMap = new HashMap<String, MatrixBillDtl>(this.matrixDomainInfo.getEIdMatBillDtlMap());
        HashSet<String> notDefMatEIdKeys = new HashSet<String>(eIdAllNoZeroBillDtlsMap.keySet());
        notDefMatEIdKeys.removeAll(newEIdMatBillDtlMap.keySet());
        for (String string : notDefMatEIdKeys) {
            newEIdMatBillDtlMap.put(string, null);
        }
        for (Map.Entry entry : newEIdMatBillDtlMap.entrySet()) {
            boolean isNoOtherNotZeroEle;
            String eIdAndType = (String)entry.getKey();
            MatrixBillDtl matrixBillDtl = (MatrixBillDtl)entry.getValue();
            List<MatrixBillDtl> matrixBillDtls = eIdAllNoZeroBillDtlsMap.get(eIdAndType);
            boolean isNotZero = matrixBillDtl != null && this.matrixDomainInfo.isNotZero(matrixBillDtl);
            boolean bl = isNoOtherNotZeroEle = matrixBillDtls == null || matrixBillDtls.isEmpty();
            if (matrixBillDtl != null && (isNotZero || isNoOtherNotZeroEle)) {
                this.addNewRptDtl(newIds, i, matrixBillDtl);
                ++i;
            }
            if (matrixBillDtls == null) continue;
            for (MatrixBillDtl notZeroMatrixBillDtl : matrixBillDtls) {
                this.addNewRptDtl(newIds, i, notZeroMatrixBillDtl);
                ++i;
            }
        }
    }

    private void addNewRptDtl(long[] newIds, int i, MatrixBillDtl matrixBillDtl) {
        Object[] matrixDtl = new Object[26];
        matrixDtl[0] = newIds[i];
        matrixDtl[1] = this.holder.getRptHead()[0];
        matrixDtl[2] = matrixBillDtl.getMatrixType();
        matrixDtl[3] = matrixBillDtl.getBillNo();
        matrixDtl[4] = new Timestamp(matrixBillDtl.getBizDate().getTime());
        matrixDtl[5] = new Timestamp(matrixBillDtl.getAuditDate().getTime());
        matrixDtl[6] = matrixBillDtl.getSubEleId();
        matrixDtl[7] = matrixBillDtl.getBaseUnitId();
        matrixDtl[8] = matrixBillDtl.getCurrency();
        matrixDtl[9] = matrixBillDtl.getInBaseQty();
        matrixDtl[10] = matrixBillDtl.getInUnitCost();
        matrixDtl[11] = matrixBillDtl.getInCost();
        matrixDtl[12] = matrixBillDtl.getOutBaseQty();
        matrixDtl[13] = matrixBillDtl.getOutUnitCost();
        matrixDtl[14] = matrixBillDtl.getOutCost();
        matrixDtl[15] = matrixBillDtl.getDomainId();
        matrixDtl[16] = this.holder.getRptHead()[8];
        matrixDtl[17] = this.holder.getRptHead()[1];
        matrixDtl[18] = this.holder.getRptHead()[9];
        matrixDtl[19] = matrixBillDtl.getEntryId();
        String sortListId = this.matrixDomainInfo.getSortListId();
        matrixDtl[20] = StringUtils.isEmpty((String)sortListId) ? "" : sortListId;
        matrixDtl[21] = matrixBillDtl.getEntity();
        matrixDtl[22] = matrixBillDtl.getRemark();
        String costPriceSource = matrixBillDtl.getCostPriceSource();
        matrixDtl[23] = costPriceSource == null ? "" : costPriceSource;
        matrixDtl[24] = this.matrixDomainInfo.getMaterialId();
        matrixDtl[25] = matrixBillDtl.getBillTypeName();
        this.holder.addMatrixDtl(matrixDtl);
    }

    private void createBeginEntry() {
        BigDecimal totalBegQty = this.matrixDomainInfo.getTotalBegQty();
        BigDecimal totalBegCost = this.matrixDomainInfo.getTotalBegCost();
        Integer qtyPrecision = this.matrixDomainInfo.getQtyPrecision();
        Integer pricePrecision = this.matrixDomainInfo.getPricePrecision();
        Integer amtPrecision = this.matrixDomainInfo.getAmtPrecision();
        int beginIndex = this.holder.createNewEntry();
        this.holder.setBillType(beginIndex, ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"AbstractAccountType_4", (String)"fi-calx-algox", (Object[])new Object[0]));
        StringBuilder formula = new StringBuilder();
        formula.append(this.toBigDecimalString(totalBegQty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
        formula.append('*');
        BigDecimal unitActualCost = totalBegQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : totalBegCost.divide(totalBegQty, (int)pricePrecision, RoundingMode.HALF_UP);
        formula.append(this.toBigDecimalString(unitActualCost));
        formula.append('=');
        formula.append(this.toBigDecimalString(totalBegCost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
        this.holder.setBalanceFormula(beginIndex, formula.toString());
        Long accountId = this.matrixDomainInfo.getAccountId();
        for (Map.Entry<Long, CostSubElement> eleIdElement : this.getElementMap(accountId).entrySet()) {
            BigDecimal cost = this.matrixDomainInfo.getEleIdBegCostMap().get(eleIdElement.getKey());
            BigDecimal qty = this.matrixDomainInfo.getEleIdBegQtyMap().get(eleIdElement.getKey());
            if (cost == null || cost.compareTo(BigDecimal.ZERO) == 0) continue;
            qty = this.getBigDecimalNotNull(qty);
            int subIndex = this.holder.createNewSubEntry(beginIndex, eleIdElement.getValue().getName());
            StringBuilder endFormula = new StringBuilder();
            endFormula.append(this.toBigDecimalString(qty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
            endFormula.append('*');
            BigDecimal elementUnitActualCost = cost.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : cost.divide(qty, (int)pricePrecision, RoundingMode.HALF_UP);
            endFormula.append(this.toBigDecimalString(elementUnitActualCost));
            endFormula.append('=');
            endFormula.append(this.toBigDecimalString(cost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
            this.holder.setBalanceFormula(subIndex, endFormula.toString());
        }
    }

    private void createFixInEntry() {
        BigDecimal totalFixedInQty = this.matrixDomainInfo.getTotalFixedInQty();
        BigDecimal totalFixInCost = this.matrixDomainInfo.getTotalFixInCost();
        Integer qtyPrecision = this.matrixDomainInfo.getQtyPrecision();
        Integer pricePrecision = this.matrixDomainInfo.getPricePrecision();
        Integer amtPrecision = this.matrixDomainInfo.getAmtPrecision();
        int fixInIndex = this.holder.createNewEntry();
        this.holder.setBillType(fixInIndex, ResManager.loadKDString((String)"\u666e\u901a\u5165\u5e93", (String)"MatrixRptManager_1", (String)"fi-calx-algox", (Object[])new Object[0]));
        StringBuilder inFormula = new StringBuilder();
        inFormula.append(this.toBigDecimalString(totalFixedInQty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
        inFormula.append('*');
        BigDecimal inUnitActualCost = totalFixedInQty.compareTo(BigDecimal.ZERO) == 0 || totalFixInCost.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : totalFixInCost.divide(totalFixedInQty, (int)pricePrecision, RoundingMode.HALF_UP);
        inFormula.append(this.toBigDecimalString(inUnitActualCost));
        inFormula.append('=');
        inFormula.append(this.toBigDecimalString(totalFixInCost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
        this.holder.setInFormula(fixInIndex, inFormula.toString());
        Long accountId = this.matrixDomainInfo.getAccountId();
        for (Map.Entry<Long, CostSubElement> eleIdElement : this.getElementMap(accountId).entrySet()) {
            BigDecimal cost = this.matrixDomainInfo.getEleIdFixInCostMap().get(eleIdElement.getKey());
            BigDecimal qty = this.matrixDomainInfo.getEleIdFixedInQtyMap().get(eleIdElement.getKey());
            if (cost == null || cost.compareTo(BigDecimal.ZERO) == 0) continue;
            qty = this.getBigDecimalNotNull(qty);
            int subIndex = this.holder.createNewSubEntry(fixInIndex, eleIdElement.getValue().getName());
            StringBuilder endFormula = new StringBuilder();
            endFormula.append(this.toBigDecimalString(qty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
            endFormula.append('*');
            BigDecimal elementUnitActualCost = cost.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : cost.divide(qty, (int)pricePrecision, RoundingMode.HALF_UP);
            endFormula.append(this.toBigDecimalString(elementUnitActualCost));
            endFormula.append('=');
            endFormula.append(this.toBigDecimalString(cost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
            this.holder.setInFormula(subIndex, endFormula.toString());
        }
    }

    private void createTranInEntry() {
        BigDecimal totalTraInQty = this.matrixDomainInfo.getTotalTraInQty();
        BigDecimal totalTraInCost = this.matrixDomainInfo.getTotalTraInCost();
        Integer qtyPrecision = this.matrixDomainInfo.getQtyPrecision();
        Integer pricePrecision = this.matrixDomainInfo.getPricePrecision();
        Integer amtPrecision = this.matrixDomainInfo.getAmtPrecision();
        String tranInTitle = ResManager.loadKDString((String)"\u6210\u7ec4\u5165\u5e93", (String)"MatrixRptManager_2", (String)"fi-calx-algox", (Object[])new Object[0]);
        int tranInIndex = this.holder.createNewEntry();
        this.holder.setBillType(tranInIndex, tranInTitle);
        StringBuilder tranInFormula = new StringBuilder();
        tranInFormula.append(this.toBigDecimalString(totalTraInQty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
        tranInFormula.append('*');
        BigDecimal tranIinUnitActualCost = totalTraInCost.compareTo(BigDecimal.ZERO) == 0 || totalTraInQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : totalTraInCost.divide(totalTraInQty, (int)pricePrecision, RoundingMode.HALF_UP);
        tranInFormula.append(this.toBigDecimalString(tranIinUnitActualCost));
        tranInFormula.append('=');
        tranInFormula.append(this.toBigDecimalString(totalTraInCost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
        this.holder.setInFormula(tranInIndex, tranInFormula.toString());
        Long accountId = this.matrixDomainInfo.getAccountId();
        for (Map.Entry<Long, CostSubElement> eleIdElement : this.getElementMap(accountId).entrySet()) {
            BigDecimal cost = this.matrixDomainInfo.getEleIdTraInCostMap().get(eleIdElement.getKey());
            BigDecimal qty = this.matrixDomainInfo.getEleIdTraInQtyMap().get(eleIdElement.getKey());
            if (cost == null || cost.compareTo(BigDecimal.ZERO) == 0) continue;
            qty = this.getBigDecimalNotNull(qty);
            int subIndex = this.holder.createNewSubEntry(tranInIndex, eleIdElement.getValue().getName());
            StringBuilder endFormula = new StringBuilder();
            endFormula.append(this.toBigDecimalString(qty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
            endFormula.append('*');
            BigDecimal elementUnitActualCost = cost.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : cost.divide(qty, (int)pricePrecision, RoundingMode.HALF_UP);
            endFormula.append(this.toBigDecimalString(elementUnitActualCost));
            endFormula.append('=');
            endFormula.append(this.toBigDecimalString(cost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
            this.holder.setInFormula(subIndex, endFormula.toString());
        }
    }

    private void createTranOutEntry() {
        BigDecimal totalTraOutQty = this.matrixDomainInfo.getTotalTraOutQty();
        BigDecimal totalTraOutCost = this.matrixDomainInfo.getTotalTraOutCost();
        Integer qtyPrecision = this.matrixDomainInfo.getQtyPrecision();
        Integer pricePrecision = this.matrixDomainInfo.getPricePrecision();
        Integer amtPrecision = this.matrixDomainInfo.getAmtPrecision();
        String tranInTitle = ResManager.loadKDString((String)"\u6210\u7ec4\u8f6c\u51fa", (String)"MatrixRptManager_4", (String)"fi-calx-algox", (Object[])new Object[0]);
        int tranOutIndex = this.holder.createNewEntry();
        this.holder.setBillType(tranOutIndex, tranInTitle);
        StringBuilder tranOutFormula = new StringBuilder();
        tranOutFormula.append(this.toBigDecimalString(totalTraOutQty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
        tranOutFormula.append('*');
        BigDecimal tranOutUnitActualCost = totalTraOutCost.compareTo(BigDecimal.ZERO) == 0 || totalTraOutQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : totalTraOutCost.divide(totalTraOutQty, (int)pricePrecision, RoundingMode.HALF_UP);
        tranOutFormula.append(this.toBigDecimalString(tranOutUnitActualCost));
        tranOutFormula.append('=');
        tranOutFormula.append(this.toBigDecimalString(totalTraOutCost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
        this.holder.setOutFormula(tranOutIndex, tranOutFormula.toString());
        Long accountId = this.matrixDomainInfo.getAccountId();
        for (Map.Entry<Long, CostSubElement> eleIdElement : this.getElementMap(accountId).entrySet()) {
            BigDecimal cost = this.matrixDomainInfo.getEleIdTraOutCostMap().get(eleIdElement.getKey());
            BigDecimal qty = this.matrixDomainInfo.getEleIdTraOutQtyMap().get(eleIdElement.getKey());
            if (cost == null || cost.compareTo(BigDecimal.ZERO) == 0) continue;
            qty = this.getBigDecimalNotNull(qty);
            int subIndex = this.holder.createNewSubEntry(tranOutIndex, eleIdElement.getValue().getName());
            StringBuilder endFormula = new StringBuilder();
            endFormula.append(this.toBigDecimalString(qty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
            endFormula.append('*');
            BigDecimal elementUnitActualCost = cost.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : cost.divide(qty, (int)pricePrecision, RoundingMode.HALF_UP);
            endFormula.append(this.toBigDecimalString(elementUnitActualCost));
            endFormula.append('=');
            endFormula.append(this.toBigDecimalString(cost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
            this.holder.setOutFormula(subIndex, endFormula.toString());
        }
    }

    private void createOutEntry() {
        BigDecimal totalOutQty = this.matrixDomainInfo.getTotalOutQty();
        BigDecimal totalOutCost = this.matrixDomainInfo.getTotalOutCost();
        Integer qtyPrecision = this.matrixDomainInfo.getQtyPrecision();
        Integer pricePrecision = this.matrixDomainInfo.getPricePrecision();
        Integer amtPrecision = this.matrixDomainInfo.getAmtPrecision();
        int outIndex = this.holder.createNewEntry();
        this.holder.setBillType(outIndex, ResManager.loadKDString((String)"\u666e\u901a\u51fa\u5e93", (String)"MatrixRptManager_5", (String)"fi-calx-algox", (Object[])new Object[0]));
        StringBuilder outFormula = new StringBuilder();
        outFormula.append(this.toBigDecimalString(totalOutQty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
        outFormula.append('*');
        BigDecimal outUnitActualCost = totalOutCost.compareTo(BigDecimal.ZERO) == 0 || totalOutQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : totalOutCost.divide(totalOutQty, (int)pricePrecision, RoundingMode.HALF_UP);
        outFormula.append(this.toBigDecimalString(outUnitActualCost));
        outFormula.append('=');
        outFormula.append(this.toBigDecimalString(totalOutCost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
        this.holder.setOutFormula(outIndex, outFormula.toString());
        Long accountId = this.matrixDomainInfo.getAccountId();
        for (Map.Entry<Long, CostSubElement> eleIdElement : this.getElementMap(accountId).entrySet()) {
            BigDecimal cost = this.matrixDomainInfo.getEleIdOutCostMap().get(eleIdElement.getKey());
            BigDecimal qty = this.matrixDomainInfo.getEleIdOutQtyMap().get(eleIdElement.getKey());
            if (cost == null || cost.compareTo(BigDecimal.ZERO) == 0) continue;
            qty = this.getBigDecimalNotNull(qty);
            int subIndex = this.holder.createNewSubEntry(outIndex, eleIdElement.getValue().getName());
            StringBuilder endFormula = new StringBuilder();
            endFormula.append(this.toBigDecimalString(qty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
            endFormula.append('*');
            BigDecimal elementUnitActualCost = cost.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : cost.divide(qty, (int)pricePrecision, RoundingMode.HALF_UP);
            endFormula.append(this.toBigDecimalString(elementUnitActualCost));
            endFormula.append('=');
            endFormula.append(this.toBigDecimalString(cost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
            this.holder.setOutFormula(subIndex, endFormula.toString());
        }
    }

    private void createFixOutEntry() {
        BigDecimal totalFixOutQty = this.matrixDomainInfo.getTotalFixOutQty();
        BigDecimal totalFixedOutCost = this.matrixDomainInfo.getTotalFixedOutCost();
        Integer qtyPrecision = this.matrixDomainInfo.getQtyPrecision();
        Integer pricePrecision = this.matrixDomainInfo.getPricePrecision();
        Integer amtPrecision = this.matrixDomainInfo.getAmtPrecision();
        int fixoutIndex = this.holder.createNewEntry();
        this.holder.setBillType(fixoutIndex, ResManager.loadKDString((String)"\u6210\u672c\u56fa\u5b9a\u51fa\u5e93", (String)"MatrixRptManager_3", (String)"fi-calx-algox", (Object[])new Object[0]));
        StringBuilder fixOutFormula = new StringBuilder();
        fixOutFormula.append(this.toBigDecimalString(totalFixOutQty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
        fixOutFormula.append('*');
        BigDecimal fixOutUnitActualCost = totalFixedOutCost.compareTo(BigDecimal.ZERO) == 0 || totalFixOutQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : totalFixedOutCost.divide(totalFixOutQty, (int)pricePrecision, RoundingMode.HALF_UP);
        fixOutFormula.append(this.toBigDecimalString(fixOutUnitActualCost));
        fixOutFormula.append('=');
        fixOutFormula.append(this.toBigDecimalString(totalFixedOutCost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
        this.holder.setOutFormula(fixoutIndex, fixOutFormula.toString());
        Long accountId = this.matrixDomainInfo.getAccountId();
        for (Map.Entry<Long, CostSubElement> eleIdElement : this.getElementMap(accountId).entrySet()) {
            BigDecimal cost = this.matrixDomainInfo.getEleIdFixedOutCostMap().get(eleIdElement.getKey());
            BigDecimal qty = this.matrixDomainInfo.getEleIdFixOutQtyMap().get(eleIdElement.getKey());
            if (cost == null || cost.compareTo(BigDecimal.ZERO) == 0) continue;
            qty = this.getBigDecimalNotNull(qty);
            int subIndex = this.holder.createNewSubEntry(fixoutIndex, eleIdElement.getValue().getName());
            StringBuilder endFormula = new StringBuilder();
            endFormula.append(this.toBigDecimalString(qty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
            endFormula.append('*');
            BigDecimal elementUnitActualCost = cost.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : cost.divide(qty, (int)pricePrecision, RoundingMode.HALF_UP);
            endFormula.append(this.toBigDecimalString(elementUnitActualCost));
            endFormula.append('=');
            endFormula.append(this.toBigDecimalString(cost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
            this.holder.setOutFormula(subIndex, endFormula.toString());
        }
    }

    private void createEndEntry() {
        Integer amtPrecision = this.matrixDomainInfo.getAmtPrecision();
        BigDecimal totalEndQty = this.matrixDomainInfo.getTotalEndQty();
        BigDecimal totalEndCost = this.matrixDomainInfo.getTotalEndCost();
        Integer qtyPrecision = this.matrixDomainInfo.getQtyPrecision();
        Integer pricePrecision = this.matrixDomainInfo.getPricePrecision();
        int endindex = this.holder.createNewEntry();
        this.holder.setBillType(endindex, ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d", (String)"AbstractAccountType_1", (String)"fi-calx-algox", (Object[])new Object[0]));
        StringBuilder endFormula = new StringBuilder();
        endFormula.append(this.toBigDecimalString(totalEndQty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
        endFormula.append('*');
        BigDecimal entUnitActualCost = totalEndQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : totalEndCost.divide(totalEndQty, (int)pricePrecision, RoundingMode.HALF_UP);
        endFormula.append(this.toBigDecimalString(entUnitActualCost));
        endFormula.append('=');
        endFormula.append(this.toBigDecimalString(totalEndCost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
        this.holder.setBalanceFormula(endindex, endFormula.toString());
        Long accountId = this.matrixDomainInfo.getAccountId();
        for (Map.Entry<Long, CostSubElement> eleIdElement : this.getElementMap(accountId).entrySet()) {
            BigDecimal cost = this.matrixDomainInfo.getEleIdEndCostMap().get(eleIdElement.getKey());
            BigDecimal qty = this.matrixDomainInfo.getTotalEndQty();
            if (cost == null || cost.compareTo(BigDecimal.ZERO) == 0) continue;
            qty = this.getBigDecimalNotNull(qty);
            int subIndex = this.holder.createNewSubEntry(endindex, eleIdElement.getValue().getName());
            StringBuilder eleEndFormula = new StringBuilder();
            eleEndFormula.append(this.toBigDecimalString(qty.setScale((int)qtyPrecision, RoundingMode.HALF_UP)));
            eleEndFormula.append('*');
            BigDecimal elementUnitActualCost = cost.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(pricePrecision) : cost.divide(qty, (int)pricePrecision, RoundingMode.HALF_UP);
            eleEndFormula.append(this.toBigDecimalString(elementUnitActualCost));
            eleEndFormula.append('=');
            eleEndFormula.append(this.toBigDecimalString(cost.setScale((int)amtPrecision, RoundingMode.HALF_UP)));
            this.holder.setBalanceFormula(subIndex, eleEndFormula.toString());
        }
    }

    private void dealRptStatus() {
        BigDecimal calPrice = this.matrixDomainInfo.getCalPrice();
        if (calPrice.compareTo(BigDecimal.ZERO) < 0) {
            RptStatus negRgtStaValue = this.getAvgNegPriceRptStatus();
            this.holder.setCalStatus(negRgtStaValue);
            this.holder.setNewLog(ResManager.loadKDString((String)"\u52a0\u6743\u8d1f\u5355\u4ef7", (String)"WeightedAvgAT_7", (String)"fi-calx-algox", (Object[])new Object[0]));
        }
        if (calPrice.compareTo(BigDecimal.ZERO) == 0) {
            this.holder.setCalStatus(RptStatus.WARNING);
            this.holder.setNewLog(ResManager.loadKDString((String)"\u52a0\u6743\u5355\u4ef7\u4e3a\u96f6", (String)"WeightedAvgAT_8", (String)"fi-calx-algox", (Object[])new Object[0]));
        }
        String rptErrorType = this.matrixDomainInfo.getRptErrorType();
        if (RptErrorTypeEnum.AVG_ZERO_PRICE.getValue().equals(rptErrorType)) {
            this.holder.setCalStatus(RptStatus.WARNING);
            this.holder.setNewLog(ResManager.loadKDString((String)"\u52a0\u6743\u5355\u4ef7\u4e3a\u96f6", (String)"WeightedAvgAT_8", (String)"fi-calx-algox", (Object[])new Object[0]));
        } else if (RptErrorTypeEnum.AVG_NEG_PRICE.getValue().equals(rptErrorType)) {
            RptStatus negRgtStaValue = this.getAvgNegPriceRptStatus();
            this.holder.setCalStatus(negRgtStaValue);
            this.holder.setNewLog(ResManager.loadKDString((String)"\u52a0\u6743\u8d1f\u5355\u4ef7", (String)"WeightedAvgAT_7", (String)"fi-calx-algox", (Object[])new Object[0]));
        } else if (RptErrorTypeEnum.AVG_POS_PRICE.getValue().equals(rptErrorType)) {
            this.holder.setCalStatus(RptStatus.SUCESS);
            this.holder.setNewLog("");
        }
        if (StringUtils.isEmpty((String)this.holder.getLog())) {
            BigDecimal totalEndQty = this.matrixDomainInfo.getTotalEndQty();
            BigDecimal totalEndCost = this.matrixDomainInfo.getTotalEndCost();
            if (totalEndQty.compareTo(BigDecimal.ZERO) != 0) {
                boolean isEndNegPrice;
                BigDecimal endPrice = totalEndCost.divide(totalEndQty, 10, RoundingMode.HALF_UP);
                boolean bl = isEndNegPrice = endPrice.compareTo(BigDecimal.ZERO) < 0;
                if (isEndNegPrice) {
                    this.holder.setCalStatus(RptStatus.WARNING);
                    this.holder.setNewLog(ResManager.loadKDString((String)"\u671f\u672b\u8d1f\u5355\u4ef7", (String)"AbstractAccountType_15", (String)"fi-calx-algox", (Object[])new Object[0]));
                }
            }
        }
    }

    private RptStatus getAvgNegPriceRptStatus() {
        RptStatus result = RptStatus.ERROR;
        String negRptSta = (String)this.commonInfo.getParamCache().getParamValue("matrix_neg_rpt_sta");
        if (RptStatus.WARNING == RptStatus.valueOf(negRptSta)) {
            result = RptStatus.WARNING;
        }
        CostPriceResultInfo priceInfo = this.matrixDomainInfo.getPriceInfo();
        boolean getPriceSuccess = new MatrixDesignCostHelper().isGetPriceSuccess(priceInfo);
        if (priceInfo != null && priceInfo.isSuccess() && getPriceSuccess) {
            result = RptStatus.WARNING;
        }
        return result;
    }

    protected String toBigDecimalString(BigDecimal bigdecimal) {
        String bgStr = bigdecimal.toPlainString();
        if (bigdecimal.signum() < 0) {
            bgStr = "(" + bgStr + ")";
        }
        return bgStr;
    }

    protected final Map<Long, CostSubElement> getElementMap(Long costAccountId) {
        Map<Long, CostSubElement> elementMap;
        if (this.commonInfo.getParamCache().isCalByElement(costAccountId)) {
            elementMap = this.commonInfo.getElementMap();
        } else {
            elementMap = new HashMap<Long, CostSubElement>(16);
            elementMap.put(773175233367685120L, this.commonInfo.getElementMap().get(773175233367685120L));
        }
        return elementMap;
    }

    public void setCommonInfo(CommonInfo commonInfo) {
        this.commonInfo = commonInfo;
    }

    public CommonInfo getCommonInfo() {
        return this.commonInfo;
    }

    public void setRowMeta(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public void save2Db() {
        try (TXHandle h = TX.requiresNew();){
            try {
                boolean hasBill = this.matrixDomainInfo.hashBill();
                this.holder.setHasBill(hasBill);
                this.holder.flushRptInfo(new DBRoute("cal"));
            }
            catch (Exception e1) {
                h.markRollback();
                throw e1;
            }
        }
    }

    private BigDecimal getBigDecimalNotNull(BigDecimal srcValue) {
        srcValue = srcValue == null ? BigDecimal.ZERO : srcValue;
        return srcValue;
    }

    public void setMatrixDomainInfo(MatrixAfterCalDomainInfo matrixDomainInfo) {
        this.matrixDomainInfo = matrixDomainInfo;
    }

    public void setRptHoder(CalOutRptHolder holder) {
        this.holder = holder;
    }
}

