/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.helper.MatrixDesignCostHelper;

public class DealDiffFunctoin
extends GroupReduceFunction {
    private static final long serialVersionUID = -6969203160968958349L;
    private final CommonInfo commonInfo;
    private RowMeta rowMeta;
    private RowMeta resultMeta;

    public DealDiffFunctoin(CommonInfo commonInfo, RowMeta rowMeta, RowMeta resultMeta) {
        this.rowMeta = rowMeta;
        this.resultMeta = resultMeta;
        this.commonInfo = commonInfo;
    }

    public RowMeta getResultRowMeta() {
        return this.resultMeta;
    }

    public void reduce(Iterable<RowX> arg0, Collector arg1) {
        boolean isDealDiff;
        Iterator<RowX> it = arg0.iterator();
        BigDecimal srcTotalAmt = BigDecimal.ZERO;
        BigDecimal targTotalAmt = BigDecimal.ZERO;
        BigDecimal maxTargQty = null;
        HashMap<Long, RowX> targBillRows = new HashMap<Long, RowX>(16);
        Long maxQtyEntryId = 0L;
        boolean hasSrcBill = false;
        boolean hasTgtBill = false;
        HashSet<Integer> tgtQtySigns = new HashSet<Integer>(15);
        BigDecimal sumSrcQty = BigDecimal.ZERO;
        BigDecimal sumTgtQty = BigDecimal.ZERO;
        int periodIdIndex = this.rowMeta.getFieldIndex("periodid");
        int costaccountIndex = this.rowMeta.getFieldIndex("costaccount");
        boolean hasLastPeriodTgtBill = false;
        boolean hasNotCalEntryId = false;
        while (it.hasNext()) {
            RowX row = it.next();
            Boolean iscompleted = row.getBoolean(this.rowMeta.getFieldIndex("iscompleted"));
            String type = row.getString(this.rowMeta.getFieldIndex("type"));
            BigDecimal currAmt = row.getBigDecimal(this.rowMeta.getFieldIndex("cost"));
            BigDecimal currQty = row.getBigDecimal(this.rowMeta.getFieldIndex("baseqty"));
            Long entryid = row.getLong(this.rowMeta.getFieldIndex("entryid"));
            Long costAcctId = row.getLong(costaccountIndex);
            Long curPeriodId = this.commonInfo.getParamCache().getCurrentPeriod(costAcctId);
            boolean notCalEntryId = new MatrixDesignCostHelper().isNotCalEntryId(this.rowMeta, row, this.commonInfo);
            boolean isGroup = StringUtils.isNotEmpty((String)type);
            if (notCalEntryId && isGroup) {
                hasNotCalEntryId = true;
                continue;
            }
            if (iscompleted == null || !iscompleted.booleanValue() || type == null) {
                this.collectRow(arg1, row);
                continue;
            }
            if ("0".equals(type)) {
                this.collectRow(arg1, row);
                srcTotalAmt = srcTotalAmt.add(currAmt);
                hasSrcBill = true;
                sumSrcQty = sumSrcQty.add(currQty);
                continue;
            }
            targTotalAmt = targTotalAmt.add(currAmt);
            if (maxTargQty == null || currQty.compareTo(maxTargQty) > 0) {
                maxTargQty = currQty;
                maxQtyEntryId = entryid;
            }
            targBillRows.put(entryid, row);
            hasTgtBill = true;
            tgtQtySigns.add(currQty.signum());
            sumTgtQty = sumTgtQty.add(currQty);
            if (row.getLong(periodIdIndex) <= curPeriodId) continue;
            hasLastPeriodTgtBill = true;
        }
        if (hasNotCalEntryId) {
            return;
        }
        boolean isTgtSameSign = this.getIsTgtQtySameSign(tgtQtySigns);
        boolean isSrcTgtDiff = srcTotalAmt.compareTo(targTotalAmt) != 0;
        boolean isMaxTgtQtyNotNull = maxTargQty != null;
        boolean bl = isDealDiff = hasSrcBill && hasTgtBill && isTgtSameSign && !hasLastPeriodTgtBill;
        if (isDealDiff && isSrcTgtDiff && isMaxTgtQtyNotNull) {
            BigDecimal diff = srcTotalAmt.abs().multiply(new BigDecimal(sumTgtQty.signum())).subtract(targTotalAmt);
            boolean isSrcNegPrice = srcTotalAmt.signum() * sumSrcQty.signum() < 0;
            diff = isSrcNegPrice ? BigDecimal.ZERO : diff;
            RowX maxEntryRow = (RowX)targBillRows.get(maxQtyEntryId);
            diff = this.adjDiff(diff, maxEntryRow);
            Long maxRowEntryId = maxEntryRow.getLong(this.rowMeta.getFieldIndex("entryid"));
            if (BigDecimal.ZERO.compareTo(diff) != 0) {
                for (Map.Entry targBillRow : targBillRows.entrySet()) {
                    RowX curTgtRow;
                    if (!((Long)targBillRow.getKey()).equals(maxRowEntryId) && BigDecimal.ZERO.compareTo(diff = this.adjDiff(diff, curTgtRow = (RowX)targBillRow.getValue())) == 0) break;
                }
            }
        }
        for (Map.Entry targBillRow : targBillRows.entrySet()) {
            this.collectRow(arg1, (RowX)targBillRow.getValue());
        }
    }

    private boolean getIsTgtQtySameSign(Set<Integer> tgtSigns) {
        boolean isTgtSameSign = true;
        int tgtSign = 0;
        for (Integer curTgtSign : tgtSigns) {
            int curTgtSignIntValue = curTgtSign;
            if (tgtSign == 0) {
                tgtSign = curTgtSignIntValue;
                continue;
            }
            if (tgtSign == curTgtSignIntValue) continue;
            isTgtSameSign = false;
        }
        return isTgtSameSign;
    }

    private void collectRow(Collector arg1, RowX row) {
        int periodIdIndex = this.rowMeta.getFieldIndex("periodid");
        int costAccontIdIndex = this.rowMeta.getFieldIndex("costaccount");
        Long costAcctId = row.getLong(costAccontIdIndex);
        Long curPeriodId = this.commonInfo.getParamCache().getCurrentPeriod(costAcctId);
        if (curPeriodId.compareTo(row.getLong(periodIdIndex)) != 0) {
            return;
        }
        arg1.collect(row);
    }

    private BigDecimal adjDiff(BigDecimal totalDiff, RowX maxEntryRow) {
        BigDecimal currTypeAmt;
        int periodIdIndex = this.rowMeta.getFieldIndex("periodid");
        int costAccontIdIndex = this.rowMeta.getFieldIndex("costaccount");
        int isfixedIndex = this.rowMeta.getFieldIndex("isfixed");
        Long costAcctId = maxEntryRow.getLong(costAccontIdIndex);
        Long curPeriodId = this.commonInfo.getParamCache().getCurrentPeriod(costAcctId);
        Boolean isfixed = maxEntryRow.getBoolean(isfixedIndex);
        if (isfixed != null && isfixed.booleanValue()) {
            return totalDiff;
        }
        if (curPeriodId.compareTo(maxEntryRow.getLong(periodIdIndex)) != 0) {
            return totalDiff;
        }
        if ((totalDiff = this.getAddPriceZeroDiff(totalDiff, maxEntryRow)).compareTo(BigDecimal.ZERO) == 0) {
            return totalDiff;
        }
        BigDecimal maxAmt = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("cost"));
        String elementType = maxEntryRow.getString(this.rowMeta.getFieldIndex("elementtype"));
        BigDecimal newCost = maxAmt.add(totalDiff);
        BigDecimal maxTargQty = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("baseqty"));
        boolean isAdj = newCost.signum() == maxTargQty.signum() || newCost.signum() == 0;
        BigDecimal curDiff = BigDecimal.ZERO;
        if (isAdj) {
            curDiff = totalDiff;
            totalDiff = BigDecimal.ZERO;
        } else {
            curDiff = maxAmt.negate();
            totalDiff = totalDiff.subtract(curDiff);
        }
        newCost = maxAmt.add(curDiff);
        maxEntryRow.set(this.rowMeta.getFieldIndex("cost"), (Object)newCost);
        maxEntryRow.set(this.rowMeta.getFieldIndex("actualcost"), (Object)newCost);
        if ("001".equals(elementType)) {
            currTypeAmt = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("materialcost"));
            maxEntryRow.set(this.rowMeta.getFieldIndex("materialcost"), (Object)currTypeAmt.add(curDiff));
        } else if ("002".equals(elementType)) {
            currTypeAmt = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("fee"));
            maxEntryRow.set(this.rowMeta.getFieldIndex("fee"), (Object)currTypeAmt.add(curDiff));
        } else if ("003".equals(elementType)) {
            currTypeAmt = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("manufacturecost"));
            maxEntryRow.set(this.rowMeta.getFieldIndex("manufacturecost"), (Object)currTypeAmt.add(curDiff));
        } else if ("004".equals(elementType)) {
            currTypeAmt = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("resource"));
            maxEntryRow.set(this.rowMeta.getFieldIndex("resource"), (Object)currTypeAmt.add(curDiff));
        } else if ("005".equals(elementType)) {
            currTypeAmt = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("processcost"));
            maxEntryRow.set(this.rowMeta.getFieldIndex("processcost"), (Object)currTypeAmt.add(curDiff));
        }
        String queueType = maxEntryRow.getString(this.rowMeta.getFieldIndex("queuetype"));
        if ("1".equals(queueType)) {
            maxEntryRow.set(this.rowMeta.getFieldIndex("tranoutcost"), (Object)newCost);
        } else {
            maxEntryRow.set(this.rowMeta.getFieldIndex("tranincost"), (Object)newCost);
        }
        return totalDiff;
    }

    private BigDecimal getAddPriceZeroDiff(BigDecimal diff, RowX maxEntryRow) {
        BigDecimal addPricePercent;
        int addPriceFieldIndex = this.rowMeta.getFieldIndex("addpricefield", false);
        if (addPriceFieldIndex >= 0 && (addPricePercent = maxEntryRow.getBigDecimal(addPriceFieldIndex)) != null && BigDecimal.ZERO.compareTo(addPricePercent) != 0) {
            diff = BigDecimal.ZERO;
        }
        return diff;
    }
}

