/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.RowX;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.CalOutDataRangeHolder;
import kd.fi.calx.algox.CalRange;
import kd.fi.calx.algox.CostAccount;
import kd.fi.calx.algox.function.CommonInfo;

public class DealDomainInfoFunction
extends FlatMapFunction {
    private static final long serialVersionUID = -510111792657224821L;
    private final List<CalOutDataRangeHolder.CalOutRange> calOutRangeList;
    private RowMeta rowMeta;
    private RowMeta resultMeta;
    private CommonInfo commonInfo;
    private Map<Long, CostAccount> costAccountMap;
    private static final char CONNECTOR = '_';
    public static final String CAL_DIMENSION_VALUE = "calDimensionValue";
    public static final String CALRANGE = "calrangeid";
    public static final String COSTACCOUNT = "costaccount";
    public static final String DIVIDE_BASIS_VALUE = "divideBasisValue";
    public static final String MATERIAL = "material";
    private List<String> costDomainList = Arrays.asList("calDimensionValue", "calrangeid", "costaccount", "divideBasisValue", "material");

    public DealDomainInfoFunction(RowMeta rowMeta, CommonInfo commonInfo, Map<Long, CostAccount> costAccountMap, List<CalOutDataRangeHolder.CalOutRange> calOutRangeList) {
        this.rowMeta = rowMeta;
        this.commonInfo = commonInfo;
        this.costAccountMap = costAccountMap;
        this.resultMeta = this.createResultMeta(rowMeta);
        this.costDomainList.sort(Comparator.naturalOrder());
        this.calOutRangeList = calOutRangeList;
    }

    public RowMeta getResultRowMeta() {
        return this.resultMeta;
    }

    public void flatMap(RowX row, Collector collector) {
        RowX resultRow = this.createResultRow(row);
        this.setCalRangeId(row, resultRow);
        if (!this.isInCalRange(row)) {
            return;
        }
        this.setDividebasis(row, resultRow);
        this.setCalDimension(row, resultRow);
        this.setDomain(resultRow);
        collector.collect(resultRow);
    }

    private boolean isInCalRange(RowX row) {
        Long calRangeId = this.getCalRangeId(row);
        for (CalOutDataRangeHolder.CalOutRange range : this.calOutRangeList) {
            if (!calRangeId.equals(range.getCalRangeId())) continue;
            return true;
        }
        return false;
    }

    private void setCalRangeId(RowX row, RowX resultRow) {
        CalRange emptyRange;
        int rowType = this.rowMeta.getFieldIndex("rowtype", false);
        if (rowType < 0) {
            return;
        }
        Long costAccountId = (Long)this.getRowValue(row, COSTACCOUNT, false);
        Long calRangeId = null;
        CostAccount costAccount = this.costAccountMap.get(costAccountId);
        for (CalRange calRange : costAccount.getNotEmptyCalRange()) {
            CalRange.CalRangeEntry rangeEntry = calRange.getValidCalRangeEntry(row, this.rowMeta);
            if (rangeEntry == null) continue;
            calRangeId = rangeEntry.getRangeId();
            break;
        }
        if (calRangeId == null && (emptyRange = costAccount.getEmptyCalRange()) != null) {
            calRangeId = emptyRange.getRangeId();
        }
        if (calRangeId == null) {
            calRangeId = (Long)this.getRowValue(row, CALRANGE, false);
        }
        row.set(this.resultMeta.getFieldIndex(CALRANGE), (Object)calRangeId);
        resultRow.set(this.resultMeta.getFieldIndex(CALRANGE), (Object)calRangeId);
    }

    private Long getCalRangeId(RowX row) {
        return row.getLong(this.rowMeta.getFieldIndex(CALRANGE));
    }

    private RowX createResultRow(RowX row) {
        int sourceCount = this.rowMeta.getFieldCount();
        RowX resultRow = new RowX(this.resultMeta.getFieldCount());
        for (int i = 0; i < sourceCount; ++i) {
            resultRow.set(i, row.get(i));
        }
        return resultRow;
    }

    private void setDividebasis(RowX row, RowX resultRow) {
        Long calRangeId = row.getLong(this.resultMeta.getFieldIndex(CALRANGE));
        Long costaccountid = row.getLong(this.resultMeta.getFieldIndex(COSTACCOUNT));
        CalRange calRange = this.commonInfo.getCalRangeInfoMap().get(calRangeId);
        CostAccount costAccount = this.costAccountMap.get(costaccountid);
        StringBuilder sb = new StringBuilder();
        StringBuilder valueSb = new StringBuilder();
        for (String basis : costAccount.getDivideBasis()) {
            valueSb.append(this.getRowValue(row, basis, true));
            valueSb.append('_');
            sb.append(basis);
            sb.append(',');
        }
        if (sb.length() != 0 && sb.toString().endsWith(",")) {
            sb.deleteCharAt(sb.length() - 1);
        }
        resultRow.set(this.resultMeta.getFieldIndex("divideBasisStr"), (Object)sb.toString());
        resultRow.set(this.resultMeta.getFieldIndex("divideBasis"), (Object)costAccount.getDivideBasisID());
        if (!calRange.isEmpty()) {
            resultRow.set(this.resultMeta.getFieldIndex(DIVIDE_BASIS_VALUE), (Object)"#");
        } else {
            resultRow.set(this.resultMeta.getFieldIndex(DIVIDE_BASIS_VALUE), (Object)valueSb.toString());
        }
    }

    private void setCalDimension(RowX row, RowX resultRow) {
        Long costaccountid = row.getLong(this.resultMeta.getFieldIndex(COSTACCOUNT));
        CostAccount costAccount = this.costAccountMap.get(costaccountid);
        Long calRangeId = row.getLong(this.resultMeta.getFieldIndex(CALRANGE));
        CalRange calRange = this.commonInfo.getCalRangeInfoMap().get(calRangeId);
        Long materialId = (Long)this.getRowValue(row, MATERIAL, false);
        String mGroupNo = (String)this.getRowValue(row, "materialGroupNo", false);
        String spCaldimension = null;
        spCaldimension = costAccount.getSpCaldimension(calRangeId.toString(), materialId.toString(), mGroupNo);
        Long calDimensionID = 0L;
        String calDimesionStr = "";
        if (spCaldimension == null) {
            calDimensionID = calRange.getCalDimensionID();
            calDimesionStr = calRange.getCaldimension();
        } else {
            String[] spArr = spCaldimension.split("@");
            calDimensionID = Long.valueOf(spArr[0]);
            calDimesionStr = spArr[1];
        }
        resultRow.set(this.resultMeta.getFieldIndex("calDimension"), (Object)calDimensionID);
        StringBuilder valueSb = new StringBuilder();
        if (!StringUtils.isEmpty((String)calDimesionStr)) {
            for (String dimension : calDimesionStr.split(",")) {
                valueSb.append(this.getRowValue(row, dimension, true));
                valueSb.append('_');
            }
        }
        resultRow.set(this.resultMeta.getFieldIndex("calDimensionStr"), (Object)calDimesionStr);
        resultRow.set(this.resultMeta.getFieldIndex(CAL_DIMENSION_VALUE), (Object)valueSb.toString());
    }

    private void setDomain(RowX resultRow) {
        StringBuilder dimensionStr = new StringBuilder();
        for (String field : this.costDomainList) {
            Object value = this.getResultRowValue(resultRow, field, false);
            if (value == null || "".equals(value)) {
                value = "#";
            }
            dimensionStr.append(value);
            dimensionStr.append("_");
        }
        String domainId = DealDomainInfoFunction.getSHA256Base64Str(dimensionStr.toString());
        resultRow.set(this.resultMeta.getFieldIndex("domainid"), (Object)domainId);
    }

    private Object getRowValue(RowX row, String field, boolean isDivideOrCaldimension) {
        int index = this.rowMeta.getFieldIndex(field);
        Object value = row.get(index);
        if (isDivideOrCaldimension && (value == null || value.equals(""))) {
            value = "#";
        }
        return value;
    }

    private Object getResultRowValue(RowX row, String field, boolean isDivideOrCaldimension) {
        int index = this.resultMeta.getFieldIndex(field);
        Object value = row.get(index);
        if (isDivideOrCaldimension && (value == null || value.equals(""))) {
            value = "#";
        }
        return value;
    }

    private static String getSHA256Base64Str(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDBizException(String.format("getSHA256Base64Str:[%s] args:[%s]", e.getMessage(), message));
        }
    }

    private RowMeta createResultMeta(RowMeta rowMeta) {
        Field[] sourceFields = rowMeta.getFields();
        int sourceArrLength = sourceFields.length;
        Field divideBasis = new Field("divideBasis", (DataType)DataType.LongType);
        Field divideBasisStr = new Field("divideBasisStr", (DataType)DataType.StringType);
        Field divideBasisValue = new Field(DIVIDE_BASIS_VALUE, (DataType)DataType.StringType);
        Field calRange = new Field("calRange", (DataType)DataType.LongType);
        Field calDimension = new Field("calDimension", (DataType)DataType.LongType);
        Field calDimensionStr = new Field("calDimensionStr", (DataType)DataType.StringType);
        Field calDimensionValue = new Field(CAL_DIMENSION_VALUE, (DataType)DataType.StringType);
        Field domainid = new Field("domainid", (DataType)DataType.StringType);
        Field[] resultFields = new Field[sourceArrLength + 8];
        System.arraycopy(sourceFields, 0, resultFields, 0, sourceArrLength);
        resultFields[sourceArrLength] = divideBasis;
        resultFields[sourceArrLength + 1] = divideBasisStr;
        resultFields[sourceArrLength + 2] = divideBasisValue;
        resultFields[sourceArrLength + 3] = calRange;
        resultFields[sourceArrLength + 4] = calDimension;
        resultFields[sourceArrLength + 5] = calDimensionStr;
        resultFields[sourceArrLength + 6] = calDimensionValue;
        resultFields[sourceArrLength + 7] = domainid;
        return new RowMeta(resultFields);
    }
}

