/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.accounttype.CostAdjustInfo;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.helper.MatrixDesignCostHelper;

public class DealGroupAdjFunction
extends GroupReduceFunction {
    private final CommonInfo commonInfo;
    private final RowMeta rowMeta;

    public DealGroupAdjFunction(CommonInfo commonInfo, RowMeta rowMeta) {
        this.commonInfo = commonInfo;
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        Iterator<RowX> iterator = iter.iterator();
        HashMap<Long, CostAdjustInfo> recEntIdCostAdjBillMap = new HashMap<Long, CostAdjustInfo>(16);
        HashMap<Long, BigDecimal> recEIdTotalAdjCostMap = new HashMap<Long, BigDecimal>(16);
        this.dealAdjEle(collector, iterator, recEntIdCostAdjBillMap, recEIdTotalAdjCostMap);
        Map<Long, CostAdjustInfo> adjustInfoMap = this.dealAdjEntry(recEntIdCostAdjBillMap, recEIdTotalAdjCostMap);
        this.flushCostAdjust(adjustInfoMap);
    }

    private void dealAdjEle(Collector collector, Iterator<RowX> iterator, Map<Long, CostAdjustInfo> recEntIdCostAdjBillMap, Map<Long, BigDecimal> recEIdTotalAdjCostMap) {
        HashMap<String, RowX> groupEntryIdEleRowMap = new HashMap<String, RowX>(16);
        while (iterator.hasNext()) {
            BigDecimal cost;
            BigDecimal adjustCost;
            boolean noAdjGroupDiff;
            RowX row = iterator.next();
            String grouptype = row.getString(this.rowMeta.getFieldIndex("type"));
            String entryEleStr = "" + row.getLong(this.rowMeta.getFieldIndex("entryid")) + row.getLong(this.rowMeta.getFieldIndex("subelementid"));
            if ("0".equals(grouptype) || "1".equals(grouptype)) {
                boolean isGroupSrcNotAdd;
                boolean bl = isGroupSrcNotAdd = !groupEntryIdEleRowMap.containsKey(entryEleStr);
                if (isGroupSrcNotAdd || "1".equals(grouptype)) {
                    groupEntryIdEleRowMap.put(entryEleStr, row);
                }
            } else {
                collector.collect(row);
            }
            Boolean isVoucher = row.getBoolean(this.rowMeta.getFieldIndex("isvoucher"));
            Boolean isRework = row.getBoolean(this.rowMeta.getFieldIndex("isrework"));
            if (!isVoucher.booleanValue() && !isRework.booleanValue() || !"1".equals(grouptype) || (noAdjGroupDiff = this.getIsNoAdjGroupDiff(row))) continue;
            BigDecimal oriCost = row.getBigDecimal(this.rowMeta.getFieldIndex("oricost"));
            Long costAcctId = row.getLong(this.rowMeta.getFieldIndex("costaccount"));
            boolean isCalByElement = this.commonInfo.getParamCache().isCalByElement(costAcctId);
            if (!isCalByElement) {
                oriCost = row.getBigDecimal(this.rowMeta.getFieldIndex("orimaterialcost"));
            }
            if ((adjustCost = (cost = row.getBigDecimal(this.rowMeta.getFieldIndex("cost"))).subtract(oriCost)).compareTo(BigDecimal.ZERO) == 0) continue;
            Long costAccountId = row.getLong(this.rowMeta.getFieldIndex("costaccount"));
            boolean isCalByEle = this.commonInfo.getParamCache().isCalByElement(costAccountId);
            Long headId = row.getLong(this.rowMeta.getFieldIndex("id"));
            Long entryId = row.getLong(this.rowMeta.getFieldIndex("entryid"));
            String callbilltype = row.getString(this.rowMeta.getFieldIndex("calbilltype"));
            callbilltype = "IN".equals(callbilltype) ? "A" : "B";
            CostAdjustInfo adjustInfo = recEntIdCostAdjBillMap.get(entryId);
            if (adjustInfo == null) {
                adjustInfo = CostAdjustInfo.createCostAdjustByRecord(headId, entryId, callbilltype, "F", null);
                recEntIdCostAdjBillMap.put(entryId, adjustInfo);
            }
            if (isCalByEle) {
                CostSubElement subElement = this.commonInfo.getElementMap().get(row.getLong(this.rowMeta.getFieldIndex("subelementid")));
                adjustInfo.setAdjustCost(subElement, adjustCost);
            } else {
                BigDecimal totalAdjCost = recEIdTotalAdjCostMap.get(entryId);
                totalAdjCost = totalAdjCost == null ? adjustCost : totalAdjCost.add(adjustCost);
                recEIdTotalAdjCostMap.put(entryId, totalAdjCost);
            }
            if (adjustInfo == null) continue;
            DynamicObject adjBillDyc = adjustInfo.getCostAdjustBill();
            String billNo = adjBillDyc.getString("billno");
            Date bizDate = adjustInfo.getBizDate();
            Date auditDate = adjustInfo.getAuditDate();
            ArrayList<Object> adjInfos = new ArrayList<Object>(5);
            adjInfos.add(billNo);
            adjInfos.add(adjustCost);
            adjInfos.add(bizDate.getTime());
            adjInfos.add(auditDate.getTime());
            adjInfos.add(adjustInfo.getCostAdjustEntryId());
            String adjInfoStr = SerializationUtils.toJsonString(adjInfos);
            row.set(this.rowMeta.getFieldIndex("adjinfo"), (Object)adjInfoStr);
        }
        for (RowX rowX : groupEntryIdEleRowMap.values()) {
            boolean isFixedSrcBill;
            String groupType = rowX.getString(this.rowMeta.getFieldIndex("type"));
            Boolean isfixed = rowX.getBoolean(this.rowMeta.getFieldIndex("isfixed"));
            isfixed = isfixed == null ? Boolean.FALSE : isfixed;
            boolean bl = isFixedSrcBill = "0".equals(groupType) && isfixed != false;
            if (isFixedSrcBill) continue;
            collector.collect(rowX);
        }
    }

    private Map<Long, CostAdjustInfo> dealAdjEntry(Map<Long, CostAdjustInfo> recEntIdCostAdjBillMap, Map<Long, BigDecimal> recEIdTotalAdjCostMap) {
        HashMap<Long, CostAdjustInfo> adjustInfoMap = new HashMap<Long, CostAdjustInfo>(16);
        for (Map.Entry<Long, CostAdjustInfo> recEntIdAdjBill : recEntIdCostAdjBillMap.entrySet()) {
            Long recEId = recEntIdAdjBill.getKey();
            CostAdjustInfo adjustInfo = recEntIdAdjBill.getValue();
            Object costAccount = adjustInfo.getCostAdjustBill().get("costaccount");
            if (costAccount instanceof DynamicObject) {
                costAccount = ((DynamicObject)costAccount).getPkValue();
            }
            if (!this.commonInfo.getParamCache().isCalByElement((Long)costAccount)) {
                BigDecimal totalAdjCost = recEIdTotalAdjCostMap.get(recEId);
                adjustInfo.setAdjustCost(this.commonInfo.getElementMap().get(773175233367685120L), totalAdjCost);
            }
            adjustInfoMap.put(adjustInfo.getCostAdjustEntryId(), adjustInfo);
        }
        return adjustInfoMap;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private void flushCostAdjust(Map<Long, CostAdjustInfo> adjustInfoMap) {
        DynamicObject[] adjustDyInfos = new DynamicObject[adjustInfoMap.size()];
        int i = 0;
        HashMap periodAdjustInfoMap = new HashMap(16);
        for (CostAdjustInfo costAdjustInfo : adjustInfoMap.values()) {
            adjustDyInfos[i] = costAdjustInfo.getCostAdjustBill();
            ++i;
            Object period = costAdjustInfo.getCostAdjustBill().get("period");
            periodAdjustInfoMap.putIfAbsent(period, new ArrayList());
            List adjustInfoList = (List)periodAdjustInfoMap.get(period);
            adjustInfoList.add(costAdjustInfo.getCostAdjustEntryId());
        }
        SaveServiceHelper.save((DynamicObject[])adjustDyInfos);
        HashSet<Long> adjustIdSet = new HashSet<Long>(16);
        for (DynamicObject info : adjustDyInfos) {
            adjustIdSet.add(info.getLong("id"));
        }
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((Object[])adjustIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreop", "true");
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignoreValidation", "true");
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])dynamicObjectArray, (OperateOption)option);
        if (!opResult.isSuccess()) {
            throw new KDBizException(opResult.getAllErrorOrValidateInfo() + "\r\n" + opResult.getMessage());
        }
        for (List entryIdList : periodAdjustInfoMap.values()) {
            this.commonInfo.getBalanceCalculator().updateBalance4CostAdjust(entryIdList.toArray());
        }
    }

    private boolean getIsNoAdjGroupDiff(RowX row) {
        boolean notCalEntryId;
        boolean isPurOrOmInFixed;
        boolean noAdjGroupDiff = false;
        Long costAcctId = row.getLong(this.rowMeta.getFieldIndex("costaccount"));
        boolean isCalByElement = this.commonInfo.getParamCache().isCalByElement(costAcctId);
        Boolean isApWf = row.getBoolean(this.rowMeta.getFieldIndex("issubbillinvoiceverify"));
        String bizEntity = row.getString(this.rowMeta.getFieldIndex("bizentityobject"));
        Set purSet = (Set)this.commonInfo.getParamCache().getParamValue("purBizEntityObjectSet");
        boolean isPurInEntity = purSet.contains(bizEntity);
        if (!isCalByElement && isApWf.booleanValue() && isPurInEntity) {
            noAdjGroupDiff = true;
        }
        Set omInSet = (Set)this.commonInfo.getParamCache().getParamValue("ominBizEntityObjectSet");
        boolean isPurIn = purSet.contains(bizEntity);
        boolean isOmIn = omInSet.contains(bizEntity);
        String elementType = row.getString(this.rowMeta.getFieldIndex("elementtype"));
        boolean isPurFixed = isPurIn && "001".equals(elementType);
        boolean isOmInFixed = isOmIn && "005".equals(elementType);
        boolean bl = isPurOrOmInFixed = isPurFixed || isOmInFixed;
        if (isCalByElement && isApWf.booleanValue() && isPurOrOmInFixed) {
            noAdjGroupDiff = true;
        }
        if (notCalEntryId = new MatrixDesignCostHelper().isNotCalEntryId(this.rowMeta, row, this.commonInfo)) {
            noAdjGroupDiff = true;
        }
        return noAdjGroupDiff;
    }
}

