/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.LinearEquationsDataFactory;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.log.MatrixLogUtils;
import kd.fi.calx.algox.matrix.obj.MatrixInfo;

public class DealMatrixBySubElement {
    private static final Log logger = LogFactory.getLog(DealMatrixBySubElement.class);
    private Long subElementId;
    private CommonInfo commonInfo;
    private Map<Object, BigDecimal> beginCosts = new HashMap<Object, BigDecimal>(16);
    private Map<Object, BigDecimal> domainIdOutPriceMap = new HashMap<Object, BigDecimal>(16);
    private Map<Object, BigDecimal> fixedInCosts = new HashMap<Object, BigDecimal>(16);
    private Map<Object, BigDecimal> transInQtys = new HashMap<Object, BigDecimal>(16);
    private Map<Object, BigDecimal> transOutQtys = new HashMap<Object, BigDecimal>(16);
    private Map<Object, BigDecimal> fixedOutCosts = new HashMap<Object, BigDecimal>(16);
    private Map<Object, BigDecimal> beginQtys = new HashMap<Object, BigDecimal>(16);
    private Map<Object, BigDecimal> inQtys = new HashMap<Object, BigDecimal>(16);
    private Map<Object, BigDecimal> outQtys = new HashMap<Object, BigDecimal>(16);
    private Map<Object, BigDecimal> fixedOutQtys = new HashMap<Object, BigDecimal>(16);
    private Map<Object, BigDecimal> fixedInQtys = new HashMap<Object, BigDecimal>(16);
    private Map<String, Set<String>> destDomainIdTransKeyMap = new HashMap<String, Set<String>>(16);
    private List<String> domainIds = new ArrayList<String>(16);
    private Map<Object, BigDecimal> destDomainTransOutQtyMap = new HashMap<Object, BigDecimal>(16);
    private Boolean matrixChangeOne;
    private Boolean matrixUseOutPrice;
    private String sortId = "";
    private final Map<String, Object[]> domainIdResultMap = new HashMap<String, Object[]>(16);

    public DealMatrixBySubElement(CommonInfo commonInfo) {
        this.commonInfo = commonInfo;
        this.matrixChangeOne = (Boolean)commonInfo.getParamCache().getParamValue("matrix_change_one");
        this.matrixUseOutPrice = (Boolean)commonInfo.getParamCache().getParamValue("matrix_use_outprice");
    }

    public void addDomainInfoByRow(RowX row, RowMeta rowMeta) {
        String dySortListId = row.getString(rowMeta.getFieldIndex("dysortlistid"));
        this.sortId = StringUtils.isEmpty((String)dySortListId) ? this.sortId : dySortListId;
        String domainId = row.getString(rowMeta.getFieldIndex("domainid"));
        String srcDomainId = row.getString(rowMeta.getFieldIndex("srcdomainid"));
        BigDecimal balPeriodOutQty = row.getBigDecimal(rowMeta.getFieldIndex("baseqty_out"));
        BigDecimal balPeriodOutCost = row.getBigDecimal(rowMeta.getFieldIndex("actualcost_out"));
        BigDecimal outPrice = balPeriodOutQty.compareTo(BigDecimal.ZERO) != 0 ? balPeriodOutCost.divide(balPeriodOutQty, 10, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        this.domainIdOutPriceMap.put(domainId, outPrice);
        this.beginCosts.put(domainId, row.getBigDecimal(rowMeta.getFieldIndex("begincost")));
        this.fixedInCosts.put(domainId, row.getBigDecimal(rowMeta.getFieldIndex("fixedincost")));
        String transKey = srcDomainId + "_" + domainId;
        BigDecimal transQty = row.getBigDecimal(rowMeta.getFieldIndex("transqty"));
        transQty = transQty == null ? BigDecimal.ZERO : transQty;
        this.transInQtys.put(transKey, transQty);
        BigDecimal transOutQty = row.getBigDecimal(rowMeta.getFieldIndex("calouttransqty"));
        transOutQty = transOutQty == null ? BigDecimal.ZERO : transOutQty;
        this.transOutQtys.put(transKey, transOutQty);
        BigDecimal tmpTransOutQty = this.destDomainTransOutQtyMap.computeIfAbsent(domainId, k -> BigDecimal.ZERO);
        this.destDomainTransOutQtyMap.put(domainId, tmpTransOutQty.add(transOutQty));
        Set srcDestDomainId = this.destDomainIdTransKeyMap.computeIfAbsent(domainId, k -> new HashSet(16));
        srcDestDomainId.add(transKey);
        this.fixedOutCosts.put(domainId, row.getBigDecimal(rowMeta.getFieldIndex("fixedoutcost")));
        this.beginQtys.put(domainId, row.getBigDecimal(rowMeta.getFieldIndex("beginqty")));
        this.inQtys.put(domainId, row.getBigDecimal(rowMeta.getFieldIndex("inqty")));
        this.outQtys.put(domainId, row.getBigDecimal(rowMeta.getFieldIndex("outqty")));
        this.fixedOutQtys.put(domainId, row.getBigDecimal(rowMeta.getFieldIndex("fixedoutqty")));
        this.fixedInQtys.put(domainId, row.getBigDecimal(rowMeta.getFieldIndex("fixedinqty")));
        if (!this.domainIds.contains(domainId)) {
            this.domainIds.add(domainId);
        }
        this.subElementId = row.getLong(rowMeta.getFieldIndex("subelementid"));
    }

    public Map<String, Object[]> dealMatrix() {
        int domainSize = this.domainIds.size();
        ArrayList<Integer> noOutPutIndex = new ArrayList<Integer>(16);
        ArrayList<Integer> noInPutIndex = new ArrayList<Integer>(16);
        for (int index = 0; index < domainSize; ++index) {
            String currDomainId = this.domainIds.get(index);
            this.dealNotDomainOut(noOutPutIndex, index, currDomainId);
            this.dealNoBeginNoIn(noInPutIndex, index, currDomainId);
        }
        BigDecimal[][] variableCoef = new BigDecimal[domainSize][domainSize];
        BigDecimal[] constantCoef = new BigDecimal[domainSize];
        this.buildMatrix(domainSize, variableCoef, constantCoef);
        this.dealSelfValZero(variableCoef, constantCoef);
        if (!this.matrixChangeOne.booleanValue()) {
            variableCoef = this.removeNoOutVar(domainSize, noOutPutIndex, variableCoef);
        }
        variableCoef = this.removeNoOutVar(domainSize, noInPutIndex, variableCoef);
        if (!this.matrixChangeOne.booleanValue()) {
            constantCoef = this.removeNoOutCon(domainSize, noOutPutIndex, constantCoef);
        }
        constantCoef = this.removeNoOutCon(domainSize, noInPutIndex, constantCoef);
        BigDecimal[] resolveResult = null;
        MatrixInfo matrixInfo = new MatrixInfo();
        this.setCommonMatrixInfo(matrixInfo);
        matrixInfo.setNoOutPutIndex(noOutPutIndex);
        matrixInfo.setNoInPutIndex(noInPutIndex);
        matrixInfo.setConstantCoef(constantCoef);
        matrixInfo.setVariableCoef(variableCoef);
        MatrixLogUtils logUtils = new MatrixLogUtils(this.commonInfo, matrixInfo);
        resolveResult = this.resolveMatrix(domainSize, matrixInfo, logUtils);
        Map<String, BigDecimal> domainPriceMap = this.getDomainPriceMap(matrixInfo, resolveResult);
        matrixInfo.setResolveResult(resolveResult);
        matrixInfo.setDomainPriceMap(domainPriceMap);
        logUtils.logDetailInfo();
        this.buildResult(domainSize, resolveResult, domainPriceMap);
        return this.domainIdResultMap;
    }

    private Map<String, BigDecimal> getDomainPriceMap(MatrixInfo matrixInfo, BigDecimal[] resolveResult) {
        List<Integer> noOutPutIndex = matrixInfo.getNoOutPutIndex();
        List<Integer> noInPutIndex = matrixInfo.getNoInPutIndex();
        HashMap<String, BigDecimal> domainPriceMap = new HashMap<String, BigDecimal>(16);
        if (resolveResult != null) {
            int index = 0;
            int resultIndex = 0;
            for (String domainId : this.domainIds) {
                boolean removeNoOut = noOutPutIndex.contains(index) && this.matrixChangeOne == false;
                boolean removeNoIn = noInPutIndex.contains(index);
                if (removeNoOut || removeNoIn) {
                    ++index;
                    continue;
                }
                ++index;
                domainPriceMap.put(domainId, resolveResult[resultIndex++]);
            }
        }
        return domainPriceMap;
    }

    private void buildResult(int domainSize, BigDecimal[] resolveResult, Map<String, BigDecimal> domainPriceMap) {
        boolean isNoResult = resolveResult == null || resolveResult.length < 1;
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < domainSize; ++index) {
            String currDomainId = this.domainIds.get(index);
            Object[] result = new Object[6];
            result[0] = currDomainId;
            result[1] = this.subElementId;
            BigDecimal price = BigDecimal.ZERO;
            if (!isNoResult) {
                BigDecimal domainPrice = domainPriceMap.get(currDomainId);
                BigDecimal bigDecimal = price = domainPrice == null ? BigDecimal.ZERO : domainPrice;
                if (price.compareTo(BigDecimal.ZERO) == 0) {
                    BigDecimal noOutDomainPrice;
                    price = noOutDomainPrice = this.getNoOutDomainPrice(currDomainId, this.destDomainIdTransKeyMap, this.transInQtys, domainPriceMap);
                    builder.append("\r\n");
                    builder.append(currDomainId);
                    builder.append(", subelementId:");
                    builder.append(this.subElementId);
                    builder.append(",");
                    builder.append(price);
                }
            }
            price = this.dealZeroOrNegPrice(price, currDomainId);
            result[2] = price;
            result[3] = this.sortId;
            result[4] = "";
            result[5] = "";
            this.domainIdResultMap.put(currDomainId, result);
        }
        if (builder.length() > 0) {
            String string = builder.toString();
            logger.info("\u6210\u672c\u57df\u65e0\u89e3\uff08\u89e3\u4e3a0\uff09\uff1a" + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal[] resolveMatrix(int domainSize, MatrixInfo matrixInfo, MatrixLogUtils logUtils) {
        BigDecimal[] resolveResult;
        BigDecimal[][] variableCoef = matrixInfo.getVariableCoef();
        BigDecimal[] constantCoef = matrixInfo.getConstantCoef();
        try (LinearEquationsDataFactory linearEqDataFactory = null;){
            logUtils.logBeforeResolve();
            linearEqDataFactory = new LinearEquationsDataFactory(null, null);
            Boolean newSov = (Boolean)this.commonInfo.getParamCache().getParamValue("matrix_new_resolve");
            resolveResult = newSov.booleanValue() ? linearEqDataFactory.resolveNew(variableCoef, constantCoef) : linearEqDataFactory.resolve(variableCoef, constantCoef);
        }
        return resolveResult;
    }

    public Object[] getResultByDomainId(String domainId) {
        Object[] result = this.domainIdResultMap.get(domainId);
        return result;
    }

    public String getResultDomainId(String domainId) {
        Object[] result = this.domainIdResultMap.get(domainId);
        String returnValue = result == null ? domainId : (String)result[0];
        return returnValue;
    }

    public Long getResultSubEleId(String domainId) {
        Object[] result = this.domainIdResultMap.get(domainId);
        Long returnValue = result == null ? Long.valueOf(0L) : (Long)result[1];
        return returnValue;
    }

    public BigDecimal getResultPrice(String domainId) {
        Object[] result = this.domainIdResultMap.get(domainId);
        BigDecimal returnValue = result == null ? BigDecimal.ZERO : (BigDecimal)result[2];
        return returnValue;
    }

    public void setResultPrice(String domainId, BigDecimal value) {
        Object[] result = this.domainIdResultMap.get(domainId);
        if (result == null) {
            return;
        }
        result[2] = value;
    }

    public String getResultSortListId(String domainId) {
        Object[] result = this.domainIdResultMap.get(domainId);
        String returnValue = result == null ? this.sortId : (String)result[3];
        return returnValue;
    }

    public void setSubElementId(Long subElementId) {
        this.subElementId = subElementId;
    }

    public Map<Object, BigDecimal> getBeginCosts() {
        return this.beginCosts;
    }

    public Map<Object, BigDecimal> getDomainIdOutPriceMap() {
        return this.domainIdOutPriceMap;
    }

    public Map<Object, BigDecimal> getFixedInCosts() {
        return this.fixedInCosts;
    }

    public Map<Object, BigDecimal> getTransInQtys() {
        return this.transInQtys;
    }

    public Map<Object, BigDecimal> getTransOutQtys() {
        return this.transOutQtys;
    }

    public Map<Object, BigDecimal> getFixedOutCosts() {
        return this.fixedOutCosts;
    }

    public Map<Object, BigDecimal> getBeginQtys() {
        return this.beginQtys;
    }

    public Map<Object, BigDecimal> getInQtys() {
        return this.inQtys;
    }

    public Map<Object, BigDecimal> getOutQtys() {
        return this.outQtys;
    }

    public Map<Object, BigDecimal> getFixedOutQtys() {
        return this.fixedOutQtys;
    }

    public Map<Object, BigDecimal> getFixedInQtys() {
        return this.fixedInQtys;
    }

    public Map<String, Set<String>> getDestDomainIdTransKeyMap() {
        return this.destDomainIdTransKeyMap;
    }

    public List<String> getDomainIds() {
        return this.domainIds;
    }

    public Long getSubElementId() {
        return this.subElementId;
    }

    public Map<Object, BigDecimal> getDestDomainTransOutQtyMap() {
        return this.destDomainTransOutQtyMap;
    }

    private BigDecimal getBigDecimal(Map<Object, BigDecimal> map, Object key) {
        BigDecimal value = map.get(key);
        return value == null ? BigDecimal.ZERO : value;
    }

    private BigDecimal getSelfCoefVal(String currDomainId, Map<Object, BigDecimal> transQtys, Map<Object, BigDecimal> beginQtys, Map<Object, BigDecimal> inQtys, Map<Object, BigDecimal> outQtys, Map<Object, BigDecimal> fixedOutQtys, Map<Object, BigDecimal> transOutQtys, Map<Object, BigDecimal> destDomainTransOutQtyMap) {
        String transKey = currDomainId + "_" + currDomainId;
        BigDecimal selfTransQty = this.getBigDecimal(transQtys, transKey);
        BigDecimal outQty = this.getBigDecimal(outQtys, currDomainId);
        BigDecimal noFixedOutQty = this.getBigDecimal(outQtys, currDomainId).subtract(this.getBigDecimal(fixedOutQtys, currDomainId)).subtract(this.getBigDecimal(destDomainTransOutQtyMap, currDomainId));
        BigDecimal totalInQty = this.getBigDecimal(beginQtys, currDomainId).add(this.getBigDecimal(inQtys, currDomainId));
        BigDecimal selfTransOutQty = this.getBigDecimal(transOutQtys, transKey);
        BigDecimal rightOutQty = totalInQty.multiply(selfTransOutQty).setScale(10, RoundingMode.HALF_UP);
        return selfTransQty.multiply(outQty).subtract(noFixedOutQty.multiply(totalInQty)).subtract(rightOutQty).setScale(10, RoundingMode.HALF_UP);
    }

    private BigDecimal getOtherDomainCoefVal(String currDomainId, String srcDomainId, Map<Object, BigDecimal> transQtys, Map<Object, BigDecimal> outQtys, Map<Object, BigDecimal> transOutQtys, Map<Object, BigDecimal> beginQtys, Map<Object, BigDecimal> inQtys) {
        String transKey = srcDomainId + "_" + currDomainId;
        BigDecimal transQty = this.getBigDecimal(transQtys, transKey);
        BigDecimal outQty = this.getBigDecimal(outQtys, currDomainId);
        BigDecimal transOutQty = this.getBigDecimal(transOutQtys, transKey);
        BigDecimal totalInQty = this.getBigDecimal(beginQtys, currDomainId).add(this.getBigDecimal(inQtys, currDomainId));
        BigDecimal rigthOutQty = totalInQty.multiply(transOutQty).setScale(10, RoundingMode.HALF_UP);
        logger.info(currDomainId + "-DealMatrixFunction-getOtherDomainCoefVal==>{}", Arrays.asList(transKey, transQty, outQty, transOutQty, totalInQty, rigthOutQty));
        return transQty.multiply(outQty).subtract(rigthOutQty).setScale(10, RoundingMode.HALF_UP);
    }

    private BigDecimal getConstantCoefVal(String currDomainId, Map<Object, BigDecimal> inQtys, Map<Object, BigDecimal> outQtys, Map<Object, BigDecimal> beginQtys, Map<Object, BigDecimal> fixedInCosts, Map<Object, BigDecimal> fixedOutCosts, Map<Object, BigDecimal> beginCosts) {
        BigDecimal fixedOutCost = this.getBigDecimal(fixedOutCosts, currDomainId);
        BigDecimal totalInQty = this.getBigDecimal(beginQtys, currDomainId).add(this.getBigDecimal(inQtys, currDomainId));
        BigDecimal beginAndFixedInCost = this.getBigDecimal(beginCosts, currDomainId).add(this.getBigDecimal(fixedInCosts, currDomainId));
        BigDecimal outQty = this.getBigDecimal(outQtys, currDomainId);
        return fixedOutCost.multiply(totalInQty).subtract(beginAndFixedInCost.multiply(outQty)).setScale(10, RoundingMode.HALF_UP);
    }

    private BigDecimal[][] removeNoOutVar(int domainSize, List<Integer> noOutPutIndex, BigDecimal[][] variableCoef) {
        int matrixCount = domainSize;
        int finalDmCount = matrixCount - noOutPutIndex.size();
        BigDecimal[][] tempVariableMatrix = new BigDecimal[finalDmCount][matrixCount];
        BigDecimal[][] finalVariableMatrix = new BigDecimal[finalDmCount][finalDmCount];
        int tempindex = 0;
        if (!noOutPutIndex.isEmpty()) {
            int i;
            for (i = 0; i < matrixCount; ++i) {
                if (noOutPutIndex.contains(i)) continue;
                tempVariableMatrix[tempindex++] = variableCoef[i];
            }
            for (i = 0; i < finalDmCount; ++i) {
                tempindex = 0;
                for (int j = 0; j < matrixCount; ++j) {
                    if (noOutPutIndex.contains(j)) continue;
                    finalVariableMatrix[i][tempindex++] = tempVariableMatrix[i][j];
                }
            }
            variableCoef = finalVariableMatrix;
        }
        return variableCoef;
    }

    private BigDecimal dealZeroOrNegPrice(BigDecimal price, String currDomainId) {
        boolean outPriceLargeZero;
        if (!this.matrixUseOutPrice.booleanValue()) {
            return price;
        }
        BigDecimal outPrice = this.getBigDecimal(this.domainIdOutPriceMap, currDomainId);
        boolean isPriceLessZero = price.compareTo(BigDecimal.ZERO) <= 0;
        boolean bl = outPriceLargeZero = outPrice.compareTo(BigDecimal.ZERO) > 0;
        if (isPriceLessZero && outPriceLargeZero) {
            price = outPrice;
        }
        return price;
    }

    private void dealSelfValZero(BigDecimal[][] variableCoef, BigDecimal[] constantCoef) {
        Boolean sameVarUseBeginIn = (Boolean)this.commonInfo.getParamCache().getParamValue(CalDbParamConstant.MATRIX_SAMEVAR_USE_BEGININ);
        if (!sameVarUseBeginIn.booleanValue()) {
            return;
        }
        StringBuilder builder1 = new StringBuilder();
        StringBuilder builder2 = new StringBuilder();
        for (int i = 0; i < variableCoef.length; ++i) {
            if (variableCoef[i][i].compareTo(BigDecimal.ZERO) != 0) continue;
            String currDomainId = this.domainIds.get(i);
            BigDecimal curBeginCost = this.getBigDecimal(this.beginCosts, currDomainId);
            BigDecimal curFixedCost = this.getBigDecimal(this.fixedInCosts, currDomainId);
            BigDecimal curBeginQty = this.getBigDecimal(this.beginQtys, currDomainId);
            BigDecimal curFixedInQty = this.getBigDecimal(this.fixedInQtys, currDomainId);
            BigDecimal curAllInQty = curBeginQty.add(curFixedInQty);
            BigDecimal curAllInCost = curBeginCost.add(curFixedCost);
            if (curAllInQty.compareTo(BigDecimal.ZERO) != 0) {
                variableCoef[i][i] = BigDecimal.ONE;
                for (int j = 0; j < variableCoef.length; ++j) {
                    variableCoef[i][j] = BigDecimal.ZERO;
                }
                constantCoef[i] = curAllInCost.divide(curAllInQty, 10, RoundingMode.HALF_UP);
                builder1.append(currDomainId);
                builder1.append("#");
            }
            builder2.append(currDomainId);
            builder2.append("#");
        }
        if (builder1.length() > 0) {
            String String2 = builder1.toString();
            logger.info("DealMatrix_Error\uff1a\u7cfb\u6570\u4e3a0\uff0c\u5e76\u8f6c\u6362 ==>{}", (Object)String2);
        }
        if (builder2.length() > 0) {
            String str = builder2.toString();
            logger.info("DealMatrix_Error\uff1a\u7cfb\u6570\u4e3a0 ==>{}", (Object)str);
        }
    }

    private BigDecimal[] removeNoOutCon(int domainSize, List<Integer> noOutPutIndex, BigDecimal[] constantCoef) {
        int matrixCount = domainSize;
        int finalDmCount = matrixCount - noOutPutIndex.size();
        BigDecimal[] finalConstantMatrix = new BigDecimal[finalDmCount];
        int finalindex = 0;
        if (!noOutPutIndex.isEmpty()) {
            for (int i = 0; i < matrixCount; ++i) {
                if (noOutPutIndex.contains(i)) continue;
                finalConstantMatrix[finalindex++] = constantCoef[i];
            }
            constantCoef = finalConstantMatrix;
        }
        return constantCoef;
    }

    private BigDecimal getNoOutDomainPrice(String currDomainId, Map<String, Set<String>> destDomainIdTransDomianMap, Map<Object, BigDecimal> transQtys, Map<String, BigDecimal> domainPriceMap) {
        BigDecimal srcTotalCost = BigDecimal.ZERO;
        BigDecimal transTotalInQty = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        Set<String> transKeys = destDomainIdTransDomianMap.get(currDomainId);
        int tmpAmtPrecision = 10;
        for (String transKey : transKeys) {
            BigDecimal transInQty = transQtys.get(transKey);
            if (transInQty.compareTo(BigDecimal.ZERO) == 0) continue;
            transTotalInQty = transTotalInQty.add(transInQty);
            BigDecimal srcPrice = domainPriceMap.get(transKey.split("_")[0]);
            if (srcPrice == null) continue;
            BigDecimal srcCost = transInQty.multiply(srcPrice).setScale(tmpAmtPrecision, 4);
            srcTotalCost = srcTotalCost.add(srcCost);
        }
        if (transTotalInQty.compareTo(BigDecimal.ZERO) != 0) {
            price = srcTotalCost.divide(transTotalInQty, 10, RoundingMode.HALF_UP);
        }
        return price;
    }

    private void dealNoBeginNoIn(List<Integer> noInPutIndex, int index, String currDomainId) {
        BigDecimal beginQty;
        if (!this.matrixUseOutPrice.booleanValue()) {
            return;
        }
        BigDecimal inQty = this.getBigDecimal(this.inQtys, currDomainId);
        if (inQty.add(beginQty = this.getBigDecimal(this.beginQtys, currDomainId)).compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal outPrice = this.getBigDecimal(this.domainIdOutPriceMap, currDomainId);
            if (outPrice.compareTo(BigDecimal.ZERO) > 0) {
                this.beginCosts.put(currDomainId, BigDecimal.ONE.multiply(outPrice));
                this.beginQtys.put(currDomainId, BigDecimal.ONE);
                this.fixedInCosts.put(currDomainId, BigDecimal.ZERO);
                for (String srcDomainId : this.domainIds) {
                    String transKey = srcDomainId + "_" + currDomainId;
                    this.transInQtys.put(transKey, BigDecimal.ZERO);
                }
                this.inQtys.put(currDomainId, BigDecimal.ZERO);
            } else {
                noInPutIndex.add(index);
            }
        }
    }

    private void dealNotDomainOut(List<Integer> noOutPutIndex, int index, String currDomainId) {
        BigDecimal fixedOutQty;
        boolean realOutQtyZero;
        BigDecimal outQty = this.getBigDecimal(this.outQtys, currDomainId);
        boolean bl = realOutQtyZero = outQty.compareTo(fixedOutQty = this.getBigDecimal(this.fixedOutQtys, currDomainId)) == 0;
        if (BigDecimal.ZERO.compareTo(outQty) == 0 || realOutQtyZero) {
            noOutPutIndex.add(index);
            if (this.matrixChangeOne.booleanValue()) {
                this.outQtys.put(currDomainId, BigDecimal.ONE);
                this.fixedOutCosts.put(currDomainId, BigDecimal.ZERO);
                this.fixedOutQtys.put(currDomainId, BigDecimal.ZERO);
                this.destDomainTransOutQtyMap.put(currDomainId, BigDecimal.ZERO);
                for (String srcDomainId : this.domainIds) {
                    String transKey = srcDomainId + "_" + currDomainId;
                    this.transOutQtys.put(transKey, BigDecimal.ZERO);
                }
            }
        }
    }

    private void buildMatrix(int domainSize, BigDecimal[][] variableCoef, BigDecimal[] constantCoef) {
        String currDomainId;
        int index;
        for (index = 0; index < domainSize; ++index) {
            currDomainId = this.domainIds.get(index);
            int secdIndex = 0;
            for (String srcDomainId : this.domainIds) {
                variableCoef[index][secdIndex] = currDomainId.equals(srcDomainId) ? this.getSelfCoefVal(currDomainId, this.transInQtys, this.beginQtys, this.inQtys, this.outQtys, this.fixedOutQtys, this.transOutQtys, this.destDomainTransOutQtyMap) : this.getOtherDomainCoefVal(currDomainId, srcDomainId, this.transInQtys, this.outQtys, this.transOutQtys, this.beginQtys, this.inQtys);
                ++secdIndex;
            }
        }
        for (index = 0; index < domainSize; ++index) {
            currDomainId = this.domainIds.get(index);
            constantCoef[index] = this.getConstantCoefVal(currDomainId, this.inQtys, this.outQtys, this.beginQtys, this.fixedInCosts, this.fixedOutCosts, this.beginCosts);
        }
    }

    private void setCommonMatrixInfo(MatrixInfo matrixInfo) {
        matrixInfo.setSubelementId(this.subElementId);
        matrixInfo.setDomainIds(this.domainIds);
        matrixInfo.setTransInQtys(this.transInQtys);
        matrixInfo.setBeginQtys(this.beginQtys);
        matrixInfo.setInQtys(this.inQtys);
        matrixInfo.setOutQtys(this.outQtys);
        matrixInfo.setFixedOutQtys(this.fixedOutQtys);
        matrixInfo.setTransOutQtys(this.transOutQtys);
        matrixInfo.setDestDomainTransOutQtyMap(this.destDomainTransOutQtyMap);
        matrixInfo.setFixedInCosts(this.fixedInCosts);
        matrixInfo.setFixedOutCosts(this.fixedOutCosts);
        matrixInfo.setBeginCosts(this.beginCosts);
    }

    public Map<String, Object[]> getResult() {
        return this.domainIdResultMap;
    }
}

