/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.calx.algox.CostPriceResultInfo;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.RptErrorTypeEnum;
import kd.fi.calx.algox.matrix.function.DealMatrixBySubElement;
import kd.fi.calx.algox.matrix.helper.MatrixDesignCostHelper;

public class DealMatrixFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 5913488249026787445L;
    private static final Log logger = LogFactory.getLog(DealMatrixFunction.class);
    private final CommonInfo commonInfo;
    private RowMeta rowMeta;
    private RowMeta resultMeta;

    public DealMatrixFunction(RowMeta rowMeta, CommonInfo commonInfo) {
        this.rowMeta = rowMeta;
        this.resultMeta = this.createResultRowMeta();
        this.commonInfo = commonInfo;
    }

    public RowMeta getResultRowMeta() {
        return this.resultMeta;
    }

    public void reduce(Iterable<RowX> arg0, Collector arg1) {
        Iterator<RowX> it = arg0.iterator();
        HashMap<Long, DealMatrixBySubElement> subEleIdMatrixMap = new HashMap<Long, DealMatrixBySubElement>(16);
        HashMap<String, Long> domainIdMaxRowBillIdMap = new HashMap<String, Long>(16);
        HashMap<String, Long> domainIdMaxRowEntryIdMap = new HashMap<String, Long>(16);
        HashMap<String, Integer> domainIdNeedZeroPriceFlagMap = new HashMap<String, Integer>(16);
        HashSet<String> allDomainIds = new HashSet<String>(16);
        while (it.hasNext()) {
            RowX row = it.next();
            String domainId = row.getString(this.rowMeta.getFieldIndex("domainid"));
            allDomainIds.add(domainId);
            Long maxRowBillId = row.getLong(this.rowMeta.getFieldIndex("maxrowbillid"));
            Long maxRowEntryId = row.getLong(this.rowMeta.getFieldIndex("maxrowentryid"));
            Integer needZeroPriceInt = row.getInteger(this.rowMeta.getFieldIndex("needzeroprice"));
            if (maxRowBillId != null && maxRowBillId > 0L) {
                domainIdMaxRowBillIdMap.put(domainId, maxRowBillId);
                domainIdMaxRowEntryIdMap.put(domainId, maxRowEntryId);
                if (needZeroPriceInt > 0 || needZeroPriceInt == 1 || !domainIdNeedZeroPriceFlagMap.containsKey(domainId)) {
                    domainIdNeedZeroPriceFlagMap.put(domainId, needZeroPriceInt);
                }
            }
            Long subEleId = row.getLong(this.rowMeta.getFieldIndex("subelementid"));
            DealMatrixBySubElement dealMatrixBySubElement = subEleIdMatrixMap.computeIfAbsent(subEleId, k -> new DealMatrixBySubElement(this.commonInfo));
            dealMatrixBySubElement.addDomainInfoByRow(row, this.rowMeta);
        }
        if (subEleIdMatrixMap.isEmpty()) {
            return;
        }
        HashMap<String, BigDecimal> domainIdTotalPriceMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> domainIdBeginQtyMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> domainIdBeginCostMap = new HashMap<String, BigDecimal>(16);
        for (Map.Entry entry : subEleIdMatrixMap.entrySet()) {
            DealMatrixBySubElement dealMatrixBySubElement = (DealMatrixBySubElement)entry.getValue();
            dealMatrixBySubElement.dealMatrix();
            Map<String, Object[]> domainIdResultMap = dealMatrixBySubElement.getResult();
            for (Map.Entry<String, Object[]> entry2 : domainIdResultMap.entrySet()) {
                String domainId = entry2.getKey();
                BigDecimal resultPrice = dealMatrixBySubElement.getResultPrice(domainId);
                BigDecimal totalPrice = (BigDecimal)domainIdTotalPriceMap.get(domainId);
                totalPrice = totalPrice == null ? BigDecimal.ZERO : totalPrice;
                totalPrice = totalPrice.add(resultPrice);
                domainIdTotalPriceMap.put(domainId, totalPrice);
            }
            Map<Object, BigDecimal> beginQtysMap = dealMatrixBySubElement.getBeginQtys();
            for (Map.Entry<Object, BigDecimal> beginQtyEntry : beginQtysMap.entrySet()) {
                Object domainIdObj = beginQtyEntry.getKey();
                BigDecimal subQty = beginQtyEntry.getValue();
                domainIdBeginQtyMap.put((String)domainIdObj, subQty);
            }
            Map<Object, BigDecimal> map = dealMatrixBySubElement.getBeginCosts();
            this.addSub2Total(domainIdBeginCostMap, map);
        }
        Map<String, CostPriceResultInfo> domainIdPriceResultMap = new MatrixDesignCostHelper().getPrice(domainIdMaxRowBillIdMap, domainIdMaxRowEntryIdMap, domainIdTotalPriceMap, this.commonInfo, domainIdNeedZeroPriceFlagMap, domainIdBeginQtyMap, domainIdBeginCostMap);
        this.collectData(arg1, subEleIdMatrixMap, allDomainIds, domainIdPriceResultMap, domainIdTotalPriceMap);
    }

    private void collectData(Collector arg1, Map<Long, DealMatrixBySubElement> subEleIdMatrixMap, Set<String> allDomainIds, Map<String, CostPriceResultInfo> domainIdPriceResultMap, Map<String, BigDecimal> domainIdTotalPriceMap) {
        for (String domainId : allDomainIds) {
            for (Map.Entry<Long, DealMatrixBySubElement> entry : subEleIdMatrixMap.entrySet()) {
                BigDecimal totalPrice;
                Long subEleId = entry.getKey();
                DealMatrixBySubElement matrixBySubElement = entry.getValue();
                Object[] resultByDomainId = matrixBySubElement.getResultByDomainId(domainId);
                if (resultByDomainId == null) continue;
                CostPriceResultInfo priceInfo = domainIdPriceResultMap.get(domainId);
                if (priceInfo != null) {
                    if (priceInfo.isSuccess()) {
                        BigDecimal unitCost = priceInfo.getCostSubElementUnitcostMap().get(subEleId);
                        if (unitCost == null) {
                            unitCost = BigDecimal.ZERO;
                        }
                        matrixBySubElement.setResultPrice(domainId, unitCost);
                    }
                    String priceInfoStr = SerializationUtils.toJsonString((Object)priceInfo);
                    resultByDomainId[this.resultMeta.getFieldIndex((String)"priceinfostr")] = priceInfoStr;
                }
                totalPrice = (totalPrice = domainIdTotalPriceMap.get(domainId)) == null ? BigDecimal.ZERO : totalPrice;
                String rptErrorType = "";
                if (totalPrice.compareTo(BigDecimal.ZERO) == 0) {
                    rptErrorType = RptErrorTypeEnum.AVG_ZERO_PRICE.getValue();
                } else if (totalPrice.compareTo(BigDecimal.ZERO) < 0) {
                    rptErrorType = RptErrorTypeEnum.AVG_NEG_PRICE.getValue();
                } else if (totalPrice.compareTo(BigDecimal.ZERO) > 0) {
                    rptErrorType = RptErrorTypeEnum.AVG_POS_PRICE.getValue();
                }
                resultByDomainId[this.resultMeta.getFieldIndex((String)"rpterrortype")] = rptErrorType;
                RowX rowX = new RowX(resultByDomainId);
                arg1.collect(rowX);
            }
        }
    }

    private RowMeta createResultRowMeta() {
        return new RowMeta(new Field[]{new Field("domainid", (DataType)DataType.StringType), new Field("subelementid", (DataType)DataType.LongType), new Field("calprice", (DataType)DataType.BigDecimalType), new Field("dysortlistid", (DataType)DataType.StringType), new Field("priceinfostr", (DataType)DataType.StringType), new Field("rpterrortype", (DataType)DataType.StringType)});
    }

    private void addSub2Total(Map<String, BigDecimal> domainIdTotalValueMap, Map<Object, BigDecimal> domainIdSubValueMap) {
        for (Map.Entry<Object, BigDecimal> domainIdSubValueEntry : domainIdSubValueMap.entrySet()) {
            Object domainId = domainIdSubValueEntry.getKey();
            BigDecimal subValue = domainIdSubValueEntry.getValue();
            subValue = subValue == null ? BigDecimal.ZERO : subValue;
            BigDecimal totalValue = domainIdTotalValueMap.get(domainId);
            totalValue = totalValue == null ? BigDecimal.ZERO : totalValue;
            totalValue = totalValue.add(subValue);
            domainIdTotalValueMap.put((String)domainId, totalValue);
        }
    }
}

