/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import java.util.Date;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.MatrixEndCostDiffAdjHelper;
import kd.fi.calx.algox.matrix.MatrixRptManager;
import kd.fi.calx.algox.matrix.obj.MatrixAfterCalDomainInfo;
import kd.fi.calx.algox.report.CalOutRptHolder;
import kd.fi.calx.algox.report.RptStatus;

public class DealMatrixRptFunction
extends GroupReduceFunction {
    private final RowMeta rowMeta;
    private final CommonInfo commonInfo;

    public DealMatrixRptFunction(CommonInfo commonInfo, RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.commonInfo = commonInfo;
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        Iterator<RowX> it = iter.iterator();
        CalOutRptHolder holder = null;
        MatrixAfterCalDomainInfo matrixDomainInfo = new MatrixAfterCalDomainInfo();
        matrixDomainInfo.setRowMeta(this.rowMeta);
        Long billId = null;
        while (it.hasNext()) {
            RowX row = it.next();
            Long accountId = row.getLong(this.rowMeta.getFieldIndex("costaccount"));
            if (accountId == null) continue;
            if (row.getLong(this.rowMeta.getFieldIndex("billid")) != null) {
                billId = row.getLong(this.rowMeta.getFieldIndex("billid"));
            }
            if (holder == null) {
                holder = this.createHeader(row);
                matrixDomainInfo.setMatrixComInfo(matrixDomainInfo, row);
            }
            matrixDomainInfo.setPriceInfo(this.commonInfo, row);
            matrixDomainInfo.setMatrixSumCostInfo(matrixDomainInfo, row);
            matrixDomainInfo.setMatrixNotCalInfo(this.commonInfo, matrixDomainInfo, row);
            matrixDomainInfo.addBillDtl(this.commonInfo, row);
            matrixDomainInfo.setRptErrorType(row);
        }
        if (holder == null) {
            return;
        }
        matrixDomainInfo.calEleCost2SumCost();
        matrixDomainInfo.endSubNotCalBill(this.commonInfo);
        MatrixEndCostDiffAdjHelper matrixEndCostAdjHelper = new MatrixEndCostDiffAdjHelper();
        matrixEndCostAdjHelper.setCommonInfo(this.commonInfo);
        matrixEndCostAdjHelper.dealEndDiff(matrixDomainInfo, billId);
        if (!this.commonInfo.isWriteRpt()) {
            return;
        }
        MatrixRptManager matrixRptManager = new MatrixRptManager();
        matrixRptManager.setCommonInfo(this.commonInfo);
        matrixRptManager.setRowMeta(this.rowMeta);
        matrixRptManager.setMatrixDomainInfo(matrixDomainInfo);
        matrixRptManager.setRptHoder(holder);
        matrixRptManager.writeRpt();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private CalOutRptHolder createHeader(RowX row) {
        CalOutRptHolder holder = new CalOutRptHolder();
        holder.setCalOrgID(row.getLong(this.rowMeta.getFieldIndex("calorg")));
        holder.setCostAccountID(row.getLong(this.rowMeta.getFieldIndex("costaccount")));
        holder.setPeriodID(row.getLong(this.rowMeta.getFieldIndex("periodid")));
        holder.setMaterialID(row.getLong(this.rowMeta.getFieldIndex("material")));
        holder.setDivideBasisID(row.getLong(this.rowMeta.getFieldIndex("divideBasis")));
        holder.setCalDimensionID(row.getLong(this.rowMeta.getFieldIndex("calDimension")));
        holder.addDivideBasisValue(row.getString(this.rowMeta.getFieldIndex("divideBasisValue")));
        holder.setCalDimensionValue(row.getString(this.rowMeta.getFieldIndex("calDimensionValue")));
        String calDimensionStr = row.getString(this.rowMeta.getFieldIndex("calDimensionStr"));
        String calDimensionValue = row.getString(this.rowMeta.getFieldIndex("calDimensionValue"));
        if (!StringUtils.isEmpty((String)calDimensionStr) && !StringUtils.isEmpty((String)calDimensionValue)) {
            String[] names = calDimensionStr.split(",");
            String[] values = calDimensionValue.split("_");
            for (int i = 0; i < names.length; ++i) {
                if (StringUtils.isEmpty((String)names[i])) continue;
                String value = values[i];
                if ("assist".equals(names[i])) {
                    if (StringUtils.isEmpty((String)value)) continue;
                    holder.setAssistId(Long.parseLong(value));
                    continue;
                }
                if ("configuredcode".equals(names[i])) {
                    if (StringUtils.isEmpty((String)value)) continue;
                    holder.setConfiguredcodeId(Long.parseLong(value));
                    continue;
                }
                if ("project".equals(names[i])) {
                    if (StringUtils.isEmpty((String)value)) continue;
                    holder.setProjectId(Long.parseLong(value));
                    continue;
                }
                if (!"tracknumber".equals(names[i]) || StringUtils.isEmpty((String)value)) continue;
                holder.setTracknumberId(Long.parseLong(value));
            }
        }
        holder.setAccountType("A");
        holder.setCalStatus(RptStatus.SUCESS);
        Long calRange = row.getLong(this.rowMeta.getFieldIndex("calrangeid"));
        calRange = calRange == null ? Long.valueOf(0L) : calRange;
        holder.setCalRangeID(calRange);
        holder.setMatrix(true);
        boolean costEndDateEnable = this.commonInfo.isCostatenddateenable();
        holder.setCostatenddateenable(costEndDateEnable);
        if (costEndDateEnable) {
            Date costEndDate = this.commonInfo.getCostatenddate();
            holder.setCostatenddate(costEndDate);
        }
        return holder;
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }
}

