/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.helper.MatrixDesignCostHelper;
import kd.fi.calx.algox.matrix.log.MatrixRemarkUtil;
import kd.fi.calx.algox.util.ArrayUtils;

public class DealOutDiffFunction
extends GroupReduceFunction {
    private final CommonInfo commonInfo;
    private RowMeta rowMeta;

    public DealOutDiffFunction(CommonInfo commonInfo, RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.commonInfo = commonInfo;
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        BigDecimal billCalPrice;
        Iterator<RowX> it = iter.iterator();
        BigDecimal billTotalOutCost = BigDecimal.ZERO;
        BigDecimal billTotalQty = BigDecimal.ZERO;
        BigDecimal calPrice = BigDecimal.ZERO;
        RowX maxEntryRow = null;
        BigDecimal maxBaseQty = BigDecimal.ZERO;
        HashSet<String> srcEntryIdEles = new HashSet<String>(16);
        while (it.hasNext()) {
            RowX row = it.next();
            BigDecimal currAmt = row.getBigDecimal(this.rowMeta.getFieldIndex("cost"));
            BigDecimal currQty = row.getBigDecimal(this.rowMeta.getFieldIndex("baseqty"));
            Boolean isVoucher = row.getBoolean(this.rowMeta.getFieldIndex("isvoucher"));
            Boolean isRework = row.getBoolean(this.rowMeta.getFieldIndex("isrework"));
            billCalPrice = row.getBigDecimal(this.rowMeta.getFieldIndex("calprice"));
            String type = row.getString(this.rowMeta.getFieldIndex("type"));
            String entryEleStr = "" + row.getLong(this.rowMeta.getFieldIndex("entryid")) + row.getLong(this.rowMeta.getFieldIndex("subelementid"));
            boolean isDul = !srcEntryIdEles.add(entryEleStr);
            String queueType = row.getString(this.rowMeta.getFieldIndex("queuetype"));
            boolean notCalEntryId = new MatrixDesignCostHelper().isNotCalEntryId(this.rowMeta, row, this.commonInfo);
            if (notCalEntryId) continue;
            if ("1".equals(type) || isVoucher.booleanValue() || isRework.booleanValue() || !"1".equals(queueType) || isDul || "0".equals(type)) {
                this.afterCollectorRow(collector, row);
                continue;
            }
            billTotalOutCost = billTotalOutCost.add(currAmt);
            billTotalQty = billTotalQty.add(currQty);
            BigDecimal bigDecimal = calPrice = billCalPrice == null ? calPrice : billCalPrice;
            if (maxEntryRow == null || maxBaseQty.compareTo(currQty) <= 0) {
                if (maxEntryRow != null) {
                    this.afterCollectorRow(collector, maxEntryRow);
                }
                maxEntryRow = row;
                maxBaseQty = currQty;
                continue;
            }
            this.afterCollectorRow(collector, row);
        }
        if (maxEntryRow != null) {
            int amtprecision = maxEntryRow.getInteger(this.rowMeta.getFieldIndex("amtprecision"));
            BigDecimal domainOutTotalCost = calPrice.multiply(billTotalQty).setScale(amtprecision, RoundingMode.HALF_UP);
            BigDecimal diff = domainOutTotalCost.subtract(billTotalOutCost);
            Boolean coverZero = (Boolean)this.commonInfo.getParamCache().getParamValue("matrix_cover_zero");
            Boolean coverNeg = (Boolean)this.commonInfo.getParamCache().getParamValue("matrix_cover_neg");
            billCalPrice = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("calprice"));
            boolean isCalPriceZero = billCalPrice == null || billCalPrice.compareTo(BigDecimal.ZERO) == 0;
            diff = isCalPriceZero && coverZero == false ? BigDecimal.ZERO : diff;
            boolean isCalPriceNeg = billCalPrice != null && billCalPrice.compareTo(BigDecimal.ZERO) < 0;
            diff = isCalPriceNeg && coverNeg == false ? BigDecimal.ZERO : diff;
            boolean saveBillCost = new MatrixDesignCostHelper().isSaveBillCost(maxEntryRow, this.rowMeta);
            diff = saveBillCost ? BigDecimal.ZERO : diff;
            BigDecimal maxAmt = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("cost"));
            BigDecimal newMaxAmt = maxAmt.add(diff);
            BigDecimal maxQty = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("baseqty"));
            boolean isNegPrice = newMaxAmt.signum() * maxQty.signum() < 0;
            diff = isNegPrice ? BigDecimal.ZERO : diff;
            String remark = MatrixRemarkUtil.getSumOut();
            remark = diff.compareTo(BigDecimal.ZERO) == 0 ? "" : String.format(remark, diff.toPlainString());
            maxEntryRow.set(this.rowMeta.getFieldIndex("calremark"), (Object)remark);
            String elementType = maxEntryRow.getString(this.rowMeta.getFieldIndex("elementtype"));
            maxEntryRow.set(this.rowMeta.getFieldIndex("cost"), (Object)maxAmt.add(diff));
            maxEntryRow.set(this.rowMeta.getFieldIndex("actualcost"), (Object)maxAmt.add(diff));
            if (BigDecimal.ZERO.compareTo(diff) != 0) {
                maxEntryRow.set(this.rowMeta.getFieldIndex("divprice"), (Object)Boolean.TRUE);
            }
            if ("001".equals(elementType)) {
                BigDecimal currTypeAmt = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("materialcost"));
                maxEntryRow.set(this.rowMeta.getFieldIndex("materialcost"), (Object)currTypeAmt.add(diff));
            } else if ("002".equals(elementType)) {
                BigDecimal currTypeAmt = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("fee"));
                maxEntryRow.set(this.rowMeta.getFieldIndex("fee"), (Object)currTypeAmt.add(diff));
            } else if ("003".equals(elementType)) {
                BigDecimal currTypeAmt = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("manufacturecost"));
                maxEntryRow.set(this.rowMeta.getFieldIndex("manufacturecost"), (Object)currTypeAmt.add(diff));
            } else if ("004".equals(elementType)) {
                BigDecimal currTypeAmt = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("resource"));
                maxEntryRow.set(this.rowMeta.getFieldIndex("resource"), (Object)currTypeAmt.add(diff));
            } else if ("005".equals(elementType)) {
                BigDecimal currTypeAmt = maxEntryRow.getBigDecimal(this.rowMeta.getFieldIndex("processcost"));
                maxEntryRow.set(this.rowMeta.getFieldIndex("processcost"), (Object)currTypeAmt.add(diff));
            }
            this.afterCollectorRow(collector, maxEntryRow);
        }
    }

    private void afterCollectorRow(Collector collector, RowX row) {
        BigDecimal tranInCost = BigDecimal.ZERO;
        BigDecimal tranInQty = BigDecimal.ZERO;
        BigDecimal tranOutCost = BigDecimal.ZERO;
        BigDecimal tranOutQty = BigDecimal.ZERO;
        BigDecimal domainOutCost = BigDecimal.ZERO;
        BigDecimal domainOutQty = BigDecimal.ZERO;
        String type = row.getString(this.rowMeta.getFieldIndex("type"));
        String queueType = row.getString(this.rowMeta.getFieldIndex("queuetype"));
        BigDecimal cost = row.getBigDecimal(this.rowMeta.getFieldIndex("cost"));
        BigDecimal baseQty = row.getBigDecimal(this.rowMeta.getFieldIndex("baseqty"));
        Boolean isVoucher = row.getBoolean(this.rowMeta.getFieldIndex("isvoucher"));
        Boolean isRework = row.getBoolean(this.rowMeta.getFieldIndex("isrework"));
        if ("1".equals(type)) {
            if (row.getBigDecimal(this.rowMeta.getFieldIndex("transqty")).compareTo(BigDecimal.ZERO) != 0) {
                tranInCost = cost;
                tranInQty = baseQty;
            }
            if (row.getBigDecimal(this.rowMeta.getFieldIndex("calouttransqty")).compareTo(BigDecimal.ZERO) != 0) {
                tranOutCost = cost;
                tranOutQty = baseQty;
            }
        } else if ("1".equals(queueType) && !isVoucher.booleanValue() && !isRework.booleanValue()) {
            domainOutCost = cost;
            domainOutQty = baseQty;
        }
        collector.collect(new RowX(ArrayUtils.concatAll(row.values(), new Object[][]{{tranInCost, tranInQty, domainOutCost, domainOutQty, tranOutCost, tranOutQty}})));
    }

    public RowMeta getResultRowMeta() {
        return new RowMeta(ArrayUtils.concatAll(this.rowMeta.getFields(), new Field[][]{{new Field("tranincost", (DataType)DataType.BigDecimalType), new Field("traninqty", (DataType)DataType.BigDecimalType), new Field("domainoutcost", (DataType)DataType.BigDecimalType), new Field("domainoutqty", (DataType)DataType.BigDecimalType), new Field("tranoutcost", (DataType)DataType.BigDecimalType), new Field("tranoutqty", (DataType)DataType.BigDecimalType)}}));
    }
}

