/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.util.ArrayUtils;

public class DealSortIdFunction
extends FlatMapFunction {
    private final CommonInfo commonInfo;
    private RowMeta rowMeta;

    public DealSortIdFunction(CommonInfo commonInfo, RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.commonInfo = commonInfo;
    }

    public void flatMap(RowX rowX, Collector collector) {
        Long groupNo = rowX.getLong(this.rowMeta.getFieldIndex("groupno"));
        String sortListId = "";
        if (groupNo == null) {
            sortListId = rowX.getString(this.rowMeta.getFieldIndex("domainid"));
        } else if (groupNo > -1L) {
            sortListId = groupNo.toString();
        } else if (groupNo == -1L) {
            Long material = rowX.getLong(this.rowMeta.getFieldIndex("material"));
            Long costAccount = rowX.getLong(this.rowMeta.getFieldIndex("costaccount"));
            Long periodId = rowX.getLong(this.rowMeta.getFieldIndex("periodid"));
            Long calRange = rowX.getLong(this.rowMeta.getFieldIndex("calrange"));
            sortListId = material + "#" + costAccount + "#" + periodId + "#" + calRange;
        }
        collector.collect(new RowX(ArrayUtils.concatAll(rowX.values(), new Object[][]{{sortListId}})));
    }

    public RowMeta getResultRowMeta() {
        return new RowMeta(ArrayUtils.concatAll(this.rowMeta.getFields(), new Field[][]{{new Field("dysortlistid", (DataType)DataType.StringType)}}));
    }
}

