/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.function.CommonInfo;

public class DealSplitRecordFunction
extends GroupReduceFunction {
    private final RowMeta rowMeta;
    private final CommonInfo commonInfo;

    public DealSplitRecordFunction(CommonInfo commonInfo, RowMeta rowMeta) {
        this.commonInfo = commonInfo;
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        Iterator<RowX> it = iter.iterator();
        HashMap<String, RowX> eIdSubEleIdRowMap = new HashMap<String, RowX>(16);
        long lastChildAId = 0L;
        Object[] lastChildAValues = null;
        int entryIdIndex = this.rowMeta.getFieldIndex("entryid");
        int headIdIndex = this.rowMeta.getFieldIndex("id");
        int childBaseQtyIndex = this.rowMeta.getFieldIndex("childbaseqty");
        int baseqtyIndex = this.rowMeta.getFieldIndex("baseqty");
        boolean isWriteoffEnd = true;
        HashMap<Long, Object[]> childAValuesMap = new HashMap<Long, Object[]>(16);
        HashMap<Long, Object[]> childBValuesMap = new HashMap<Long, Object[]>(16);
        int subCostIndex = this.rowMeta.getFieldIndex("cost");
        int srcBaseQtyIndex = this.rowMeta.getFieldIndex("baseqty");
        int amtPrecisionIndex = this.rowMeta.getFieldIndex("amtprecision");
        BigDecimal totalACost = BigDecimal.ZERO;
        BigDecimal totalBillCost = BigDecimal.ZERO;
        while (it.hasNext()) {
            RowX row = it.next();
            Long coreEntryId = row.getLong(entryIdIndex);
            Long subEleId = row.getLong(this.rowMeta.getFieldIndex("subelementid"));
            String key = coreEntryId + "," + subEleId;
            if (!eIdSubEleIdRowMap.containsKey(key)) {
                eIdSubEleIdRowMap.put(key, row);
            }
            Long childId = row.getLong(this.rowMeta.getFieldIndex("childid"));
            Long childHeadId = row.getLong(this.rowMeta.getFieldIndex("childheadid"));
            Long writeoffendperiod = row.getLong(this.rowMeta.getFieldIndex("writeoffendperiod"));
            if (null != writeoffendperiod && writeoffendperiod == 0L) {
                isWriteoffEnd = false;
            }
            if (childId == null) continue;
            String writeOffStatus = (String)this.getValue(row, "writeoffstatus");
            Object[] newValues = Arrays.asList(row.values()).toArray();
            BigDecimal srcCost = row.getBigDecimal(subCostIndex);
            totalBillCost = srcCost == null ? totalBillCost : srcCost;
            BigDecimal bigDecimal = srcCost = srcCost == null ? BigDecimal.ZERO : srcCost;
            if ("A".equals(writeOffStatus)) {
                BigDecimal srcBaseQty = row.getBigDecimal(srcBaseQtyIndex);
                BigDecimal childQty = row.getBigDecimal(childBaseQtyIndex);
                int amtPrecision = row.getInteger(amtPrecisionIndex);
                BigDecimal thisCost = srcCost.multiply(childQty).divide(srcBaseQty, amtPrecision, RoundingMode.HALF_UP);
                totalACost = totalACost.add(thisCost);
                newValues[entryIdIndex] = childId;
                newValues[headIdIndex] = childHeadId;
                BigDecimal unitCost = thisCost.divide(childQty, 10, RoundingMode.HALF_UP);
                newValues[baseqtyIndex] = childQty;
                this.setCost(thisCost, newValues, unitCost);
                if (childId > lastChildAId) {
                    if (lastChildAValues != null) {
                        collector.collect(new RowX(lastChildAValues));
                    }
                    lastChildAId = childId;
                    lastChildAValues = newValues;
                } else {
                    collector.collect(new RowX(newValues));
                }
                childAValuesMap.put(childId, newValues);
                continue;
            }
            newValues[entryIdIndex] = childId;
            newValues[headIdIndex] = childHeadId;
            newValues[baseqtyIndex] = row.getBigDecimal(childBaseQtyIndex);
            childBValuesMap.put(childId, newValues);
        }
        this.dealDiffA(collector, lastChildAValues, isWriteoffEnd, totalACost, totalBillCost);
        this.dealB(collector, childAValuesMap, childBValuesMap, totalBillCost);
    }

    private void dealB(Collector collector, Map<Long, Object[]> childAValuesMap, Map<Long, Object[]> childBValuesMap, BigDecimal totalBillCost) {
        int wfPeriodIndex = this.rowMeta.getFieldIndex("writeoffperiod");
        int actualCostIndex = this.rowMeta.getFieldIndex("actualcost");
        int childBaseQtyIndex = this.rowMeta.getFieldIndex("childbaseqty");
        for (Map.Entry<Long, Object[]> entryB : childBValuesMap.entrySet()) {
            Object[] valuesB = entryB.getValue();
            valuesB[this.rowMeta.getFieldIndex((String)"costpricesourcetype")] = "splitbill";
            Long writeOffPeriodB = (Long)valuesB[wfPeriodIndex];
            BigDecimal childQty = (BigDecimal)valuesB[childBaseQtyIndex];
            BigDecimal curTotalCostA = BigDecimal.ZERO;
            for (Map.Entry<Long, Object[]> entryA : childAValuesMap.entrySet()) {
                Object[] valuesA = entryA.getValue();
                Long writeOffPeriodA = (Long)valuesA[wfPeriodIndex];
                if (writeOffPeriodA > writeOffPeriodB) continue;
                curTotalCostA = curTotalCostA.add((BigDecimal)valuesA[actualCostIndex]);
            }
            BigDecimal costB = totalBillCost.subtract(curTotalCostA);
            BigDecimal unitCostB = costB.divide(childQty, 10, RoundingMode.HALF_UP);
            this.setCost(costB, valuesB, unitCostB);
            collector.collect(new RowX(valuesB));
        }
    }

    private void dealDiffA(Collector collector, Object[] lastChildAValues, boolean isWriteoffEnd, BigDecimal totalACost, BigDecimal totalBillCost) {
        if (lastChildAValues == null) {
            return;
        }
        Long lastChildAId = (Long)lastChildAValues[this.rowMeta.getFieldIndex("childid")];
        lastChildAValues[this.rowMeta.getFieldIndex((String)"costpricesourcetype")] = "splitbill";
        if (lastChildAId != null) {
            if (isWriteoffEnd) {
                int subCostIndex = this.rowMeta.getFieldIndex("cost");
                int childBaseQtyIndex = this.rowMeta.getFieldIndex("childbaseqty");
                BigDecimal srcCost = (BigDecimal)lastChildAValues[subCostIndex];
                BigDecimal costDiff = totalBillCost.subtract(totalACost);
                BigDecimal thisCost = srcCost.add(costDiff);
                BigDecimal childQty = (BigDecimal)lastChildAValues[childBaseQtyIndex];
                BigDecimal unitCost = thisCost.divide(childQty, 10, RoundingMode.HALF_UP);
                this.setCost(thisCost, lastChildAValues, unitCost);
                collector.collect(new RowX(lastChildAValues));
            } else {
                collector.collect(new RowX(lastChildAValues));
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private Object getValue(RowX row, String field) {
        return row.get(this.rowMeta.getFieldIndex(field));
    }

    private void setCost(BigDecimal thisCost, Object[] values, BigDecimal unitCost) {
        int subCostIndex = this.rowMeta.getFieldIndex("cost");
        int subUnitIndex = this.rowMeta.getFieldIndex("sub_unitactualcost");
        int unitActCostIndex = this.rowMeta.getFieldIndex("unitactualcost");
        int actualCostIndex = this.rowMeta.getFieldIndex("actualcost");
        values[subUnitIndex] = unitCost;
        values[actualCostIndex] = thisCost;
        values[unitActCostIndex] = unitCost;
        values[subCostIndex] = thisCost;
        String elementType = (String)values[this.rowMeta.getFieldIndex("elementtype")];
        if ("001".equals(elementType)) {
            values[this.rowMeta.getFieldIndex((String)"unitmaterialcost")] = unitCost;
            values[this.rowMeta.getFieldIndex((String)"materialcost")] = thisCost;
        } else if ("002".equals(elementType)) {
            values[this.rowMeta.getFieldIndex((String)"unitfee")] = unitCost;
            values[this.rowMeta.getFieldIndex((String)"fee")] = thisCost;
        } else if ("003".equals(elementType)) {
            values[this.rowMeta.getFieldIndex((String)"unitmanufacturecost")] = unitCost;
            values[this.rowMeta.getFieldIndex((String)"manufacturecost")] = thisCost;
        } else if ("004".equals(elementType)) {
            values[this.rowMeta.getFieldIndex((String)"unitresource")] = unitCost;
            values[this.rowMeta.getFieldIndex((String)"resource")] = thisCost;
        } else if ("005".equals(elementType)) {
            values[this.rowMeta.getFieldIndex((String)"unitprocesscost")] = unitCost;
            values[this.rowMeta.getFieldIndex((String)"processcost")] = thisCost;
        }
    }
}

