/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.constant.CostPriceSourceTypeEnum;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.MatrixTypeEnum;
import kd.fi.calx.algox.matrix.helper.MatrixDesignCostHelper;
import kd.fi.calx.algox.util.ArrayUtils;

public class DealTranInPriceFunction
extends GroupReduceFunction {
    private final CommonInfo commonInfo;
    private final RowMeta rowMeta;

    public DealTranInPriceFunction(CommonInfo commonInfo, RowMeta rowMeta) {
        this.commonInfo = commonInfo;
        this.rowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        Field[] fields = this.rowMeta.getFields();
        Field[] newField = new Field[]{new Field("divprice", (DataType)DataType.BooleanType), new Field("matrixtype", (DataType)DataType.StringType), new Field("adjinfo", (DataType)DataType.StringType), new Field("costpricesourcetype", (DataType)DataType.StringType), new Field("calremark", (DataType)DataType.StringType)};
        return new RowMeta(ArrayUtils.concatAll(fields, new Field[][]{newField}));
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        Iterator<RowX> it = iter.iterator();
        RowMeta resultRowMeta = this.getResultRowMeta();
        RowX sumRow = null;
        BigDecimal sumSrcCost = BigDecimal.ZERO;
        BigDecimal sumTranInQty = BigDecimal.ZERO;
        BigDecimal sumTranOutQty = BigDecimal.ZERO;
        int srcCalPriceIndex = resultRowMeta.getFieldIndex("srccalprice");
        int calCalPriceIndex = resultRowMeta.getFieldIndex("calprice");
        int transQtyIndex = resultRowMeta.getFieldIndex("transqty");
        int calOutTransqtyIndex = resultRowMeta.getFieldIndex("calouttransqty");
        int groupTypeIndex = resultRowMeta.getFieldIndex("type");
        while (it.hasNext()) {
            boolean isTranOutQtyNotNull;
            RowX rowX = it.next();
            Boolean isFixedFee = rowX.getBoolean(resultRowMeta.getFieldIndex("isfixedfee"));
            if (isFixedFee != null && isFixedFee.booleanValue()) continue;
            if (sumRow == null) {
                sumRow = rowX;
            }
            BigDecimal transQty = rowX.getBigDecimal(transQtyIndex);
            BigDecimal calOutTransqty = rowX.getBigDecimal(calOutTransqtyIndex);
            BigDecimal calprice = rowX.getBigDecimal(srcCalPriceIndex);
            calprice = calprice == null ? BigDecimal.ZERO : calprice;
            String queueType = rowX.getString(resultRowMeta.getFieldIndex("queuetype"));
            boolean isTgtBill = "1".equals(rowX.getString(groupTypeIndex));
            boolean isTraninQtyNotNull = "0".equals(queueType) && transQty != null && isTgtBill;
            boolean bl = isTranOutQtyNotNull = "1".equals(queueType) && calOutTransqty != null && isTgtBill;
            if (isTraninQtyNotNull) {
                sumTranInQty = sumTranInQty.add(transQty);
                sumSrcCost = sumSrcCost.add(transQty.multiply(calprice).setScale(10, RoundingMode.HALF_UP));
                continue;
            }
            if (!isTranOutQtyNotNull) continue;
            sumTranOutQty = sumTranOutQty.add(calOutTransqty);
            sumSrcCost = sumSrcCost.add(calOutTransqty.multiply(calprice).setScale(10, RoundingMode.HALF_UP));
        }
        if (sumRow == null) {
            return;
        }
        boolean notCalEntryId = new MatrixDesignCostHelper().isNotCalEntryId(this.rowMeta, sumRow, this.commonInfo);
        if (notCalEntryId) {
            return;
        }
        if (sumRow != null) {
            boolean isAfterPeriodBill;
            boolean isTgtBill = "1".equals(sumRow.getString(groupTypeIndex));
            BigDecimal baseQty = sumRow.getBigDecimal(resultRowMeta.getFieldIndex("baseqty"));
            if (isTgtBill) {
                BigDecimal sumPrice = sumSrcCost.divide(baseQty, 10, RoundingMode.HALF_UP);
                sumRow.set(calCalPriceIndex, (Object)sumPrice);
            }
            sumRow.set(transQtyIndex, (Object)sumTranInQty);
            sumRow.set(calOutTransqtyIndex, (Object)sumTranOutQty);
            String calPrcSrc = new MatrixDesignCostHelper().getPriceSrcType(sumRow, this.rowMeta, this.commonInfo);
            calPrcSrc = StringUtils.isEmpty((String)calPrcSrc) ? CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getValue() : calPrcSrc;
            String priceSrcType = isTgtBill ? CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue() : calPrcSrc;
            Object[] newRowValues = ArrayUtils.concatAll(sumRow.values(), new Object[][]{{isTgtBill, "", "", priceSrcType, ""}});
            this.setDesOrOutBillMatrixType(newRowValues);
            Boolean writeDtlRpt = new MatrixDesignCostHelper().isWriteDtlRpt(this.commonInfo);
            String matrixType = (String)newRowValues[resultRowMeta.getFieldIndex("matrixtype")];
            boolean writeRptAndEmptyMatrixType = writeDtlRpt != false && StringUtils.isEmpty((String)matrixType);
            Boolean isFixed = sumRow.getBoolean(this.rowMeta.getFieldIndex("isfixed"));
            isFixed = isFixed == null ? Boolean.FALSE : isFixed;
            int periodIdIndex = this.rowMeta.getFieldIndex("periodid");
            int costAcctIndex = this.rowMeta.getFieldIndex("costaccount");
            Long costAcctId = sumRow.getLong(costAcctIndex);
            Long curPeriodId = this.commonInfo.getParamCache().getCurrentPeriod(costAcctId);
            boolean bl = isAfterPeriodBill = curPeriodId.compareTo(sumRow.getLong(periodIdIndex)) < 0;
            if (!writeRptAndEmptyMatrixType) {
                RowX newRowX = new RowX(newRowValues);
                collector.collect(newRowX);
            } else if (isTgtBill && isFixed.booleanValue()) {
                RowX newRowX = new RowX(newRowValues);
                collector.collect(newRowX);
            } else if (isTgtBill && isAfterPeriodBill) {
                RowX newRowX = new RowX(newRowValues);
                collector.collect(newRowX);
            }
        }
    }

    private void setDesOrOutBillMatrixType(Object[] newRowValues) {
        String matrixType = "";
        int transQtyIndex = this.getResultRowMeta().getFieldIndex("transqty");
        int calOutTransqtyIndex = this.getResultRowMeta().getFieldIndex("calouttransqty");
        int matrixTypeIndex = this.getResultRowMeta().getFieldIndex("matrixtype");
        int isFixedIndex = this.getResultRowMeta().getFieldIndex("isfixed");
        Boolean isFixed = (Boolean)newRowValues[isFixedIndex];
        isFixed = isFixed == null ? Boolean.FALSE : isFixed;
        BigDecimal sumTranInQty = (BigDecimal)newRowValues[transQtyIndex];
        BigDecimal sumTranOutQty = (BigDecimal)newRowValues[calOutTransqtyIndex];
        if (sumTranInQty.compareTo(BigDecimal.ZERO) != 0) {
            matrixType = MatrixTypeEnum.TRANIN.getValue();
        } else if (sumTranOutQty.compareTo(BigDecimal.ZERO) != 0) {
            matrixType = MatrixTypeEnum.TRANOUT.getValue();
        } else {
            String queueType = (String)newRowValues[this.rowMeta.getFieldIndex("queuetype")];
            Boolean isVou = (Boolean)newRowValues[this.rowMeta.getFieldIndex("isvoucher")];
            Boolean isRework = (Boolean)newRowValues[this.rowMeta.getFieldIndex("isrework")];
            boolean isVouOrRework = isVou != false || isRework != false;
            RowX newRowX = new RowX(newRowValues);
            RowMeta resultRowMeta = this.getResultRowMeta();
            boolean designFixedCost = new MatrixDesignCostHelper().isDesignFixedCostNotGroup(newRowX, resultRowMeta, this.commonInfo);
            if (!isFixed.booleanValue() && "1".equals(queueType) && !isVouOrRework && !designFixedCost) {
                matrixType = MatrixTypeEnum.OUT.getValue();
            }
        }
        newRowValues[matrixTypeIndex] = matrixType;
    }
}

