/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.helper.MatrixDesignCostHelper;

public class DealUpdateBillFunctoin
extends GroupReduceFunction {
    private static final long serialVersionUID = -6969203160968958349L;
    private final CommonInfo commonInfo;
    private RowMeta rowMeta;
    private boolean skipGroupBill = false;

    public DealUpdateBillFunctoin(CommonInfo commonInfo, RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.commonInfo = commonInfo;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> arg0, Collector arg1) {
        Iterator<RowX> it = arg0.iterator();
        Field interPeriodCostField = this.rowMeta.getField("interperiodcost", false);
        int interPeriodCostIndex = -1;
        if (interPeriodCostField != null) {
            interPeriodCostIndex = this.rowMeta.getFieldIndex("interperiodcost");
        }
        int costAccontIdIndex = this.rowMeta.getFieldIndex("costaccount");
        int subElementIdIndex = this.rowMeta.getFieldIndex("subelementid");
        int groupType = this.rowMeta.getFieldIndex("type");
        RowX matSubEleRowx = null;
        BigDecimal allSubEleCost = BigDecimal.ZERO;
        BigDecimal allUnitSubEleCost = BigDecimal.ZERO;
        HashSet<String> srcEntryIdEles = new HashSet<String>(16);
        int periodIdIndex = this.rowMeta.getFieldIndex("periodid");
        while (it.hasNext()) {
            BigDecimal interPeriodcost;
            boolean notCalEntryId;
            RowX row = it.next();
            if (this.skipGroupBill && row.getString(this.rowMeta.getFieldIndex("srcdomainid")) != null) break;
            Boolean isFixedFee = row.getBoolean(this.rowMeta.getFieldIndex("isfixedfee"));
            if (isFixedFee != null && isFixedFee.booleanValue() || (notCalEntryId = new MatrixDesignCostHelper().isNotCalEntryId(this.rowMeta, row, this.commonInfo))) continue;
            Long costAcctId = row.getLong(costAccontIdIndex);
            BigDecimal calprice = row.getBigDecimal(this.rowMeta.getFieldIndex("calprice"));
            if (calprice == null) {
                calprice = BigDecimal.ZERO;
            }
            BigDecimal baseQty = row.getBigDecimal(this.rowMeta.getFieldIndex("baseqty"));
            int amtprecision = row.getInteger(this.rowMeta.getFieldIndex("amtprecision"));
            String elementType = row.getString(this.rowMeta.getFieldIndex("elementtype"));
            BigDecimal currAmt = calprice.multiply(baseQty).setScale(amtprecision, RoundingMode.HALF_UP);
            Boolean isFixed = row.getBoolean(this.rowMeta.getFieldIndex("isfixed"));
            if (isFixed != null && isFixed.booleanValue() && (interPeriodcost = row.getBigDecimal(interPeriodCostIndex)) != null && interPeriodcost.compareTo(BigDecimal.ZERO) != 0) {
                calprice = interPeriodcost.divide(baseQty, 10, RoundingMode.HALF_UP);
                currAmt = interPeriodcost;
            }
            Boolean coverZero = (Boolean)this.commonInfo.getParamCache().getParamValue("matrix_cover_zero");
            Boolean coverNeg = (Boolean)this.commonInfo.getParamCache().getParamValue("matrix_cover_neg");
            Long costAccount = row.getLong(this.rowMeta.getFieldIndex("costaccount"));
            boolean isCalByElement = this.commonInfo.getParamCache().isCalByElement(costAccount);
            boolean noCoverZero = BigDecimal.ZERO.compareTo(calprice) == 0 && coverZero == false;
            boolean noCoverNeg = BigDecimal.ZERO.compareTo(calprice) > 0 && coverNeg == false;
            boolean saveBillCost = new MatrixDesignCostHelper().isSaveBillCost(row, this.rowMeta);
            if (noCoverZero || noCoverNeg || saveBillCost) {
                String costPriceSourceType = "saveps";
                row.set(this.rowMeta.getFieldIndex("costpricesourcetype"), (Object)costPriceSourceType);
                if (isCalByElement) {
                    BigDecimal oriBillCost;
                    currAmt = oriBillCost = row.getBigDecimal(this.rowMeta.getFieldIndex("cost"));
                    BigDecimal oriBillUnitCost = row.getBigDecimal(this.rowMeta.getFieldIndex("sub_unitactualcost"));
                    calprice = BigDecimal.ZERO.compareTo(oriBillUnitCost) == 0 ? currAmt.divide(baseQty, 10, RoundingMode.HALF_UP) : oriBillUnitCost;
                } else {
                    BigDecimal oriBillUnitCost;
                    BigDecimal oriBillCost;
                    Long subEleId;
                    Map<Long, CostSubElement> elementMap = this.commonInfo.getElementMap();
                    String subType = elementMap.get(subEleId = row.getLong(subElementIdIndex)).getType();
                    if ("001".equals(subType)) {
                        currAmt = oriBillCost = row.getBigDecimal(this.rowMeta.getFieldIndex("materialcost"));
                        oriBillUnitCost = row.getBigDecimal(this.rowMeta.getFieldIndex("unitmaterialcost"));
                        calprice = BigDecimal.ZERO.compareTo(oriBillUnitCost) == 0 ? currAmt.divide(baseQty, 10, RoundingMode.HALF_UP) : oriBillUnitCost;
                    } else if ("002".equals(subType)) {
                        currAmt = oriBillCost = row.getBigDecimal(this.rowMeta.getFieldIndex("fee"));
                        oriBillUnitCost = row.getBigDecimal(this.rowMeta.getFieldIndex("unitfee"));
                        calprice = BigDecimal.ZERO.compareTo(oriBillUnitCost) == 0 ? currAmt.divide(baseQty, 10, RoundingMode.HALF_UP) : oriBillUnitCost;
                    } else if ("003".equals(subType)) {
                        currAmt = oriBillCost = row.getBigDecimal(this.rowMeta.getFieldIndex("manufacturecost"));
                        oriBillUnitCost = row.getBigDecimal(this.rowMeta.getFieldIndex("unitmanufacturecost"));
                        calprice = BigDecimal.ZERO.compareTo(oriBillUnitCost) == 0 ? currAmt.divide(baseQty, 10, RoundingMode.HALF_UP) : oriBillUnitCost;
                    } else if ("004".equals(subType)) {
                        currAmt = oriBillCost = row.getBigDecimal(this.rowMeta.getFieldIndex("resource"));
                        oriBillUnitCost = row.getBigDecimal(this.rowMeta.getFieldIndex("unitresource"));
                        calprice = BigDecimal.ZERO.compareTo(oriBillUnitCost) == 0 ? currAmt.divide(baseQty, 10, RoundingMode.HALF_UP) : oriBillUnitCost;
                    } else if ("005".equals(subType)) {
                        currAmt = oriBillCost = row.getBigDecimal(this.rowMeta.getFieldIndex("processcost"));
                        oriBillUnitCost = row.getBigDecimal(this.rowMeta.getFieldIndex("unitprocesscost"));
                        calprice = BigDecimal.ZERO.compareTo(oriBillUnitCost) == 0 ? currAmt.divide(baseQty, 10, RoundingMode.HALF_UP) : oriBillUnitCost;
                    }
                }
            }
            row.set(this.rowMeta.getFieldIndex("unitactualcost"), (Object)calprice);
            row.set(this.rowMeta.getFieldIndex("actualcost"), (Object)currAmt);
            row.set(this.rowMeta.getFieldIndex("sub_unitactualcost"), (Object)calprice);
            row.set(this.rowMeta.getFieldIndex("cost"), (Object)currAmt);
            if (isCalByElement) {
                row.set(this.rowMeta.getFieldIndex("unitmaterialcost"), (Object)BigDecimal.ZERO);
                row.set(this.rowMeta.getFieldIndex("materialcost"), (Object)BigDecimal.ZERO);
                row.set(this.rowMeta.getFieldIndex("unitfee"), (Object)BigDecimal.ZERO);
                row.set(this.rowMeta.getFieldIndex("fee"), (Object)BigDecimal.ZERO);
                row.set(this.rowMeta.getFieldIndex("unitmanufacturecost"), (Object)BigDecimal.ZERO);
                row.set(this.rowMeta.getFieldIndex("manufacturecost"), (Object)BigDecimal.ZERO);
                row.set(this.rowMeta.getFieldIndex("unitresource"), (Object)BigDecimal.ZERO);
                row.set(this.rowMeta.getFieldIndex("resource"), (Object)BigDecimal.ZERO);
                row.set(this.rowMeta.getFieldIndex("unitprocesscost"), (Object)BigDecimal.ZERO);
                row.set(this.rowMeta.getFieldIndex("processcost"), (Object)BigDecimal.ZERO);
            }
            if ("001".equals(elementType)) {
                row.set(this.rowMeta.getFieldIndex("unitmaterialcost"), (Object)calprice);
                row.set(this.rowMeta.getFieldIndex("materialcost"), (Object)currAmt);
            } else if ("002".equals(elementType)) {
                row.set(this.rowMeta.getFieldIndex("unitfee"), (Object)calprice);
                row.set(this.rowMeta.getFieldIndex("fee"), (Object)currAmt);
            } else if ("003".equals(elementType)) {
                row.set(this.rowMeta.getFieldIndex("unitmanufacturecost"), (Object)calprice);
                row.set(this.rowMeta.getFieldIndex("manufacturecost"), (Object)currAmt);
            } else if ("004".equals(elementType)) {
                row.set(this.rowMeta.getFieldIndex("unitresource"), (Object)calprice);
                row.set(this.rowMeta.getFieldIndex("resource"), (Object)currAmt);
            } else if ("005".equals(elementType)) {
                row.set(this.rowMeta.getFieldIndex("unitprocesscost"), (Object)calprice);
                row.set(this.rowMeta.getFieldIndex("processcost"), (Object)currAmt);
            }
            Long subEleId = row.getLong(subElementIdIndex);
            if (!this.commonInfo.getParamCache().isCalByElement(costAcctId)) {
                String entryEleStr;
                boolean isDul;
                if (subEleId.equals(773175233367685120L)) {
                    String grouptype = row.getString(this.rowMeta.getFieldIndex("type"));
                    boolean isGoupTgtBill = "1".equals(grouptype);
                    if (matSubEleRowx == null || isGoupTgtBill) {
                        matSubEleRowx = row;
                    }
                }
                if (isDul = !srcEntryIdEles.add(entryEleStr = "" + row.getLong(this.rowMeta.getFieldIndex("entryid")) + row.getLong(this.rowMeta.getFieldIndex("subelementid")))) continue;
                allSubEleCost = allSubEleCost.add(currAmt);
                allUnitSubEleCost = allUnitSubEleCost.add(calprice);
                continue;
            }
            arg1.collect(row);
        }
        if (matSubEleRowx != null) {
            matSubEleRowx.set(this.rowMeta.getFieldIndex("sub_unitactualcost"), (Object)allUnitSubEleCost);
            matSubEleRowx.set(this.rowMeta.getFieldIndex("cost"), (Object)allSubEleCost);
            matSubEleRowx.set(this.rowMeta.getFieldIndex("actualcost"), (Object)allSubEleCost);
            arg1.collect(matSubEleRowx);
        }
    }

    public void setSkipGroupBill(boolean skipGroupBill) {
        this.skipGroupBill = skipGroupBill;
    }
}

