/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.calx.algox.constant.CostPriceSourceTypeEnum;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.helper.MatrixDesignCostHelper;

public class DealUpdateBillToDBFunctoin
extends GroupReduceFunction {
    protected static Log log = LogFactory.getLog(DealUpdateBillToDBFunctoin.class);
    private static final long serialVersionUID = -6969203160968958349L;
    private static final String UPDATE_COSTRECORD = "update t_cal_calcostrecordentry set funitactualcost= ? , factualcost = ?, funitmaterialcost = ?, fmaterialcost = ?, funitfee = ?, ffee = ?, funitprocesscost = ?, fprocesscost = ?, funitmanufacturecost = ?, fmanufacturecost = ?, funitresource = ?, fresource =  ?, fiscalculated = ?, fcostpricesource = ?,fdesignatedcost = ? where fentryid = ?";
    private static final String UPDATE_COSTRECORD_DETAIL = "update t_cal_costrecord_detail set funitactualcost=? , factualcost = ? where fentryid = ? and fcostsubelementid = ?";
    private static final int priceprecision = 10;
    private static final int BATCH_SIZE = 1000;
    private final CommonInfo commonInfo;
    private RowMeta rowMeta;
    private RowMeta resultMeta;

    public DealUpdateBillToDBFunctoin(CommonInfo commonInfo, RowMeta rowMeta) {
        this.commonInfo = commonInfo;
        this.rowMeta = rowMeta;
        this.resultMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.resultMeta;
    }

    public void reduce(Iterable<RowX> arg0, Collector arg1) {
        Iterator<RowX> it = arg0.iterator();
        HashMap<Long, Object[]> recordUpdateEtyParams = new HashMap<Long, Object[]>(16);
        ArrayList recordUpdate_list = new ArrayList(16);
        ArrayList<Object[]> elementUpdate_list = new ArrayList<Object[]>(16);
        HashSet<Long> costAccountIds = new HashSet<Long>();
        Date startDate = null;
        Date endDate = null;
        while (it.hasNext()) {
            boolean notCalEntryId;
            RowX row = it.next();
            Long l = row.getLong(this.rowMeta.getFieldIndex("entryid"));
            Long headid = row.getLong(this.rowMeta.getFieldIndex("id"));
            Boolean isVoucher = row.getBoolean(this.rowMeta.getFieldIndex("isvoucher"));
            Boolean isRework = row.getBoolean(this.rowMeta.getFieldIndex("isrework"));
            if (isVoucher.booleanValue() || isRework.booleanValue() || (notCalEntryId = new MatrixDesignCostHelper().isNotCalEntryId(this.rowMeta, row, this.commonInfo))) continue;
            int signNumIndex = this.rowMeta.getFieldIndex("signnum");
            Integer signNum = row.getInteger(signNumIndex);
            BigDecimal signBigDec = new BigDecimal(signNum);
            Long subelementid = row.getLong(this.rowMeta.getFieldIndex("subelementid"));
            BigDecimal sub_actualcost = row.getBigDecimal(this.rowMeta.getFieldIndex("cost"));
            BigDecimal sub_unitactualcost = row.getBigDecimal(this.rowMeta.getFieldIndex("sub_unitactualcost"));
            costAccountIds.add(row.getLong(this.rowMeta.getFieldIndex("costAccount")));
            Date bizDate = row.getDate(this.rowMeta.getFieldIndex("bizdate"));
            if (startDate == null || startDate.after(bizDate)) {
                startDate = bizDate;
            }
            if (endDate == null || endDate.before(bizDate)) {
                endDate = bizDate;
            }
            BigDecimal baseqty = row.getBigDecimal(this.rowMeta.getFieldIndex("baseqty"));
            Object[] recordUpdateparams = this.createRecordUpdateObj(l, baseqty, row);
            Object[] totalparams = (Object[])recordUpdateEtyParams.get(l);
            if (totalparams == null) {
                recordUpdateEtyParams.put(l, recordUpdateparams);
            } else {
                this.mergData(totalparams, recordUpdateparams);
            }
            Long costAccount = row.getLong(this.rowMeta.getFieldIndex("costaccount"));
            sub_actualcost = sub_actualcost.multiply(signBigDec);
            boolean isCalByElement = this.commonInfo.getParamCache().isCalByElement(costAccount);
            if (!isCalByElement) {
                sub_unitactualcost = (BigDecimal)recordUpdateparams[0];
                sub_actualcost = (BigDecimal)recordUpdateparams[1];
            }
            Object[] elementUpdate_params = this.createRecird_ElementUpdateObj(l, baseqty, subelementid, sub_actualcost, sub_unitactualcost, row);
            elementUpdate_list.add(elementUpdate_params);
            arg1.collect(row);
        }
        for (Map.Entry entry : recordUpdateEtyParams.entrySet()) {
            recordUpdate_list.add(entry.getValue());
        }
        Date newStDate = startDate;
        Date date = endDate;
        log.info("#################CostRecordUpdateFunction->costAccountIDs:" + costAccountIds);
        log.info("#################CostRecordUpdateFunction\u2014>recordUpdate_list.size:" + recordUpdate_list.size());
        log.info("#################CostRecordUpdateFunction\u2014>elementUpdate_list.size:" + elementUpdate_list.size());
        DBRoute route = new DBRoute("cal");
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.in_range, costAccountIds), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, newStDate), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, date)});){
            ctx.set();
            Lists.partition(recordUpdate_list, (int)1000).forEach(list1 -> {
                Long startTime = System.currentTimeMillis();
                try (TXHandle handler = TX.requiresNew();){
                    try {
                        DB.executeBatch((DBRoute)route, (String)UPDATE_COSTRECORD, (List)list1);
                    }
                    catch (Throwable e) {
                        log.error("CostRecordUpdateFunction->recordUpdate_list Throwable erro", e);
                        throw new KDBizException(e.getMessage());
                    }
                }
                Long endTime = System.currentTimeMillis();
                log.info("#################CostRecordUpdateFunction\u2014>\u66f4\u65b0COSTRECORDEntry\u5206\u5f55\uff1a" + list1.size() + "\u6761,\u8017\u65f6" + (endTime - startTime) / 1000L + "\u79d2");
                log.info("#################CostRecordUpdateFunction\u2014>\u66f4\u65b0COSTRECORDEntry\u5206\u5f55\u5f53\u524d\u6279\u6b21\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "\u79d2");
            });
        }
        ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.in_range, costAccountIds), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)newStDate), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)date)});
        var14_17 = null;
        try {
            ctx.set();
            Lists.partition(elementUpdate_list, (int)1000).forEach(list3 -> {
                Long startTime = System.currentTimeMillis();
                try (TXHandle handler = TX.requiresNew();){
                    try {
                        DB.executeBatch((DBRoute)route, (String)UPDATE_COSTRECORD_DETAIL, (List)list3);
                    }
                    catch (Throwable e) {
                        log.error("CostRecordUpdateFunction->elementUpdate_list erro", e);
                        throw new KDBizException(e.getMessage());
                    }
                }
                Long endTime = System.currentTimeMillis();
                log.info("#################CostRecordUpdateFunction\u2014>\u66f4\u65b0COSTRECORDEntry_Detail\u5206\u5f55\uff1a" + list3.size() + "\u6761,\u8017\u65f6" + (endTime - startTime) / 1000L + "\u79d2");
            });
        }
        catch (Throwable throwable) {
            var14_17 = throwable;
            throw throwable;
        }
        finally {
            if (ctx != null) {
                if (var14_17 != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        var14_17.addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
    }

    private Object[] createRecordUpdateObj(Long recordId, BigDecimal qty, RowX row) {
        int signNumIndex = this.rowMeta.getFieldIndex("signnum");
        Integer signNum = row.getInteger(signNumIndex);
        BigDecimal signBigDec = new BigDecimal(signNum);
        BigDecimal actualcost = row.getBigDecimal(this.rowMeta.getFieldIndex("actualcost"));
        BigDecimal materialCost = row.getBigDecimal(this.rowMeta.getFieldIndex("materialcost"));
        BigDecimal fee = row.getBigDecimal(this.rowMeta.getFieldIndex("fee"));
        BigDecimal processcost = row.getBigDecimal(this.rowMeta.getFieldIndex("processcost"));
        BigDecimal manufacturecost = row.getBigDecimal(this.rowMeta.getFieldIndex("manufacturecost"));
        BigDecimal resource = row.getBigDecimal(this.rowMeta.getFieldIndex("resource"));
        Boolean divPrice = row.getBoolean(this.rowMeta.getFieldIndex("divprice"));
        BigDecimal unitactualcost = row.getBigDecimal(this.rowMeta.getFieldIndex("unitactualcost"));
        unitactualcost = this.getNewUnitCost(qty, actualcost, divPrice, unitactualcost);
        BigDecimal unitmaterialcost = row.getBigDecimal(this.rowMeta.getFieldIndex("unitmaterialcost"));
        unitmaterialcost = this.getNewUnitCost(qty, materialCost, divPrice, unitmaterialcost);
        BigDecimal unitfee = row.getBigDecimal(this.rowMeta.getFieldIndex("unitfee"));
        unitfee = this.getNewUnitCost(qty, fee, divPrice, unitfee);
        BigDecimal unitprocesscost = row.getBigDecimal(this.rowMeta.getFieldIndex("unitprocesscost"));
        unitprocesscost = this.getNewUnitCost(qty, processcost, divPrice, unitprocesscost);
        BigDecimal unitmanufacturecost = row.getBigDecimal(this.rowMeta.getFieldIndex("unitmanufacturecost"));
        unitmanufacturecost = this.getNewUnitCost(qty, manufacturecost, divPrice, unitmanufacturecost);
        BigDecimal unitresource = row.getBigDecimal(this.rowMeta.getFieldIndex("unitresource"));
        unitresource = this.getNewUnitCost(qty, resource, divPrice, unitresource);
        actualcost = actualcost.multiply(signBigDec);
        materialCost = materialCost.multiply(signBigDec);
        fee = fee.multiply(signBigDec);
        processcost = processcost.multiply(signBigDec);
        manufacturecost = manufacturecost.multiply(signBigDec);
        resource = resource.multiply(signBigDec);
        Long costAccount = row.getLong(this.rowMeta.getFieldIndex("costaccount"));
        boolean isCalByElement = this.commonInfo.getParamCache().isCalByElement(costAccount);
        if (!isCalByElement) {
            qty = qty.multiply(signBigDec);
            BigDecimal newActCost = materialCost.add(fee).add(processcost).add(manufacturecost).add(resource);
            if (newActCost.compareTo(actualcost) != 0) {
                unitactualcost = newActCost.divide(qty, 10, RoundingMode.HALF_UP);
                actualcost = newActCost;
            }
        }
        String costpricesourcetype = row.getString(this.rowMeta.getFieldIndex("costpricesourcetype"));
        String costpricesource = row.getString(this.rowMeta.getFieldIndex("costpricesource"));
        String designatedcostStr = "0";
        if ("splitbill".equals(costpricesourcetype)) {
            costpricesource = " ";
            designatedcostStr = "0";
        } else if ("saveps".equals(costpricesourcetype)) {
            String costpricesourceLast = CostPriceSourceTypeEnum.getLastByCostPriceSource(costpricesource);
            CostPriceSourceTypeEnum costPriceSourceTypeEnum = CostPriceSourceTypeEnum.getEnumByValue(costpricesourceLast);
            if (costPriceSourceTypeEnum != null) {
                designatedcostStr = costPriceSourceTypeEnum.getDesignated();
            }
        } else if (StringUtils.isNotEmpty((CharSequence)costpricesourcetype)) {
            costpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue(costpricesource, costpricesourcetype);
            CostPriceSourceTypeEnum costPriceSourceTypeEnum = CostPriceSourceTypeEnum.getEnumByValue(costpricesourcetype);
            if (costPriceSourceTypeEnum != null) {
                designatedcostStr = costPriceSourceTypeEnum.getDesignated();
            }
        } else {
            String costpricesourceLast = CostPriceSourceTypeEnum.getLastByCostPriceSource(costpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue(costpricesource, CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getValue()));
            CostPriceSourceTypeEnum costPriceSourceTypeEnum = CostPriceSourceTypeEnum.getEnumByValue(costpricesourceLast);
            if (costPriceSourceTypeEnum != null) {
                designatedcostStr = costPriceSourceTypeEnum.getDesignated();
            }
        }
        return new Object[]{unitactualcost, actualcost, unitmaterialcost, materialCost, unitfee, fee, unitprocesscost, processcost, unitmanufacturecost, manufacturecost, unitresource, resource, "1", costpricesource, designatedcostStr, recordId};
    }

    private void mergData(Object[] totalDatas, Object[] detailDatas) {
        if (totalDatas == null || detailDatas == null) {
            return;
        }
        for (int index = 0; index < totalDatas.length; ++index) {
            if (!(totalDatas[index] instanceof BigDecimal)) continue;
            totalDatas[index] = ((BigDecimal)totalDatas[index]).add((BigDecimal)detailDatas[index]);
        }
    }

    private Object[] createRecird_ElementUpdateObj(Long recordId, BigDecimal qty, long elementId, BigDecimal cost, BigDecimal unitCost, RowX row) {
        int signNumIndex = this.rowMeta.getFieldIndex("signnum");
        Integer signNum = row.getInteger(signNumIndex);
        BigDecimal signBigDec = new BigDecimal(signNum);
        qty = qty.multiply(signBigDec);
        Boolean divPrice = row.getBoolean(this.rowMeta.getFieldIndex("divprice"));
        unitCost = this.getNewUnitCost(qty, cost, divPrice, unitCost);
        return new Object[]{unitCost, cost, recordId, elementId};
    }

    private BigDecimal getNewUnitCost(BigDecimal qty, BigDecimal cost, Boolean divPrice, BigDecimal unitCost) {
        BigDecimal newUnitCost = unitCost;
        if (divPrice.booleanValue()) {
            newUnitCost = cost.divide(qty, 10, RoundingMode.HALF_UP);
        }
        return newUnitCost;
    }
}

