/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.CalOutDataRangeHolder;
import kd.fi.calx.algox.DataInputFactory;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.helper.CBFieldsQueryHelper;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CommonSettingHelper;
import kd.fi.calx.algox.matrix.helper.MatrixDesignCostHelper;
import kd.fi.calx.algox.util.CommonUtils;

public class MatrixDataInputFactory
extends DataInputFactory {
    private static final String ALGOKEY = "kd.fi.calx.algox.matrix.DataInputFactory";
    private final CommonInfo commonInfo;
    private CalOutDataRangeHolder holder;
    private CBFieldsQueryHelper fieldHelper;
    Set<Long> notUpdateBalBizTypeIds = CommonSettingHelper.getNotUpdBalBizType();
    Set<Long> calInvTypeIds = new HashSet<Long>(16);
    Set<Long> calInvSchemeIds = new HashSet<Long>(16);
    private RowMeta bizDataMeta;
    private static final String[] ADJUSTBILL_CREATETYPE = new String[]{"G", "H", "K"};

    public MatrixDataInputFactory(CalOutDataRangeHolder holder, CalCulateOutParams param, CommonInfo commonInfo) {
        super(holder, param);
        this.isMatrix = true;
        this.commonInfo = commonInfo;
        try (DataSet invSchemeDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_invscheme", (String)"id", (QFilter[])new QFilter("isforwardamount", "=", (Object)true).toArray(), null);){
            for (Row row : invSchemeDS) {
                this.calInvSchemeIds.add(row.getLong("id"));
            }
        }
        var5_5 = null;
        try (DataSet invTypeDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_invtype", (String)"id", (QFilter[])new QFilter("isforwardamount", "=", (Object)true).toArray(), null);){
            for (Row row : invTypeDS) {
                this.calInvTypeIds.add(row.getLong("id"));
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        this.fieldHelper = new CBFieldsQueryHelper();
        this.holder = holder;
        this.buildBizRowMeta();
    }

    @Override
    public Input[] createBalanceBizDataInput() {
        ArrayList<Input> inputList = new ArrayList<Input>();
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getMergeRangeListNoRangeId()) {
            Integer period = range.getPeriod();
            Long costAccountId = range.getCostAccountId();
            QFilter filter = new QFilter("costaccount.id", "=", (Object)costAccountId);
            filter.and("invtype", "in", this.calInvTypeIds);
            filter.and("accounttype", "in", (Object)new String[]{AccountTypeEnum.SPPRICE.getValue(), AccountTypeEnum.WEIGHTAVG.getValue()});
            if (range.isAllMaterial()) {
                QFilter lastPeriodFilter = filter.copy();
                lastPeriodFilter.and(new QFilter("period", "<", (Object)period));
                lastPeriodFilter.and("endperiod", ">=", (Object)period);
                Input balInput = this.queryBal(range, period, lastPeriodFilter);
                inputList.add(balInput);
                QFilter curPeriodFilter = filter.copy();
                curPeriodFilter.and(new QFilter("period", "=", (Object)period));
                Input recSedInput = this.queryBal(range, period, curPeriodFilter);
                inputList.add(recSedInput);
                continue;
            }
            HashSet<Object> matIds = new HashSet<Object>();
            matIds.add(1L);
            for (Set<Object> materialIds : range.getMaterialSetList()) {
                matIds.addAll(materialIds);
            }
            QFilter mfilter = filter.copy();
            mfilter.and("material.id", "in", matIds);
            QFilter lastPeriodFilter = mfilter.copy();
            lastPeriodFilter.and(new QFilter("period", "<", (Object)period));
            lastPeriodFilter.and("endperiod", ">=", (Object)period);
            Input balInput = this.queryBal(range, period, lastPeriodFilter);
            inputList.add(balInput);
            QFilter curPeriodFilter = mfilter.copy();
            curPeriodFilter.and(new QFilter("period", "=", (Object)period));
            Input recSedInput = this.queryBal(range, period, curPeriodFilter);
            inputList.add(recSedInput);
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    private void setBalRowMeta(DataSet data) {
        data.getRowMeta().getField("rowtype").setDataType((DataType)DataType.StringType);
        data.getRowMeta().getField("createtype").setDataType((DataType)DataType.StringType);
        data.getRowMeta().getField("costaccounttype").setDataType((DataType)DataType.LongType);
        data.getRowMeta().getField("priceprecision").setDataType((DataType)DataType.IntegerType);
        data.getRowMeta().getField("ordercol").setDataType((DataType)DataType.StringType);
        data.getRowMeta().getField("calrangeid").setDataType((DataType)DataType.LongType);
        data.getRowMeta().getField("costrecordentryid").setDataType((DataType)DataType.LongType);
        data.getRowMeta().getField("bizbillid").setDataType((DataType)DataType.LongType);
        data.getRowMeta().getField("biztypeid").setDataType((DataType)DataType.LongType);
        data.getRowMeta().getField("bizbillentryid").setDataType((DataType)DataType.LongType);
        data.getRowMeta().getField("calentryid").setDataType((DataType)DataType.LongType);
        data.getRowMeta().getField("queuetype").setDataType((DataType)DataType.StringType);
        data.getRowMeta().getField("iscalculated").setDataType((DataType)DataType.BooleanType);
        data.getRowMeta().getField("isvoucher").setDataType((DataType)DataType.BooleanType);
        data.getRowMeta().getField("isfivoucher").setDataType((DataType)DataType.BooleanType);
        data.getRowMeta().getField("iscalculated").setDataType((DataType)DataType.BooleanType);
        data.getRowMeta().getField("ispresent").setDataType((DataType)DataType.BooleanType);
        data.getRowMeta().getField("billstatus").setDataType((DataType)DataType.StringType);
        data.getRowMeta().getField("periodid").setDataType((DataType)DataType.LongType);
        data.getRowMeta().getField("materialcost").setDataType((DataType)DataType.BigDecimalType);
        data.getRowMeta().getField("fee").setDataType((DataType)DataType.BigDecimalType);
        data.getRowMeta().getField("processcost").setDataType((DataType)DataType.BigDecimalType);
        data.getRowMeta().getField("manufacturecost").setDataType((DataType)DataType.BigDecimalType);
        data.getRowMeta().getField("resource").setDataType((DataType)DataType.BigDecimalType);
        data.getRowMeta().getField("beginqty").setDataType((DataType)DataType.BigDecimalType);
        data.getRowMeta().getField("baseqty").setDataType((DataType)DataType.BigDecimalType);
        data.getRowMeta().getField("actualcost").setDataType((DataType)DataType.BigDecimalType);
        data.getRowMeta().getField("cost").setDataType((DataType)DataType.BigDecimalType);
        data.getRowMeta().getField("begincost").setDataType((DataType)DataType.BigDecimalType);
    }

    private Input queryBal(CalOutDataRangeHolder.CalOutRange range, Integer period, QFilter filter) {
        OrmInput input = null;
        String balEntity = CalBalanceModelHelper.getBalanceEntityName(true);
        String balSels = this.getBalanceBizField(range.getPeriodId(), period);
        RowMeta balRowMeta = this.getBalRowMeta(balEntity, balSels);
        Boolean balCompress = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        if (CalBalanceModelHelper.isNewBalance() && balCompress.booleanValue()) {
            String selects = this.getBalanceBizField(range.getPeriodId(), period);
            HashSet<String> otherDims = new HashSet<String>(16);
            otherDims.add("id");
            otherDims.add("costaccount.name");
            otherDims.add("costaccount.calsystem");
            otherDims.add("costaccount.calpolicy");
            otherDims.add("costaccount.costtype");
            otherDims.add("costaccount.booktype");
            otherDims.add("periodid.begindate");
            otherDims.add("calorg");
            otherDims.add("costaccount.calpolicy.currency");
            otherDims.add("costaccount.calpolicy.currency.amtprecision");
            otherDims.add("costaccount.calpolicy.currency.priceprecision");
            otherDims.add("calrange");
            otherDims.add("baseunit");
            otherDims.add("baseunit.precision");
            otherDims.add("costsubelement");
            String cacheId = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalUncompressService", (String)"getBalancDataSetDetail", (Object[])new Object[]{false, false, otherDims, Collections.singletonList(filter)});
            DataSet data = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)this.getClass().getName()), true);
            data = data.select(selects);
            this.setBalRowMeta(data);
            input = new DataSetInput(data, data.getRowMeta());
        } else {
            input = new OrmInput(ALGOKEY, balEntity, balSels, filter.toArray(), balRowMeta);
        }
        return input;
    }

    @Override
    public Input[] createCostAdjustBizDataInput() {
        return this.createCostAdjustBizDataInput(null);
    }

    public Input[] createCostAdjustBizDataInput(QFilter otherFilter) {
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getCalOutRangeList()) {
            Long costAccountId = range.getCostAccountId();
            QFilter filter = null;
            if (this.holder.isNeedCalculatedLater()) {
                filter = new QFilter("period.id", ">=", (Object)range.getPeriodId());
                filter.and("bookdate", ">=", (Object)range.getStartDate());
            } else {
                filter = new QFilter("period.id", "=", (Object)range.getPeriodId());
                filter.and("bookdate", ">=", (Object)range.getStartDate());
                filter.and("bookdate", "<=", (Object)range.getEndDate());
            }
            filter.and("costaccount.id", "=", (Object)costAccountId);
            filter.and("entryentity.calrange", "=", (Object)range.getCalRangeId());
            filter.and("createtype", "not in", (Object)ADJUSTBILL_CREATETYPE);
            filter.and("difftype", "=", (Object)"B");
            filter.and("entryentity.accounttype", "in", (Object)new String[]{AccountTypeEnum.SPPRICE.getValue(), AccountTypeEnum.WEIGHTAVG.getValue()});
            filter.and(otherFilter);
            if (range.isAllMaterial()) {
                RowMeta adjRowMeta = this.getAdjRowMeta();
                OrmInput adjInput = new OrmInput(ALGOKEY, "cal_costadjust_subentity", this.getCostAdjustBizField(), filter.toArray(), adjRowMeta);
                inputList.add(adjInput);
                continue;
            }
            HashSet<Long> matIds = new HashSet<Long>();
            matIds.add(1L);
            for (Set set : range.getMaterialSetList()) {
                matIds.addAll(set);
            }
            QFilter mFilter = filter.copy();
            mFilter.and("entryentity.material.id", "in", matIds);
            RowMeta rowMeta = this.getAdjRowMeta();
            OrmInput adjInput = new OrmInput(ALGOKEY, "cal_costadjust_subentity", this.getCostAdjustBizField(), mFilter.toArray(), rowMeta);
            inputList.add(adjInput);
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    @Override
    protected String getSplitCostRecordField() {
        return "costaccount,costaccount.booktype as costaccounttype,id,invscheme.zerocost as invzerocost,entry.id as entryid,entry.isrework as isrework,entry.calentryid as calentryid,entry.ancestorentryid as ancestorentryid,entry.fatherentryid as parentid,period as periodid,isvoucher,issplitcreate,issplit,isinitbill,ischargeoff,ischargeoffed,writeofftype,entry.material as material, " + this.fieldHelper.getAllCalFields("cal_costrecord_subentity") + ",entry.baseqty*entry.signnum as baseqty,entry.queuetype as queuetype,entry.signnum as signnum,entry.accounttype as accounttype,entry.iscalculated as iscalculated,issubbillinvoiceverify,writeoffperiod,writeoffendperiod,writeoffstatus,entry.writeoffid as writeoffid,invscheme.bizdirection as invbizdirection,localcurrency,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as priceprecision,costaccount.calsystem as calsystem,costaccount.calpolicy as calpolicy,costaccount.calpolicy.exratetable as exratetable,costaccount.calpolicy.convertmode as convertmode,entry.actualcost*entry.signnum as actualcost,entry.materialcost*entry.signnum as materialcost,entry.fee*entry.signnum as fee,entry.processcost*entry.signnum as processcost,entry.manufacturecost*entry.signnum as manufacturecost,entry.resource*entry.signnum as resource,billno,entry.costpricesource as costpricesource,null as costpricesourcetype,entry.designatedcost as designatedcost,entry.seq as entryseq,0L as calrangeid,entry.baseunit as baseunit,entry.baseunit.precision as qtyprecision,case when entry.queuetype = '0' and entry.baseqty*entry.signnum > 0 then '1' when entry.queuetype = '0' and entry.baseqty*entry.signnum < 0 then '2' when entry.queuetype = '1' and entry.baseqty*entry.signnum > 0 then '2' else '1' end as ordercol,0L as costrecordentryid,bizentityobject,0L as incostadjustentryid,entry.entrystatus as entrystatus,entry.subentrycostelement.costsubelement as elementid,entry.subentrycostelement.sub_actualcost*entry.signnum as cost";
    }

    private RowMeta getAdjRowMeta() {
        RowMeta adjRowMeta = ORM.create().createRowMeta("cal_costadjust_subentity", this.getCostAdjustBizField());
        adjRowMeta.getField("isfivoucher").setDataType((DataType)DataType.BooleanType);
        adjRowMeta.getField("ispresent").setDataType((DataType)DataType.BooleanType);
        adjRowMeta.getField("iscalculated").setDataType((DataType)DataType.BooleanType);
        adjRowMeta.getField("unitactualcost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("sub_unitactualcost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("unitmaterialcost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("unitfee").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("unitmanufacturecost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("unitresource").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("unitprocesscost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("oricost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("orimaterialcost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("isRework").setDataType((DataType)DataType.BooleanType);
        adjRowMeta.getField("bizentityobject").setDataType((DataType)DataType.StringType);
        adjRowMeta.getField("issubbillinvoiceverify").setDataType((DataType)DataType.BooleanType);
        adjRowMeta.getField("baseqty_out").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("actualcost_out").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("calbilltype").setDataType((DataType)DataType.StringType);
        adjRowMeta.getField("billtypenum").setDataType((DataType)DataType.StringType);
        adjRowMeta.getField("billtypename").setDataType((DataType)DataType.StringType);
        adjRowMeta.getField("biztypeid").setDataType((DataType)DataType.LongType);
        adjRowMeta.getField("calentryid").setDataType((DataType)DataType.LongType);
        adjRowMeta.getField("rowtype").setDataType((DataType)DataType.StringType);
        adjRowMeta.getField("baseqty").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("materialcost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("fee").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("processcost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("manufacturecost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("resource").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("oricost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("orimaterialcost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("cost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("baseqty_out").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("actualcost_out").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("ordercol").setDataType((DataType)DataType.StringType);
        adjRowMeta.getField("entrystatus").setDataType((DataType)DataType.StringType);
        adjRowMeta.getField("fixedoutcost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("fixedincost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("begincost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("beginqty").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("inqty").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("outqty").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("fixedoutqty").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("fixedinqty").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("costpricesource").setDataType((DataType)DataType.StringType);
        adjRowMeta.getField("designatedcost").setDataType((DataType)DataType.BooleanType);
        adjRowMeta.getField("invzerocost").setDataType((DataType)DataType.BooleanType);
        Field addPriceField = adjRowMeta.getField("addPriceField", false);
        if (addPriceField != null) {
            addPriceField.setDataType((DataType)DataType.BigDecimalType);
        }
        adjRowMeta.getField("maxrowbillid").setDataType((DataType)DataType.LongType);
        adjRowMeta.getField("maxrowentryid").setDataType((DataType)DataType.LongType);
        adjRowMeta.getField("needzeroprice").setDataType((DataType)DataType.IntegerType);
        return adjRowMeta;
    }

    public Input[] createUpdateBillDataInput(QFilter qfilter) {
        ArrayList<Object> inputList = new ArrayList<Object>();
        Algo algo = Algo.create((String)ALGOKEY);
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getCalOutRangeList()) {
            QFilter filter = null;
            if (this.holder.isNeedCalculatedLater()) {
                filter = new QFilter("period.id", ">=", (Object)range.getPeriodId());
                filter.and("bookdate", ">=", (Object)range.getStartDate());
            } else {
                filter = new QFilter("period.id", "=", (Object)range.getPeriodId());
                filter.and("bookdate", ">=", (Object)range.getStartDate());
                filter.and("bookdate", "<=", (Object)range.getEndDate());
            }
            filter.and("costaccount.id", "=", (Object)range.getCostAccountId());
            filter.and("entry.calrange", "=", (Object)range.getCalRangeId());
            filter.and("isinitbill", "=", (Object)Boolean.FALSE);
            filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            filter.and("invscheme", "in", this.calInvSchemeIds);
            filter.and("entry.invtype", "in", this.calInvTypeIds);
            filter.and("entry.accounttype", "in", (Object)new String[]{AccountTypeEnum.SPPRICE.getValue(), AccountTypeEnum.WEIGHTAVG.getValue()});
            if (this.notUpdateBalBizTypeIds != null && !this.notUpdateBalBizTypeIds.isEmpty()) {
                filter.and("biztype", "not in", this.notUpdateBalBizTypeIds);
            }
            QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
            filter.and(billStatusf);
            if (qfilter != null) {
                filter.and(qfilter);
            }
            if (range.isAllMaterial()) {
                inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getUpdateCostRecordBizField(), filter.toArray(), this.bizDataMeta));
                continue;
            }
            HashSet<Object> matIds = new HashSet<Object>();
            for (Set<Object> materialIds : range.getMaterialSetList()) {
                matIds.addAll(materialIds);
            }
            filter.and("entry.material.id", "in", matIds);
            inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getUpdateCostRecordBizField(), filter.toArray(), this.bizDataMeta));
        }
        DataSet emptySet = algo.createDataSet(new ArrayList(), this.bizDataMeta);
        inputList.add(new DataSetInput(emptySet, this.bizDataMeta));
        return inputList.toArray(new Input[inputList.size()]);
    }

    public Input[] createNotCalCostRecInput(QFilter qfilter) {
        ArrayList<Object> inputList = new ArrayList<Object>(16);
        Algo algo = Algo.create((String)ALGOKEY);
        String notCalSels = this.getNotCalSels();
        RowMeta bizDataMeta = ORM.create().createRowMeta("cal_costrecord_subentity", notCalSels);
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getCalOutRangeList()) {
            QFilter filter = null;
            if (this.holder.isNeedCalculatedLater()) {
                filter = new QFilter("period.id", ">=", (Object)range.getPeriodId());
                filter.and("bookdate", ">=", (Object)range.getStartDate());
            } else {
                filter = new QFilter("period.id", "=", (Object)range.getPeriodId());
                filter.and("bookdate", ">=", (Object)range.getStartDate());
                filter.and("bookdate", "<=", (Object)range.getEndDate());
            }
            filter.and("costaccount.id", "=", (Object)range.getCostAccountId());
            filter.and("entry.calrange", "=", (Object)range.getCalRangeId());
            filter.and("isinitbill", "=", (Object)Boolean.FALSE);
            filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            filter.and("invscheme", "in", this.calInvSchemeIds);
            filter.and("entry.invtype", "in", this.calInvTypeIds);
            filter.and("entry.accounttype", "in", (Object)new String[]{AccountTypeEnum.SPPRICE.getValue(), AccountTypeEnum.WEIGHTAVG.getValue()});
            if (this.notUpdateBalBizTypeIds != null && !this.notUpdateBalBizTypeIds.isEmpty()) {
                filter.and("biztype", "not in", this.notUpdateBalBizTypeIds);
            }
            QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
            filter.and(billStatusf);
            if (qfilter != null) {
                filter.and(qfilter);
            }
            if (range.isAllMaterial()) {
                inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", notCalSels, filter.toArray(), bizDataMeta));
                continue;
            }
            HashSet<Object> matIds = new HashSet<Object>(16);
            for (Set<Object> materialIds : range.getMaterialSetList()) {
                matIds.addAll(materialIds);
            }
            filter.and("entry.material.id", "in", matIds);
            inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", notCalSels, filter.toArray(), bizDataMeta));
        }
        DataSet emptySet = algo.createDataSet(new ArrayList(16), bizDataMeta);
        inputList.add(new DataSetInput(emptySet, bizDataMeta));
        return inputList.toArray(new Input[inputList.size()]);
    }

    private String getNotCalSels() {
        return "entry.id as notcalentryid";
    }

    public Input[] createUpdateBillDataInputNoBookDate(QFilter qfilter) {
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        Algo algo = Algo.create((String)ALGOKEY);
        QFilter filter = new QFilter("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("invscheme", "in", this.calInvSchemeIds);
        filter.and("entry.invtype", "in", this.calInvTypeIds);
        filter.and("entry.accounttype", "in", (Object)new String[]{AccountTypeEnum.SPPRICE.getValue(), AccountTypeEnum.WEIGHTAVG.getValue()});
        if (this.notUpdateBalBizTypeIds != null && !this.notUpdateBalBizTypeIds.isEmpty()) {
            filter.and("biztype", "not in", this.notUpdateBalBizTypeIds);
        }
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        filter.and(billStatusf);
        filter.and(qfilter);
        inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getUpdateCostRecordBizField(), filter.toArray(), this.bizDataMeta));
        return inputList.toArray(new Input[inputList.size()]);
    }

    @Override
    public Input[] createAllGroupData() {
        Date maxDate = null;
        Date minDate = null;
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        DataSet entryIdSet = null;
        if (this.isBizGroup.booleanValue()) {
            String selectField = "costrecordentryid as entryentity.costrecordentryid,costaccount as entryentity.costaccount,bookdate as entryentity.bookdate,period as entryentity.period,periodenddate as entryentity.period.enddate";
            entryIdSet = this.getBizGroupDS();
            entryIdSet = entryIdSet.select(selectField);
        } else {
            HashSet<Long> tempGIds = new HashSet<Long>(16);
            ArrayList<OrmInput> accountGroupRecordList = new ArrayList<OrmInput>(16);
            for (Long gId : this.getGroupRecordIdSet()) {
                tempGIds.add(gId);
                if (tempGIds.size() < 100000) continue;
                OrmInput tempInput = new OrmInput(ALGOKEY, "cal_account_grouprecord", "entryentity.costrecordentryid,entryentity.costaccount,entryentity.bookdate,entryentity.period,entryentity.period.enddate", new QFilter("id", "in", tempGIds).toArray());
                accountGroupRecordList.add(tempInput);
                tempGIds = new HashSet(100000);
            }
            OrmInput tempInput = new OrmInput(ALGOKEY, "cal_account_grouprecord", "entryentity.costrecordentryid,entryentity.costaccount,entryentity.bookdate,entryentity.period,entryentity.period.enddate", new QFilter("id", "in", tempGIds).toArray());
            accountGroupRecordList.add(tempInput);
            entryIdSet = Algo.create((String)this.getClass().getName()).createDataSet((Input[])accountGroupRecordList.toArray(new OrmInput[0]));
        }
        RowMeta RowMeta2 = this.getBizDataMeta();
        HashSet<Long> tempGIds = new HashSet<Long>(16);
        ArrayList<OrmInput> costRecordList = new ArrayList<OrmInput>(16);
        while (entryIdSet.hasNext()) {
            Row row = entryIdSet.next();
            Long costrecordentryid = row.getLong("entryentity.costrecordentryid");
            Date endDate = row.getDate("entryentity.period.enddate");
            Date bookDate = row.getDate("entryentity.bookdate");
            Long costaccountid = row.getLong("entryentity.costaccount");
            costAccountIds.add(costaccountid);
            tempGIds.add(costrecordentryid);
            if (maxDate == null || maxDate.compareTo(endDate) < 0) {
                maxDate = endDate;
            }
            if (bookDate != null && (minDate == null || minDate.after(bookDate))) {
                minDate = bookDate;
            }
            if (tempGIds.size() < 100000) continue;
            QFilter filter = new QFilter("entry.id", "in", tempGIds);
            filter = filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            filter = filter.and("costaccount", "in", costAccountIds);
            filter = filter.and("bookdate", "<=", (Object)maxDate);
            if (this.getNewGroup().booleanValue()) {
                filter = filter.and("bookdate", ">=", (Object)minDate);
            }
            QFilter calEndDateFilter = new MatrixDesignCostHelper().getCalEndDateFilter(this.commonInfo);
            filter.and(calEndDateFilter);
            OrmInput crInput = new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getCostRecordBizField(), filter.toArray(), RowMeta2);
            costRecordList.add(crInput);
            tempGIds = new HashSet(100000);
            costAccountIds = new HashSet(16);
            maxDate = null;
            minDate = null;
        }
        QFilter filter = new QFilter("entry.id", "in", tempGIds);
        filter = filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        filter = filter.and("costaccount", "in", costAccountIds);
        filter = filter.and("bookdate", "<=", maxDate);
        if (this.getNewGroup().booleanValue()) {
            filter = filter.and("bookdate", ">=", minDate);
        }
        QFilter calEndDateFilter = new MatrixDesignCostHelper().getCalEndDateFilter(this.commonInfo);
        filter.and(calEndDateFilter);
        OrmInput crInput = new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getCostRecordBizField(), filter.toArray(), RowMeta2);
        costRecordList.add(crInput);
        return (Input[])costRecordList.toArray(new OrmInput[0]);
    }

    @Override
    public Input[] createOutSortInput() {
        QFilter filter = null;
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>(16);
        StringBuilder sb = new StringBuilder();
        String selectFields = this.fieldHelper.getDimFileds("cal_sortresult", false);
        sb.append(selectFields);
        sb.append(",id as sortid,groupno,sortlistid,period as periodid,calrange as calrangeid,costaccount,headcalorg as calorg");
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getCalOutRangeList()) {
            filter = filter != null ? filter.and("costaccount.id", "=", (Object)range.getCostAccountId()) : new QFilter("costaccount.id", "=", (Object)range.getCostAccountId());
            filter.and(new QFilter("calrange.id", "=", (Object)range.getCalRangeId()));
            if (!range.isAllMaterial()) {
                HashSet<Object> matIds = new HashSet<Object>();
                for (Set<Object> materialIds : range.getMaterialSetList()) {
                    matIds.addAll(materialIds);
                }
                filter.and("material", "in", matIds);
            }
            inputList.add(new OrmInput(ALGOKEY, "cal_sortresult", sb.toString(), filter != null ? filter.toArray() : null));
            filter = null;
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    public DataSet getGroupRecordDataSetByBiz() {
        DataSet groupDataSet = this.getBizGroupDS();
        groupDataSet = groupDataSet.select("groupid,iscompleted,costrecordentryid as groupcostrecordentryid,type,bizbillid,bookdate,period,periodenddate");
        return groupDataSet;
    }

    public Input[] getGroupRecordDataSet() {
        if (this.isBizGroup.booleanValue()) {
            DataSet groupDataSet = this.getBizGroupDS();
            groupDataSet = groupDataSet.select("groupid,iscompleted,costrecordentryid as groupcostrecordentryid,type,bizbillid,bookdate,period,periodenddate");
            return new Input[]{new DataSetInput(groupDataSet)};
        }
        String selectFields = "id as groupid,iscompleted,entryentity.costrecordentryid as groupcostrecordentryid,entryentity.type as type,entryentity.bizbillid as bizbillid,entryentity.bookdate as bookdate,entryentity.period as period,entryentity.period.enddate as periodenddate";
        DataSet groupDataDs = this.createBillGroupDataSet(selectFields);
        return new Input[]{new DataSetInput(groupDataDs)};
    }

    private String getCostRecordBizField() {
        String addPriceField = this.getAddPriceField();
        return "id,billno,entry.id as entryid,calorg,costaccount,costaccount.name as costaccountname,costaccount.calsystem as calsystem,costaccount.calpolicy as calpolicy,costaccount.costtype as costtype,costaccount.booktype as costaccounttype,calbilltype,bookdate as bizdate,auditdate,billno as billnumber,billtype.number as billtypenum,billtype.name as billtypename,id as bizbillid,biztype as biztypeid,entry.id as bizbillentryid,entry.calentryid as calentryid," + this.fieldHelper.getDimFileds("cal_costrecord") + ",'1' as rowtype,entry.queuetype as queuetype,entry.signnum as signnum,entry.iscalculated as iscalculated,period as periodid,entry.baseqty*entry.signnum as baseqty,localcurrency,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as priceprecision,isvoucher,isfivoucher,entry.ispresent as ispresent,billstatus,' ' as createtype,entry.actualcost*entry.signnum as actualcost,entry.materialcost*entry.signnum as materialcost,entry.fee*entry.signnum as fee,entry.processcost*entry.signnum as processcost,entry.manufacturecost*entry.signnum as manufacturecost,entry.resource*entry.signnum as resource,entry.seq as entryseq,entry.calrange as calrangeid,entry.baseunit as baseunit,entry.baseunit.precision as qtyprecision,case when entry.queuetype = '0' and entry.baseqty*entry.signnum > 0 then '1' when entry.queuetype = '0' and entry.baseqty*entry.signnum < 0 then '3' when entry.queuetype = '1' and entry.baseqty*entry.signnum > 0 then '3' else '1' end as ordercol,0L as costrecordentryid,entry.entrystatus as entrystatus,entry.subentrycostelement.costsubelement as subelementid,entry.subentrycostelement.costsubelement.type as elementtype,entry.subentrycostelement.sub_actualcost*entry.signnum as cost,0.0 as fixedoutcost,0.0 as fixedincost,0.0 as begincost,0.0 as beginqty,0.0 as inqty,0.0 as fixedinqty,0.0 as outqty,0.0 as fixedoutqty,entry.unitactualcost as unitactualcost,entry.subentrycostelement.sub_unitactualcost as sub_unitactualcost,entry.unitmaterialcost as unitmaterialcost,entry.unitfee as unitfee,entry.unitmanufacturecost as unitmanufacturecost,entry.unitresource as unitresource,entry.unitprocesscost as unitprocesscost,entry.costdomainkey as domainid,entry.subentrycostelement.sub_actualcost*entry.signnum as oricost,entry.materialcost*entry.signnum as orimaterialcost" + addPriceField + ",entry.isrework isRework,bizentityobject,issubbillinvoiceverify,0 as baseqty_out,0 as actualcost_out,entry.costpricesource as costpricesource,entry.designatedcost designatedcost,invscheme.zerocost as invzerocost,0L as maxrowbillid,0L as maxrowentryid,0 as needzeroprice";
    }

    private String getUpdateCostRecordBizField() {
        String addPriceField = this.getAddPriceField();
        return "id,billno,entry.id as entryid,calorg,costaccount,costaccount.name as costaccountname,costaccount.calsystem as calsystem,costaccount.calpolicy as calpolicy,costaccount.costtype as costtype,costaccount.booktype as costaccounttype,calbilltype,bookdate as bizdate,auditdate,billno as billnumber,billtype.number as billtypenum,billtype.name as billtypename,id as bizbillid,biztype as biztypeid,entry.id as bizbillentryid,entry.calentryid as calentryid," + this.fieldHelper.getDimFileds("cal_costrecord") + ",'1' as rowtype,entry.queuetype as queuetype,entry.signnum as signnum,entry.iscalculated as iscalculated,period as periodid,entry.baseqty*entry.signnum as baseqty,localcurrency,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as priceprecision,isvoucher,isfivoucher,entry.ispresent as ispresent,billstatus,' ' as createtype,0.0 as actualcost,entry.materialcost*entry.signnum as materialcost,entry.fee*entry.signnum as fee,entry.processcost*entry.signnum as processcost,entry.manufacturecost*entry.signnum as manufacturecost,entry.resource*entry.signnum as resource,entry.seq as entryseq,entry.calrange as calrangeid,entry.baseunit as baseunit,entry.baseunit.precision as qtyprecision,case when entry.queuetype = '0' and entry.baseqty*entry.signnum > 0 then '1' when entry.queuetype = '0' and entry.baseqty*entry.signnum < 0 then '3' when entry.queuetype = '1' and entry.baseqty*entry.signnum > 0 then '3' else '1' end as ordercol,0L as costrecordentryid,entry.entrystatus as entrystatus,entry.subentrycostelement.costsubelement as subelementid,entry.subentrycostelement.costsubelement.type as elementtype,entry.subentrycostelement.sub_actualcost*entry.signnum as cost,0.0 as fixedoutcost,0.0 as fixedincost,0.0 as begincost,0.0 as beginqty,0.0 as inqty,0.0 as fixedinqty,0.0 as outqty,0.0 as fixedoutqty,entry.unitactualcost as unitactualcost,entry.subentrycostelement.sub_unitactualcost as sub_unitactualcost,entry.unitmaterialcost as unitmaterialcost,entry.unitfee as unitfee,entry.unitmanufacturecost as unitmanufacturecost,entry.unitresource as unitresource,entry.unitprocesscost as unitprocesscost,entry.costdomainkey as domainid,entry.subentrycostelement.sub_actualcost*entry.signnum as oricost,entry.materialcost*entry.signnum as orimaterialcost" + addPriceField + ",entry.isrework isRework,bizentityobject,issubbillinvoiceverify,0 as baseqty_out,0 as actualcost_out,entry.costpricesource as costpricesource,entry.designatedcost designatedcost,invscheme.zerocost as invzerocost,0L as maxrowbillid,0L as maxrowentryid,0 as  needzeroprice";
    }

    private String getBalanceBizField(Long periodId, Integer period) {
        String s = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"DataInputFactory_0", (String)"fi-calx-algox", (Object[])new Object[0]);
        String balanceFileds = "";
        if (CalBalanceModelHelper.isNewBalance()) {
            String dimFields = CalBalanceModelHelper.getDimFields(false);
            balanceFileds = " id as id,'' as billno,id as entryid," + dimFields + ",costaccount.name as costaccountname,costaccount.calsystem as calsystem,costaccount.calpolicy as calpolicy,costaccount.costtype as costtype,costaccount.booktype as costaccounttype,'' as calbilltype,periodid.begindate as bizdate,periodid.begindate as auditdate,'' as billnumber,'' as billtypenum,'" + s + "' as billtypename,0L as bizbillid,0L as biztypeid,0L as bizbillentryid,0L as calentryid,calorg,'0' as rowtype,'0' as queuetype,0 as signnum,'1' as iscalculated," + periodId + " as periodid,case when period = " + period + " then 0 else baseqty_bal end as beginqty,costaccount.calpolicy.currency as localcurrency,costaccount.calpolicy.currency.amtprecision as amtprecision,costaccount.calpolicy.currency.priceprecision as priceprecision,case when period = " + period + " then 0 else baseqty_bal end as baseqty,0.0 as inqty,0.0 as fixedinqty,0.0 as outqty,'0' as isvoucher,'0' as isfivoucher,'0' as ispresent,'A' as billstatus,' ' as createtype,case when period = " + period + " then 0 else actualcost_bal end as actualcost,case when period = " + period + " then 0 else actualcost_bal end as cost,0 as materialcost,0 as fee,0 as processcost,0 as manufacturecost,0 as resource,0 as entryseq,calrange as calrangeid,baseunit as baseunit,baseunit.precision as qtyprecision,'0' as ordercol,0L as costrecordentryid,'C' as entrystatus,costsubelement as subelementid, case when period = " + period + " then 0 else actualcost_bal end as begincost, 0.0 as fixedoutcost,0.0 as fixedincost,0.0 as fixedoutqty,case when period = " + period + " then baseqty_out else 0 end as baseqty_out,case when period = " + period + " then actualcost_out else 0 end as actualcost_out,0L as maxrowbillid, 0L as maxrowentryid, 0 as needzeroprice";
        } else {
            balanceFileds = " id as id,'' as billno,id as entryid,calorg,costaccount,costaccount.name as costaccountname,costaccount.calsystem as calsystem,costaccount.calpolicy as calpolicy,costaccount.costtype as costtype,costaccount.booktype as costaccounttype,'' as calbilltype,periodid.begindate as bizdate,periodid.begindate as auditdate,'' as billnumber,'' as billtypenum,'" + s + "' as billtypename,0L as bizbillid,0L as biztypeid,0L as bizbillentryid,0L as calentryid," + this.fieldHelper.getDimFileds("cal_balance") + ",'0' as rowtype,0 as queuetype,0 as signnum,'1' as iscalculated," + periodId + " as periodid,case when period = " + period + " then 0 else periodendqty end as beginqty,costaccount.calpolicy.currency as localcurrency,costaccount.calpolicy.currency.amtprecision as amtprecision,costaccount.calpolicy.currency.priceprecision as priceprecision,case when period = " + period + " then 0 else periodendqty end as baseqty,0 as inqty,0.0 as fixedinqty,0 as outqty,'0' as isvoucher,'0' as isfivoucher,'0' as ispresent,'A' as billstatus,' ' as createtype,case when period = " + period + " then 0 else periodendactualcost end as actualcost,case when period = " + period + " then 0 else periodendactualcost end as cost,0 as materialcost,0 as fee,0 as processcost,0 as manufacturecost,0 as resource,0 as entryseq,calrange as calrangeid,baseunit as baseunit,baseunit.precision as qtyprecision,'0' as ordercol,0L as costrecordentryid,'C' as entrystatus,entryentity.costsubelement as subelementid, case when period = " + period + " then 0 else entryentity.sub_periodendactualcost end as begincost, 0.0 as fixedoutcost,0.0 as fixedincost,0.0 as fixedoutqty,case when period = " + period + " then periodissueqty else 0 end as baseqty_out,case when period = " + period + " then periodissueactualcost else 0 end as actualcost_out,0L as maxrowbillid, 0L as maxrowentryid, 0 as needzeroprice";
        }
        return balanceFileds;
    }

    private String getCostAdjustBizField() {
        String addPriceField = this.getAddPriceField();
        if (StringUtils.isNotEmpty((String)addPriceField)) {
            addPriceField = ",0.0 as addPriceField";
        }
        String s = ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"DataInputFactory_1", (String)"fi-calx-algox", (Object[])new Object[0]);
        return "id,billno,entryentity.id as entryid,calorg,costaccount,costaccount.name as costaccountname,costaccount.calsystem as calsystem,costaccount.calpolicy as calpolicy,costaccount.costtype as costtype,costaccount.booktype as costaccounttype, case when biztype = 'A' then 'IN' else 'OUT' end as calbilltype,entryentity.invbizdate as bizdate,entryentity.invauditdate as auditdate,billno as billnumber,'cal_costadjustbill' as billtypenum,'" + s + "' as billtypename,id as bizbillid,0L as biztypeid,entryentity.id as bizbillentryid,0L as calentryid," + this.fieldHelper.getDimFileds("cal_costadjustbill") + ",'2' as rowtype,entryentity.queuetype as queuetype,entryentity.signnum as signnum,'1' as iscalculated,period as periodid,0.0 as baseqty,currency as localcurrency,currency.amtprecision as amtprecision,currency.priceprecision as priceprecision,isvoucher,'0' as isfivoucher,'0' as ispresent,billstatus,createtype,entryentity.adjustamt as actualcost,0.0 as materialcost,0.0 as fee,0.0 as processcost,0.0 as manufacturecost,0.0 as resource,entryentity.seq as entryseq,entryentity.calrange as calrangeid,entryentity.baseunit as baseunit,entryentity.baseunit.precision as qtyprecision,'2' as ordercol,entryentity.invbillentryid as costrecordentryid,'C' as entrystatus,entryentity.subentryentity.costsubelement as subelementid,entryentity.subentryentity.costsubelement.type as elementtype,entryentity.subentryentity.sub_adjustamt as cost,case when entryentity.queuetype = '1' then entryentity.subentryentity.sub_adjustamt*entryentity.signnum else 0.0 end as fixedoutcost,case when entryentity.queuetype = '0' then entryentity.subentryentity.sub_adjustamt*entryentity.signnum else 0.0 end as fixedincost,0.0 as begincost,0.0 as beginqty,0.0 as inqty,0.0 as fixedinqty,0.0 as outqty,0.0 as fixedoutqty,0.0 as unitactualcost,0.0 as  sub_unitactualcost,0.0 as  unitmaterialcost,0.0 as  unitfee, 0.0 as unitmanufacturecost, 0.0 as unitresource, 0.0 as unitprocesscost,entryentity.costdomainkey as domainid, 0.0 as oricost, 0.0 as orimaterialcost" + addPriceField + ", '0' as isRework, '' as bizentityobject, '0' as issubbillinvoiceverify, 0.0 as baseqty_out, 0.0 as actualcost_out, null as costpricesource,'0' as designatedcost,'0' as invzerocost,0L as maxrowbillid,0L as maxrowentryid,0 as  needzeroprice";
    }

    private void buildBizRowMeta() {
        this.bizDataMeta = ORM.create().createRowMeta("cal_costrecord_subentity", this.getCostRecordBizField());
        this.bizDataMeta.getField("rowtype").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("createtype").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("costaccounttype").setDataType((DataType)DataType.LongType);
        this.bizDataMeta.getField("priceprecision").setDataType((DataType)DataType.IntegerType);
        this.bizDataMeta.getField("ordercol").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("calrangeid").setDataType((DataType)DataType.LongType);
        this.bizDataMeta.getField("costrecordentryid").setDataType((DataType)DataType.LongType);
        this.bizDataMeta.getField("fixedoutcost").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("fixedincost").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("begincost").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("beginqty").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("inqty").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("fixedinqty").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("outqty").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("fixedoutqty").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("baseqty").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("actualcost").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("materialcost").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("fee").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("processcost").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("manufacturecost").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("resource").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("oricost").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("orimaterialcost").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("cost").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("baseqty_out").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("actualcost_out").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("maxrowbillid").setDataType((DataType)DataType.LongType);
        this.bizDataMeta.getField("maxrowentryid").setDataType((DataType)DataType.LongType);
        this.bizDataMeta.getField("needzeroprice").setDataType((DataType)DataType.IntegerType);
    }

    @Override
    public RowMeta getBizDataMeta() {
        return this.bizDataMeta;
    }

    private RowMeta getCostDomainRowMeta() {
        ArrayList<Field> resultFields = new ArrayList<Field>(16);
        resultFields.add(new Field("domainid", (DataType)DataType.StringType));
        resultFields.add(new Field("subelementid", (DataType)DataType.LongType));
        resultFields.add(new Field("fixedoutcost", (DataType)DataType.BigDecimalType));
        resultFields.add(new Field("fixedincost", (DataType)DataType.BigDecimalType));
        resultFields.add(new Field("begincost", (DataType)DataType.BigDecimalType));
        resultFields.add(new Field("beginqty", (DataType)DataType.BigDecimalType));
        resultFields.add(new Field("inqty", (DataType)DataType.BigDecimalType));
        resultFields.add(new Field("fixedinqty", (DataType)DataType.BigDecimalType));
        resultFields.add(new Field("outqty", (DataType)DataType.BigDecimalType));
        resultFields.add(new Field("fixedoutqty", (DataType)DataType.BigDecimalType));
        resultFields.add(new Field("periodid", (DataType)DataType.LongType));
        resultFields.add(new Field("costaccount", (DataType)DataType.LongType));
        resultFields.add(new Field("baseqty_out", (DataType)DataType.BigDecimalType));
        resultFields.add(new Field("actualcost_out", (DataType)DataType.BigDecimalType));
        resultFields.add(new Field("maxrowbillid", (DataType)DataType.LongType));
        resultFields.add(new Field("maxrowentryid", (DataType)DataType.LongType));
        resultFields.add(new Field("needzeroprice", (DataType)DataType.IntegerType));
        RowMeta rowMeta = new RowMeta(resultFields.toArray(new Field[resultFields.size()]));
        return rowMeta;
    }

    public Input[] createFixDomainData() {
        ArrayList<Object> inputList = new ArrayList<Object>(16);
        RowMeta costDomainRowMeta = this.getCostDomainRowMeta();
        String selectFields = "costdomainkey as domainid,costsubelement as subelementid,outcost as fixedoutcost,incost as fixedincost,0 as begincost,0 as beginqty,suminqty as inqty,inqty as fixedinqty,sumoutqty as outqty,outqty as fixedoutqty,periodid,costaccount,0 as baseqty_out,0 as actualcost_out,0L as maxrowbillid,0L as maxrowentryid,0 as needzeroprice";
        Algo algo = Algo.create((String)ALGOKEY);
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getCalOutRangeList()) {
            QFilter filter = new QFilter("costaccount", "=", (Object)range.getCostAccountId());
            if (this.holder.isNeedCalculatedLater()) {
                filter.and(new QFilter("periodid", ">=", (Object)range.getPeriodId()));
            } else {
                filter.and(new QFilter("periodid", "=", (Object)range.getPeriodId()));
            }
            filter.and("calrange", "=", (Object)range.getCalRangeId());
            if (range.isAllMaterial()) {
                inputList.add(new OrmInput(ALGOKEY, "cal_domain_bal", selectFields, filter.toArray(), costDomainRowMeta));
                continue;
            }
            HashSet<Object> matIds = new HashSet<Object>(16);
            for (Set<Object> materialIds : range.getMaterialSetList()) {
                matIds.addAll(materialIds);
            }
            filter.and("material", "in", matIds);
            inputList.add(new OrmInput(ALGOKEY, "cal_domain_bal", selectFields, filter.toArray(), costDomainRowMeta));
        }
        DataSet emptySet = algo.createDataSet(new ArrayList(16), costDomainRowMeta);
        inputList.add(new DataSetInput(emptySet, costDomainRowMeta));
        return inputList.toArray(new Input[0]);
    }

    private String getAddPriceField() {
        String addPriceField = "";
        String costRecAddPriceField = CalDbParamServiceHelper.getString("costrec_add_price", null);
        if (StringUtils.isNotEmpty((String)costRecAddPriceField)) {
            String fieldPath = CommonUtils.getFieldPath("cal_costrecord", costRecAddPriceField);
            addPriceField = "," + fieldPath + " as addpricefield";
        }
        return addPriceField;
    }

    private RowMeta getBalRowMeta(String balEntity, String balSels) {
        RowMeta balRowMeta = ORM.create().createRowMeta(balEntity, balSels);
        balRowMeta.getField("rowtype").setDataType((DataType)DataType.StringType);
        balRowMeta.getField("createtype").setDataType((DataType)DataType.StringType);
        balRowMeta.getField("costaccounttype").setDataType((DataType)DataType.LongType);
        balRowMeta.getField("priceprecision").setDataType((DataType)DataType.IntegerType);
        balRowMeta.getField("ordercol").setDataType((DataType)DataType.StringType);
        balRowMeta.getField("calrangeid").setDataType((DataType)DataType.LongType);
        balRowMeta.getField("costrecordentryid").setDataType((DataType)DataType.LongType);
        balRowMeta.getField("bizbillid").setDataType((DataType)DataType.LongType);
        balRowMeta.getField("biztypeid").setDataType((DataType)DataType.LongType);
        balRowMeta.getField("bizbillentryid").setDataType((DataType)DataType.LongType);
        balRowMeta.getField("calentryid").setDataType((DataType)DataType.LongType);
        balRowMeta.getField("queuetype").setDataType((DataType)DataType.StringType);
        balRowMeta.getField("iscalculated").setDataType((DataType)DataType.BooleanType);
        balRowMeta.getField("isvoucher").setDataType((DataType)DataType.BooleanType);
        balRowMeta.getField("isfivoucher").setDataType((DataType)DataType.BooleanType);
        balRowMeta.getField("ispresent").setDataType((DataType)DataType.BooleanType);
        balRowMeta.getField("billstatus").setDataType((DataType)DataType.StringType);
        balRowMeta.getField("periodid").setDataType((DataType)DataType.LongType);
        balRowMeta.getField("materialcost").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("fee").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("processcost").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("manufacturecost").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("resource").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("inqty").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("outqty").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("baseqty_out").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("actualcost_out").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("billno").setDataType((DataType)DataType.StringType);
        balRowMeta.getField("billnumber").setDataType((DataType)DataType.StringType);
        balRowMeta.getField("billtypename").setDataType((DataType)DataType.StringType);
        balRowMeta.getField("signnum").setDataType((DataType)DataType.IntegerType);
        balRowMeta.getField("calbilltype").setDataType((DataType)DataType.StringType);
        balRowMeta.getField("billtypenum").setDataType((DataType)DataType.StringType);
        balRowMeta.getField("beginqty").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("baseqty").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("fixedinqty").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("actualcost").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("cost").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("entryseq").setDataType((DataType)DataType.IntegerType);
        balRowMeta.getField("entrystatus").setDataType((DataType)DataType.StringType);
        balRowMeta.getField("begincost").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("fixedoutcost").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("fixedincost").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("fixedoutqty").setDataType((DataType)DataType.BigDecimalType);
        balRowMeta.getField("maxrowbillid").setDataType((DataType)DataType.LongType);
        balRowMeta.getField("maxrowentryid").setDataType((DataType)DataType.LongType);
        balRowMeta.getField("needzeroprice").setDataType((DataType)DataType.IntegerType);
        return balRowMeta;
    }
}

