/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.util.ArrayUtils;

public class ModFunction
extends FlatMapFunction {
    private static final long serialVersionUID = -8053953614178539672L;
    private final RowMeta rowMeta;
    private final String modField;
    private int modSize = 8;

    public ModFunction(RowMeta rowMeta, String modField) {
        this(rowMeta, modField, 8);
    }

    public ModFunction(RowMeta rowMeta, String modField, int modSize) {
        this.rowMeta = rowMeta;
        this.modField = modField;
        this.modSize = modSize;
    }

    public void flatMap(RowX rowX, Collector collector) {
        String modFieldValue = rowX.getString(this.rowMeta.getFieldIndex(this.modField));
        int modValue = modFieldValue.hashCode() % this.modSize;
        RowX newRowX = new RowX(ArrayUtils.concatAll(rowX.values(), new Object[][]{{modValue}}));
        collector.collect(newRowX);
    }

    public RowMeta getResultRowMeta() {
        Field[] fields = ArrayUtils.concatAll(this.rowMeta.getFields(), new Field[][]{{new Field("mod", (DataType)DataType.IntegerType)}});
        return new RowMeta(fields);
    }
}

