/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;

public class SumBillData2RptFunction
extends GroupReduceFunction {
    private final RowMeta srcRowMeta;

    public SumBillData2RptFunction(RowMeta rowMeta) {
        this.srcRowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        Iterator<RowX> it = iter.iterator();
        RowX sumRow = null;
        RowMeta resultRowMeta = this.getResultRowMeta();
        String sortListId = "";
        while (it.hasNext()) {
            RowX rowX = it.next();
            String dySortListId = rowX.getString(this.srcRowMeta.getFieldIndex("dysortlistid"));
            String string = sortListId = StringUtils.isEmpty((String)dySortListId) ? sortListId : dySortListId;
            if (sumRow == null) {
                sumRow = rowX;
                continue;
            }
            this.sumCost(sumRow, rowX, "tranincost");
            this.sumCost(sumRow, rowX, "tranoutcost");
            this.sumCost(sumRow, rowX, "traninqty");
            this.sumCost(sumRow, rowX, "tranoutqty");
            this.sumCost(sumRow, rowX, "domainoutcost");
            this.sumCost(sumRow, rowX, "domainoutqty");
            this.max(sumRow, rowX, "id");
        }
        if (sumRow == null) {
            return;
        }
        int fieldIndex = this.srcRowMeta.getFieldIndex("dysortlistid");
        sumRow.set(fieldIndex, (Object)sortListId);
        RowX newSumRow = new RowX(new Object[]{sumRow.getString(this.srcRowMeta.getFieldIndex("domainid")), sumRow.getLong(this.srcRowMeta.getFieldIndex("subelementid")), sumRow.getLong(this.srcRowMeta.getFieldIndex("periodid")), sumRow.getBigDecimal(this.srcRowMeta.getFieldIndex("tranincost")), sumRow.getBigDecimal(this.srcRowMeta.getFieldIndex("tranoutcost")), sumRow.getBigDecimal(this.srcRowMeta.getFieldIndex("traninqty")), sumRow.getBigDecimal(this.srcRowMeta.getFieldIndex("tranoutqty")), sumRow.getBigDecimal(this.srcRowMeta.getFieldIndex("domainoutcost")), sumRow.getBigDecimal(this.srcRowMeta.getFieldIndex("domainoutqty")), sumRow.getLong(this.srcRowMeta.getFieldIndex("id")), sumRow.getString(this.srcRowMeta.getFieldIndex("dysortlistid")), sumRow.getString(this.srcRowMeta.getFieldIndex("priceinfostr")), sumRow.getString(this.srcRowMeta.getFieldIndex("rpterrortype"))});
        collector.collect(newSumRow);
    }

    private void max(RowX sumRow, RowX rowX, String fieldName) {
        Long maxValue;
        int fieldIndex = this.srcRowMeta.getFieldIndex(fieldName);
        Long value = rowX.getLong(fieldIndex);
        value = value == null ? Long.valueOf(0L) : value;
        if (value.compareTo(maxValue = sumRow.getLong(fieldIndex)) > 0) {
            maxValue = value;
        }
        sumRow.set(fieldIndex, (Object)maxValue);
    }

    private BigDecimal sumCost(RowX sumRow, RowX rowX, String fieldName) {
        int fieldIndex = this.srcRowMeta.getFieldIndex(fieldName);
        BigDecimal sumValue = sumRow.getBigDecimal(fieldIndex);
        BigDecimal curValue = rowX.getBigDecimal(fieldIndex);
        sumValue = sumValue.add(curValue);
        sumRow.set(fieldIndex, (Object)sumValue);
        return sumValue;
    }

    public RowMeta getResultRowMeta() {
        return new RowMeta(new Field[]{new Field("domainid", (DataType)DataType.StringType), new Field("subelementid", (DataType)DataType.LongType), new Field("periodid", (DataType)DataType.LongType), new Field("tranincost", (DataType)DataType.BigDecimalType), new Field("tranoutcost", (DataType)DataType.BigDecimalType), new Field("tgtbaseqty", (DataType)DataType.BigDecimalType), new Field("outtgtbaseqty", (DataType)DataType.BigDecimalType), new Field("domainoutcost", (DataType)DataType.BigDecimalType), new Field("domainoutqty", (DataType)DataType.BigDecimalType), new Field("billid", (DataType)DataType.LongType), new Field("dysortlistid", (DataType)DataType.StringType), new Field("priceinfostr", (DataType)DataType.StringType), new Field("rpterrortype", (DataType)DataType.StringType)});
    }
}

