/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.constant.CostPriceSourceTypeEnum;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.MatrixTypeEnum;
import kd.fi.calx.algox.matrix.helper.MatrixDesignCostHelper;
import kd.fi.calx.algox.matrix.log.MatrixRemarkUtil;
import kd.fi.calx.algox.util.ArrayUtils;

public class TransInQtyFunction
extends GroupReduceFunction {
    private CommonInfo commonInfo;
    private RowMeta rowMeta;
    private RowMeta resultRowMeta;

    public TransInQtyFunction(CommonInfo commonInfo, RowMeta rowMeta) {
        this.commonInfo = commonInfo;
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        this.resultRowMeta = this.getResultRowMeta();
        Iterator<RowX> it = iter.iterator();
        HashMap<Long, RowX> srcEIdRowxMap = new HashMap<Long, RowX>(16);
        ArrayList<RowX> tgtEIdRowxs = new ArrayList<RowX>(16);
        BigDecimal tgtTotalWeight = BigDecimal.ZERO;
        int groupTypeIndex = this.rowMeta.getFieldIndex("grouptype");
        int groupWeightIndex = this.rowMeta.getFieldIndex("groupweight");
        int entryIdIndex = this.rowMeta.getFieldIndex("entryid");
        int baseQtyIndex = this.rowMeta.getFieldIndex("baseqty");
        int groupOccQty = this.rowMeta.getFieldIndex("groupoccupiedqty");
        int domainIdIndex = this.rowMeta.getFieldIndex("domainid");
        int costaccountIndex = this.rowMeta.getFieldIndex("costaccount");
        int periodIdIndex = this.rowMeta.getFieldIndex("periodid");
        int costIndex = this.rowMeta.getFieldIndex("cost");
        boolean isExitNegQty = false;
        RowX maxTgtRow = null;
        HashSet<Integer> tgtQtySigns = new HashSet<Integer>(15);
        BigDecimal sumSrcQty = BigDecimal.ZERO;
        BigDecimal sumTgtQty = BigDecimal.ZERO;
        BigDecimal sumSrcCost = BigDecimal.ZERO;
        boolean hasLastPeriodTgtBill = false;
        boolean hasNotCalEntryId = false;
        while (it.hasNext()) {
            RowX row = it.next();
            String groupType = row.getString(groupTypeIndex);
            BigDecimal groupWeight = row.getBigDecimal(groupWeightIndex);
            BigDecimal currQty = row.getBigDecimal(baseQtyIndex);
            Long costAcctId = row.getLong(costaccountIndex);
            Long curPeriodId = this.commonInfo.getParamCache().getCurrentPeriod(costAcctId);
            boolean notCalEntryId = new MatrixDesignCostHelper().isNotCalEntryId(this.rowMeta, row, this.commonInfo);
            if (notCalEntryId) {
                hasNotCalEntryId = true;
                continue;
            }
            if ("0".equals(groupType)) {
                srcEIdRowxMap.put(row.getLong(entryIdIndex), row);
                if (curPeriodId.compareTo(row.getLong(periodIdIndex)) == 0) {
                    Object[] newSrcRowValues = ArrayUtils.concatAll(row.values(), new Object[][]{{0L, null, BigDecimal.ZERO, BigDecimal.ZERO, Boolean.FALSE, BigDecimal.ZERO, BigDecimal.ZERO, Boolean.FALSE, "", "", "", "", Boolean.FALSE}});
                    Boolean isSrcVoucher = (Boolean)newSrcRowValues[this.resultRowMeta.getFieldIndex("isvoucher")];
                    String srcQueue = row.getString(this.resultRowMeta.getFieldIndex("queuetype"));
                    boolean isSrcInQueue = "0".equals(srcQueue);
                    Boolean isRework = row.getBoolean(this.rowMeta.getFieldIndex("isrework"));
                    boolean isZeroOutSrcGroup = new MatrixDesignCostHelper().getZeroOutSrcGroup(row, this.rowMeta, this.commonInfo);
                    if (isSrcVoucher.booleanValue() || isSrcInQueue || isRework.booleanValue() || isZeroOutSrcGroup) {
                        BigDecimal srcCost = (BigDecimal)newSrcRowValues[this.resultRowMeta.getFieldIndex("cost")];
                        BigDecimal srcBaseQty = (BigDecimal)newSrcRowValues[this.resultRowMeta.getFieldIndex("baseqty")];
                        if ("0".equals(newSrcRowValues[this.resultRowMeta.getFieldIndex("queuetype")])) {
                            newSrcRowValues[this.resultRowMeta.getFieldIndex((String)"fixedincost")] = srcCost;
                            newSrcRowValues[this.resultRowMeta.getFieldIndex((String)"fixedinqty")] = srcBaseQty;
                            newSrcRowValues[this.resultRowMeta.getFieldIndex((String)"matrixtype")] = MatrixTypeEnum.FIXEDIN.getValue();
                        } else {
                            newSrcRowValues[this.resultRowMeta.getFieldIndex((String)"fixedoutcost")] = srcCost;
                            newSrcRowValues[this.resultRowMeta.getFieldIndex((String)"fixedoutqty")] = srcBaseQty;
                            newSrcRowValues[this.resultRowMeta.getFieldIndex((String)"matrixtype")] = MatrixTypeEnum.FIXEDOUT.getValue();
                        }
                        newSrcRowValues[this.resultRowMeta.getFieldIndex((String)"isfixed")] = Boolean.TRUE;
                        int priceSrcIndex = this.resultRowMeta.getFieldIndex("costpricesource");
                        String priceSrcType = (String)newSrcRowValues[priceSrcIndex];
                        String lastByCostPriceSource = CostPriceSourceTypeEnum.getLastByCostPriceSource(priceSrcType);
                        lastByCostPriceSource = StringUtils.isEmpty((String)lastByCostPriceSource) ? CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue() : lastByCostPriceSource;
                        newSrcRowValues[this.resultRowMeta.getFieldIndex((String)"costpricesourcetype")] = lastByCostPriceSource;
                        String remark = MatrixRemarkUtil.getFixedSrcBill(isSrcVoucher, isSrcInQueue, isRework, isZeroOutSrcGroup);
                        newSrcRowValues[this.resultRowMeta.getFieldIndex((String)"calremark")] = remark;
                    }
                    collector.collect(new RowX(newSrcRowValues));
                }
                sumSrcQty = sumSrcQty.add(currQty);
                sumSrcCost = sumSrcCost.add(row.getBigDecimal(costIndex));
            } else {
                tgtTotalWeight = tgtTotalWeight.add(groupWeight);
                if (maxTgtRow == null) {
                    maxTgtRow = row;
                    tgtEIdRowxs.add(row);
                } else if (maxTgtRow.getLong(periodIdIndex) < row.getLong(periodIdIndex)) {
                    maxTgtRow = row;
                    tgtEIdRowxs.add(row);
                } else {
                    tgtEIdRowxs.add(0, row);
                }
                tgtQtySigns.add(currQty.signum());
                sumTgtQty = sumTgtQty.add(currQty);
                if (row.getLong(periodIdIndex) > curPeriodId) {
                    hasLastPeriodTgtBill = true;
                }
            }
            if (row.getBigDecimal(baseQtyIndex).compareTo(BigDecimal.ZERO) >= 0) continue;
            isExitNegQty = true;
        }
        if (hasNotCalEntryId) {
            return;
        }
        int addPriceFieldIndex = this.rowMeta.getFieldIndex("addpricefield", false);
        boolean isTgtSameSign = this.getIsTgtQtySameSign(tgtQtySigns);
        boolean isDealDiff = isTgtSameSign && !hasLastPeriodTgtBill;
        BigDecimal sumTgtCost = BigDecimal.ZERO;
        HashSet<Long> fixedFeeEIds = new HashSet<Long>(16);
        for (int index = 0; index < tgtEIdRowxs.size(); ++index) {
            RowX tgtRow = (RowX)tgtEIdRowxs.get(index);
            Long costAcctId = tgtRow.getLong(costaccountIndex);
            Long curPeriodId = this.commonInfo.getParamCache().getCurrentPeriod(costAcctId);
            BigDecimal tgtWeight = tgtRow.getBigDecimal(groupWeightIndex);
            BigDecimal tgtBaseQty = tgtRow.getBigDecimal(baseQtyIndex);
            BigDecimal tgtOccQty = tgtRow.getBigDecimal(groupOccQty);
            int amtPrecisionIndex = tgtRow.getInteger(this.rowMeta.getFieldIndex("amtprecision"));
            Boolean isCompleted = tgtRow.getBoolean(this.resultRowMeta.getFieldIndex("iscompleted"));
            BigDecimal addPricePercent = this.getAddPricePercent(addPriceFieldIndex, tgtRow);
            BigDecimal tgtQtySign = new BigDecimal(tgtBaseQty.signum());
            for (Map.Entry srcEidRowxEnt : srcEIdRowxMap.entrySet()) {
                int priceSrcIndex;
                String priceSrcType;
                String lastByCostPriceSource;
                RowX srcRow = (RowX)srcEidRowxEnt.getValue();
                String domainId = srcRow.getString(domainIdIndex);
                Long srcEId = srcRow.getLong(entryIdIndex);
                BigDecimal srcOccQty = srcRow.getBigDecimal(groupOccQty);
                BigDecimal transQty = BigDecimal.ZERO;
                transQty = isExitNegQty || isCompleted == false ? tgtBaseQty : srcOccQty.multiply(tgtWeight).multiply(tgtBaseQty).divide(tgtTotalWeight.multiply(tgtOccQty), 10, 4);
                transQty = transQty.abs().multiply(tgtQtySign);
                transQty = transQty.multiply(addPricePercent).setScale(10, 4);
                BigDecimal transInQty = BigDecimal.ZERO;
                BigDecimal transOutQty = BigDecimal.ZERO;
                String queueType = tgtRow.getString(this.rowMeta.getFieldIndex("queuetype"));
                if ("1".equals(queueType)) {
                    transOutQty = transQty;
                } else {
                    transInQty = transQty;
                }
                Object[] tgtNewRowValues = ArrayUtils.concatAll(tgtRow.values(), new Object[][]{{srcEId, domainId, transInQty, BigDecimal.ZERO, Boolean.FALSE, transOutQty, BigDecimal.ZERO, Boolean.FALSE, "", "", "", "", Boolean.TRUE}});
                boolean isSrcBeforePeriod = curPeriodId.compareTo(srcRow.getLong(periodIdIndex)) > 0;
                Boolean isSrcVoucher = srcRow.getBoolean(this.resultRowMeta.getFieldIndex("isvoucher"));
                String srcQueue = srcRow.getString(this.resultRowMeta.getFieldIndex("queuetype"));
                boolean isSrcInQueue = "0".equals(srcQueue);
                Boolean isRework = srcRow.getBoolean(this.rowMeta.getFieldIndex("isrework"));
                this.dealNoCalByEleFeeAsFixed(collector, tgtRow, domainId, fixedFeeEIds);
                boolean isZeroOutSrcGroup = new MatrixDesignCostHelper().getZeroOutSrcGroup(srcRow, this.rowMeta, this.commonInfo);
                if (isSrcVoucher.booleanValue() || isSrcBeforePeriod || isSrcInQueue || isRework.booleanValue() || isZeroOutSrcGroup) {
                    boolean isTgtBeforePeriod;
                    boolean notAddPrice;
                    BigDecimal srcCost = srcRow.getBigDecimal(this.resultRowMeta.getFieldIndex("cost"));
                    BigDecimal srcBaseQty = srcRow.getBigDecimal(this.resultRowMeta.getFieldIndex("baseqty"));
                    BigDecimal tgtSrcCost = srcCost.multiply(transQty).divide(srcBaseQty, amtPrecisionIndex, 4);
                    tgtSrcCost = tgtSrcCost.abs().multiply(new BigDecimal(tgtBaseQty.signum()));
                    boolean isLastRow = index == tgtEIdRowxs.size() - 1;
                    boolean bl = notAddPrice = BigDecimal.ONE.compareTo(addPricePercent) == 0;
                    if (isCompleted.booleanValue() && isLastRow && isDealDiff && notAddPrice) {
                        BigDecimal lastSumSrcCost;
                        tgtSrcCost = lastSumSrcCost = sumSrcCost.abs().multiply(new BigDecimal(sumTgtQty.signum())).subtract(sumTgtCost);
                    }
                    boolean bl2 = isTgtBeforePeriod = curPeriodId.compareTo(tgtRow.getLong(periodIdIndex)) > 0;
                    if (isTgtBeforePeriod) {
                        tgtSrcCost = tgtRow.getBigDecimal(this.rowMeta.getFieldIndex("cost"));
                    }
                    if ("0".equals(tgtNewRowValues[this.resultRowMeta.getFieldIndex("queuetype")])) {
                        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"fixedincost")] = tgtSrcCost;
                        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"fixedinqty")] = tgtBaseQty;
                        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"matrixtype")] = MatrixTypeEnum.FIXEDIN.getValue();
                    } else {
                        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"fixedoutcost")] = tgtSrcCost;
                        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"fixedoutqty")] = tgtBaseQty;
                        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"matrixtype")] = MatrixTypeEnum.FIXEDOUT.getValue();
                    }
                    tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"transinqty")] = BigDecimal.ZERO;
                    tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"transoutqty")] = BigDecimal.ZERO;
                    boolean noCalByElePurInApWf = this.getNoCalByElePurInApWfNotWriteMatCost(tgtRow, costAcctId);
                    if (noCalByElePurInApWf) {
                        BigDecimal materialCost;
                        tgtSrcCost = materialCost = (BigDecimal)tgtNewRowValues[this.resultRowMeta.getFieldIndex("materialcost")];
                    }
                    if ("1".equals(queueType)) {
                        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"tranoutcost")] = tgtSrcCost;
                    } else {
                        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"tranincost")] = tgtSrcCost;
                    }
                    tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"actualcost")] = tgtSrcCost;
                    tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"cost")] = tgtSrcCost;
                    tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"isfixed")] = Boolean.TRUE;
                    tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"isfixedfee")] = Boolean.FALSE;
                    sumTgtCost = sumTgtCost.add(tgtSrcCost);
                    String remark = MatrixRemarkUtil.getFixedBySrcBill(isSrcBeforePeriod, isSrcVoucher, isSrcInQueue, isRework, isZeroOutSrcGroup);
                    tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"calremark")] = remark;
                }
                lastByCostPriceSource = StringUtils.isEmpty((String)(lastByCostPriceSource = CostPriceSourceTypeEnum.getLastByCostPriceSource(priceSrcType = (String)tgtNewRowValues[priceSrcIndex = this.resultRowMeta.getFieldIndex("costpricesource")]))) ? CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue() : lastByCostPriceSource;
                String groupType = (String)tgtNewRowValues[groupTypeIndex];
                if ("1".equals(groupType)) {
                    lastByCostPriceSource = CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue();
                }
                tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"costpricesourcetype")] = lastByCostPriceSource;
                this.dealCalByEleAsFixed(tgtRow, costAcctId, tgtNewRowValues, tgtBaseQty);
                if (curPeriodId.compareTo(tgtRow.getLong(periodIdIndex)) != 0) continue;
                collector.collect(new RowX(tgtNewRowValues));
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return new RowMeta(ArrayUtils.concatAll(this.rowMeta.getFields(), new Field[][]{{new Field("srcentryid", (DataType)DataType.LongType), new Field("srcdomainid", (DataType)DataType.StringType), new Field("transinqty", (DataType)DataType.BigDecimalType), new Field("tranincost", (DataType)DataType.BigDecimalType), new Field("isfixed", (DataType)DataType.BooleanType), new Field("transoutqty", (DataType)DataType.BigDecimalType), new Field("tranoutcost", (DataType)DataType.BigDecimalType), new Field("isfixedfee", (DataType)DataType.BooleanType), new Field("matrixtype", (DataType)DataType.StringType), new Field("adjinfo", (DataType)DataType.StringType), new Field("costpricesourcetype", (DataType)DataType.StringType), new Field("calremark", (DataType)DataType.StringType), new Field("divprice", (DataType)DataType.BooleanType)}}));
    }

    private BigDecimal getAddPricePercent(int addPriceFieldIndex, RowX tgtRow) {
        BigDecimal addPricePercent = BigDecimal.ONE;
        if (addPriceFieldIndex >= 0 && (addPricePercent = tgtRow.getBigDecimal(addPriceFieldIndex)) != null) {
            addPricePercent = BigDecimal.ONE.add(addPricePercent.divide(new BigDecimal(100), 10, RoundingMode.HALF_UP));
        }
        return addPricePercent;
    }

    private boolean getIsTgtQtySameSign(Set<Integer> tgtSigns) {
        boolean isTgtSameSign = true;
        int tgtSign = 0;
        for (Integer curTgtSign : tgtSigns) {
            int curTgtSignIntValue = curTgtSign;
            if (tgtSign == 0) {
                tgtSign = curTgtSignIntValue;
                continue;
            }
            if (tgtSign == curTgtSignIntValue) continue;
            isTgtSameSign = false;
        }
        return isTgtSameSign;
    }

    private void dealCalByEleAsFixed(RowX tgtRow, Long costAcctId, Object[] tgtNewRowValues, BigDecimal tgtBaseQty) {
        boolean isPurOrOmInFixed;
        boolean isCalByElement = this.commonInfo.getParamCache().isCalByElement(costAcctId);
        Set purSet = (Set)this.commonInfo.getParamCache().getParamValue("purBizEntityObjectSet");
        Set omInSet = (Set)this.commonInfo.getParamCache().getParamValue("ominBizEntityObjectSet");
        String bizEntity = tgtRow.getString(this.rowMeta.getFieldIndex("bizentityobject"));
        boolean isPurIn = purSet.contains(bizEntity);
        boolean isOmIn = omInSet.contains(bizEntity);
        Boolean isApWf = tgtRow.getBoolean(this.rowMeta.getFieldIndex("issubbillinvoiceverify"));
        String elementType = (String)tgtNewRowValues[this.rowMeta.getFieldIndex("elementtype")];
        boolean isPurFixed = isPurIn && "001".equals(elementType);
        boolean isOmInFixed = isOmIn && "005".equals(elementType);
        boolean bl = isPurOrOmInFixed = isPurFixed || isOmInFixed;
        if (!(isCalByElement && isApWf.booleanValue() && isPurOrOmInFixed)) {
            return;
        }
        BigDecimal fixedCost = (BigDecimal)tgtNewRowValues[this.resultRowMeta.getFieldIndex("cost")];
        if ("0".equals(tgtNewRowValues[this.resultRowMeta.getFieldIndex("queuetype")])) {
            tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"fixedincost")] = fixedCost;
            tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"fixedinqty")] = tgtBaseQty;
        } else {
            tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"fixedoutcost")] = fixedCost;
            tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"fixedoutqty")] = tgtBaseQty;
        }
        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"transinqty")] = BigDecimal.ZERO;
        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"transoutqty")] = BigDecimal.ZERO;
        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"tranoutcost")] = BigDecimal.ZERO;
        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"tranincost")] = BigDecimal.ZERO;
        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"actualcost")] = fixedCost;
        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"cost")] = fixedCost;
        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"isfixed")] = Boolean.TRUE;
        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"isfixedfee")] = Boolean.FALSE;
        String queueType = tgtRow.getString(this.rowMeta.getFieldIndex("queuetype"));
        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"matrixtype")] = "1".equals(queueType) ? MatrixTypeEnum.FIXEDOUT.getValue() : MatrixTypeEnum.FIXEDIN.getValue();
        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"baseqty")] = BigDecimal.ZERO;
        int priceSrcIndex = this.resultRowMeta.getFieldIndex("costpricesource");
        String priceSrcType = (String)tgtNewRowValues[priceSrcIndex];
        String lastByCostPriceSource = CostPriceSourceTypeEnum.getLastByCostPriceSource(priceSrcType);
        lastByCostPriceSource = StringUtils.isEmpty((String)lastByCostPriceSource) ? CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue() : lastByCostPriceSource;
        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"costpricesourcetype")] = lastByCostPriceSource;
        String calRemark = MatrixRemarkUtil.getCalEleApWf();
        tgtNewRowValues[this.resultRowMeta.getFieldIndex((String)"calremark")] = calRemark;
    }

    private BigDecimal dealNoCalByEleFeeAsFixed(Collector collector, RowX tgtRow, String domainId, Set<Long> fixedFeeEIds) {
        boolean isFixedFeeNoZero;
        BigDecimal fixedFee = BigDecimal.ZERO;
        int periodIdIndex = this.rowMeta.getFieldIndex("periodid");
        Long costAcctId = tgtRow.getLong(this.rowMeta.getFieldIndex("costaccount"));
        boolean isCalByElement = this.commonInfo.getParamCache().isCalByElement(costAcctId);
        Long curPeriodId = this.commonInfo.getParamCache().getCurrentPeriod(costAcctId);
        Object[] noCalByEleTgtNewRow = ArrayUtils.concatAll(tgtRow.values(), new Object[][]{{0L, domainId, BigDecimal.ZERO, BigDecimal.ZERO, Boolean.FALSE, BigDecimal.ZERO, BigDecimal.ZERO, Boolean.TRUE, "", "", "", "", Boolean.FALSE}});
        BigDecimal fee = (BigDecimal)noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex("fee")];
        BigDecimal manCost = (BigDecimal)noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex("manufacturecost")];
        BigDecimal resource = (BigDecimal)noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex("resource")];
        BigDecimal processCost = (BigDecimal)noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex("processcost")];
        BigDecimal allFeeCost = fee.add(manCost).add(resource).add(processCost);
        fixedFee = allFeeCost;
        boolean bl = isFixedFeeNoZero = fixedFee.compareTo(BigDecimal.ZERO) != 0;
        if (!isCalByElement && isFixedFeeNoZero) {
            boolean notAdd;
            if ("0".equals(noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex("queuetype")])) {
                noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"fixedincost")] = allFeeCost;
                noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"fixedinqty")] = BigDecimal.ZERO;
                noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"matrixtype")] = MatrixTypeEnum.FIXEDIN.getValue();
            } else {
                noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"fixedoutcost")] = allFeeCost;
                noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"fixedoutqty")] = BigDecimal.ZERO;
                noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"matrixtype")] = MatrixTypeEnum.FIXEDOUT.getValue();
            }
            String calRemark = MatrixRemarkUtil.getNotCalEleFixedFee();
            calRemark = String.format(calRemark, isCalByElement, isFixedFeeNoZero);
            noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"calremark")] = calRemark;
            int priceSrcIndex = this.resultRowMeta.getFieldIndex("costpricesource");
            String priceSrcType = (String)noCalByEleTgtNewRow[priceSrcIndex];
            String lastByCostPriceSource = CostPriceSourceTypeEnum.getLastByCostPriceSource(priceSrcType);
            lastByCostPriceSource = StringUtils.isEmpty((String)lastByCostPriceSource) ? CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue() : lastByCostPriceSource;
            noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"costpricesourcetype")] = lastByCostPriceSource;
            noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"transinqty")] = BigDecimal.ZERO;
            noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"transoutqty")] = BigDecimal.ZERO;
            noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"tranoutcost")] = BigDecimal.ZERO;
            noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"tranincost")] = BigDecimal.ZERO;
            noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"actualcost")] = allFeeCost;
            noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"cost")] = allFeeCost;
            noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"isfixed")] = Boolean.TRUE;
            noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"isfixedfee")] = Boolean.TRUE;
            noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex((String)"baseqty")] = BigDecimal.ZERO;
            Long entryId = (Long)noCalByEleTgtNewRow[this.resultRowMeta.getFieldIndex("entryid")];
            boolean bl2 = notAdd = !fixedFeeEIds.contains(entryId);
            if (curPeriodId.compareTo(tgtRow.getLong(periodIdIndex)) == 0 && notAdd) {
                fixedFeeEIds.add(entryId);
                collector.collect(new RowX(noCalByEleTgtNewRow));
            }
        }
        return fixedFee;
    }

    private boolean getNoCalByElePurInApWfNotWriteMatCost(RowX tgtRow, Long costAcctId) {
        boolean isCalByElement = this.commonInfo.getParamCache().isCalByElement(costAcctId);
        Boolean isApWf = tgtRow.getBoolean(this.rowMeta.getFieldIndex("issubbillinvoiceverify"));
        String bizEntity = tgtRow.getString(this.rowMeta.getFieldIndex("bizentityobject"));
        Set purSet = (Set)this.commonInfo.getParamCache().getParamValue("purBizEntityObjectSet");
        boolean isPurInEntity = purSet.contains(bizEntity);
        boolean noCalByElePurInApWf = !isCalByElement && isApWf != false && isPurInEntity;
        return noCalByElePurInApWf;
    }
}

