/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.CalOutDataRangeHolder;
import kd.fi.calx.algox.CostPriceResultInfo;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.constant.CostPriceSourceTypeEnum;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.RptErrorTypeEnum;
import kd.fi.calx.algox.matrix.log.MatrixRemarkUtil;
import kd.fi.calx.algox.util.DateUtils;

public class MatrixDesignCostHelper {
    public static final String SAVE_PS = "saveps";

    public void dealDesignatedCostNotGroup(RowX row, Object[] newRow, RowMeta srcRowMeta, RowMeta resultRowMeta, CommonInfo commonInfo) {
        Boolean writeDtlRpt = this.isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return;
        }
        int queueTypeIndex = srcRowMeta.getFieldIndex("queuetype");
        int calRemarkIndex = resultRowMeta.getFieldIndex("calremark", false);
        boolean outAsInQueue = this.getDesignAsInQueueNotGroup(row, srcRowMeta, commonInfo);
        boolean vouOutAsInQueue = this.getVouOutAsInQueueNotGroup(row, srcRowMeta, commonInfo);
        if (outAsInQueue || vouOutAsInQueue) {
            HashSet<String> qtyAndCostFields = new HashSet<String>(Arrays.asList("baseqty", "cost"));
            for (String field : qtyAndCostFields) {
                int fieldIndex = srcRowMeta.getFieldIndex(field, false);
                if (fieldIndex < 0) continue;
                BigDecimal qtyOrCost = row.getBigDecimal(fieldIndex).multiply(new BigDecimal(-1));
                row.set(fieldIndex, (Object)qtyOrCost);
                newRow[fieldIndex] = qtyOrCost;
                row.set(queueTypeIndex, (Object)"0");
                newRow[queueTypeIndex] = "0";
            }
            if (outAsInQueue) {
                newRow[calRemarkIndex] = MatrixRemarkUtil.getDesignAsInQueue();
            }
            if (vouOutAsInQueue) {
                newRow[calRemarkIndex] = MatrixRemarkUtil.getVouOutAsInQueue();
            }
        }
    }

    public boolean isDesignFixedCostNotGroup(RowX row, RowMeta srcRowMeta, CommonInfo commonInfo) {
        Boolean writeDtlRpt = this.isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return false;
        }
        boolean outAsInQueue = this.getDesignAsInQueueNotGroup(row, srcRowMeta, commonInfo);
        boolean designAsFixedOut = this.getDesignAsFixedOutNotGroup(row, srcRowMeta, commonInfo);
        boolean vouOutAsInQueue = this.getVouOutAsInQueueNotGroup(row, srcRowMeta, commonInfo);
        boolean zeroFixedOutNotGroup = this.getZeroFixedOutNotGroup(row, srcRowMeta, commonInfo);
        return outAsInQueue || designAsFixedOut || vouOutAsInQueue || zeroFixedOutNotGroup;
    }

    public boolean isNotCalEntryId(RowMeta srcRowMeta, RowX row, CommonInfo commonInfo) {
        boolean isCalEntry;
        Boolean writeDtlRpt = this.isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return false;
        }
        Long notCalEntryId = null;
        int notCalEntryIdIndex = srcRowMeta.getFieldIndex("notcalentryid", false);
        if (notCalEntryIdIndex > -1) {
            notCalEntryId = row.getLong(notCalEntryIdIndex);
        }
        boolean bl = isCalEntry = notCalEntryId == null || notCalEntryId.equals(0L);
        return !isCalEntry;
    }

    private boolean getDesignAsInQueueNotGroup(RowX row, RowMeta srcRowMeta, CommonInfo commonInfo) {
        boolean designOutWeightedAvg = commonInfo.isDesigoutweightedavgat();
        Boolean designatedCost = row.getBoolean(srcRowMeta.getFieldIndex("designatedcost"));
        boolean isNotGroup = this.isNotGroup(row, srcRowMeta);
        Boolean invZeroCost = row.getBoolean(srcRowMeta.getFieldIndex("invzerocost"));
        int queueTypeIndex = srcRowMeta.getFieldIndex("queuetype");
        String queueType = row.getString(queueTypeIndex);
        boolean isOutQueue = "1".equals(queueType);
        boolean outAsInQueue = designOutWeightedAvg && designatedCost != false && isNotGroup && invZeroCost == false && isOutQueue;
        return outAsInQueue;
    }

    public QFilter getCalEndDateFilter(CommonInfo commonInfo) {
        Boolean writeDtlRpt = this.isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return null;
        }
        if (!commonInfo.isCostatenddateenable() || commonInfo.getCostatenddate() == null) {
            return null;
        }
        Date endDateStartTime = DateUtils.getDayStartTime(commonInfo.getCostatenddate());
        endDateStartTime = DateUtils.addDateTime(endDateStartTime, 5, 1);
        QFilter calEndDateFilter = new QFilter("bookdate", "<", (Object)endDateStartTime);
        return calEndDateFilter;
    }

    public void setCalEndDate(CalOutDataRangeHolder holder, CommonInfo commonInfo) {
        Boolean writeDtlRpt = this.isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return;
        }
        if (!commonInfo.isCostatenddateenable() || commonInfo.getCostatenddate() == null) {
            return;
        }
        holder.setNeedCalculatedLater(false);
        for (CalOutDataRangeHolder.CalOutRange range : holder.getCalOutRangeList()) {
            range.setEndDate(commonInfo.getCostatenddate());
        }
    }

    public boolean getZeroFixedOutNotGroup(RowX row, RowMeta srcRowMeta, CommonInfo commonInfo) {
        Boolean writeDtlRpt = this.isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return false;
        }
        boolean isNotGroup = this.isNotGroup(row, srcRowMeta);
        Boolean invZeroCost = row.getBoolean(srcRowMeta.getFieldIndex("invzerocost"));
        int queueTypeIndex = srcRowMeta.getFieldIndex("queuetype");
        String queueType = row.getString(queueTypeIndex);
        boolean isOutQueue = "1".equals(queueType);
        return isNotGroup && invZeroCost != false && isOutQueue;
    }

    public boolean getDesignAsFixedOutNotGroup(RowX row, RowMeta srcRowMeta, CommonInfo commonInfo) {
        Boolean writeDtlRpt = this.isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return false;
        }
        boolean designOutWeightedAvg = commonInfo.isDesigoutweightedavgat();
        boolean coverDesignOutCost = commonInfo.isCoverdesigoutcost();
        Boolean designatedCost = row.getBoolean(srcRowMeta.getFieldIndex("designatedcost"));
        boolean isNotGroup = this.isNotGroup(row, srcRowMeta);
        Boolean invZeroCost = row.getBoolean(srcRowMeta.getFieldIndex("invzerocost"));
        int queueTypeIndex = srcRowMeta.getFieldIndex("queuetype");
        String queueType = row.getString(queueTypeIndex);
        boolean isOutQueue = "1".equals(queueType);
        boolean isOutFix = !designOutWeightedAvg && !coverDesignOutCost && designatedCost != false && isNotGroup && invZeroCost == false && isOutQueue;
        return isOutFix;
    }

    private boolean getVouOutAsInQueueNotGroup(RowX row, RowMeta srcRowMeta, CommonInfo commonInfo) {
        int queueTypeIndex = srcRowMeta.getFieldIndex("queuetype");
        String queueType = row.getString(queueTypeIndex);
        boolean isOutQueue = "1".equals(queueType);
        boolean vouAvgCal = commonInfo.isVoucherdutweightedavgat();
        boolean isNotGroup = this.isNotGroup(row, srcRowMeta);
        Boolean isVoucher = row.getBoolean(srcRowMeta.getFieldIndex("isvoucher"));
        boolean vouOutAsInQueue = vouAvgCal && isVoucher != false && isOutQueue && isNotGroup;
        return vouOutAsInQueue;
    }

    public boolean getZeroOutSrcGroup(RowX row, RowMeta srcRowMeta, CommonInfo commonInfo) {
        Boolean writeDtlRpt = this.isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return false;
        }
        int groupTypeIndex = srcRowMeta.getFieldIndex("grouptype", false);
        if (groupTypeIndex < 0) {
            return false;
        }
        String groupType = row.getString(groupTypeIndex);
        boolean isGroupSrcBill = "0".equals(groupType);
        int queueTypeIndex = srcRowMeta.getFieldIndex("queuetype");
        String queueType = row.getString(queueTypeIndex);
        Boolean invZeroCost = row.getBoolean(srcRowMeta.getFieldIndex("invzerocost"));
        boolean isOutQueue = "1".equals(queueType);
        boolean zeroOutSrcGroup = isGroupSrcBill && isOutQueue && invZeroCost != false;
        return zeroOutSrcGroup;
    }

    public Map<String, CostPriceResultInfo> getPrice(Map<String, Long> domainIdMaxRowBillIdMap, Map<String, Long> domainIdMaxRowEntryIdMap, Map<String, BigDecimal> domainIdTotalPriceMap, CommonInfo commonInfo, Map<String, Integer> domainIdNeedZeroPriceFlagMap, Map<String, BigDecimal> domainIdBeginQtyMap, Map<String, BigDecimal> domainIdBeginCostMap) {
        HashMap<String, CostPriceResultInfo> domainIdPriceResultMap = new HashMap<String, CostPriceResultInfo>(16);
        Boolean writeDtlRpt = this.isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return domainIdPriceResultMap;
        }
        for (Map.Entry<String, BigDecimal> entry : domainIdTotalPriceMap.entrySet()) {
            boolean isTotalPriceLessZero;
            boolean needNegPrice;
            boolean hasNoInCostRecBillAndNoBegin;
            String domainId = entry.getKey();
            BigDecimal totalPrice = entry.getValue();
            Long costRecId = domainIdMaxRowBillIdMap.get(domainId);
            Long costRecEntryId = domainIdMaxRowEntryIdMap.get(domainId);
            if (costRecId == null || costRecEntryId == null) continue;
            Integer needZeroPriceFlag = domainIdNeedZeroPriceFlagMap.get(domainId);
            boolean isTotalPriceZero = BigDecimal.ZERO.compareTo(totalPrice) == 0;
            boolean needZeroPrice = isTotalPriceZero && commonInfo.enableZeroPrice() != false;
            BigDecimal beginQty = domainIdBeginQtyMap.get(domainId);
            beginQty = beginQty == null ? BigDecimal.ZERO : beginQty;
            BigDecimal beginCost = domainIdBeginCostMap.get(domainId);
            beginCost = beginCost == null ? BigDecimal.ZERO : beginCost;
            boolean needZeroPriceFromBegin = beginCost.compareTo(BigDecimal.ZERO) != 0;
            boolean hasNoGroupInAmtNotZero = needZeroPriceFlag == 1;
            boolean bl = hasNoInCostRecBillAndNoBegin = needZeroPriceFlag == 2 && beginQty.compareTo(BigDecimal.ZERO) == 0 && beginCost.compareTo(BigDecimal.ZERO) == 0;
            if (needZeroPrice && (needZeroPriceFromBegin || hasNoGroupInAmtNotZero || hasNoInCostRecBillAndNoBegin)) {
                CostPriceResultInfo priceResult = commonInfo.getPriceHelper().getPriceFromEntryId("cal_costrecord_subentity", costRecId, costRecEntryId, "E");
                domainIdPriceResultMap.put(domainId, priceResult);
            }
            if (!(needNegPrice = (isTotalPriceLessZero = totalPrice.compareTo(BigDecimal.ZERO) < 0) && commonInfo.enableAvgNegPrice() != false)) continue;
            CostPriceResultInfo priceResult = commonInfo.getPriceHelper().getPriceFromEntryId("cal_costrecord_subentity", costRecId, costRecEntryId, "L");
            domainIdPriceResultMap.put(domainId, priceResult);
        }
        return domainIdPriceResultMap;
    }

    public boolean isSaveBillCost(RowX row, RowMeta rowMeta) {
        String groupType = row.getString(rowMeta.getFieldIndex("type"));
        boolean isTgtBill = "1".equals(groupType);
        if (isTgtBill) {
            return false;
        }
        String rptErrorType = row.getString(rowMeta.getFieldIndex("rpterrortype"));
        boolean avgNegPrice = RptErrorTypeEnum.AVG_NEG_PRICE.getValue().equals(rptErrorType);
        String priceInfoStr = row.getString(rowMeta.getFieldIndex("priceinfostr"));
        boolean isGetPriceSuccess = false;
        if (StringUtils.isNotEmpty((String)priceInfoStr)) {
            CostPriceResultInfo priceInfo = (CostPriceResultInfo)SerializationUtils.fromJsonString((String)priceInfoStr, CostPriceResultInfo.class);
            isGetPriceSuccess = this.isGetPriceSuccess(priceInfo);
        }
        boolean saveBillCost = avgNegPrice && !isGetPriceSuccess;
        return saveBillCost;
    }

    public boolean isGetPriceSuccess(CostPriceResultInfo priceInfo) {
        boolean isNegPrice;
        if (priceInfo == null) {
            return false;
        }
        boolean isGetPriceSuccess = priceInfo.isSuccess();
        BigDecimal priceTotalUnitActualCost = BigDecimal.ZERO;
        Map<Long, BigDecimal> costSubElementUnitcostMap = priceInfo.getCostSubElementUnitcostMap();
        for (Map.Entry<Long, BigDecimal> entry : costSubElementUnitcostMap.entrySet()) {
            BigDecimal unitCost = entry.getValue();
            if (unitCost == null) {
                unitCost = BigDecimal.ZERO;
            }
            if (unitCost.compareTo(BigDecimal.ZERO) == 0) continue;
            priceTotalUnitActualCost = priceTotalUnitActualCost.add(unitCost);
        }
        boolean bl = isNegPrice = priceTotalUnitActualCost.compareTo(BigDecimal.ZERO) < 0;
        if (isNegPrice) {
            isGetPriceSuccess = false;
        }
        return isGetPriceSuccess;
    }

    private boolean isNotGroup(RowX row, RowMeta srcRowMeta) {
        boolean isNotGroup = true;
        int groupEntryIdIndex = srcRowMeta.getFieldIndex("groupcostrecordentryid", false);
        if (groupEntryIdIndex > -1) {
            Long gBillId = row.getLong(groupEntryIdIndex);
            isNotGroup = gBillId == null || gBillId.equals(0L);
        } else {
            int groupIdIndex = srcRowMeta.getFieldIndex("groupid");
            String gBillId = row.getString(groupIdIndex);
            isNotGroup = StringUtils.isEmpty((String)gBillId);
        }
        return isNotGroup;
    }

    public Boolean isWriteDtlRpt(CommonInfo commonInfo) {
        return (Boolean)commonInfo.getParamCache().getParamValue(CalDbParamConstant.MATRIX_WRITE_DTLRPT);
    }

    public boolean hasNoGroupInQtyNotZeroAmtNotZero(RowX row, RowMeta srcRowMeta, CommonInfo commonInfo) {
        Boolean writeDtlRpt = this.isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return false;
        }
        String rowType = row.getString(srcRowMeta.getFieldIndex("rowtype"));
        boolean isCostRec = "1".equals(rowType);
        if (!isCostRec) {
            return false;
        }
        boolean notGroup = this.isNotGroup(row, srcRowMeta);
        int queueTypeIndex = srcRowMeta.getFieldIndex("queuetype");
        String queueType = row.getString(queueTypeIndex);
        boolean isInQueue = "0".equals(queueType);
        BigDecimal cost = row.getBigDecimal(srcRowMeta.getFieldIndex("cost"));
        boolean isAmtNotZero = BigDecimal.ZERO.compareTo(cost) != 0;
        boolean result = notGroup && isInQueue && isAmtNotZero;
        return result;
    }

    public boolean hasGroupInBill(RowX row, RowMeta srcRowMeta, CommonInfo commonInfo) {
        Boolean writeDtlRpt = this.isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return false;
        }
        String rowType = row.getString(srcRowMeta.getFieldIndex("rowtype"));
        boolean isCostRec = "1".equals(rowType);
        if (!isCostRec) {
            return false;
        }
        boolean notGroup = this.isNotGroup(row, srcRowMeta);
        int queueTypeIndex = srcRowMeta.getFieldIndex("queuetype");
        String queueType = row.getString(queueTypeIndex);
        boolean isInQueue = "0".equals(queueType);
        boolean result = !notGroup && isInQueue;
        return result;
    }

    public boolean hasNoGroupInBill(RowX row, RowMeta srcRowMeta, CommonInfo commonInfo) {
        Boolean writeDtlRpt = this.isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return false;
        }
        boolean notGroup = this.isNotGroup(row, srcRowMeta);
        String rowType = row.getString(srcRowMeta.getFieldIndex("rowtype"));
        boolean isCostRec = "1".equals(rowType);
        if (!isCostRec) {
            return false;
        }
        int queueTypeIndex = srcRowMeta.getFieldIndex("queuetype");
        String queueType = row.getString(queueTypeIndex);
        boolean isInQueue = "0".equals(queueType);
        boolean result = notGroup && isInQueue;
        return result;
    }

    public String getPriceSrcType(RowX sumRow, RowMeta rowMeta, CommonInfo commonInfo) {
        CostPriceResultInfo priceInfo;
        boolean isGetPriceSuccess;
        String priceSrcType = "";
        Boolean writeDtlRpt = this.isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return priceSrcType;
        }
        String priceInfoStr = sumRow.getString(rowMeta.getFieldIndex("priceinfostr"));
        if (StringUtils.isNotEmpty((String)priceInfoStr) && (isGetPriceSuccess = this.isGetPriceSuccess(priceInfo = (CostPriceResultInfo)SerializationUtils.fromJsonString((String)priceInfoStr, CostPriceResultInfo.class)))) {
            priceSrcType = CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue();
        }
        return priceSrcType;
    }

    public int getNeedZeroPriceTotalInt(boolean hasNoGroupInAmtNotZero, boolean hasGroupInBillTotal, boolean hasNoGroupInTotal) {
        int needZeroPriceTotalInt = 0;
        if (hasNoGroupInAmtNotZero) {
            needZeroPriceTotalInt = 1;
        }
        if (!hasNoGroupInTotal) {
            needZeroPriceTotalInt = 2;
        }
        if (hasGroupInBillTotal) {
            needZeroPriceTotalInt = 0;
        }
        return needZeroPriceTotalInt;
    }
}

