/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.log;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.helper.CalLogManager;
import kd.fi.calx.algox.matrix.obj.MatrixInfo;
import kd.fi.calx.algox.util.JsonUtils;

public class MatrixLogUtils {
    private static final Log logger = LogFactory.getLog(MatrixLogUtils.class);
    private final CommonInfo commonInfo;
    private final MatrixInfo matrixInfo;
    private final long time;
    private CalLogManager calLogManager = new CalLogManager();
    private final String logDomainId;

    public MatrixLogUtils(CommonInfo commonInfo, MatrixInfo matrixInfo) {
        this.commonInfo = commonInfo;
        this.matrixInfo = matrixInfo;
        this.logDomainId = (String)this.commonInfo.getParamCache().getParamValue("matrix_domainid_log");
        this.time = TimeServiceHelper.now().getTime();
    }

    public void logBeforeResolve() {
        try {
            this.doLogBeforeResolve();
        }
        catch (Throwable e) {
            logger.error("MatrixLogUtils-logBeforeResolve", e);
        }
    }

    private void doLogBeforeResolve() {
        List<String> domainIds = this.matrixInfo.getDomainIds();
        int domainSize = domainIds.size();
        BigDecimal[] constantCoef = this.matrixInfo.getConstantCoef();
        BigDecimal[][] variableCoef = this.matrixInfo.getVariableCoef();
        List<Integer> noInPutIndex = this.matrixInfo.getNoInPutIndex();
        List<Integer> noOutPutIndex = this.matrixInfo.getNoOutPutIndex();
        Boolean isLog = (Boolean)this.commonInfo.getParamCache().getParamValue("matrix_log");
        Boolean matrixChangeOne = (Boolean)this.commonInfo.getParamCache().getParamValue("matrix_change_one");
        if (isLog.booleanValue()) {
            String currDomainId;
            int index;
            String logTag = this.time + "-%s--" + this.matrixInfo.getSubelementId() + "-";
            String logDomainId = (String)this.commonInfo.getParamCache().getParamValue("matrix_domainid_log");
            StringBuilder rowStr = new StringBuilder();
            ArrayList<String> realDoMainIds = new ArrayList<String>(16);
            for (index = 0; index < domainSize; ++index) {
                currDomainId = domainIds.get(index);
                boolean removeNoOut = noOutPutIndex.contains(index) && matrixChangeOne == false;
                boolean removeNoIn = noInPutIndex.contains(index);
                if (removeNoOut || removeNoIn) {
                    String newLogTag = String.format(logTag, currDomainId);
                    rowStr.append(newLogTag).append("-DealMatrixFunction-before-removeNoOut==>").append(removeNoOut);
                    rowStr.append("-removeNoIn==>").append(removeNoIn).append("\r\n");
                    continue;
                }
                realDoMainIds.add(currDomainId);
            }
            for (index = 0; index < realDoMainIds.size(); ++index) {
                currDomainId = (String)realDoMainIds.get(index);
                if (!"all".equals(logDomainId) && !currDomainId.equals(logDomainId)) continue;
                String newLogTag = String.format(logTag, currDomainId);
                rowStr.append(newLogTag).append("-DealMatrixFunction-before-constantCoef==>");
                rowStr.append(JsonUtils.objToJson(constantCoef[index])).append("\r\n");
                rowStr.append(newLogTag).append("-DealMatrixFunction-before-variableCoef==>");
                rowStr.append(JsonUtils.objToJson(variableCoef[index])).append("\r\n");
                rowStr.append(newLogTag).append("-DealMatrixFunction-before-index==>").append(index).append("\r\n");
            }
            this.calLogManager.error(rowStr.toString(), "logBeforeResolve-" + domainSize, "D");
        }
    }

    public void logDetailInfo() {
        try {
            this.doLogDetailInfo();
        }
        catch (Throwable e) {
            logger.error("MatrixLogUtils-logDetailInfo", e);
        }
    }

    private void doLogDetailInfo() {
        boolean isLogDetail;
        Boolean isLog = (Boolean)this.commonInfo.getParamCache().getParamValue("matrix_log");
        BigDecimal[] constantCoef = this.matrixInfo.getConstantCoef();
        Long subelementId = this.matrixInfo.getSubelementId();
        boolean bl = isLogDetail = isLog != false && constantCoef.length > 0;
        if (isLogDetail) {
            String logTag = this.time + "-%s--" + subelementId + "-";
            StringBuilder allInfoSb = new StringBuilder();
            List<String> domainIds = this.matrixInfo.getDomainIds();
            this.getLogDetailInfo(allInfoSb, this.matrixInfo.getTransInQtys(), domainIds, logTag, "transInQtys");
            this.getLogDetailInfo(allInfoSb, this.matrixInfo.getBeginQtys(), domainIds, logTag, "beginQtys");
            this.getLogDetailInfo(allInfoSb, this.matrixInfo.getInQtys(), domainIds, logTag, "inQtys");
            this.getLogDetailInfo(allInfoSb, this.matrixInfo.getOutQtys(), domainIds, logTag, "outQtys");
            this.getLogDetailInfo(allInfoSb, this.matrixInfo.getFixedOutQtys(), domainIds, logTag, "fixedOutQtys");
            this.getLogDetailInfo(allInfoSb, this.matrixInfo.getTransOutQtys(), domainIds, logTag, "transOutQtys");
            this.getLogDetailInfo(allInfoSb, this.matrixInfo.getDestDomainTransOutQtyMap(), domainIds, logTag, "destDomainTransOutQtyMap");
            this.getLogDetailInfo(allInfoSb, this.matrixInfo.getFixedInCosts(), domainIds, logTag, "fixedInCosts");
            this.getLogDetailInfo(allInfoSb, this.matrixInfo.getFixedOutCosts(), domainIds, logTag, "fixedOutCosts");
            this.getLogDetailInfo(allInfoSb, this.matrixInfo.getBeginCosts(), domainIds, logTag, "beginCosts");
            String resultInfo = String.format("ResolveResult==>%s", JsonUtils.objToJson(this.matrixInfo.getResolveResult()));
            String domainPriceInfo = String.format("DomainPrice==>%s", JsonUtils.objToJson(this.matrixInfo.getDomainPriceMap()));
            allInfoSb.append(resultInfo).append("\r\n");
            allInfoSb.append(domainPriceInfo).append("\r\n");
            allInfoSb.append(this.matrixInfo.getExMsg()).append("\r\n");
            String errorPre = this.matrixInfo.getExMsg().isEmpty() ? "" : "error";
            this.calLogManager.error(allInfoSb.toString(), "logDetailInfo-" + constantCoef.length + "-" + errorPre, "D");
        } else if (isLog.booleanValue() && !this.matrixInfo.getExMsg().isEmpty()) {
            String domainIds = String.join((CharSequence)",", this.matrixInfo.getDomainIds().toArray(new String[0]));
            this.calLogManager.error(this.matrixInfo.getExMsg() + "\r\n" + domainIds, "logDetailInfo-error", "D");
        }
    }

    private void getLogDetailInfo(StringBuilder allInfoSb, Map<Object, BigDecimal> propValueMap, List<String> domainIds, String logTag, String prop) {
        if ("all".equalsIgnoreCase(this.logDomainId)) {
            for (String domainId : domainIds) {
                String newLogTag = String.format(logTag, domainId);
                HashMap<String, BigDecimal> keyValueMap = new HashMap<String, BigDecimal>(16);
                for (Map.Entry<Object, BigDecimal> entry : propValueMap.entrySet()) {
                    String key = (String)entry.getKey();
                    BigDecimal value = entry.getValue();
                    if (!key.endsWith(domainId) || value.compareTo(BigDecimal.ZERO) == 0) continue;
                    keyValueMap.put(key, value);
                }
                String logInfo = String.format(newLogTag + "-DealMatrixFunction-detail-" + prop + "==>%s", JsonUtils.objToJson(keyValueMap));
                allInfoSb.append(logInfo).append("\r\n");
            }
        } else if (StringUtils.isNotEmpty((String)this.logDomainId)) {
            String newLogTag = String.format(logTag, this.logDomainId);
            HashMap<String, BigDecimal> keyValueMap = new HashMap<String, BigDecimal>(16);
            for (Map.Entry<Object, BigDecimal> entry : propValueMap.entrySet()) {
                String key = (String)entry.getKey();
                BigDecimal value = entry.getValue();
                if (!key.endsWith(this.logDomainId) || value.compareTo(BigDecimal.ZERO) == 0) continue;
                keyValueMap.put(key, value);
            }
            logger.info(newLogTag + "-DealMatrixFunction-detail-" + prop + "==>{}", keyValueMap);
            String logInfo = String.format(newLogTag + "-DealMatrixFunction-detail-" + prop + "==>%s", JsonUtils.objToJson(keyValueMap));
            allInfoSb.append(logInfo).append("\r\n");
        }
    }
}

