/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.matrix.obj;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.calx.algox.CostPriceResultInfo;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.accounttype.CostAdjustInfo;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.constant.CostAdjustBilCreateTypeEnum;
import kd.fi.calx.algox.constant.CostPriceSourceTypeEnum;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.matrix.MatrixTypeEnum;
import kd.fi.calx.algox.matrix.helper.MatrixDesignCostHelper;
import kd.fi.calx.algox.matrix.log.MatrixRemarkUtil;
import kd.fi.calx.algox.matrix.obj.MatrixBillDtl;

public class MatrixAfterCalDomainInfo {
    private BigDecimal totalBegQty = BigDecimal.ZERO;
    private BigDecimal totalBegCost = BigDecimal.ZERO;
    private BigDecimal totalFixedInQty = BigDecimal.ZERO;
    private BigDecimal totalFixInCost = BigDecimal.ZERO;
    private BigDecimal totalFixOutQty = BigDecimal.ZERO;
    private BigDecimal totalFixedOutCost = BigDecimal.ZERO;
    private BigDecimal totalOutQty = BigDecimal.ZERO;
    private BigDecimal totalOutCost = BigDecimal.ZERO;
    private BigDecimal totalTraInQty = BigDecimal.ZERO;
    private BigDecimal totalTraInCost = BigDecimal.ZERO;
    private BigDecimal totalTraOutQty = BigDecimal.ZERO;
    private BigDecimal totalTraOutCost = BigDecimal.ZERO;
    private BigDecimal totalNotCalOutQty = BigDecimal.ZERO;
    private BigDecimal totalNotCalOutCost = BigDecimal.ZERO;
    private BigDecimal totalNotCalInQty = BigDecimal.ZERO;
    private BigDecimal totalNotCalInCost = BigDecimal.ZERO;
    private Map<Long, BigDecimal> eleIdBegQtyMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdBegCostMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdFixedInQtyMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdFixInCostMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdFixOutQtyMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdFixedOutCostMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdOutQtyMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdOutCostMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdTraInQtyMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdTraInCostMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdTraOutQtyMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdTraOutCostMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdNotCalOutQtyMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdNotCalOutCostMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdNotCalInQtyMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> eleIdNotCalInCostMap = new HashMap<Long, BigDecimal>(16);
    private Integer pricePrecision;
    private Integer amtPrecision;
    private Integer qtyPrecision;
    private Long accountId;
    private Map<Long, BigDecimal> eleIdEndCostMap = new HashMap<Long, BigDecimal>(16);
    private Long calOrgId;
    private String domainKey;
    private RowMeta rowMeta;
    private Map<String, MatrixBillDtl> eIdMatBillDtlMap = new HashMap<String, MatrixBillDtl>(16);
    private Set<String> eIdAndTypeAndSubStrs = new HashSet<String>(16);
    private Map<String, List<MatrixBillDtl>> eIdAllNoZeroBillDtlsMap = new HashMap<String, List<MatrixBillDtl>>(16);
    private Long subEleId;
    private Long localCurrency;
    private String sortListId;
    private Long materialId;
    private boolean hasBillDtl = false;
    private CostPriceResultInfo priceInfo = null;
    private String rptErrorType = "";

    public void setMatrixComInfo(MatrixAfterCalDomainInfo matrixDomainInfo, RowX row) {
        Long subEleId = row.getLong(this.rowMeta.getFieldIndex("subelementid"));
        Long calOrgId = row.getLong(this.rowMeta.getFieldIndex("calorg"));
        String domainKey = row.getString(this.rowMeta.getFieldIndex("domainid"));
        Integer pricePrecision = row.getInteger(this.rowMeta.getFieldIndex("priceprecision"));
        pricePrecision = pricePrecision == null ? Integer.valueOf(10) : pricePrecision;
        Integer amtPrecision = row.getInteger(this.rowMeta.getFieldIndex("amtprecision"));
        amtPrecision = amtPrecision == null ? Integer.valueOf(10) : amtPrecision;
        Integer qtyPrecision = row.getInteger(this.rowMeta.getFieldIndex("qtyprecision"));
        qtyPrecision = qtyPrecision == null ? Integer.valueOf(10) : qtyPrecision;
        Long acctId = row.getLong(this.rowMeta.getFieldIndex("costaccount"));
        Long materialId = row.getLong(this.rowMeta.getFieldIndex("material"));
        matrixDomainInfo.setPricePrecision(pricePrecision);
        matrixDomainInfo.setAmtPrecision(amtPrecision);
        matrixDomainInfo.setQtyPrecision(qtyPrecision);
        matrixDomainInfo.setAccountId(acctId);
        matrixDomainInfo.setCalOrgId(calOrgId);
        int localCurrencyIndex = this.rowMeta.getFieldIndex("localcurrency", false);
        if (localCurrencyIndex > -1) {
            Long localCurrency = row.getLong(localCurrencyIndex);
            matrixDomainInfo.setLocalCurrency(localCurrency);
        }
        matrixDomainInfo.setDomainKey(domainKey);
        matrixDomainInfo.setSubEleId(subEleId);
        matrixDomainInfo.setMaterialId(materialId);
    }

    public void setMatrixSumCostInfo(MatrixAfterCalDomainInfo matrixDomainInfo, RowX row) {
        BigDecimal begQty = row.getBigDecimal(this.rowMeta.getFieldIndex("beginqty"));
        BigDecimal begCost = row.getBigDecimal(this.rowMeta.getFieldIndex("begincost"));
        BigDecimal fixedInQty = row.getBigDecimal(this.rowMeta.getFieldIndex("fixedinqty"));
        BigDecimal fixInCost = row.getBigDecimal(this.rowMeta.getFieldIndex("fixedincost"));
        BigDecimal fixOutQty = row.getBigDecimal(this.rowMeta.getFieldIndex("fixedoutqty"));
        BigDecimal fixedOutCost = row.getBigDecimal(this.rowMeta.getFieldIndex("fixedoutcost"));
        BigDecimal outCost = row.getBigDecimal(this.rowMeta.getFieldIndex("outcost"));
        BigDecimal tranInCost = row.getBigDecimal(this.rowMeta.getFieldIndex("tranincost"));
        BigDecimal tranOutCost = row.getBigDecimal(this.rowMeta.getFieldIndex("tranoutcost"));
        BigDecimal domainOutQty = row.getBigDecimal(this.rowMeta.getFieldIndex("domainoutqty"));
        BigDecimal tgtBaseQty = row.getBigDecimal(this.rowMeta.getFieldIndex("tgtbaseqty"));
        BigDecimal outTgtBaseQty = row.getBigDecimal(this.rowMeta.getFieldIndex("outtgtbaseqty"));
        begQty = this.getBigDecimalNotNull(begQty);
        begCost = this.getBigDecimalNotNull(begCost);
        fixedInQty = this.getBigDecimalNotNull(fixedInQty);
        fixInCost = this.getBigDecimalNotNull(fixInCost);
        fixOutQty = this.getBigDecimalNotNull(fixOutQty);
        fixedOutCost = this.getBigDecimalNotNull(fixedOutCost);
        outCost = this.getBigDecimalNotNull(outCost);
        tranInCost = this.getBigDecimalNotNull(tranInCost);
        tranOutCost = this.getBigDecimalNotNull(tranOutCost);
        domainOutQty = this.getBigDecimalNotNull(domainOutQty);
        tgtBaseQty = this.getBigDecimalNotNull(tgtBaseQty);
        outTgtBaseQty = this.getBigDecimalNotNull(outTgtBaseQty);
        if (begQty.compareTo(BigDecimal.ZERO) != 0) {
            matrixDomainInfo.setTotalBegQty(begQty);
        }
        if (fixedInQty.compareTo(BigDecimal.ZERO) != 0) {
            matrixDomainInfo.setTotalFixedInQty(fixedInQty);
        }
        if (fixOutQty.compareTo(BigDecimal.ZERO) != 0) {
            matrixDomainInfo.setTotalFixOutQty(fixOutQty);
        }
        if (domainOutQty.compareTo(BigDecimal.ZERO) != 0) {
            matrixDomainInfo.setTotalOutQty(domainOutQty);
        }
        if (tgtBaseQty.compareTo(BigDecimal.ZERO) != 0) {
            matrixDomainInfo.setTotalTraInQty(tgtBaseQty);
        }
        if (outTgtBaseQty.compareTo(BigDecimal.ZERO) != 0) {
            matrixDomainInfo.setTotalTraOutQty(outTgtBaseQty);
        }
        Long eleId = row.getLong(this.rowMeta.getFieldIndex("subelementid"));
        matrixDomainInfo.getEleIdBegQtyMap().put(eleId, begQty);
        matrixDomainInfo.getEleIdFixedInQtyMap().put(eleId, fixedInQty);
        matrixDomainInfo.getEleIdFixOutQtyMap().put(eleId, fixOutQty);
        matrixDomainInfo.getEleIdOutQtyMap().put(eleId, domainOutQty);
        matrixDomainInfo.getEleIdTraInQtyMap().put(eleId, tgtBaseQty);
        matrixDomainInfo.getEleIdTraOutQtyMap().put(eleId, outTgtBaseQty);
        matrixDomainInfo.getEleIdBegCostMap().put(eleId, begCost);
        matrixDomainInfo.getEleIdFixInCostMap().put(eleId, fixInCost);
        matrixDomainInfo.getEleIdFixedOutCostMap().put(eleId, fixedOutCost);
        matrixDomainInfo.getEleIdOutCostMap().put(eleId, outCost);
        matrixDomainInfo.getEleIdTraInCostMap().put(eleId, tranInCost);
        matrixDomainInfo.getEleIdTraOutCostMap().put(eleId, tranOutCost);
        BigDecimal totalEndCost = begCost.add(fixInCost).add(tranInCost).subtract(fixedOutCost).subtract(outCost).subtract(tranOutCost);
        matrixDomainInfo.getEleIdEndCostMap().put(row.getLong(this.rowMeta.getFieldIndex("subelementid")), totalEndCost);
        matrixDomainInfo.setSortListId(row.getString(this.rowMeta.getFieldIndex("dysortlistid")));
    }

    public void setMatrixNotCalInfo(CommonInfo commonInfo, MatrixAfterCalDomainInfo matrixDomainInfo, RowX row) {
        Boolean writeDtlRpt = new MatrixDesignCostHelper().isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return;
        }
        String matrixType = row.getString(this.rowMeta.getFieldIndex("matrixtype"));
        BigDecimal baseQty = row.getBigDecimal(this.rowMeta.getFieldIndex("baseqty"));
        BigDecimal cost = row.getBigDecimal(this.rowMeta.getFieldIndex("cost"));
        Long eleId = row.getLong(this.rowMeta.getFieldIndex("subelementid"));
        if (MatrixTypeEnum.NOTCALOUT.getValue().equals(matrixType)) {
            baseQty = baseQty == null ? BigDecimal.ZERO : baseQty;
            cost = cost == null ? BigDecimal.ZERO : cost;
            BigDecimal eleNotCalOutQty = matrixDomainInfo.getEleIdNotCalOutQtyMap().get(eleId);
            eleNotCalOutQty = eleNotCalOutQty == null ? BigDecimal.ZERO : eleNotCalOutQty;
            matrixDomainInfo.getEleIdNotCalOutQtyMap().put(eleId, eleNotCalOutQty.add(baseQty));
            BigDecimal eleNotCalOutCost = matrixDomainInfo.getEleIdNotCalOutCostMap().get(eleId);
            eleNotCalOutCost = eleNotCalOutCost == null ? BigDecimal.ZERO : eleNotCalOutCost;
            matrixDomainInfo.getEleIdNotCalOutCostMap().put(eleId, eleNotCalOutCost.add(cost));
            if (773175233367685120L == eleId) {
                matrixDomainInfo.setTotalNotCalOutQty(matrixDomainInfo.getTotalNotCalOutQty().add(baseQty));
            }
            matrixDomainInfo.setTotalNotCalOutCost(matrixDomainInfo.getTotalNotCalOutCost().add(cost));
        } else if (MatrixTypeEnum.NOTCALIN.getValue().equals(matrixType)) {
            baseQty = baseQty == null ? BigDecimal.ZERO : baseQty;
            cost = cost == null ? BigDecimal.ZERO : cost;
            BigDecimal eleNotCalInQty = matrixDomainInfo.getEleIdNotCalInQtyMap().get(eleId);
            eleNotCalInQty = eleNotCalInQty == null ? BigDecimal.ZERO : eleNotCalInQty;
            matrixDomainInfo.getEleIdNotCalInQtyMap().put(eleId, eleNotCalInQty.add(baseQty));
            BigDecimal eleNotCalInCost = matrixDomainInfo.getEleIdNotCalInCostMap().get(eleId);
            eleNotCalInCost = eleNotCalInCost == null ? BigDecimal.ZERO : eleNotCalInCost;
            matrixDomainInfo.getEleIdNotCalInCostMap().put(eleId, eleNotCalInCost.add(cost));
            if (773175233367685120L == eleId) {
                matrixDomainInfo.setTotalNotCalInQty(matrixDomainInfo.getTotalNotCalInQty().add(baseQty));
            }
            matrixDomainInfo.setTotalNotCalInCost(matrixDomainInfo.getTotalNotCalInCost().add(cost));
        }
    }

    public void setTotalBegQty(BigDecimal totalBegQty) {
        this.totalBegQty = totalBegQty;
    }

    public BigDecimal getTotalBegQty() {
        return this.totalBegQty;
    }

    public void setTotalBegCost(BigDecimal totalBegCost) {
        this.totalBegCost = totalBegCost;
    }

    public BigDecimal getTotalBegCost() {
        return this.totalBegCost;
    }

    public void setTotalFixedInQty(BigDecimal totalFixedInQty) {
        this.totalFixedInQty = totalFixedInQty;
    }

    public BigDecimal getTotalFixedInQty() {
        return this.totalFixedInQty;
    }

    public void setTotalFixInCost(BigDecimal totalFixInCost) {
        this.totalFixInCost = totalFixInCost;
    }

    public BigDecimal getTotalFixInCost() {
        return this.totalFixInCost;
    }

    public void setTotalFixOutQty(BigDecimal totalFixOutQty) {
        this.totalFixOutQty = totalFixOutQty;
    }

    public BigDecimal getTotalFixOutQty() {
        return this.totalFixOutQty;
    }

    public void setTotalFixedOutCost(BigDecimal totalFixedOutCost) {
        this.totalFixedOutCost = totalFixedOutCost;
    }

    public BigDecimal getTotalFixedOutCost() {
        return this.totalFixedOutCost;
    }

    public void setTotalOutQty(BigDecimal totalOutQty) {
        this.totalOutQty = totalOutQty;
    }

    public BigDecimal getTotalOutQty() {
        return this.totalOutQty;
    }

    public void setTotalOutCost(BigDecimal totalOutCost) {
        this.totalOutCost = totalOutCost;
    }

    public BigDecimal getTotalOutCost() {
        return this.totalOutCost;
    }

    public void setTotalTraInQty(BigDecimal totalTraInQty) {
        this.totalTraInQty = totalTraInQty;
    }

    public BigDecimal getTotalTraInQty() {
        return this.totalTraInQty;
    }

    public void setTotalTraInCost(BigDecimal totalTraInCost) {
        this.totalTraInCost = totalTraInCost;
    }

    public BigDecimal getTotalTraInCost() {
        return this.totalTraInCost;
    }

    public void setTotalTraOutQty(BigDecimal totalTraOutQty) {
        this.totalTraOutQty = totalTraOutQty;
    }

    public BigDecimal getTotalTraOutQty() {
        return this.totalTraOutQty;
    }

    public void setTotalTraOutCost(BigDecimal totalTraOutCost) {
        this.totalTraOutCost = totalTraOutCost;
    }

    public BigDecimal getTotalTraOutCost() {
        return this.totalTraOutCost;
    }

    public Map<Long, BigDecimal> getEleIdBegQtyMap() {
        return this.eleIdBegQtyMap;
    }

    public void setEleIdBegQtyMap(Map<Long, BigDecimal> eleIdBegQtyMap) {
        this.eleIdBegQtyMap = eleIdBegQtyMap;
    }

    public Map<Long, BigDecimal> getEleIdBegCostMap() {
        return this.eleIdBegCostMap;
    }

    public void setEleIdBegCostMap(Map<Long, BigDecimal> eleIdBegCostMap) {
        this.eleIdBegCostMap = eleIdBegCostMap;
    }

    public Map<Long, BigDecimal> getEleIdFixedInQtyMap() {
        return this.eleIdFixedInQtyMap;
    }

    public void setEleIdFixedInQtyMap(Map<Long, BigDecimal> eleIdFixedInQtyMap) {
        this.eleIdFixedInQtyMap = eleIdFixedInQtyMap;
    }

    public Map<Long, BigDecimal> getEleIdFixInCostMap() {
        return this.eleIdFixInCostMap;
    }

    public void setEleIdFixInCostMap(Map<Long, BigDecimal> eleIdFixInCostMap) {
        this.eleIdFixInCostMap = eleIdFixInCostMap;
    }

    public Map<Long, BigDecimal> getEleIdFixOutQtyMap() {
        return this.eleIdFixOutQtyMap;
    }

    public void setEleIdFixOutQtyMap(Map<Long, BigDecimal> eleIdFixOutQtyMap) {
        this.eleIdFixOutQtyMap = eleIdFixOutQtyMap;
    }

    public Map<Long, BigDecimal> getEleIdFixedOutCostMap() {
        return this.eleIdFixedOutCostMap;
    }

    public void setEleIdFixedOutCostMap(Map<Long, BigDecimal> eleIdFixedOutCostMap) {
        this.eleIdFixedOutCostMap = eleIdFixedOutCostMap;
    }

    public Map<Long, BigDecimal> getEleIdOutQtyMap() {
        return this.eleIdOutQtyMap;
    }

    public void setEleIdOutQtyMap(Map<Long, BigDecimal> eleIdOutQtyMap) {
        this.eleIdOutQtyMap = eleIdOutQtyMap;
    }

    public Map<Long, BigDecimal> getEleIdOutCostMap() {
        return this.eleIdOutCostMap;
    }

    public void setEleIdOutCostMap(Map<Long, BigDecimal> eleIdOutCostMap) {
        this.eleIdOutCostMap = eleIdOutCostMap;
    }

    public Map<Long, BigDecimal> getEleIdTraInQtyMap() {
        return this.eleIdTraInQtyMap;
    }

    public void setEleIdTraInQtyMap(Map<Long, BigDecimal> eleIdTraInQtyMap) {
        this.eleIdTraInQtyMap = eleIdTraInQtyMap;
    }

    public Map<Long, BigDecimal> getEleIdTraInCostMap() {
        return this.eleIdTraInCostMap;
    }

    public void setEleIdTraInCostMap(Map<Long, BigDecimal> eleIdTraInCostMap) {
        this.eleIdTraInCostMap = eleIdTraInCostMap;
    }

    public Map<Long, BigDecimal> getEleIdTraOutQtyMap() {
        return this.eleIdTraOutQtyMap;
    }

    public void setEleIdTraOutQtyMap(Map<Long, BigDecimal> eleIdTraOutQtyMap) {
        this.eleIdTraOutQtyMap = eleIdTraOutQtyMap;
    }

    public Map<Long, BigDecimal> getEleIdTraOutCostMap() {
        return this.eleIdTraOutCostMap;
    }

    public void setEleIdTraOutCostMap(Map<Long, BigDecimal> eleIdTraOutCostMap) {
        this.eleIdTraOutCostMap = eleIdTraOutCostMap;
    }

    public void calEleCost2SumCost() {
        this.totalBegCost = BigDecimal.ZERO;
        this.totalFixInCost = BigDecimal.ZERO;
        this.totalFixedOutCost = BigDecimal.ZERO;
        this.totalOutCost = BigDecimal.ZERO;
        this.totalTraInCost = BigDecimal.ZERO;
        this.totalTraOutCost = BigDecimal.ZERO;
        this.totalNotCalOutCost = BigDecimal.ZERO;
        this.totalNotCalInCost = BigDecimal.ZERO;
        for (BigDecimal eleCost : this.getEleIdBegCostMap().values()) {
            this.totalBegCost = this.totalBegCost.add(eleCost);
        }
        for (BigDecimal eleCost : this.getEleIdFixInCostMap().values()) {
            this.totalFixInCost = this.totalFixInCost.add(eleCost);
        }
        for (BigDecimal eleCost : this.getEleIdFixedOutCostMap().values()) {
            this.totalFixedOutCost = this.totalFixedOutCost.add(eleCost);
        }
        for (BigDecimal eleCost : this.getEleIdOutCostMap().values()) {
            this.totalOutCost = this.totalOutCost.add(eleCost);
        }
        for (BigDecimal eleCost : this.getEleIdTraInCostMap().values()) {
            this.totalTraInCost = this.totalTraInCost.add(eleCost);
        }
        for (BigDecimal eleCost : this.getEleIdTraOutCostMap().values()) {
            this.totalTraOutCost = this.totalTraOutCost.add(eleCost);
        }
        for (BigDecimal eleCost : this.getEleIdNotCalOutCostMap().values()) {
            this.totalNotCalOutCost = this.totalNotCalOutCost.add(eleCost);
        }
        for (BigDecimal eleCost : this.getEleIdNotCalInCostMap().values()) {
            this.totalNotCalInCost = this.totalNotCalInCost.add(eleCost);
        }
    }

    public void setPricePrecision(Integer pricePrecision) {
        this.pricePrecision = pricePrecision;
    }

    public Integer getPricePrecision() {
        return this.pricePrecision;
    }

    public void setAmtPrecision(Integer amtPrecision) {
        this.amtPrecision = amtPrecision;
    }

    public Integer getAmtPrecision() {
        return this.amtPrecision;
    }

    public void setQtyPrecision(Integer qtyPrecision) {
        this.qtyPrecision = qtyPrecision;
    }

    public Integer getQtyPrecision() {
        return this.qtyPrecision;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public BigDecimal getTotalBeInQty() {
        return this.totalBegQty.add(this.totalFixedInQty).add(this.totalTraInQty);
    }

    public BigDecimal getTotalBeInCost() {
        return this.totalBegCost.add(this.totalFixInCost).add(this.totalTraInCost);
    }

    public BigDecimal getCalPrice() {
        BigDecimal totalBeInQty = this.getTotalBeInQty();
        BigDecimal totalBeInCost = this.getTotalBeInCost();
        BigDecimal calPrice = totalBeInQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : totalBeInCost.divide(totalBeInQty, 10, RoundingMode.HALF_UP);
        return calPrice;
    }

    public BigDecimal getTotalEndQty() {
        BigDecimal totalEndQty = this.totalBegQty.add(this.totalFixedInQty).add(this.totalTraInQty).add(this.totalNotCalInQty).subtract(this.totalFixOutQty).subtract(this.totalOutQty).subtract(this.totalTraOutQty).subtract(this.totalNotCalOutQty);
        return totalEndQty;
    }

    public BigDecimal getTotalEndCost() {
        BigDecimal totalEndCost = this.totalBegCost.add(this.totalFixInCost).add(this.totalTraInCost).add(this.totalNotCalInCost).subtract(this.totalFixedOutCost).subtract(this.totalOutCost).subtract(this.totalTraOutCost).subtract(this.totalNotCalOutCost);
        return totalEndCost;
    }

    public void setEleIdEndCostMap(Map<Long, BigDecimal> eleIdEndCostMap) {
        this.eleIdEndCostMap = eleIdEndCostMap;
    }

    public Map<Long, BigDecimal> getEleIdEndCostMap() {
        return this.eleIdEndCostMap;
    }

    public void setCalOrgId(Long calOrgId) {
        this.calOrgId = calOrgId;
    }

    public Long getCalOrgId() {
        return this.calOrgId;
    }

    public void setDomainKey(String domainKey) {
        this.domainKey = domainKey;
    }

    public String getDomainKey() {
        return this.domainKey;
    }

    public boolean hashBill() {
        boolean noIn = this.totalFixedInQty.add(this.totalTraInQty).add(this.totalNotCalInQty).compareTo(BigDecimal.ZERO) == 0 && this.totalFixInCost.add(this.totalTraInCost).add(this.totalNotCalInCost).compareTo(BigDecimal.ZERO) == 0;
        boolean noOut = this.totalFixOutQty.add(this.totalOutQty).add(this.totalTraOutQty).add(this.totalNotCalOutQty).compareTo(BigDecimal.ZERO) == 0 && this.totalFixedOutCost.add(this.totalOutCost).add(this.totalTraOutCost).add(this.totalNotCalOutCost).compareTo(BigDecimal.ZERO) == 0;
        boolean hasBill = !noIn || !noOut || this.hasBillDtl;
        return hasBill;
    }

    public void setRowMeta(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    private BigDecimal getBigDecimalNotNull(BigDecimal srcValue) {
        srcValue = srcValue == null ? BigDecimal.ZERO : srcValue;
        return srcValue;
    }

    public void addBillDtl(CommonInfo commonInfo, RowX row) {
        boolean noBill;
        Boolean writeDtlRpt = (Boolean)commonInfo.getParamCache().getParamValue(CalDbParamConstant.MATRIX_WRITE_DTLRPT);
        if (!writeDtlRpt.booleanValue()) {
            return;
        }
        Long entryId = row.getLong(this.rowMeta.getFieldIndex("entryid"));
        boolean bl = noBill = entryId == null || entryId.equals(0L);
        if (noBill) {
            return;
        }
        String matrixType = row.getString(this.rowMeta.getFieldIndex("matrixtype"));
        String billNo = row.getString(this.rowMeta.getFieldIndex("billno"));
        Long subEleId = row.getLong(this.rowMeta.getFieldIndex("subelementid"));
        String queueType = row.getString(this.rowMeta.getFieldIndex("queuetype"));
        Date bizDate = row.getDate(this.rowMeta.getFieldIndex("bizdate"));
        Date auditDate = row.getDate(this.rowMeta.getFieldIndex("auditdate"));
        BigDecimal baseQty = row.getBigDecimal(this.rowMeta.getFieldIndex("baseqty"));
        BigDecimal cost = row.getBigDecimal(this.rowMeta.getFieldIndex("cost"));
        Long baseUnit = row.getLong(this.rowMeta.getFieldIndex("baseunit"));
        Long localCurrency = row.getLong(this.rowMeta.getFieldIndex("localcurrency"));
        String domainId = row.getString(this.rowMeta.getFieldIndex("domainid"));
        String costpricesourcetype = row.getString(this.rowMeta.getFieldIndex("costpricesourcetype"));
        String costPriceSource = row.getString(this.rowMeta.getFieldIndex("costpricesource"));
        if ("splitbill".equals(costpricesourcetype)) {
            costPriceSource = " ";
        } else if (!"saveps".equals(costpricesourcetype)) {
            costPriceSource = StringUtils.isNotEmpty((CharSequence)costpricesourcetype) ? CostPriceSourceTypeEnum.getCostPriceSourceValue(costPriceSource, costpricesourcetype) : CostPriceSourceTypeEnum.getCostPriceSourceValue(costPriceSource, CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getValue());
        }
        String calRemark = row.getString(this.rowMeta.getFieldIndex("calremark"));
        String billTypeName = row.getString(this.rowMeta.getFieldIndex("billtypename"));
        String rowType = row.getString(this.rowMeta.getFieldIndex("rowtype"));
        String createType = row.getString(this.rowMeta.getFieldIndex("createtype"));
        Boolean divPrice = row.getBoolean(this.rowMeta.getFieldIndex("divprice"));
        BigDecimal oldUnitCost = row.getBigDecimal(this.rowMeta.getFieldIndex("sub_unitactualcost"));
        boolean isIn = MatrixTypeEnum.FIXEDIN.getValue().equals(matrixType) || MatrixTypeEnum.TRANIN.getValue().equals(matrixType) || MatrixTypeEnum.NOTCALIN.getValue().equals(matrixType);
        boolean isOut = MatrixTypeEnum.FIXEDOUT.getValue().equals(matrixType) || MatrixTypeEnum.TRANOUT.getValue().equals(matrixType) || MatrixTypeEnum.OUT.getValue().equals(matrixType) || MatrixTypeEnum.NOTCALOUT.getValue().equals(matrixType);
        String adjInfoStr = row.getString(this.rowMeta.getFieldIndex("adjinfo"));
        if (kd.bos.util.StringUtils.isNotEmpty((String)adjInfoStr)) {
            List adjInfos = (List)SerializationUtils.fromJsonString((String)adjInfoStr, List.class);
            String adjBillNo = (String)adjInfos.get(0);
            BigDecimal adjCost = (BigDecimal)adjInfos.get(1);
            Date adjBookDate = new Date((Long)adjInfos.get(2));
            Date adjAuditDate = new Date((Long)adjInfos.get(3));
            Long adjEntryId = (Long)adjInfos.get(4);
            MatrixBillDtl matrixRptDtl = new MatrixBillDtl();
            matrixRptDtl.setMatrixType(matrixType);
            matrixRptDtl.setBillNo(adjBillNo);
            matrixRptDtl.setSubEleId(subEleId);
            matrixRptDtl.setQueueType(queueType);
            matrixRptDtl.setBizDate(adjBookDate);
            matrixRptDtl.setAuditDate(adjAuditDate);
            matrixRptDtl.setBaseUnitId(baseUnit);
            matrixRptDtl.setCurrency(localCurrency);
            matrixRptDtl.setDomainId(domainId);
            matrixRptDtl.setEntryId(adjEntryId);
            if (isIn) {
                matrixRptDtl.seInCost(adjCost);
            }
            if (isOut) {
                matrixRptDtl.setOutCost(adjCost);
            }
            String enumDesc = CostAdjustBilCreateTypeEnum.getEnumDesc(CostAdjustBilCreateTypeEnum.CAL_OUT_GROUP.getValue());
            String msg = MatrixRemarkUtil.getGroupSrcBill(billNo);
            matrixRptDtl.setRemark(enumDesc + msg);
            matrixRptDtl.setEntity("cal_costadjust_subentity");
            matrixRptDtl.setBillTypeName(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"DataInputFactory_1", (String)"fi-calx-algox", (Object[])new Object[0]));
            this.addRptDtl(matrixRptDtl);
            cost = cost.subtract(adjCost);
        }
        BigDecimal unitCost = BigDecimal.ZERO;
        if (divPrice.booleanValue()) {
            unitCost = baseQty == null || baseQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : cost.divide(baseQty, (int)this.pricePrecision, RoundingMode.HALF_UP);
        } else {
            BigDecimal bigDecimal = unitCost = oldUnitCost == null ? BigDecimal.ZERO : oldUnitCost;
        }
        if (baseQty == null || baseQty.compareTo(BigDecimal.ZERO) == 0) {
            unitCost = BigDecimal.ZERO;
        }
        MatrixBillDtl matrixRptDtl = new MatrixBillDtl();
        matrixRptDtl.setMatrixType(matrixType);
        matrixRptDtl.setBillNo(billNo);
        matrixRptDtl.setSubEleId(subEleId);
        matrixRptDtl.setQueueType(queueType);
        matrixRptDtl.setBizDate(bizDate);
        matrixRptDtl.setAuditDate(auditDate);
        matrixRptDtl.setBaseUnitId(baseUnit);
        matrixRptDtl.setCurrency(localCurrency);
        matrixRptDtl.setDomainId(domainId);
        matrixRptDtl.setEntryId(entryId);
        matrixRptDtl.setCostPriceSource(costPriceSource);
        if (isIn) {
            matrixRptDtl.setInBaseQty(baseQty);
            matrixRptDtl.seInCost(cost);
            matrixRptDtl.setInUnitCost(unitCost);
        }
        if (isOut) {
            matrixRptDtl.setOutBaseQty(baseQty);
            matrixRptDtl.setOutCost(cost);
            matrixRptDtl.setOutUnitCost(unitCost);
        }
        matrixRptDtl.setRemark(calRemark == null ? "" : calRemark);
        matrixRptDtl.setEntity("cal_costrecord_subentity");
        if ("2".equals(rowType)) {
            matrixRptDtl.setEntity("cal_costadjust_subentity");
            String enumDesc = CostAdjustBilCreateTypeEnum.getEnumDesc(createType);
            String oldRemark = kd.bos.util.StringUtils.isEmpty((String)matrixRptDtl.getRemark()) ? "" : "(" + matrixRptDtl.getRemark() + ")";
            matrixRptDtl.setRemark(enumDesc + oldRemark);
        }
        matrixRptDtl.setBillTypeName(billTypeName);
        this.addRptDtl(matrixRptDtl);
    }

    private void addRptDtl(MatrixBillDtl matrixRptDtl) {
        Long entryId = matrixRptDtl.getEntryId();
        String eIdAndType = entryId + "," + matrixRptDtl.getMatrixType();
        if (matrixRptDtl.getSubEleId().equals(773175233367685120L)) {
            this.eIdMatBillDtlMap.put(eIdAndType, matrixRptDtl);
        } else {
            String eIdAndTypeAndSubStr = eIdAndType + "," + matrixRptDtl.getSubEleId();
            boolean isNotZero = this.isNotZero(matrixRptDtl);
            if (isNotZero && this.eIdAndTypeAndSubStrs.add(eIdAndTypeAndSubStr)) {
                List matrixBillDtls = this.eIdAllNoZeroBillDtlsMap.computeIfAbsent(eIdAndType, k -> new ArrayList(16));
                matrixBillDtls.add(matrixRptDtl);
            }
        }
        this.hasBillDtl = true;
    }

    public boolean isNotZero(MatrixBillDtl matrixRptDtl) {
        boolean isOutNotZero = matrixRptDtl.getOutCost() != null && matrixRptDtl.getOutCost().compareTo(BigDecimal.ZERO) != 0;
        boolean isInNotZero = matrixRptDtl.getInCost() != null && matrixRptDtl.getInCost().compareTo(BigDecimal.ZERO) != 0;
        boolean isEndNotZero = matrixRptDtl.getEndCost() != null && matrixRptDtl.getEndCost().compareTo(BigDecimal.ZERO) != 0;
        boolean isNotZero = isOutNotZero || isInNotZero || isEndNotZero;
        return isNotZero;
    }

    public void addBillDtlByAdj(CommonInfo commonInfo, CostAdjustInfo adjustInfo) {
        Boolean writeDtlRpt = (Boolean)commonInfo.getParamCache().getParamValue(CalDbParamConstant.MATRIX_WRITE_DTLRPT);
        if (!writeDtlRpt.booleanValue()) {
            return;
        }
        String matrixType = MatrixTypeEnum.OUT.getValue();
        DynamicObject adjBillDyc = adjustInfo.getCostAdjustBill();
        DynamicObjectCollection entryDycs = adjBillDyc.getDynamicObjectCollection("entryentity");
        if (entryDycs.isEmpty()) {
            return;
        }
        DynamicObject entryDyc = (DynamicObject)entryDycs.get(0);
        String billNo = adjBillDyc.getString("billno");
        Date bizDate = adjustInfo.getBizDate();
        Date auditDate = adjustInfo.getAuditDate();
        long entryId = entryDyc.getLong("id");
        Map<Long, CostSubElement> elementMap = commonInfo.getElementMap();
        for (Map.Entry<Long, CostSubElement> entry : elementMap.entrySet()) {
            Long elementId = entry.getKey();
            BigDecimal elementCost = adjustInfo.getAdjustCost(elementId);
            if (elementCost == null || elementCost.compareTo(BigDecimal.ZERO) == 0) continue;
            String queueType = entryDyc.getString("queuetype");
            BigDecimal baseQty = BigDecimal.ZERO;
            BigDecimal cost = elementCost;
            Long baseUnit = entryDyc.getLong("baseunit_id");
            Long localCurrency = this.getLocalCurrency();
            String domainId = this.getDomainKey();
            BigDecimal unitCost = BigDecimal.ZERO;
            boolean isIn = MatrixTypeEnum.FIXEDIN.getValue().equals(matrixType) || MatrixTypeEnum.TRANIN.getValue().equals(matrixType);
            boolean isOut = MatrixTypeEnum.FIXEDOUT.getValue().equals(matrixType) || MatrixTypeEnum.TRANOUT.getValue().equals(matrixType) || MatrixTypeEnum.OUT.getValue().equals(matrixType);
            Long subEleId = elementId;
            MatrixBillDtl matrixRptDtl = new MatrixBillDtl();
            matrixRptDtl.setMatrixType(matrixType);
            matrixRptDtl.setBillNo(billNo);
            matrixRptDtl.setSubEleId(subEleId);
            matrixRptDtl.setQueueType(queueType);
            matrixRptDtl.setBizDate(bizDate);
            matrixRptDtl.setAuditDate(auditDate);
            matrixRptDtl.setBaseUnitId(baseUnit);
            matrixRptDtl.setCurrency(localCurrency);
            matrixRptDtl.setDomainId(domainId);
            matrixRptDtl.setEntryId(entryId);
            if (isIn) {
                matrixRptDtl.setInBaseQty(baseQty);
                matrixRptDtl.seInCost(cost);
                matrixRptDtl.setInUnitCost(unitCost);
            }
            if (isOut) {
                matrixRptDtl.setOutBaseQty(baseQty);
                matrixRptDtl.setOutCost(cost);
                matrixRptDtl.setOutUnitCost(unitCost);
            }
            matrixRptDtl.setRemark(CostAdjustBilCreateTypeEnum.getEnumDesc(CostAdjustBilCreateTypeEnum.CAL_OUT_TAILING.getValue()));
            matrixRptDtl.setEntity("cal_costadjust_subentity");
            matrixRptDtl.setBillTypeName(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"DataInputFactory_1", (String)"fi-calx-algox", (Object[])new Object[0]));
            this.addRptDtl(matrixRptDtl);
        }
    }

    public void setSubEleId(Long subEleId) {
        this.subEleId = subEleId;
    }

    public Long getSubEleId() {
        return this.subEleId;
    }

    public void setLocalCurrency(Long localCurrency) {
        this.localCurrency = localCurrency;
    }

    public Long getLocalCurrency() {
        return this.localCurrency;
    }

    public Map<String, MatrixBillDtl> getEIdMatBillDtlMap() {
        return this.eIdMatBillDtlMap;
    }

    public void setEIdAllNoZeroBillDtlsMap(Map<String, List<MatrixBillDtl>> eIdAllNoZeroBillDtlsMap) {
        this.eIdAllNoZeroBillDtlsMap = eIdAllNoZeroBillDtlsMap;
    }

    public Map<String, List<MatrixBillDtl>> getEIdAllNoZeroBillDtlsMap() {
        return this.eIdAllNoZeroBillDtlsMap;
    }

    public void setSortListId(String sortListId) {
        this.sortListId = sortListId;
    }

    public String getSortListId() {
        return this.sortListId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public Long getMaterialId() {
        return this.materialId;
    }

    public BigDecimal getTotalNotCalOutQty() {
        return this.totalNotCalOutQty;
    }

    public void setTotalNotCalOutQty(BigDecimal totalNotCalOutQty) {
        this.totalNotCalOutQty = totalNotCalOutQty;
    }

    public BigDecimal getTotalNotCalOutCost() {
        return this.totalNotCalOutCost;
    }

    public void setTotalNotCalOutCost(BigDecimal totalNotCalOutCost) {
        this.totalNotCalOutCost = totalNotCalOutCost;
    }

    public BigDecimal getTotalNotCalInQty() {
        return this.totalNotCalInQty;
    }

    public void setTotalNotCalInQty(BigDecimal totalNotCalInQty) {
        this.totalNotCalInQty = totalNotCalInQty;
    }

    public BigDecimal getTotalNotCalInCost() {
        return this.totalNotCalInCost;
    }

    public void setTotalNotCalInCost(BigDecimal totalNotCalInCost) {
        this.totalNotCalInCost = totalNotCalInCost;
    }

    public Map<Long, BigDecimal> getEleIdNotCalOutQtyMap() {
        return this.eleIdNotCalOutQtyMap;
    }

    public void setEleIdNotCalOutQtyMap(Map<Long, BigDecimal> eleIdNotCalOutQtyMap) {
        this.eleIdNotCalOutQtyMap = eleIdNotCalOutQtyMap;
    }

    public Map<Long, BigDecimal> getEleIdNotCalOutCostMap() {
        return this.eleIdNotCalOutCostMap;
    }

    public void setEleIdNotCalOutCostMap(Map<Long, BigDecimal> eleIdNotCalOutCostMap) {
        this.eleIdNotCalOutCostMap = eleIdNotCalOutCostMap;
    }

    public Map<Long, BigDecimal> getEleIdNotCalInQtyMap() {
        return this.eleIdNotCalInQtyMap;
    }

    public void setEleIdNotCalInQtyMap(Map<Long, BigDecimal> eleIdNotCalInQtyMap) {
        this.eleIdNotCalInQtyMap = eleIdNotCalInQtyMap;
    }

    public Map<Long, BigDecimal> getEleIdNotCalInCostMap() {
        return this.eleIdNotCalInCostMap;
    }

    public void setEleIdNotCalInCostMap(Map<Long, BigDecimal> eleIdNotCalInCostMap) {
        this.eleIdNotCalInCostMap = eleIdNotCalInCostMap;
    }

    public void endSubNotCalBill(CommonInfo commonInfo) {
        Boolean writeDtlRpt = new MatrixDesignCostHelper().isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return;
        }
        Map<Long, BigDecimal> eleIdEndCostMap = this.getEleIdEndCostMap();
        Map<Long, BigDecimal> eleIdNotCalInCostMap = this.getEleIdNotCalInCostMap();
        Map<Long, BigDecimal> eleIdNotCalOutCostMap = this.getEleIdNotCalOutCostMap();
        for (Map.Entry<Long, BigDecimal> entry : eleIdEndCostMap.entrySet()) {
            Long eleId = entry.getKey();
            BigDecimal endCost = entry.getValue();
            BigDecimal notCalInCost = eleIdNotCalInCostMap.get(eleId);
            notCalInCost = notCalInCost == null ? BigDecimal.ZERO : notCalInCost;
            BigDecimal notCalOutCoset = eleIdNotCalOutCostMap.get(eleId);
            notCalOutCoset = notCalOutCoset == null ? BigDecimal.ZERO : notCalOutCoset;
            entry.setValue(endCost.add(notCalInCost).subtract(notCalOutCoset));
        }
    }

    public void setPriceInfo(CommonInfo commonInfo, RowX row) {
        CostPriceResultInfo priceInfo;
        Boolean writeDtlRpt = new MatrixDesignCostHelper().isWriteDtlRpt(commonInfo);
        if (!writeDtlRpt.booleanValue()) {
            return;
        }
        if (this.priceInfo != null) {
            return;
        }
        String priceInfoStr = row.getString(this.rowMeta.getFieldIndex("priceinfostr"));
        if (kd.bos.util.StringUtils.isEmpty((String)priceInfoStr)) {
            return;
        }
        this.priceInfo = priceInfo = (CostPriceResultInfo)SerializationUtils.fromJsonString((String)priceInfoStr, CostPriceResultInfo.class);
    }

    public CostPriceResultInfo getPriceInfo() {
        return this.priceInfo;
    }

    public void setRptErrorType(RowX row) {
        String rptErrorType = row.getString(this.rowMeta.getFieldIndex("rpterrortype"));
        if (kd.bos.util.StringUtils.isNotEmpty((String)rptErrorType)) {
            this.rptErrorType = rptErrorType;
        }
    }

    public String getRptErrorType() {
        return this.rptErrorType;
    }
}

