/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.report;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.calx.algox.CalculateOutService;
import kd.fi.calx.algox.accounttype.CostAdjustInfo;
import kd.fi.calx.algox.accounttype.LocalRow;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.constant.CostAdjustBilCreateTypeEnum;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.report.RptStatus;

public class CalOutRptHolder
implements Serializable {
    private static final Log logger = LogFactory.getLog(CalculateOutService.class);
    private static final long serialVersionUID = -1059986022198861582L;
    private static final String INSERT_RPTHEAD_SQL = "insert into t_cal_caloutrpt(fid,fcostaccountid,fmaterialid,fdividebasisid,fcaldimensionid,fdividebasisvalue,fcaldimensionvalue,faccounttype,fperiodid,fcaltime,fcalstatus,fnextseq,fcalorgid,fcalrangeid,flog,foperationuserid,fmatrix,fcostatenddateenable,fcostatenddate,fassistid,fconfiguredcodeid,fprojectid,ftracknumberid)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_RPTENTRY_SQL = "insert into t_cal_caloutrptentry(fid,fentryid,fseq,fbizbillid,fbizbillentryid,fbilltypenum,fbilltype,fbillnumber,finstr,foutstr,fbalancestr,fparententryid,fbizdate,fauditdate,fdescribe)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private int size = 0;
    private Long fid;
    private boolean hasBill = false;
    private Object[] rptHead;
    private List<Object[]> entrys;
    public static final String FI_REGION = "fi";
    public static final String CAL_RPT_QUEUE = "fi.calx.calrpt";
    private Map<Integer, Boolean> updateCostPriceMap;
    private List<Object[]> matrixDtls = new ArrayList<Object[]>(16);
    private static final String INSERT_MATRIX_DTL_SQL = "insert into t_cal_caloutrpt_dtl (fid,frptid,fmatrixtype,fbillno,fbookdate,fauditdate,fcostsubelementid,fbaseunitid,fcurrencyid,finqty,finunitcost,fincost,foutqty,foutunitcost,foutcost,fcostdomainkey,fperiodid,fcostaccountid,fcaltime,fentryid,fsortlistid,fentity,fremark,fcostpricesource,fmaterialid,fbilltypename)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public CalOutRptHolder() {
        this.entrys = new ArrayList<Object[]>();
        this.fid = DB.genLongId((String)"t_cal_caloutrpt");
        this.rptHead = new Object[23];
        this.rptHead[0] = this.fid;
        this.rptHead[1] = 0L;
        this.rptHead[2] = 0L;
        this.rptHead[3] = 0L;
        this.rptHead[4] = 0L;
        this.rptHead[5] = "";
        this.rptHead[6] = "";
        this.rptHead[7] = "";
        this.rptHead[8] = 0L;
        this.rptHead[9] = new Timestamp(TimeServiceHelper.now().getTime());
        this.rptHead[10] = RptStatus.SUCESS.getValue();
        this.rptHead[11] = 0;
        this.rptHead[12] = 0L;
        this.rptHead[13] = 0L;
        this.rptHead[14] = "";
        this.rptHead[15] = RequestContext.get().getCurrUserId();
        this.rptHead[16] = false;
        this.rptHead[17] = false;
        this.rptHead[18] = null;
        this.rptHead[19] = 0L;
        this.rptHead[20] = 0L;
        this.rptHead[21] = 0L;
        this.rptHead[22] = 0L;
        this.updateCostPriceMap = new HashMap<Integer, Boolean>(16);
    }

    public Long getCalRptID() {
        return this.fid;
    }

    public void setCostAccountID(Long costAccountId) {
        this.rptHead[1] = costAccountId;
    }

    public void setCalOrgID(Long calOrgId) {
        this.rptHead[12] = calOrgId;
    }

    public void setCalRangeID(Long calRangeId) {
        this.rptHead[13] = calRangeId;
    }

    public void setMaterialID(Long materialId) {
        this.rptHead[2] = materialId;
    }

    public void setDivideBasisID(Long divideBasisId) {
        this.rptHead[3] = divideBasisId;
    }

    public void setCalDimensionID(Long calDimensionId) {
        this.rptHead[4] = calDimensionId;
    }

    public void addDivideBasisValue(String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        String values = (String)this.rptHead[5];
        if (values.contains(value)) {
            return;
        }
        values = values.isEmpty() ? value : values + "&" + value;
        this.rptHead[5] = values;
    }

    public void setCalDimensionValue(String value) {
        this.rptHead[6] = value;
    }

    public void setAccountType(String accountType) {
        this.rptHead[7] = accountType;
    }

    public void setCalStatus(RptStatus status) {
        if (RptStatus.ERROR.getValue().equals(this.rptHead[10])) {
            return;
        }
        this.rptHead[10] = status.getValue();
    }

    public String getCalStatusValue() {
        return (String)this.rptHead[10];
    }

    public void setPeriodID(Long periodID) {
        this.rptHead[8] = periodID;
    }

    public String getLog() {
        return this.rptHead[14].toString();
    }

    public void setLog(String log) {
        this.rptHead[14] = "".equals(this.rptHead[14]) ? log : this.rptHead[14] + log;
    }

    public void setNewLog(String newLog) {
        this.rptHead[14] = newLog;
    }

    public void setMatrix(boolean matrix) {
        this.rptHead[16] = matrix;
    }

    public Boolean getMatrix() {
        return (Boolean)this.rptHead[16];
    }

    public void setCostatenddateenable(boolean costatenddateenable) {
        this.rptHead[17] = costatenddateenable;
    }

    public void setCostatenddate(Date costatenddate) {
        this.rptHead[18] = costatenddate;
    }

    public void setAssistId(Long assistId) {
        this.rptHead[19] = assistId;
    }

    public void setConfiguredcodeId(Long configuredcodeId) {
        this.rptHead[20] = configuredcodeId;
    }

    public void setProjectId(Long projectId) {
        this.rptHead[21] = projectId;
    }

    public void setTracknumberId(Long tracknumberId) {
        this.rptHead[22] = tracknumberId;
    }

    public int createNewEntry(LocalRow row) {
        this.hasBill = true;
        Object[] entry = new Object[]{this.fid, DB.genLongId((String)"t_cal_caloutrptentry"), this.size + 1, row.getBizbillid(), row.getBizbillentryid(), row.getBilltypenum(), row.getBilltype(), row.getBillnumber(), "", "", "", 0L, row.getBizDate() != null ? new Timestamp(row.getBizDate().getTime()) : null, row.getAuditTime() != null ? new Timestamp(row.getAuditTime().getTime()) : null, ""};
        ++this.size;
        this.entrys.add(entry);
        return this.size - 1;
    }

    public int createNewEntry(CostAdjustInfo info) {
        Object[] entry = new Object[]{this.fid, DB.genLongId((String)"t_cal_caloutrptentry"), this.size + 1, info.getCostAdjustId(), info.getCostAdjustEntryId(), "cal_costadjustbill", ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"DataInputFactory_1", (String)"fi-calx-algox", (Object[])new Object[0]), info.getBillNo(), "", "", "", 0L, info.getBizDate() != null ? new Timestamp(info.getBizDate().getTime()) : null, info.getAuditDate() != null ? new Timestamp(info.getAuditDate().getTime()) : null, CostAdjustBilCreateTypeEnum.getEnumDesc(info.getCreateType())};
        ++this.size;
        this.entrys.add(entry);
        return this.size - 1;
    }

    public int createNewSubEntry(int index, String elementName) {
        Object[] parentEntry = this.entrys.get(index);
        Object parentEntryId = parentEntry[1];
        Object[] subEntry = new Object[]{this.fid, DB.genLongId((String)"t_cal_caloutrptentry"), this.size + 1, 0L, 0L, "", "", elementName, "", "", "", parentEntryId, null, null, ""};
        ++this.size;
        this.entrys.add(subEntry);
        return this.size - 1;
    }

    public int createNewEntry() {
        Object[] entry = new Object[]{this.fid, DB.genLongId((String)"t_cal_caloutrptentry"), this.size + 1, 0L, 0L, "", "", "", "", "", "", 0L, null, null, ""};
        ++this.size;
        this.entrys.add(entry);
        return this.size - 1;
    }

    public void setBillType(int index, String billtype) {
        Object[] objs = this.entrys.get(index);
        objs[6] = billtype;
    }

    public void setInFormula(int index, String inFormula) {
        Object[] objs = this.entrys.get(index);
        if (inFormula.length() > 450) {
            inFormula = inFormula.substring(0, 449);
        }
        objs[8] = inFormula;
    }

    public void appendInFormula(int index, String inFormula) {
        Object[] objs = this.entrys.get(index);
        inFormula = objs[8] + inFormula;
        if (inFormula.length() > 450) {
            inFormula = inFormula.substring(0, 449);
        }
        objs[8] = inFormula;
    }

    public void setOutFormula(int index, String outFormula) {
        Object[] objs = this.entrys.get(index);
        if (outFormula.length() > 450) {
            outFormula = outFormula.substring(0, 449);
        }
        objs[9] = outFormula;
    }

    public void appendOutFormula(int index, String outFormula) {
        Object[] objs = this.entrys.get(index);
        outFormula = objs[9] + outFormula;
        if (outFormula.length() > 450) {
            outFormula = outFormula.substring(0, 449);
        }
        objs[9] = outFormula;
    }

    public void setBalanceFormula(int index, String balanceFormula) {
        Object[] objs = this.entrys.get(index);
        if (balanceFormula.length() > 450) {
            balanceFormula = balanceFormula.substring(0, 449);
        }
        objs[10] = balanceFormula;
    }

    public void appendBalanceFormula(int index, String balanceFormula) {
        Object[] objs = this.entrys.get(index);
        balanceFormula = objs[10] + balanceFormula;
        if (balanceFormula.length() > 450) {
            balanceFormula = balanceFormula.substring(0, 449);
        }
        objs[10] = balanceFormula;
    }

    public void setEntryValue(int index, int entryIndex, Object value) {
        Object[] objs = this.entrys.get(index);
        objs[entryIndex] = value;
    }

    public void flushRptInfo(DBRoute route) {
        if (!this.hasBill) {
            logger.info("CalOutRptHolder-\u5f53\u671f\u6ca1\u6709\u5355\u636e\u4e0d\u5199\u62a5\u544a");
            return;
        }
        if (this.entrys.size() > 0) {
            if (CalDbParamServiceHelper.getBoolean(CalDbParamConstant.SYNC_WRITE_CALRPT).booleanValue()) {
                this.flushRptInfoToDB(route);
                return;
            }
            logger.info("CalOutRptHolder-\u5f00\u59cbpush\u961f\u5217");
            MessagePublisher pub = MQFactory.get().createSimplePublisher(FI_REGION, CAL_RPT_QUEUE);
            try {
                pub.publish((Object)this);
            }
            catch (Exception e) {
                logger.info("CalOutRptHolder-push\u961f\u5217\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getClass().getName());
                logger.error("CalOutRptHolder flushRptInfo", (Throwable)e);
                this.flushRptInfoToDB(route);
                throw e;
            }
            finally {
                logger.info("CalOutRptHolder-\u7ed3\u675fpush\u961f\u5217");
                pub.close();
            }
        }
    }

    public void flushRptInfoToDB(DBRoute route) {
        logger.info("CalOutRptHolder:\u5f00\u59cb\u6267\u884c\u65e5\u5fd7\u63d2\u5165\u6570\u636e\u5e93\uff0c\u5171" + this.entrys.size() + "\u6761");
        this.rptHead[11] = this.entrys.size() + 1;
        if (this.entrys != null && !this.entrys.isEmpty()) {
            DB.execute((DBRoute)route, (String)INSERT_RPTHEAD_SQL, (Object[])this.rptHead);
            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_caloutrpt", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, this.rptHead[1]), new ShardingHintContext.ShardingHintCondition("fcaltime", FilterType.eq, this.rptHead[9])});){
                ctx.set();
                DB.executeBatch((DBRoute)route, (String)INSERT_RPTENTRY_SQL, this.entrys);
                logger.info("CalOutRptHolder:\u7ed3\u675f\u65e5\u5fd7\u63d2\u5165\u6570\u636e\u5e93");
            }
        }
        if (this.matrixDtls != null && this.matrixDtls.size() > 0) {
            logger.info("CalOutRptHolder-matrixdtl:\u65b9\u7a0b\u7ec4\u660e\u7ec6\u63d2\u5165\u6570\u636e\u5e93\u5f00\u59cb");
            DB.executeBatch((DBRoute)route, (String)INSERT_MATRIX_DTL_SQL, this.matrixDtls);
            logger.info("CalOutRptHolder-matrixdtl:\u65b9\u7a0b\u7ec4\u660e\u7ec6\u63d2\u5165\u6570\u636e\u5e93\u7ed3\u675f");
        }
    }

    public Object[] getRptHead() {
        return this.rptHead;
    }

    public void setRptHead(Object[] rptHead) {
        this.rptHead = rptHead;
    }

    public List<Object[]> getEntrys() {
        return this.entrys;
    }

    public void setEntrys(List<Object[]> entrys) {
        this.entrys = entrys;
    }

    public void setHasBill(boolean hasBill) {
        this.hasBill = hasBill;
    }

    public Map<Integer, Boolean> getUpdateCostPriceMap() {
        return this.updateCostPriceMap;
    }

    public void setUpdateCostPriceMap(Map<Integer, Boolean> updateCostPriceMap) {
        this.updateCostPriceMap = updateCostPriceMap;
    }

    public void setDescribe(int index, String describe) {
        Object[] objs = this.entrys.get(index);
        objs[14] = describe;
    }

    public void addMatrixDtl(Object[] matrixDtl) {
        this.matrixDtls.add(matrixDtl);
    }

    public List<Object[]> getMatrixDtls() {
        return this.matrixDtls;
    }
}

